#!/usr/bin/python
import sys

sys.path.append("/var/packages/MailPlus-Server/target/backend_hook/")
from _Utils import *
from _Define import *

def enableNFS():
    resp = execWebAPI("SYNO.Core.FileServ.NFS", "get", 2)
    if not resp["success"]:
        SYSLOG(0 , "Failed to get NFS status")
        return False

    if resp["data"]["enable_nfs"] and resp["data"]["enable_nfs_v4"]:
        return True

    resp = execWebAPI("SYNO.Core.FileServ.NFS", "set", 2,
            enable_nfs = True,
            enable_nfs_v4 = True,
            nfs_v4_domain = resp["data"]["nfs_v4_domain"]
            )

    if not resp["success"]:
        SYSLOG(0 , "Failed to exec NFS enable webapi")
        return False
    return True

def main():
    if not enableNFS():
        SYSLOG(0 , "Failed to enable NFS")
        exit(1)
    exit(0)

if __name__ == '__main__':
    main()
