#!/usr/bin/python
import sys

sys.path.append("/var/packages/MailPlus-Server/target/backend_hook/")
from _Utils import *
from _Define import *

eAPI = BackendAPI()

def main():
    if isTreeChange("mailserver_service_postfix") or isKeyChange("smtp_port") or isKeyChange("smtp_tls_port") or isKeyChange("smtps_port") or \
        isKeyChange("smtp_enabled") or isKeyChange("smtp_ssl_enabled") or isKeyChange("smtp_tls_enabled") or isKeyChange("enable_balancer_address") or \
        isTreeChange("mapping_table"):

            ## smtp not enable stop haproxy
            smtpEnable = eAPI.mailconfGet("smtp_enabled")
            if "yes" != smtpEnable:
                cmd = "/var/packages/MailPlus-Server/target/bin/syno_action haproxy \"stop\""
                executeCommand(cmd, False)
                exit(0)

            ## Not enable balancer address direct stop haproxy and exit
            enableBalancerAddress = eAPI.mailconfGet("enable_balancer_address")
            if "no" == enableBalancerAddress:
                cmd = "/var/packages/MailPlus-Server/target/bin/syno_action haproxy \"stop\""
                executeCommand(cmd, False)
                exit(0)

            configGenerator = HAProxyConfigGenerator()
            try:
                configGenerator.genConfig()
            except:
                SYSLOG(LOG_ERR, "Failed to update haproxy config")
                exit(1)

            cmd = "/var/packages/MailPlus-Server/target/bin/syno_action haproxy \"restart\""
            _, success = executeCommand(cmd, False)
            if not success:
                ## Restart haproxy from old config
                SYSLOG(LOG_ERR, "Failed to restart haproxy")

                if not configGenerator.rollbackConfig():
                    SYSLOG(LOG_ERR, "Failed to rollback config")

                cmd = "/var/packages/MailPlus-Server/target/bin/syno_action haproxy \"restart\""
                _, success = executeCommand(cmd, False)
                exit(1)

    exit(0)
if __name__ == '__main__':
    try:
        main()
    except Exception as e:
        SYSLOG(LOG_ERR, "exception: %s" % e)
