#!/bin/sh
. /var/packages/MailPlus-Server/target/backend_hook/hookUtils.conf
loadEnv

## Check identity
NODE_ID=$(getHostID)
mailer_servers="$(${MAILPLUS_SERVER_BACKEND_BINARY} --getConfKeyVal "mailer")"
if ! containString "${NODE_ID}" "${mailer_servers}"; then
	exit 0
fi

## Convert syno config
if ! ${SET_CONF_BINARY} "smtp"; then
	err_log "Failed to set conf smtp"
	exit 1
fi

if ! ${SET_CONF_BINARY} "dovecot"; then
	err_log "Failed to set conf dovecot"
	exit 1
fi

if ! ${SET_CONF_BINARY} "mailscanner"; then
	err_log "Failed to set conf mailscanner"
	exit 1
fi

if isKeyChanged "sync_spam_db"; then
	chown -R postfix:root /var/spool/@MailPlus-Server/MailScanner/spamassassin/*
fi


## Actions
if ! ${CALLBACK_BINARY} "mailscanner" "${_MAIL_mailserver_trigger_events}"; then
	err_log "Failed to callback mailscanner"
	exit 1
fi

if isKeyChanged "anti_virus_enable" || isKeyChanged "anti_virus_engine"; then
	if ! ${CALLBACK_BINARY} "antivirus" "${_MAIL_mailserver_trigger_events}"; then
		err_log "Failed to callback antivirus"
		exit 1
	fi
fi

if isKeyChanged "report_learn_clear_history"; then
	/var/packages/MailPlus-Server/target/scripts/ReportLearn.py clear_history
fi

if isKeyChanged "spam_enable" || isKeyChanged "spam_auto_learn" || isKeyChanged "spam_report_enable"; then
	if ! ${CALLBACK_BINARY} "setReportLearnMaintainTask" "${_MAIL_mailserver_trigger_events}"; then
		err_log "Failed to setReportLearnMaintainTask"
	fi
fi

if isKeyChanged "spam_enable" || isKeyChanged "spam_auto_learn" || isKeyChanged "spam_report_enable" || isKeyChanged "report_autolearn_enable" || isKeyChanged "report_autolearn_hour" || isKeyChanged "report_autolearn_minute"; then
	if ! ${CALLBACK_BINARY} "setReportAutoLearnTask" "${_MAIL_mailserver_trigger_events}"; then
		err_log "Failed to setReportAutoLearnTask"
	fi
fi

exit 0
