#!/bin/sh

. /var/packages/MailPlus-Server/target/backend_hook/hookUtils.conf
loadEnv

## Check identity
NODE_ID=$(getHostID)
mailer_servers="$(${MAILPLUS_SERVER_BACKEND_BINARY} --getConfKeyVal "mailer")"
if ! containString "${NODE_ID}" "${mailer_servers}"; then
	exit 0
fi

## Convert syno config
if ! ${SET_CONF_BINARY} "alias"; then
	err_log "Failed to set conf alias"
	exit 1
fi

exit 0
