#!/bin/sh

GUESTNAME=$1
BIND_IFNAME=$2
GUEST_TARGET_IFNAME="eth0"
SZF_PKG_NETIF_CFG="/var/packages/Docker/etc/ovs_reg.conf"

if [ -z "${BIND_IFNAME}" ]; then
	exit 0
fi
OVS_IFNAME=ovs_${BIND_IFNAME}

# check if ovs bridage have this interface
if ! synoovstool --list-all 2>&1 | grep -E "^${OVS_IFNAME}$"; then
	logger -p user.err -t $(basename $0) "fail to find ovs interface ${OVS_IFNAME}"
	exit 0
fi

# get docker pid
RETRIES=3
while [ $RETRIES -gt 0 ]; do
	NSPID=$(docker inspect --format='{{ .State.Pid }}' $GUESTNAME)
	[ $NSPID != 0 ] && break
	sleep 3
	RETRIES=$((RETRIES - 1))
done

if [ "$NSPID" = 0 ]; then
	echo "Docker inspect returned invalid PID 0"
	exit 1
fi

GUEST_IFNAME=g${NSPID}${BIND_IFNAME}
HOST_IFNAME=ddsm${NSPID}${BIND_IFNAME}

# setup ns
[ ! -d /var/run/netns ] && mkdir -p /var/run/netns
[ -f /var/run/netns/$NSPID ] && rm -f /var/run/netns/$NSPID
ln -s /proc/$NSPID/ns/net /var/run/netns/$NSPID

# create veth pair interface
ip link add ${HOST_IFNAME} type veth peer name ${GUEST_IFNAME}

# always detach before attach
synoovstool --detach-port ${HOST_IFNAME} ${OVS_IFNAME}
# attach to ovs
synoovstool --attach-port ${HOST_IFNAME} ${OVS_IFNAME}

# reg use port to config
synosetkeyvalue ${SZF_PKG_NETIF_CFG} ${GUESTNAME} ${HOST_IFNAME}

ip link set ${HOST_IFNAME} up

# assign to docker interface, rename to eth0, and up interface
ip link set ${GUEST_IFNAME} netns ${NSPID}
if [ 0 -ne $? ]; then
	# fail to set interface, remove the interface
	ip link delete ${GUEST_IFNAME}
	exit 1
fi

ip netns exec ${NSPID} ip link set ${GUEST_IFNAME} name ${GUEST_TARGET_IFNAME}
ip netns exec ${NSPID} ip link set ${GUEST_TARGET_IFNAME} up
