#!/bin/sh

###############################################################
#   This script should be hooked when invoking share_set hook.
#   Usable environment variable:
#       ORIGIN_SHARE_NAME, SHARE_NAME, ORIGIN_SHARE_PATH, SHARE_PATH,
#       STATUS, RESULT
#
#   Note: The script should bear to be invoked multiple times
###############################################################

#Include common scripts
SZF_DockerDSM_COMMON_UTIL="/var/packages/Docker/target/ddsm/plugins/DockerDSMCommon.sh"
. ${SZF_DockerDSM_COMMON_UTIL}

RemoveSocketAndHupDaemon() {
	DDSM=`$SZF_DDSM_CTL_TOOL --get-ddsm-name-by-share $SHARE_NAME`

	if [ $? -eq 1 ]; then
		# always remove socket file and hup daemon for create a new one
		/bin/rm ${SHARE_PATH}/@synology_dockerdsm_conf/Infostore/ddsm_host.sock
		/usr/sbin/reload synoddsm-hostd
	fi
}

CheckShareNameChange() {
	# if origin share name is empty, skip it
	if [ "" = "${ORIGIN_SHARE_NAME}" ]; then
		return
	fi

	# share name changed or share path changed
	if [ "${ORIGIN_SHARE_NAME}" != "${SHARE_NAME}" ]; then
		IS_RENAME=1
	fi;
}

DockerDSMShareForbidden() {
	DDSM=`$SZF_DDSM_CTL_TOOL --get-ddsm-name-by-share $SHARE_NAME`

	if [ $? -eq 1 ]; then
		$SZF_DDSM_CTL_TOOL --pause-reason-add $DDSM $SYNO_PLUGIN_UUID
		/usr/syno/bin/synosetkeyvalue "/tmp/ddsm-$SYNO_PLUGIN_UUID" "name" $DDSM
		RUNNING=`$SZF_DOCKER_TOOL inspect --format '{{.State.Running}}' $DDSM`
		if [ $? -eq 0 ] && [ "$RUNNING" == "true" ]; then
			StopDockerDSM $DDSM
			# record container id for resume docker dsm on permit event
			ID=`$SZF_DOCKER_TOOL inspect --format '{{.Id}}' $DDSM`
			/bin/mkdir -p /var/run/synoddsm/pause_id/
			/bin/touch /var/run/synoddsm/pause_id/"$ID"
		fi
	fi
}

DockerDSMShareForbiddenPost() {
	DDSM=`get_key_value /tmp/ddsm-$SYNO_PLUGIN_UUID name`

	if [ $? -eq 1 ]; then
		$SZF_DDSM_CTL_TOOL --pause-reason-remove $DDSM $SYNO_PLUGIN_UUID
	fi

	rm /tmp/ddsm-$SYNO_PLUGIN_UUID
}

DockerDSMSharePermit() {
	DDSM=`$SZF_DDSM_CTL_TOOL --get-ddsm-name-by-share $SHARE_NAME`

	if [ $? -eq 1 ]; then
		RUNNING=`$SZF_DOCKER_TOOL inspect --format '{{.State.Running}}' $DDSM`
		ID=`$SZF_DOCKER_TOOL inspect --format '{{.Id}}' $DDSM`
		if [ "$RUNNING" == "false" ] && [ -f /var/run/synoddsm/pause_id/"$ID" ]; then
			StartDockerDSM $DDSM

			# remove pause flag
			/bin/rm /var/run/synoddsm/pause_id/"$ID"
		fi
	fi
}

DockerDSMShareRename() {
	$SZF_DDSM_CTL_TOOL --share-rename $ORIGIN_SHARE_NAME $SHARE_NAME
	RemoveSocketAndHupDaemon
}

case $1 in
	--sdk-mod-ver)
		#Print SDK support version
		echo "2.0";
	;;
	--name)
		#Print package name
		echo "Docker DSM";
	;;
	--pkg-ver)
		#Print package version
		echo "1.0";
	;;
	--vendor)
		#Print package vendor
		echo "Synology Inc.";
	;;
	--pre)
		#Actions before share set

		#share status change from permit to forbidden, stop ddsm
		if [ "0" == "${ORIGIN_SHARE_FORBIDDEN}" ] && [ "1" == "${SHARE_FORBIDDEN}" ]; then
			DockerDSMShareForbidden
		fi

		#share status change from forbidden to permit, ask hostd to create new socket file
		if [ "1" == "${ORIGIN_SHARE_FORBIDDEN}" ] && [ "0" == "${SHARE_FORBIDDEN}" ]; then
			RemoveSocketAndHupDaemon
		fi
	;;
	--post)
		#Actions after share set

		#share status change from permit to forbidden done, remove pause reason
		if [ "0" == "${ORIGIN_SHARE_FORBIDDEN}" ] && [ "1" == "${SHARE_FORBIDDEN}" ]; then
			DockerDSMShareForbiddenPost
		fi

		# handle share rename, update config and try to resume ddsm
		IS_RENAME=0

		#Check hook condition
		CheckShareNameChange

		#Update Docker DSM Name
		if [ "1" == "${IS_RENAME}" ] && [ "0" == "${RESULT}" ]; then
			DockerDSMShareRename
		fi

		#share status change from forbidden to permit, start ddsm
		if [ "1" == "${ORIGIN_SHARE_FORBIDDEN}" ] && [ "0" == "${SHARE_FORBIDDEN}" ]; then
			# sleep 3 sec for avoid hook racing
			sleep 3
			DockerDSMSharePermit
		fi
	;;
	*)
		echo "Usage: $0 --sdk-mod-ver|--name|--pkg-ver|--vendor|--pre|--post"
	;;
esac

