#include <iostream>
#include <synolicense/synolicense.h>

#define SDK_MODULE_VERSION   "1.0"
#define APP_NAME "Synology License"
#define VENDOR "Synology"
#define LICENSE_API_VERSION 1

int main(int argc, const char *argv[])
{
	if (argc != 2) {
		return -1;
	}

	if (strcmp(argv[1], "--sdk-mod-ver") == 0) {
		std::cout << SDK_MODULE_VERSION << std::endl;
		return 0;
	}

	if (0 == strcmp(argv[1], "--name")) {
		std::cout << APP_NAME << std::endl;
		return 0;
	}

	if (0 == strcmp(argv[1], "--pkg-ver")) {
		std::cout << LICENSE_API_VERSION << std::endl;
		return 0;
	}

	if (0 == strcmp(argv[1], "--vendor")) {
		std::cout << VENDOR << std::endl;
		return 0;
	}

	if (strcmp(argv[1], "--post") == 0) {
		return SLUserLogin(LICENSE_API_VERSION)? 0: -1;
	}

	return 0;
}
