#!/bin/sh
# Copyright (c) 2000-2017 Synology Inc. All rights reserved.

# check if DDSM is doing config update
DockerBin="/var/packages/Docker/target/usr/bin/docker"
RunningCount=`$DockerBin ps -q -f label\="IsSynologyDSM"\="yes" | wc -l`

if [ "0" != "$RunningCount" ]; then
	list=`$DockerBin ps --no-trunc=true | grep "SynologyDSM:" |awk '{print $1}'`
	for DDSM in ${list}; do
		if $DockerBin exec -t "$DDSM" ps ax|grep config_bootup_check.sh; then
			exit 1
		fi
	done
fi

exit 0
