#!/bin/sh

###############################################################
#   This script should be hooked when invoking SYNOShareDelete()
#   Usable environment variable:
#       NITEMS, SHARE_NAME_X, SHARE_PATH_X, SHARE_OP_RESULT_X
###############################################################

SZF_DockerDSM_COMMON_UTIL="/var/packages/Docker/target/ddsm/plugins/DockerDSMCommon.sh"
. ${SZF_DockerDSM_COMMON_UTIL}

CheckAndStopDDSMBeforeShareDelete() {
	INDEX=1
	NITEMS=$((NITEMS + 1))
	while [ "${INDEX}" != "${NITEMS}" ]
	do
		eval "SHARE_NAME=\$SHARE_NAME_$INDEX"
		DDSM=`$SZF_DDSM_CTL_TOOL --get-ddsm-name-by-share $SHARE_NAME`
		if [ $? -eq 1 ]; then
			# stop container
			StopDockerDSM $DDSM
		fi
		INDEX=$((INDEX + 1))
	done
}

CheckAndDeleteDDSMAfterShareDelete() {
	INDEX=1
	NITEMS=$((NITEMS + 1))
	while [ "${INDEX}" != "${NITEMS}" ]
	do
		eval "SHARE_NAME=\$SHARE_NAME_$INDEX"
		eval "SHARE_OP_RESULT=\$SHARE_OP_RESULT_$INDEX"
		if [ "0x0000" = "${SHARE_OP_RESULT}" ]; then
			DDSM=`$SZF_DDSM_CTL_TOOL --get-ddsm-name-by-share $SHARE_NAME`
			if [ $? -eq 1 ]; then
				if IsAPIAvaliable; then
					# delete container if webapi work
					DeleteDockerDSM $DDSM

					/usr/syno/bin/synodsmnotify @administrators dsmnotify:system_event ddsm:ddsm_remove_by_share_delete $DDSM $SHARE_NAME
				else
					# touch delete flag if webapi is not avaliable
					/bin/mkdir -p /var/packages/Docker/etc/delete_ddsm/
					/bin/touch /var/packages/Docker/etc/delete_ddsm/$DDSM
					logger -p user.err "synoddsm: touch delete flag for docker dsm $DDSM"
				fi
			fi
		fi
		INDEX=$((INDEX + 1))
	done
}

case $1 in
    --sdk-mod-ver)
        #Print SDK support version
		echo "2.0";
    ;;
    --name)
        #Print package name
		echo "Docker DSM";
    ;;
    --pkg-ver)
        #Print package version
		echo "1.0";
    ;;
    --vendor)
        #Print package vendor
		echo "Synology Inc.";
    ;;
    --pre)
		CheckAndStopDDSMBeforeShareDelete
	;;
    --post)
		CheckAndDeleteDDSMAfterShareDelete
    ;;
    *)
        echo "Usage: $0 --sdk-mod-ver|--name|--pkg-ver|--vendor|--pre|--post"
    ;;
esac
