#!/bin/sh

SZF_DDSM_CTL_TOOL="/var/packages/Docker/target/tool/ddsmctl"
SZF_DOCKER_TOOL="/var/packages/Docker/target/usr/bin/docker"

# check if webapi is avaliable
IsAPIAvaliable() {
	if /usr/syno/bin/synopkg status Docker; then
		return 0
	else
		return -1
	fi
}

# stop the container by webapi
StopDockerDSM() {
	local DDSM=$1

	IsAPIAvaliable || return 0

	logger -p user.err "synoddsm: Stop Container $DDSM begin"
	synowebapi --exec api=SYNO.Docker.Container method=stop version=1 name="\"$DDSM\"" is_ddsm=true
	logger -p user.err "synoddsm: Stop Container $DDSM end"

	return 0;
}

# stop the container by webapi
StartDockerDSM() {
	local DDSM=$1

	IsAPIAvaliable || return 0

	logger -p user.err "synoddsm: Start Container $DDSM begin"
	synowebapi --exec api=SYNO.Docker.Container method=start version=1 name="\"$DDSM\"" is_ddsm=true
	logger -p user.err "synoddsm: Start Container $DDSM end"

	return 0;
}

DeleteDockerDSM() {
	local DDSM=$1

	IsAPIAvaliable || return 0

	logger -p user.err "synoddsm: Delete Container $DDSM begin"
	synowebapi --exec api=SYNO.Docker.Container method=delete version=1 name="\"$DDSM\"" is_ddsm=true preserve_profile=false force=false
	logger -p user.err "synoddsm: Delete Container $DDSM end"

	return 0;
}
