/* Copyright (c) 2017 Synology Inc. All rights reserved. */

/*

 term.js - an xterm emulator
 Copyright (c) 2012-2013, Christopher Jeffrey (MIT License)
 https://github.com/chjj/term.js

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in
 all copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.

 Originally forked from (with the author's permission):
 Fabrice Bellard's javascript vt100 for jslinux:
 http://bellard.org/jslinux/
 Copyright (c) 2011 Fabrice Bellard
 The original design remains. The terminal itself
 has been extended to include xterm CSI codes, among
 other features.
*/
(function(){function r(){this._events=this._events||{}}function d(a,b,c){var e=this;if(!(this instanceof d))return new d(a,b,c);r.call(this);if(typeof a==="number")a={cols:a,rows:b,handler:c};a=a||{};x(y(d.defaults),function(i){if(a[i]==null){a[i]=d.options[i];if(d[i]!==d.defaults[i])a[i]=d[i]}e[i]=a[i]});if(a.colors.length===8)a.colors=a.colors.concat(d._colors.slice(8));else if(a.colors.length===16)a.colors=a.colors.concat(d._colors.slice(16));else if(a.colors.length===10)a.colors=a.colors.slice(0,
-2).concat(d._colors.slice(8,-2),a.colors.slice(-2));else if(a.colors.length===18)a.colors=a.colors.slice(0,-2).concat(d._colors.slice(16,-2),a.colors.slice(-2));this.colors=a.colors;this.options=a;this.parent=a.body||a.parent||(z?z.getElementsByTagName("body")[0]:null);this.cols=a.cols||a.geometry[0];this.rows=a.rows||a.geometry[1];a.handler&&this.on("data",a.handler);this.cursorState=this.y=this.x=this.ydisp=this.ybase=0;this.cursorHidden=false;this.state=0;this.queue="";this.scrollTop=0;this.scrollBottom=
this.rows-1;this.wraparoundMode=this.insertMode=this.originMode=this.applicationCursor=this.applicationKeypad=false;this.normal=null;this.searchMode=this.visualMode=this.selectMode=this.prefixMode=false;this.entry="";this.entryPrefix="Search: ";this.gcharset=this.charset=null;this.glevel=0;this.charsets=[null];this.writable=this.readable=true;this.curAttr=this.defAttr=131840;this.params=[];this.currentParam=0;this.postfix=this.prefix="";this.lines=[];for(b=this.rows;b--;)this.lines.push(this.blankLine());
this.setupStops()}function p(a,b,c,e){a.addEventListener(b,c,e||false)}function v(a,b,c,e){a.removeEventListener(b,c,e||false)}function o(a){a.preventDefault&&a.preventDefault();a.returnValue=false;a.stopPropagation&&a.stopPropagation();a.cancelBubble=true;return false}function A(a,b){function c(){this.constructor=a}c.prototype=b.prototype;a.prototype=new c}function D(a){var b=a.getElementsByTagName("body")[0];a=a.createElement("span");a.innerHTML="hello world";b.appendChild(a);var c=a.scrollWidth;
a.style.fontWeight="bold";var e=a.scrollWidth;b.removeChild(a);return c!==e}function E(a,b){for(var c=a.length;c--;)if(a[c]===b)return c;return-1}function w(a){a=a.charCodeAt(0);if(12288==a||65281<=a&&a<=65376||65504<=a&&a<=65510)return true;if(8361==a||65377<=a&&a<=65470||65474<=a&&a<=65479||65482<=a&&a<=65487||65490<=a&&a<=65495||65498<=a&&a<=65500||65512<=a&&a<=65518)return false;if(4352<=a&&a<=4447||4515<=a&&a<=4519||4602<=a&&a<=4607||9001<=a&&a<=9002||11904<=a&&a<=11929||11931<=a&&a<=12019||
12032<=a&&a<=12245||12272<=a&&a<=12283||12289<=a&&a<=12350||12353<=a&&a<=12438||12441<=a&&a<=12543||12549<=a&&a<=12589||12593<=a&&a<=12686||12688<=a&&a<=12730||12736<=a&&a<=12771||12784<=a&&a<=12830||12832<=a&&a<=12871||12880<=a&&a<=13054||13056<=a&&a<=19903||19968<=a&&a<=42124||42128<=a&&a<=42182||43360<=a&&a<=43388||44032<=a&&a<=55203||55216<=a&&a<=55238||55243<=a&&a<=55291||63744<=a&&a<=64255||65040<=a&&a<=65049||65072<=a&&a<=65106||65108<=a&&a<=65126||65128<=a&&a<=65131)return true;if(32<=a&&
a<=126||162<=a&&a<=163||165<=a&&a<=166||172==a||175==a||10214<=a&&a<=10221||10629<=a&&a<=10630)return false;if(161==a||164==a||167<=a&&a<=168||170==a||173<=a&&a<=174||176<=a&&a<=180||182<=a&&a<=186||188<=a&&a<=191||198==a||208==a||215<=a&&a<=216||222<=a&&a<=225||230==a||232<=a&&a<=234||236<=a&&a<=237||240==a||242<=a&&a<=243||247<=a&&a<=250||252==a||254==a||257==a||273==a||275==a||283==a||294<=a&&a<=295||299==a||305<=a&&a<=307||312==a||319<=a&&a<=322||324==a||328<=a&&a<=331||333==a||338<=a&&a<=339||
358<=a&&a<=359||363==a||462==a||464==a||466==a||468==a||470==a||472==a||474==a||476==a||593==a||609==a||708==a||711==a||713<=a&&a<=715||717==a||720==a||728<=a&&a<=731||733==a||735==a||768<=a&&a<=879||913<=a&&a<=929||931<=a&&a<=937||945<=a&&a<=961||963<=a&&a<=969||1025==a||1040<=a&&a<=1103||1105==a||8208==a||8211<=a&&a<=8214||8216<=a&&a<=8217||8220<=a&&a<=8221||8224<=a&&a<=8226||8228<=a&&a<=8231||8240==a||8242<=a&&a<=8243||8245==a||8251==a||8254==a||8308==a||8319==a||8321<=a&&a<=8324||8364==a||8451==
a||8453==a||8457==a||8467==a||8470==a||8481<=a&&a<=8482||8486==a||8491==a||8531<=a&&a<=8532||8539<=a&&a<=8542||8544<=a&&a<=8555||8560<=a&&a<=8569||8585==a||8592<=a&&a<=8601||8632<=a&&a<=8633||8658==a||8660==a||8679==a||8704==a||8706<=a&&a<=8707||8711<=a&&a<=8712||8715==a||8719==a||8721==a||8725==a||8730==a||8733<=a&&a<=8736||8739==a||8741==a||8743<=a&&a<=8748||8750==a||8756<=a&&a<=8759||8764<=a&&a<=8765||8776==a||8780==a||8786==a||8800<=a&&a<=8801||8804<=a&&a<=8807||8810<=a&&a<=8811||8814<=a&&a<=
8815||8834<=a&&a<=8835||8838<=a&&a<=8839||8853==a||8857==a||8869==a||8895==a||8978==a||9312<=a&&a<=9449||9451<=a&&a<=9547||9552<=a&&a<=9587||9600<=a&&a<=9615||9618<=a&&a<=9621||9632<=a&&a<=9633||9635<=a&&a<=9641||9650<=a&&a<=9651||9654<=a&&a<=9655||9660<=a&&a<=9661||9664<=a&&a<=9665||9670<=a&&a<=9672||9675==a||9678<=a&&a<=9681||9698<=a&&a<=9701||9711==a||9733<=a&&a<=9734||9737==a||9742<=a&&a<=9743||9748<=a&&a<=9749||9756==a||9758==a||9792==a||9794==a||9824<=a&&a<=9825||9827<=a&&a<=9829||9831<=a&&
a<=9834||9836<=a&&a<=9837||9839==a||9886<=a&&a<=9887||9918<=a&&a<=9919||9924<=a&&a<=9933||9935<=a&&a<=9953||9955==a||9960<=a&&a<=9983||10045==a||10071==a||10102<=a&&a<=10111||11093<=a&&a<=11097||12872<=a&&a<=12879||57344<=a&&a<=63743||65024<=a&&a<=65039||65533==a)return false;return true}function t(a,b,c){var e=a<<16|b<<8|c;if(t._cache[e]!=null)return t._cache[e];for(var i=Infinity,h=-1,g=0,f,m,l;g<d.vcolors.length;g++){f=d.vcolors[g];m=f[0];l=f[1];f=f[2];m=t.distance(a,b,c,m,l,f);if(m===0){h=g;break}if(m<
i){i=m;h=g}}return t._cache[e]=h}function x(a,b,c){if(a.forEach)return a.forEach(b,c);for(var e=0;e<a.length;e++)b.call(c,a[e],e,a)}function y(a){if(Object.keys)return Object.keys(a);var b,c=[];for(b in a)Object.prototype.hasOwnProperty.call(a,b)&&c.push(b);return c}var z=this.document;r.prototype.addListener=function(a,b){this._events[a]=this._events[a]||[];this._events[a].push(b)};r.prototype.on=r.prototype.addListener;r.prototype.removeListener=function(a,b){if(this._events[a]){a=this._events[a];
for(var c=a.length;c--;)if(a[c]===b||a[c].listener===b){a.splice(c,1);return}}};r.prototype.off=r.prototype.removeListener;r.prototype.removeAllListeners=function(a){this._events[a]&&delete this._events[a]};r.prototype.once=function(a,b){function c(){var e=Array.prototype.slice.call(arguments);this.removeListener(a,c);return b.apply(this,e)}c.listener=b;return this.on(a,c)};r.prototype.emit=function(a){if(this._events[a])for(var b=Array.prototype.slice.call(arguments,1),c=this._events[a],e=c.length,
i=0;i<e;i++)c[i].apply(this,b)};r.prototype.listeners=function(a){return this._events[a]=this._events[a]||[]};A(d,r);d.prototype.eraseAttr=function(){return this.defAttr&-512|this.curAttr&511};d.tangoColors=["#2e3436","#cc0000","#4e9a06","#c4a000","#3465a4","#75507b","#06989a","#d3d7cf","#555753","#ef2929","#8ae234","#fce94f","#729fcf","#ad7fa8","#34e2e2","#eeeeec"];d.xtermColors=["#000000","#cd0000","#00cd00","#cdcd00","#0000ee","#cd00cd","#00cdcd","#e5e5e5","#7f7f7f","#ff0000","#00ff00","#ffff00",
"#5c5cff","#ff00ff","#00ffff","#ffffff"];d.colors=function(){function a(h,g,f){c.push("#"+b(h)+b(g)+b(f))}function b(h){h=h.toString(16);return h.length<2?"0"+h:h}var c=d.tangoColors.slice(),e=[0,95,135,175,215,255],i;for(i=0;i<216;i++)a(e[i/36%6|0],e[i/6%6|0],e[i%6]);for(i=0;i<24;i++){e=8+i*10;a(e,e,e)}return c}();d.colors[256]="#000000";d.colors[257]="#f0f0f0";d._colors=d.colors.slice();d.vcolors=function(){for(var a=[],b=d.colors,c=0,e;c<256;c++){e=parseInt(b[c].substring(1),16);a.push([e>>16&
255,e>>8&255,e&255])}return a}();d.defaults={colors:d.colors,convertEol:false,termName:"xterm",geometry:[80,24],cursorBlink:true,visualBell:false,popOnBell:false,scrollback:1E3,screenKeys:false,debug:false,useStyle:false};d.options={};x(y(d.defaults),function(a){d[a]=d.defaults[a];d.options[a]=d.defaults[a]});d.focus=null;d.prototype.focus=function(){if(d.focus!==this){d.focus&&d.focus.blur();this.sendFocus&&this.send("\u001b[I");this.showCursor();d.focus=this}};d.prototype.blur=function(){if(d.focus===
this){this.cursorState=0;this.refresh(this.y,this.y);this.sendFocus&&this.send("\u001b[O");d.focus=null}};d.prototype.initGlobal=function(){var a=this.document;d._boundDocs=d._boundDocs||[];if(!~E(d._boundDocs,a)){d._boundDocs.push(a);d.bindPaste(a);d.bindKeys(a);d.bindCopy(a);this.isMobile&&this.fixMobile(a);this.useStyle&&d.insertStyle(a,this.colors[256],this.colors[257])}};d.bindPaste=function(a){p(a.defaultView,"paste",function(b){var c=d.focus;if(c){if(b.clipboardData)c.send(b.clipboardData.getData("text/plain"));
else c.context.clipboardData&&c.send(c.context.clipboardData.getData("Text"));c.element.contentEditable="inherit";return o(b)}})};d.bindKeys=function(a){p(a,"keydown",function(b){if(d.focus){var c=b.target||b.srcElement;if(c)if(c===d.focus.element||c===d.focus.context||c===d.focus.document||c===d.focus.body||c===d._textarea||c===d.focus.parent)return d.focus.keyDown(b)}},true);p(a,"keypress",function(b){if(d.focus){var c=b.target||b.srcElement;if(c)if(c===d.focus.element||c===d.focus.context||c===
d.focus.document||c===d.focus.body||c===d._textarea||c===d.focus.parent)return d.focus.keyPress(b)}},true);p(a,"mousedown",function(b){if(d.focus)if(b=b.target||b.srcElement){do if(b===d.focus.element)return;while(b=b.parentNode);d.focus.blur()}})};d.bindCopy=function(a){p(a.defaultView,"copy",function(){var b=d.focus;if(b)if(b._selected){var c=b.getCopyTextarea(),e=b.grabText(b._selected.x1,b._selected.x2,b._selected.y1,b._selected.y2);b.emit("copy",e);c.focus();c.textContent=e;c.value=e;c.setSelectionRange(0,
e.length);u(function(){b.element.focus();b.focus()},1)}})};d.prototype.fixMobile=function(a){var b=this,c=a.createElement("textarea");c.style.position="absolute";c.style.left="-32000px";c.style.top="-32000px";c.style.width="0px";c.style.height="0px";c.style.opacity="0";c.style.backgroundColor="transparent";c.style.borderStyle="none";c.style.outlineStyle="none";c.autocapitalize="none";c.autocorrect="off";a.getElementsByTagName("body")[0].appendChild(c);d._textarea=c;u(function(){c.focus()},1E3);this.isAndroid&&
p(c,"change",function(){var e=c.textContent||c.value;c.value="";c.textContent="";b.send(e+"\r")})};d.insertStyle=function(a,b,c){var e=a.getElementById("term-style");if(!e){var i=a.getElementsByTagName("head")[0];if(i){e=a.createElement("style");e.id="term-style";e.innerHTML=".terminal {\n  float: left;\n  border: "+b+' solid 5px;\n  font-family: "DejaVu Sans Mono", "Liberation Mono", monospace;\n  line-height: 18px;\n  font-size: 12px;\n  color: '+c+";\n  background: "+b+";\n}\n\n.terminal-cursor {\n  color: "+
b+";\n  background: "+c+";\n}\n.terminal-word {\n  width: 7px;\n}\n.terminal-dword {\n  width: 14px;\n}\n";i.insertBefore(e,i.firstChild)}}};d.prototype.open=function(a){var b=this,c=0;this.parent=a||this.parent;if(!this.parent)throw new Error("Terminal requires a parent element.");this.context=this.parent.ownerDocument.defaultView;this.document=this.parent.ownerDocument;this.body=this.document.getElementsByTagName("body")[0];if(this.context.navigator&&this.context.navigator.userAgent){this.isMac=
!!~this.context.navigator.userAgent.indexOf("Mac");this.isIpad=!!~this.context.navigator.userAgent.indexOf("iPad");this.isIphone=!!~this.context.navigator.userAgent.indexOf("iPhone");this.isAndroid=!!~this.context.navigator.userAgent.indexOf("Android");this.isMobile=this.isIpad||this.isIphone||this.isAndroid;this.isMSIE=!!~this.context.navigator.userAgent.indexOf("MSIE")}this.element=this.document.createElement("div");this.element.className="terminal";this.element.style.outline="none";this.element.setAttribute("tabindex",
0);this.element.setAttribute("spellcheck","false");this.element.style.backgroundColor=this.colors[256];this.element.style.color=this.colors[257];for(this.children=[];c<this.rows;c++){a=this.document.createElement("div");this.element.appendChild(a);this.children.push(a)}this.parent.appendChild(this.element);this.refresh(0,this.rows-1);if(!("useEvents"in this.options)||this.options.useEvents)this.initGlobal();if(!("useFocus"in this.options)||this.options.useFocus){this.focus();this.startBlink();p(this.element,
"focus",function(){b.focus();b.isMobile&&d._textarea.focus()});p(this.element,"mousedown",function(){b.focus()});p(this.element,"mousedown",function(e){e=e.button!=null?+e.button:e.which!=null?e.which-1:null;if(b.isMSIE)e=e===1?0:e===4?1:e;if(e===2){b.element.contentEditable="true";u(function(){b.element.contentEditable="inherit"},1)}},true)}if(!("useMouse"in this.options)||this.options.useMouse)this.bindMouse();if(!("useFocus"in this.options)||this.options.useFocus)u(function(){b.element.focus()},
100);if(d.brokenBold==null)d.brokenBold=D(this.document)};d.prototype.bindMouse=function(){function a(j){var k,n;k=i(j);if(n=h(j)){e(k,n);switch(j.type){case "mousedown":m=k;break;case "mouseup":m=32;break;case l:break}}}function b(j){var k=m;if(j=h(j)){k+=32;e(k,j)}}function c(j,k){if(f.utfMouse){if(k===2047)return j.push(0);if(k<127)j.push(k);else{if(k>2047)k=2047;j.push(192|k>>6);j.push(128|k&63)}}else{if(k===255)return j.push(0);if(k>127)k=127;j.push(k)}}function e(j,k){if(f.vt300Mouse){j&=3;
k.x-=32;k.y-=32;var n="\u001b[24";if(j===0)n+="1";else if(j===1)n+="3";else if(j===2)n+="5";else if(j===3)return;else n+="0";n+="~["+k.x+","+k.y+"]\r";f.send(n)}else if(f.decLocator){j&=3;k.x-=32;k.y-=32;if(j===0)j=2;else if(j===1)j=4;else if(j===2)j=6;else if(j===3)j=3;f.send("\u001b["+j+";"+(j===3?4:0)+";"+k.y+";"+k.x+";"+(k.page||0)+"&w")}else if(f.urxvtMouse){k.x-=32;k.y-=32;k.x++;k.y++;f.send("\u001b["+j+";"+k.x+";"+k.y+"M")}else if(f.sgrMouse){k.x-=32;k.y-=32;f.send("\u001b[<"+((j&3)===3?j&
-4:j)+";"+k.x+";"+k.y+((j&3)===3?"m":"M"))}else{n=[];c(n,j);c(n,k.x);c(n,k.y);f.send("\u001b[M"+s.fromCharCode.apply(s,n))}}function i(j){var k,n,q;switch(j.type){case "mousedown":k=j.button!=null?+j.button:j.which!=null?j.which-1:null;if(f.isMSIE)k=k===1?0:k===4?1:k;break;case "mouseup":k=3;break;case "DOMMouseScroll":k=j.detail<0?64:65;break;case "mousewheel":k=j.wheelDeltaY>0?64:65;break}n=j.shiftKey?4:0;q=j.metaKey?8:0;j=j.ctrlKey?16:0;n=n|q|j;if(f.vt200Mouse)n&=j;else f.normalMouse||(n=0);return k=
32+(n<<2)+k}function h(j){var k,n,q,B;if(j.pageX!=null){k=j.pageX;n=j.pageY;for(q=f.element;q&&q!==f.document.documentElement;){k-=q.offsetLeft;n-=q.offsetTop;q="offsetParent"in q?q.offsetParent:q.parentNode}q=f.element.clientWidth;B=f.element.clientHeight;k=Math.round(k/q*f.cols);n=Math.round(n/B*f.rows);if(k<0)k=0;if(k>f.cols)k=f.cols;if(n<0)n=0;if(n>f.rows)n=f.rows;k+=32;n+=32;return{x:k,y:n,type:j.type===l?"mousewheel":j.type}}}var g=this.element,f=this,m=32,l="onmousewheel"in this.context?"mousewheel":
"DOMMouseScroll";p(g,"mousedown",function(j){if(f.mouseEvents){a(j);f.focus();if(f.vt200Mouse){Object.defineProperty(j,"type",{value:"mouseup"});a(j);return o(j)}f.normalMouse&&p(f.document,"mousemove",b);f.x10Mouse||p(f.document,"mouseup",function k(n){a(n);f.normalMouse&&v(f.document,"mousemove",b);v(f.document,"mouseup",k);return o(n)});return o(j)}});p(g,l,function(j){if(f.mouseEvents)if(!(f.x10Mouse||f.vt300Mouse||f.decLocator)){a(j);return o(j)}});p(g,l,function(j){if(!f.mouseEvents)if(!f.applicationKeypad){j.type===
"DOMMouseScroll"?f.scrollDisp(j.detail<0?-5:5):f.scrollDisp(j.wheelDeltaY>0?-5:5);return o(j)}})};d.prototype.destroy=function(){this.writable=this.readable=false;this._events={};this.handler=function(){};this.write=function(){};this.element.parentNode&&this.element.parentNode.removeChild(this.element)};d.prototype.refresh=function(a,b){var c,e,i,h,g,f,m,l,j,k,n;if(b-a>=this.rows/2)(n=this.element.parentNode)&&n.removeChild(this.element);m=this.cols;a=a;if(b>=this.lines.length){this.log("`end` is too large. Most likely a bad CSR.");
b=this.lines.length-1}for(;a<=b;a++){c=a+this.ydisp;i=this.lines[c];h="";c=a===this.y&&this.cursorState&&(this.ydisp===this.ybase||this.selectMode)&&!this.cursorHidden?this.x:-1;f=this.defAttr;for(e=0;e<m;e++){l=i[e][0];g=i[e][1];if(e===c)l=-1;if(l!==f){if(f!==this.defAttr)h+="</span>";if(l!==this.defAttr)if(l===-1)h+='<span class="reverse-video terminal-cursor">';else{h+='<span style="';f=l&511;j=l>>9&511;k=l>>18;if(k&1){d.brokenBold||(h+="font-weight:bold;");if(j<8)j+=8}if(k&2)h+="text-decoration:underline;";
if(k&4)if(k&2){h=h.slice(0,-1);h+=" blink;"}else h+="text-decoration:blink;";if(k&8){f=l>>9&511;j=l&511;if(k&1&&j<8)j+=8}if(k&16)h+="visibility:hidden;";if(f!==256)h+="background-color:"+this.colors[f]+";";if(j!==257)h+="color:"+this.colors[j]+";";h+='">'}}switch(g){case "&":f="&amp;";break;case "<":f="&lt;";break;case ">":f="&gt;";break;default:f=g<=" "?"&nbsp;":g;break}if(w(g)){h+='<span class="terminal-dword" style="display:inline-block;">';e++}else h+='<span class="terminal-word" style="display:inline-block;">';
h+=f;h+="</span>";f=l}if(f!==this.defAttr)h+="</span>";this.children[a].innerHTML=h}n&&n.appendChild(this.element)};d.prototype._cursorBlink=function(){if(d.focus===this){this.cursorState^=1;this.refresh(this.y,this.y)}};d.prototype.showCursor=function(){if(!this.cursorState){this.cursorState=1;this.refresh(this.y,this.y)}};d.prototype.startBlink=function(){if(this.cursorBlink){var a=this;this._blinker=function(){a._cursorBlink()};this._blink=C(this._blinker,500)}};d.prototype.refreshBlink=function(){if(this.cursorBlink){clearInterval(this._blink);
this._blink=C(this._blinker,500)}};d.prototype.scroll=function(){var a;if(++this.ybase===this.scrollback){this.ybase=this.ybase/2|0;this.lines=this.lines.slice(-(this.ybase+this.rows)+1)}this.ydisp=this.ybase;a=this.ybase+this.rows-1;a-=this.rows-1-this.scrollBottom;a===this.lines.length?this.lines.push(this.blankLine()):this.lines.splice(a,0,this.blankLine());if(this.scrollTop!==0){if(this.ybase!==0){this.ybase--;this.ydisp=this.ybase}this.lines.splice(this.ybase+this.scrollTop,1)}this.updateRange(this.scrollTop);
this.updateRange(this.scrollBottom)};d.prototype.scrollDisp=function(a){this.ydisp+=a;if(this.ydisp>this.ybase)this.ydisp=this.ybase;else if(this.ydisp<0)this.ydisp=0;this.refresh(0,this.rows-1)};d.prototype.write=function(a){var b=a.length,c=0,e;this.refreshEnd=this.refreshStart=this.y;if(this.ybase!==this.ydisp){this.ydisp=this.ybase;this.maxRange()}for(;c<b;c++){e=a[c];switch(this.state){case 0:switch(e){case "\u0007":this.bell();break;case "\n":case "\u000b":case "\u000c":if(this.convertEol)this.x=
0;this.y++;if(this.y>this.scrollBottom){this.y--;this.scroll()}break;case "\r":this.x=0;break;case "\u0008":this.x>0&&this.x--;break;case "\t":this.x=this.nextStop();break;case "\u000e":this.setgLevel(1);break;case "\u000f":this.setgLevel(0);break;case "\u001b":this.state=1;break;default:if(e>=" "){if(this.charset&&this.charset[e])e=this.charset[e];if(this.x>=this.cols){this.x=0;this.y++;if(this.y>this.scrollBottom){this.y--;this.scroll()}}this.lines[this.y+this.ybase][this.x]=[this.curAttr,e];this.x++;
this.updateRange(this.y);if(w(e)){e=this.y+this.ybase;if(this.cols<2||this.x>=this.cols){this.lines[e][this.x-1]=[this.curAttr," "];break}this.lines[e][this.x]=[this.curAttr," "];this.x++}}break}break;case 1:switch(e){case "[":this.params=[];this.currentParam=0;this.state=2;break;case "]":this.params=[];this.currentParam=0;this.state=3;break;case "P":this.params=[];this.currentParam=0;this.state=5;break;case "_":this.state=6;break;case "^":this.state=6;break;case "c":this.reset();break;case "E":this.x=
0;case "D":this.index();break;case "M":this.reverseIndex();break;case "%":this.setgLevel(0);this.setgCharset(0,d.charsets.US);this.state=0;c++;break;case "(":case ")":case "*":case "+":case "-":case ".":switch(e){case "(":this.gcharset=0;break;case ")":this.gcharset=1;break;case "*":this.gcharset=2;break;case "+":this.gcharset=3;break;case "-":this.gcharset=1;break;case ".":this.gcharset=2;break}this.state=4;break;case "/":this.gcharset=3;this.state=4;c--;break;case "N":break;case "O":break;case "n":this.setgLevel(2);
break;case "o":this.setgLevel(3);break;case "|":this.setgLevel(3);break;case "}":this.setgLevel(2);break;case "~":this.setgLevel(1);break;case "7":this.saveCursor();this.state=0;break;case "8":this.restoreCursor();this.state=0;break;case "#":this.state=0;c++;break;case "H":this.tabSet();break;case "=":this.log("Serial port requested application keypad.");this.applicationKeypad=true;this.state=0;break;case ">":this.log("Switching back to normal keypad.");this.applicationKeypad=false;this.state=0;break;
default:this.state=0;this.error("Unknown ESC control: %s.",e);break}break;case 4:switch(e){case "0":e=d.charsets.SCLD;break;case "A":e=d.charsets.UK;break;case "B":e=d.charsets.US;break;case "4":e=d.charsets.Dutch;break;case "C":case "5":e=d.charsets.Finnish;break;case "R":e=d.charsets.French;break;case "Q":e=d.charsets.FrenchCanadian;break;case "K":e=d.charsets.German;break;case "Y":e=d.charsets.Italian;break;case "E":case "6":e=d.charsets.NorwegianDanish;break;case "Z":e=d.charsets.Spanish;break;
case "H":case "7":e=d.charsets.Swedish;break;case "=":e=d.charsets.Swiss;break;case "/":e=d.charsets.ISOLatin;c++;break;default:e=d.charsets.US;break}this.setgCharset(this.gcharset,e);this.gcharset=null;this.state=0;break;case 3:if(e==="\u001b"||e==="\u0007"){e==="\u001b"&&c++;this.params.push(this.currentParam);switch(this.params[0]){case 0:case 1:case 2:if(this.params[1]){this.title=this.params[1];this.handleTitle(this.title)}break;case 3:break;case 4:case 5:break;case 10:case 11:case 12:case 13:case 14:case 15:case 16:case 17:case 18:case 19:break;
case 46:break;case 50:break;case 51:break;case 52:break;case 104:case 105:case 110:case 111:case 112:case 113:case 114:case 115:case 116:case 117:case 118:break}this.params=[];this.state=this.currentParam=0}else if(this.params.length)this.currentParam+=e;else if(e>="0"&&e<="9")this.currentParam=this.currentParam*10+e.charCodeAt(0)-48;else if(e===";"){this.params.push(this.currentParam);this.currentParam=""}break;case 2:if(e==="?"||e===">"||e==="!"){this.prefix=e;break}if(e>="0"&&e<="9"){this.currentParam=
this.currentParam*10+e.charCodeAt(0)-48;break}if(e==="$"||e==='"'||e===" "||e==="'"){this.postfix=e;break}this.params.push(this.currentParam);this.currentParam=0;if(e===";")break;this.state=0;switch(e){case "A":this.cursorUp(this.params);break;case "B":this.cursorDown(this.params);break;case "C":this.cursorForward(this.params);break;case "D":this.cursorBackward(this.params);break;case "H":this.cursorPos(this.params);break;case "J":this.eraseInDisplay(this.params);break;case "K":this.eraseInLine(this.params);
break;case "m":this.prefix||this.charAttributes(this.params);break;case "n":this.prefix||this.deviceStatus(this.params);break;case "@":this.insertChars(this.params);break;case "E":this.cursorNextLine(this.params);break;case "F":this.cursorPrecedingLine(this.params);break;case "G":this.cursorCharAbsolute(this.params);break;case "L":this.insertLines(this.params);break;case "M":this.deleteLines(this.params);break;case "P":this.deleteChars(this.params);break;case "X":this.eraseChars(this.params);break;
case "`":this.charPosAbsolute(this.params);break;case "a":this.HPositionRelative(this.params);break;case "c":this.sendDeviceAttributes(this.params);break;case "d":this.linePosAbsolute(this.params);break;case "e":this.VPositionRelative(this.params);break;case "f":this.HVPosition(this.params);break;case "h":this.setMode(this.params);break;case "l":this.resetMode(this.params);break;case "r":this.setScrollRegion(this.params);break;case "s":this.saveCursor(this.params);break;case "u":this.restoreCursor(this.params);
break;case "I":this.cursorForwardTab(this.params);break;case "S":this.scrollUp(this.params);break;case "T":this.params.length<2&&!this.prefix&&this.scrollDown(this.params);break;case "Z":this.cursorBackwardTab(this.params);break;case "b":this.repeatPrecedingCharacter(this.params);break;case "g":this.tabClear(this.params);break;case "p":switch(this.prefix){case "!":this.softReset(this.params);break}break;default:this.error("Unknown CSI code: %s.",e);break}this.postfix=this.prefix="";break;case 5:if(e===
"\u001b"||e==="\u0007"){e==="\u001b"&&c++;switch(this.prefix){case "":break;case "$q":e=this.currentParam;var i=false;switch(e){case '"q':e='0"q';break;case '"p':e='61"p';break;case "r":e=""+(this.scrollTop+1)+";"+(this.scrollBottom+1)+"r";break;case "m":e="0m";break;default:this.error("Unknown DCS Pt: %s.",e);e="";break}this.send("\u001bP"+ +i+"$r"+e+"\u001b\\");break;case "+p":break;case "+q":e=this.currentParam;i=false;this.send("\u001bP"+ +i+"+r"+e+"\u001b\\");break;default:this.error("Unknown DCS prefix: %s.",
this.prefix);break}this.currentParam=0;this.prefix="";this.state=0}else if(this.currentParam)this.currentParam+=e;else if(!this.prefix&&e!=="$"&&e!=="+")this.currentParam=e;else if(this.prefix.length===2)this.currentParam=e;else this.prefix+=e;break;case 6:if(e==="\u001b"||e==="\u0007"){e==="\u001b"&&c++;this.state=0}break}}this.updateRange(this.y);this.refresh(this.refreshStart,this.refreshEnd)};d.prototype.writeln=function(a){this.write(a+"\r\n")};d.prototype.keyDown=function(a){var b=this,c;switch(a.keyCode){case 8:if(a.shiftKey){c=
"\u0008";break}c="";break;case 9:if(a.shiftKey){c="\u001b[Z";break}c="\t";break;case 13:c="\r";break;case 27:c="\u001b";break;case 37:if(this.applicationCursor){c="\u001bOD";break}c="\u001b[D";break;case 39:if(this.applicationCursor){c="\u001bOC";break}c="\u001b[C";break;case 38:if(this.applicationCursor){c="\u001bOA";break}if(a.ctrlKey){this.scrollDisp(-1);return o(a)}else c="\u001b[A";break;case 40:if(this.applicationCursor){c="\u001bOB";break}if(a.ctrlKey){this.scrollDisp(1);return o(a)}else c=
"\u001b[B";break;case 46:c="\u001b[3~";break;case 45:c="\u001b[2~";break;case 36:if(this.applicationKeypad){c="\u001bOH";break}c="\u001bOH";break;case 35:if(this.applicationKeypad){c="\u001bOF";break}c="\u001bOF";break;case 33:if(a.shiftKey){this.scrollDisp(-(this.rows-1));return o(a)}else c="\u001b[5~";break;case 34:if(a.shiftKey){this.scrollDisp(this.rows-1);return o(a)}else c="\u001b[6~";break;case 112:c="\u001bOP";break;case 113:c="\u001bOQ";break;case 114:c="\u001bOR";break;case 115:c="\u001bOS";
break;case 116:c="\u001b[15~";break;case 117:c="\u001b[17~";break;case 118:c="\u001b[18~";break;case 119:c="\u001b[19~";break;case 120:c="\u001b[20~";break;case 121:c="\u001b[21~";break;case 122:c="\u001b[23~";break;case 123:c="\u001b[24~";break;default:if(a.ctrlKey)if(a.keyCode>=65&&a.keyCode<=90){if(this.screenKeys)if(!this.prefixMode&&!this.selectMode&&a.keyCode===65){this.enterPrefix();return o(a)}if(this.prefixMode&&a.keyCode===86){this.leavePrefix();return}if((this.prefixMode||this.selectMode)&&
a.keyCode===67){this.visualMode&&u(function(){b.leaveVisual()},1);return}c=s.fromCharCode(a.keyCode-64)}else if(a.keyCode===32)c=s.fromCharCode(0);else if(a.keyCode>=51&&a.keyCode<=55)c=s.fromCharCode(a.keyCode-51+27);else if(a.keyCode===56)c=s.fromCharCode(127);else if(a.keyCode===219)c=s.fromCharCode(27);else{if(a.keyCode===221)c=s.fromCharCode(29)}else if(!this.isMac&&a.altKey||this.isMac&&a.metaKey)if(a.keyCode>=65&&a.keyCode<=90)c="\u001b"+s.fromCharCode(a.keyCode+32);else if(a.keyCode===192)c=
"\u001b`";else if(a.keyCode>=48&&a.keyCode<=57)c="\u001b"+(a.keyCode-48);break}if(!c)return true;if(this.prefixMode){this.leavePrefix();return o(a)}if(this.selectMode){this.keySelect(a,c);return o(a)}this.emit("keydown",a);this.emit("key",c,a);this.showCursor();this.handler(c);return o(a)};d.prototype.setgLevel=function(a){this.glevel=a;this.charset=this.charsets[a]};d.prototype.setgCharset=function(a,b){this.charsets[a]=b;if(this.glevel===a)this.charset=b};d.prototype.keyPress=function(a){var b;
o(a);if(a.charCode)b=a.charCode;else if(a.which==null)b=a.keyCode;else if(a.which!==0&&a.charCode!==0)b=a.which;else return false;if(!b||a.ctrlKey||a.altKey||a.metaKey)return false;b=s.fromCharCode(b);if(this.prefixMode){this.leavePrefix();this.keyPrefix(a,b);return false}if(this.selectMode){this.keySelect(a,b);return false}this.emit("keypress",b,a);this.emit("key",b,a);this.showCursor();this.handler(b);return false};d.prototype.send=function(a){var b=this;this.queue||u(function(){b.handler(b.queue);
b.queue=""},1);this.queue+=a};d.prototype.bell=function(){this.emit("bell");if(this.visualBell){var a=this;this.element.style.borderColor="white";u(function(){a.element.style.borderColor=""},10);this.popOnBell&&this.focus()}};d.prototype.log=function(){this.debug&&this.context.console&&this.context.console.log&&this.context.console.log.apply(this.context.console,Array.prototype.slice.call(arguments))};d.prototype.error=function(){this.debug&&this.context.console&&this.context.console.error&&this.context.console.error.apply(this.context.console,
Array.prototype.slice.call(arguments))};d.prototype.resize=function(a,b){var c,e,i;if(a<1)a=1;if(b<1)b=1;i=this.cols;if(i<a){e=[this.defAttr," "];for(c=this.lines.length;c--;)for(;this.lines[c].length<a;)this.lines[c].push(e)}else if(i>a)for(c=this.lines.length;c--;)for(;this.lines[c].length>a;)this.lines[c].pop();this.setupStops(i);this.cols=a;i=this.rows;if(i<b)for(e=this.element;i++<b;){this.lines.length<b+this.ybase&&this.lines.push(this.blankLine());if(this.children.length<b){c=this.document.createElement("div");
e.appendChild(c);this.children.push(c)}}else if(i>b)for(;i-- >b;){this.lines.length>b+this.ybase&&this.lines.pop();if(this.children.length>b)(e=this.children.pop())&&e.parentNode.removeChild(e)}this.rows=b;if(this.y>=b)this.y=b-1;if(this.x>=a)this.x=a-1;this.scrollTop=0;this.scrollBottom=b-1;this.refresh(0,this.rows-1);this.normal=null};d.prototype.updateRange=function(a){if(a<this.refreshStart)this.refreshStart=a;if(a>this.refreshEnd)this.refreshEnd=a};d.prototype.maxRange=function(){this.refreshStart=
0;this.refreshEnd=this.rows-1};d.prototype.setupStops=function(a){if(a!=null)this.tabs[a]||(a=this.prevStop(a));else{this.tabs={};a=0}for(;a<this.cols;a+=8)this.tabs[a]=true};d.prototype.prevStop=function(a){if(a==null)a=this.x;for(;!this.tabs[--a]&&a>0;);return a>=this.cols?this.cols-1:a<0?0:a};d.prototype.nextStop=function(a){if(a==null)a=this.x;for(;!this.tabs[++a]&&a<this.cols;);return a>=this.cols?this.cols-1:a<0?0:a};d.prototype.eraseRight=function(a,b){for(var c=this.lines[this.ybase+b],e=
[this.eraseAttr()," "];a<this.cols;a++)c[a]=e;this.updateRange(b)};d.prototype.eraseLeft=function(a,b){var c=this.lines[this.ybase+b],e=[this.eraseAttr()," "];for(a++;a--;)c[a]=e;this.updateRange(b)};d.prototype.eraseLine=function(a){this.eraseRight(0,a)};d.prototype.blankLine=function(a){a=[a?this.eraseAttr():this.defAttr," "];for(var b=[],c=0;c<this.cols;c++)b[c]=a;return b};d.prototype.ch=function(a){return a?[this.eraseAttr()," "]:[this.defAttr," "]};d.prototype.is=function(a){return(this.termName+
"").indexOf(a)===0};d.prototype.handler=function(a){this.emit("data",a)};d.prototype.handleTitle=function(a){this.emit("title",a)};d.prototype.index=function(){this.y++;if(this.y>this.scrollBottom){this.y--;this.scroll()}this.state=0};d.prototype.reverseIndex=function(){var a;this.y--;if(this.y<this.scrollTop){this.y++;this.lines.splice(this.y+this.ybase,0,this.blankLine(true));a=this.rows-1-this.scrollBottom;this.lines.splice(this.rows-1+this.ybase-a+1,1);this.updateRange(this.scrollTop);this.updateRange(this.scrollBottom)}this.state=
0};d.prototype.reset=function(){this.options.rows=this.rows;this.options.cols=this.cols;d.call(this,this.options);this.refresh(0,this.rows-1)};d.prototype.tabSet=function(){this.tabs[this.x]=true;this.state=0};d.prototype.cursorUp=function(a){a=a[0];if(a<1)a=1;this.y-=a;if(this.y<0)this.y=0};d.prototype.cursorDown=function(a){a=a[0];if(a<1)a=1;this.y+=a;if(this.y>=this.rows)this.y=this.rows-1};d.prototype.cursorForward=function(a){a=a[0];if(a<1)a=1;this.x+=a;if(this.x>=this.cols)this.x=this.cols-
1};d.prototype.cursorBackward=function(a){a=a[0];if(a<1)a=1;this.x-=a;if(this.x<0)this.x=0};d.prototype.cursorPos=function(a){var b;b=a[0]-1;a=a.length>=2?a[1]-1:0;if(b<0)b=0;else if(b>=this.rows)b=this.rows-1;if(a<0)a=0;else if(a>=this.cols)a=this.cols-1;this.x=a;this.y=b};d.prototype.eraseInDisplay=function(a){switch(a[0]){case 0:this.eraseRight(this.x,this.y);for(a=this.y+1;a<this.rows;a++)this.eraseLine(a);break;case 1:this.eraseLeft(this.x,this.y);for(a=this.y;a--;)this.eraseLine(a);break;case 2:for(a=
this.rows;a--;)this.eraseLine(a);break;case 3:break}};d.prototype.eraseInLine=function(a){switch(a[0]){case 0:this.eraseRight(this.x,this.y);break;case 1:this.eraseLeft(this.x,this.y);break;case 2:this.eraseLine(this.y);break}};d.prototype.charAttributes=function(a){if(a.length===1&&a[0]===0)this.curAttr=this.defAttr;else{for(var b=a.length,c=0,e=this.curAttr>>18,i=this.curAttr>>9&511,h=this.curAttr&511,g;c<b;c++){g=a[c];if(g>=30&&g<=37)i=g-30;else if(g>=40&&g<=47)h=g-40;else if(g>=90&&g<=97){g+=
8;i=g-90}else if(g>=100&&g<=107){g+=8;h=g-100}else if(g===0){e=this.defAttr>>18;i=this.defAttr>>9&511;h=this.defAttr&511}else if(g===1)e|=1;else if(g===4)e|=2;else if(g===5)e|=4;else if(g===7)e|=8;else if(g===8)e|=16;else if(g===22)e&=-2;else if(g===24)e&=-3;else if(g===25)e&=-5;else if(g===27)e&=-9;else if(g===28)e&=-17;else if(g===39)i=this.defAttr>>9&511;else if(g===49)h=this.defAttr&511;else if(g===38)if(a[c+1]===2){c+=2;i=t(a[c]&255,a[c+1]&255,a[c+2]&255);if(i===-1)i=511;c+=2}else{if(a[c+1]===
5){c+=2;i=g=a[c]&255}}else if(g===48)if(a[c+1]===2){c+=2;h=t(a[c]&255,a[c+1]&255,a[c+2]&255);if(h===-1)h=511;c+=2}else{if(a[c+1]===5){c+=2;h=g=a[c]&255}}else if(g===100){i=this.defAttr>>9&511;h=this.defAttr&511}else this.error("Unknown SGR attribute: %d.",g)}this.curAttr=e<<18|i<<9|h}};d.prototype.deviceStatus=function(a){if(this.prefix){if(this.prefix==="?")switch(a[0]){case 6:this.send("\u001b[?"+(this.y+1)+";"+(this.x+1)+"R");break;case 15:break;case 25:break;case 26:break;case 53:break}}else switch(a[0]){case 5:this.send("\u001b[0n");
break;case 6:this.send("\u001b["+(this.y+1)+";"+(this.x+1)+"R");break}};d.prototype.insertChars=function(a){var b,c,e;a=a[0];if(a<1)a=1;b=this.y+this.ybase;c=this.x;for(e=[this.eraseAttr()," "];a--&&c<this.cols;){this.lines[b].splice(c++,0,e);this.lines[b].pop()}};d.prototype.cursorNextLine=function(a){a=a[0];if(a<1)a=1;this.y+=a;if(this.y>=this.rows)this.y=this.rows-1;this.x=0};d.prototype.cursorPrecedingLine=function(a){a=a[0];if(a<1)a=1;this.y-=a;if(this.y<0)this.y=0;this.x=0};d.prototype.cursorCharAbsolute=
function(a){a=a[0];if(a<1)a=1;this.x=a-1};d.prototype.insertLines=function(a){var b,c;a=a[0];if(a<1)a=1;b=this.y+this.ybase;c=this.rows-1-this.scrollBottom;for(c=this.rows-1+this.ybase-c+1;a--;){this.lines.splice(b,0,this.blankLine(true));this.lines.splice(c,1)}this.updateRange(this.y);this.updateRange(this.scrollBottom)};d.prototype.deleteLines=function(a){var b,c;a=a[0];if(a<1)a=1;b=this.y+this.ybase;c=this.rows-1-this.scrollBottom;for(c=this.rows-1+this.ybase-c;a--;){this.lines.splice(c+1,0,this.blankLine(true));
this.lines.splice(b,1)}this.updateRange(this.y);this.updateRange(this.scrollBottom)};d.prototype.deleteChars=function(a){var b,c;a=a[0];if(a<1)a=1;b=this.y+this.ybase;for(c=[this.eraseAttr()," "];a--;){this.lines[b].splice(this.x,1);this.lines[b].push(c)}};d.prototype.eraseChars=function(a){var b,c,e;a=a[0];if(a<1)a=1;b=this.y+this.ybase;c=this.x;for(e=[this.eraseAttr()," "];a--&&c<this.cols;)this.lines[b][c++]=e};d.prototype.charPosAbsolute=function(a){a=a[0];if(a<1)a=1;this.x=a-1;if(this.x>=this.cols)this.x=
this.cols-1};d.prototype.HPositionRelative=function(a){a=a[0];if(a<1)a=1;this.x+=a;if(this.x>=this.cols)this.x=this.cols-1};d.prototype.sendDeviceAttributes=function(a){if(!(a[0]>0))if(this.prefix){if(this.prefix===">")if(this.is("xterm"))this.send("\u001b[>0;276;0c");else if(this.is("rxvt-unicode"))this.send("\u001b[>85;95;0c");else if(this.is("linux"))this.send(a[0]+"c");else this.is("screen")&&this.send("\u001b[>83;40003;0c")}else if(this.is("xterm")||this.is("rxvt-unicode")||this.is("screen"))this.send("\u001b[?1;2c");
else this.is("linux")&&this.send("\u001b[?6c")};d.prototype.linePosAbsolute=function(a){a=a[0];if(a<1)a=1;this.y=a-1;if(this.y>=this.rows)this.y=this.rows-1};d.prototype.VPositionRelative=function(a){a=a[0];if(a<1)a=1;this.y+=a;if(this.y>=this.rows)this.y=this.rows-1};d.prototype.HVPosition=function(a){if(a[0]<1)a[0]=1;if(a[1]<1)a[1]=1;this.y=a[0]-1;if(this.y>=this.rows)this.y=this.rows-1;this.x=a[1]-1;if(this.x>=this.cols)this.x=this.cols-1};d.prototype.setMode=function(a){if(typeof a==="object")for(var b=
a.length,c=0;c<b;c++)this.setMode(a[c]);else if(this.prefix){if(this.prefix==="?")switch(a){case 1:this.applicationCursor=true;break;case 2:this.setgCharset(0,d.charsets.US);this.setgCharset(1,d.charsets.US);this.setgCharset(2,d.charsets.US);this.setgCharset(3,d.charsets.US);break;case 3:this.savedCols=this.cols;this.resize(132,this.rows);break;case 6:this.originMode=true;break;case 7:this.wraparoundMode=true;break;case 12:break;case 66:this.log("Serial port requested application keypad.");this.applicationKeypad=
true;break;case 9:case 1E3:case 1002:case 1003:this.x10Mouse=a===9;this.vt200Mouse=a===1E3;this.normalMouse=a>1E3;this.mouseEvents=true;this.element.style.cursor="default";this.log("Binding to mouse events.");break;case 1004:this.sendFocus=true;break;case 1005:this.utfMouse=true;break;case 1006:this.sgrMouse=true;break;case 1015:this.urxvtMouse=true;break;case 25:this.cursorHidden=false;break;case 1049:case 47:case 1047:if(!this.normal){a={lines:this.lines,ybase:this.ybase,ydisp:this.ydisp,x:this.x,
y:this.y,scrollTop:this.scrollTop,scrollBottom:this.scrollBottom,tabs:this.tabs};this.reset();this.normal=a;this.showCursor()}break}}else switch(a){case 4:this.insertMode=true;break;case 20:break}};d.prototype.resetMode=function(a){if(typeof a==="object")for(var b=a.length,c=0;c<b;c++)this.resetMode(a[c]);else if(this.prefix){if(this.prefix==="?")switch(a){case 1:this.applicationCursor=false;break;case 3:this.cols===132&&this.savedCols&&this.resize(this.savedCols,this.rows);delete this.savedCols;
break;case 6:this.originMode=false;break;case 7:this.wraparoundMode=false;break;case 12:break;case 66:this.log("Switching back to normal keypad.");this.applicationKeypad=false;break;case 9:case 1E3:case 1002:case 1003:this.mouseEvents=this.normalMouse=this.vt200Mouse=this.x10Mouse=false;this.element.style.cursor="";break;case 1004:this.sendFocus=false;break;case 1005:this.utfMouse=false;break;case 1006:this.sgrMouse=false;break;case 1015:this.urxvtMouse=false;break;case 25:this.cursorHidden=true;
break;case 1049:case 47:case 1047:if(this.normal){this.lines=this.normal.lines;this.ybase=this.normal.ybase;this.ydisp=this.normal.ydisp;this.x=this.normal.x;this.y=this.normal.y;this.scrollTop=this.normal.scrollTop;this.scrollBottom=this.normal.scrollBottom;this.tabs=this.normal.tabs;this.normal=null;this.refresh(0,this.rows-1);this.showCursor()}break}}else switch(a){case 4:this.insertMode=false;break;case 20:break}};d.prototype.setScrollRegion=function(a){if(!this.prefix){this.scrollTop=(a[0]||
1)-1;this.scrollBottom=(a[1]||this.rows)-1;this.y=this.x=0}};d.prototype.saveCursor=function(){this.savedX=this.x;this.savedY=this.y};d.prototype.restoreCursor=function(){this.x=this.savedX||0;this.y=this.savedY||0};d.prototype.cursorForwardTab=function(a){for(a=a[0]||1;a--;)this.x=this.nextStop()};d.prototype.scrollUp=function(a){for(a=a[0]||1;a--;){this.lines.splice(this.ybase+this.scrollTop,1);this.lines.splice(this.ybase+this.scrollBottom,0,this.blankLine())}this.updateRange(this.scrollTop);this.updateRange(this.scrollBottom)};
d.prototype.scrollDown=function(a){for(a=a[0]||1;a--;){this.lines.splice(this.ybase+this.scrollBottom,1);this.lines.splice(this.ybase+this.scrollTop,0,this.blankLine())}this.updateRange(this.scrollTop);this.updateRange(this.scrollBottom)};d.prototype.initMouseTracking=function(){};d.prototype.resetTitleModes=function(){};d.prototype.cursorBackwardTab=function(a){for(a=a[0]||1;a--;)this.x=this.prevStop()};d.prototype.repeatPrecedingCharacter=function(a){a=a[0]||1;for(var b=this.lines[this.ybase+this.y],
c=b[this.x-1]||[this.defAttr," "];a--;)b[this.x++]=c};d.prototype.tabClear=function(a){a=a[0];if(a<=0)delete this.tabs[this.x];else if(a===3)this.tabs={}};d.prototype.mediaCopy=function(){};d.prototype.setResources=function(){};d.prototype.disableModifiers=function(){};d.prototype.setPointerMode=function(){};d.prototype.softReset=function(){this.applicationCursor=this.applicationKeypad=this.wraparoundMode=this.originMode=this.insertMode=this.cursorHidden=false;this.scrollTop=0;this.scrollBottom=this.rows-
1;this.curAttr=this.defAttr;this.x=this.y=0;this.charset=null;this.glevel=0;this.charsets=[null]};d.prototype.requestAnsiMode=function(){};d.prototype.requestPrivateMode=function(){};d.prototype.setConformanceLevel=function(){};d.prototype.loadLEDs=function(){};d.prototype.setCursorStyle=function(){};d.prototype.setCharProtectionAttr=function(){};d.prototype.restorePrivateValues=function(){};d.prototype.setAttrInRectangle=function(a){for(var b=a[0],c=a[1],e=a[2],i=a[3],h=a[4],g,f;b<e+1;b++){g=this.lines[this.ybase+
b];for(f=c;f<i;f++)g[f]=[h,g[f][1]]}this.updateRange(a[0]);this.updateRange(a[2])};d.prototype.savePrivateValues=function(){};d.prototype.manipulateWindow=function(){};d.prototype.reverseAttrInRectangle=function(){};d.prototype.setTitleModeFeature=function(){};d.prototype.setWarningBellVolume=function(){};d.prototype.setMarginBellVolume=function(){};d.prototype.copyRectangle=function(){};d.prototype.enableFilterRectangle=function(){};d.prototype.requestParameters=function(){};d.prototype.selectChangeExtent=
function(){};d.prototype.fillRectangle=function(a){for(var b=a[0],c=a[1],e=a[2],i=a[3],h=a[4],g,f;c<i+1;c++){g=this.lines[this.ybase+c];for(f=e;f<h;f++)g[f]=[g[f][0],s.fromCharCode(b)]}this.updateRange(a[1]);this.updateRange(a[3])};d.prototype.enableLocatorReporting=function(){};d.prototype.eraseRectangle=function(a){var b=a[0],c=a[1],e=a[2],i=a[3],h,g,f;for(f=[this.eraseAttr()," "];b<e+1;b++){h=this.lines[this.ybase+b];for(g=c;g<i;g++)h[g]=f}this.updateRange(a[0]);this.updateRange(a[2])};d.prototype.setLocatorEvents=
function(){};d.prototype.selectiveEraseRectangle=function(){};d.prototype.requestLocatorPosition=function(){};d.prototype.insertColumns=function(){for(var a=params[0],b=this.ybase+this.rows,c=[this.eraseAttr()," "],e;a--;)for(e=this.ybase;e<b;e++){this.lines[e].splice(this.x+1,0,c);this.lines[e].pop()}this.maxRange()};d.prototype.deleteColumns=function(){for(var a=params[0],b=this.ybase+this.rows,c=[this.eraseAttr()," "],e;a--;)for(e=this.ybase;e<b;e++){this.lines[e].splice(this.x,1);this.lines[e].push(c)}this.maxRange()};
d.prototype.enterPrefix=function(){this.prefixMode=true};d.prototype.leavePrefix=function(){this.prefixMode=false};d.prototype.enterSelect=function(){this._real={x:this.x,y:this.y,ydisp:this.ydisp,ybase:this.ybase,cursorHidden:this.cursorHidden,lines:this.copyBuffer(this.lines),write:this.write};this.write=function(){};this.selectMode=true;this.cursorHidden=this.visualMode=false;this.refresh(this.y,this.y)};d.prototype.leaveSelect=function(){this.x=this._real.x;this.y=this._real.y;this.ydisp=this._real.ydisp;
this.ybase=this._real.ybase;this.cursorHidden=this._real.cursorHidden;this.lines=this._real.lines;this.write=this._real.write;delete this._real;this.visualMode=this.selectMode=false;this.refresh(0,this.rows-1)};d.prototype.enterVisual=function(){this._real.preVisual=this.copyBuffer(this.lines);this.selectText(this.x,this.x,this.ydisp+this.y,this.ydisp+this.y);this.visualMode=true};d.prototype.leaveVisual=function(){this.lines=this._real.preVisual;delete this._real.preVisual;delete this._selected;
this.visualMode=false;this.refresh(0,this.rows-1)};d.prototype.enterSearch=function(a){this.entry="";this.searchMode=true;this.searchDown=a;this._real.preSearch=this.copyBuffer(this.lines);this._real.preSearchX=this.x;this._real.preSearchY=this.y;a=this.ydisp+this.rows-1;for(var b=0;b<this.entryPrefix.length;b++)this.lines[a][b]=[this.defAttr&-512|4,this.entryPrefix[b]];this.y=this.rows-1;this.x=this.entryPrefix.length;this.refresh(this.rows-1,this.rows-1)};d.prototype.leaveSearch=function(){this.searchMode=
false;if(this._real.preSearch){this.lines=this._real.preSearch;this.x=this._real.preSearchX;this.y=this._real.preSearchY;delete this._real.preSearch;delete this._real.preSearchX;delete this._real.preSearchY}this.refresh(this.rows-1,this.rows-1)};d.prototype.copyBuffer=function(a){a=a||this.lines;for(var b=[],c=0;c<a.length;c++){b[c]=[];for(var e=0;e<a[c].length;e++)b[c][e]=[a[c][e][0],a[c][e][1]]}return b};d.prototype.getCopyTextarea=function(){var a=this._copyTextarea,b=this.document;if(!a){a=b.createElement("textarea");
a.style.position="absolute";a.style.left="-32000px";a.style.top="-32000px";a.style.width="0px";a.style.height="0px";a.style.opacity="0";a.style.backgroundColor="transparent";a.style.borderStyle="none";a.style.outlineStyle="none";b.getElementsByTagName("body")[0].appendChild(a);this._copyTextarea=a}return a};d.prototype.copyText=function(a){var b=this,c=this.getCopyTextarea();this.emit("copy",a);c.focus();c.textContent=a;c.value=a;c.setSelectionRange(0,a.length);u(function(){b.element.focus();b.focus()},
1)};d.prototype.selectText=function(a,b,c,e){var i,h,g,f,m,l;if(this._selected){a=this._selected.x1;c=this._selected.x2;i=this._selected.y1;h=this._selected.y2;if(h<i){g=c;c=a;a=g;g=h;h=i;i=g}if(c<a&&i===h){g=c;c=a;a=g}for(f=i;f<=h;f++){g=0;m=this.cols-1;if(f===i)g=a;if(f===h)m=c;for(;g<=m;g++)if(this.lines[f][g].old!=null){l=this.lines[f][g].old;delete this.lines[f][g].old;this.lines[f][g]=[l,this.lines[f][g][1]]}}c=this._selected.y1;a=this._selected.x1}c=Math.max(c,0);c=Math.min(c,this.ydisp+this.rows-
1);e=Math.max(e,0);e=Math.min(e,this.ydisp+this.rows-1);this._selected={x1:a,x2:b,y1:c,y2:e};if(e<c){g=b;b=a;a=g;g=e;e=c;c=g}if(b<a&&c===e){g=b;b=a;a=g}for(f=c;f<=e;f++){g=0;m=this.cols-1;if(f===c)g=a;if(f===e)m=b;for(;g<=m;g++){l=this.lines[f][g][0];this.lines[f][g]=[l&-512|261636,this.lines[f][g][1]];this.lines[f][g].old=l}}c-=this.ydisp;e-=this.ydisp;c=Math.max(c,0);Math.min(c,this.rows-1);e=Math.max(e,0);Math.min(e,this.rows-1);this.refresh(0,this.rows-1)};d.prototype.grabText=function(a,b,c,
e){var i="",h="",g,f,m,l;if(e<c){g=b;b=a;a=g;g=e;e=c;c=g}if(b<a&&c===e){g=b;b=a;a=g}for(m=c;m<=e;m++){f=0;l=this.cols-1;if(m===c)f=a;if(m===e)l=b;for(;f<=l;f++){g=this.lines[m][f][1];if(g===" ")h+=g;else{if(h){i+=h;h=""}i+=g;w(g)&&f++}}h="";i+="\n"}f=b;for(m=e;f<this.cols;f++)if(this.lines[m][f][1]!==" "){i=i.slice(0,-1);break}return i};d.prototype.keyPrefix=function(a,b){if(b==="k"||b==="&")this.destroy();else if(b==="p"||b==="]")this.emit("request paste");else if(b==="c")this.emit("request create");
else if(b>="0"&&b<="9"){b=+b-1;~b||(b=9);this.emit("request term",b)}else if(b==="n")this.emit("request term next");else if(b==="P")this.emit("request term previous");else if(b===":")this.emit("request command mode");else b==="["&&this.enterSelect()};d.prototype.keySelect=function(a,b){this.showCursor();if(this.searchMode||b==="n"||b==="N")return this.keySearch(a,b);if(b==="\u0004"){a=this.ydisp+this.y;if(this.ydisp===this.ybase){this.y=Math.min(this.y+(this.rows-1)/2|0,this.rows-1);this.refresh(0,
this.rows-1)}else this.scrollDisp((this.rows-1)/2|0);this.visualMode&&this.selectText(this.x,this.x,a,this.ydisp+this.y)}else if(b==="\u0015"){a=this.ydisp+this.y;if(this.ydisp===0){this.y=Math.max(this.y-(this.rows-1)/2|0,0);this.refresh(0,this.rows-1)}else this.scrollDisp(-(this.rows-1)/2|0);this.visualMode&&this.selectText(this.x,this.x,a,this.ydisp+this.y)}else if(b==="\u0006"){a=this.ydisp+this.y;this.scrollDisp(this.rows-1);this.visualMode&&this.selectText(this.x,this.x,a,this.ydisp+this.y)}else if(b===
"\u0002"){a=this.ydisp+this.y;this.scrollDisp(-(this.rows-1));this.visualMode&&this.selectText(this.x,this.x,a,this.ydisp+this.y)}else if(b==="k"||b==="\u001b[A"){a=this.ydisp+this.y;this.y--;if(this.y<0){this.y=0;this.scrollDisp(-1)}this.visualMode?this.selectText(this.x,this.x,a,this.ydisp+this.y):this.refresh(this.y,this.y+1)}else if(b==="j"||b==="\u001b[B"){a=this.ydisp+this.y;this.y++;if(this.y>=this.rows){this.y=this.rows-1;this.scrollDisp(1)}this.visualMode?this.selectText(this.x,this.x,a,
this.ydisp+this.y):this.refresh(this.y-1,this.y)}else if(b==="h"||b==="\u001b[D"){b=this.x;this.x--;if(this.x<0)this.x=0;this.visualMode?this.selectText(b,this.x,this.ydisp+this.y,this.ydisp+this.y):this.refresh(this.y,this.y)}else if(b==="l"||b==="\u001b[C"){b=this.x;this.x++;if(this.x>=this.cols)this.x=this.cols-1;this.visualMode?this.selectText(b,this.x,this.ydisp+this.y,this.ydisp+this.y):this.refresh(this.y,this.y)}else if(b==="v"||b===" ")this.visualMode?this.leaveVisual():this.enterVisual();
else if(b==="y"){if(this.visualMode){this.copyText(this.grabText(this._selected.x1,this._selected.x2,this._selected.y1,this._selected.y2));this.leaveVisual()}}else if(b==="q"||b==="\u001b")this.visualMode?this.leaveVisual():this.leaveSelect();else if(b==="w"||b==="W"){var c=this.x,e=this.y,i=this.ydisp;b=this.x;a=this.y;for(var h=this.ydisp,g=false;;){for(var f=this.lines[h+a];b<this.cols;){if(f[b][1]<=" ")g=true;else if(g)break;b++}if(b>=this.cols)b=this.cols-1;if(b===this.cols-1&&f[b][1]<=" "){b=
0;if(++a>=this.rows){a--;if(++h>this.ybase){h=this.ybase;b=this.x;break}}}else break}this.x=b;this.y=a;this.scrollDisp(-this.ydisp+h);this.visualMode&&this.selectText(c,this.x,e+i,this.ydisp+this.y)}else if(b==="b"||b==="B"){c=this.x;e=this.y;i=this.ydisp;b=this.x;a=this.y;for(h=this.ydisp;;){f=this.lines[h+a];for(g=b>0&&f[b][1]>" "&&f[b-1][1]>" ";b>=0;){if(f[b][1]<=" ")if(g&&b+1<this.cols&&f[b+1][1]>" "){b++;break}else g=true;b--}if(b<0)b=0;if(b===0&&(f[b][1]<=" "||!g)){b=this.cols-1;if(--a<0){a++;
if(--h<0){h++;b=0;break}}}else break}this.x=b;this.y=a;this.scrollDisp(-this.ydisp+h);this.visualMode&&this.selectText(c,this.x,e+i,this.ydisp+this.y)}else if(b==="e"||b==="E"){b=this.x+1;a=this.y;h=this.ydisp;for(b>=this.cols&&b--;;){for(f=this.lines[h+a];b<this.cols;)if(f[b][1]<=" ")b++;else break;for(;b<this.cols;){if(f[b][1]<=" ")if(b-1>=0&&f[b-1][1]>" "){b--;break}b++}if(b>=this.cols)b=this.cols-1;if(b===this.cols-1&&f[b][1]<=" "){b=0;if(++a>=this.rows){a--;if(++h>this.ybase){h=this.ybase;break}}}else break}this.x=
b;this.y=a;this.scrollDisp(-this.ydisp+h);this.visualMode&&this.selectText(c,this.x,e+i,this.ydisp+this.y)}else if(b==="^"||b==="0"){c=this.x;if(b==="0")this.x=0;else if(b==="^"){f=this.lines[this.ydisp+this.y];for(b=0;b<this.cols;){if(f[b][1]>" ")break;b++}if(b>=this.cols)b=this.cols-1;this.x=b}this.visualMode?this.selectText(c,this.x,this.ydisp+this.y,this.ydisp+this.y):this.refresh(this.y,this.y)}else if(b==="$"){c=this.x;f=this.lines[this.ydisp+this.y];for(b=this.cols-1;b>=0;){if(f[b][1]>" "){this.visualMode&&
b<this.cols-1&&b++;break}b--}if(b<0)b=0;this.x=b;this.visualMode?this.selectText(c,this.x,this.ydisp+this.y,this.ydisp+this.y):this.refresh(this.y,this.y)}else if(b==="g"||b==="G"){c=this.x;e=this.y;i=this.ydisp;if(b==="g"){this.y=this.x=0;this.scrollDisp(-this.ydisp)}else if(b==="G"){this.x=0;this.y=this.rows-1;this.scrollDisp(this.ybase)}this.visualMode&&this.selectText(c,this.x,e+i,this.ydisp+this.y)}else if(b==="H"||b==="M"||b==="L"){c=this.x;e=this.y;if(b==="H")this.y=this.x=0;else if(b==="M"){this.x=
0;this.y=this.rows/2|0}else if(b==="L"){this.x=0;this.y=this.rows-1}if(this.visualMode)this.selectText(c,this.x,this.ydisp+e,this.ydisp+this.y);else{this.refresh(e,e);this.refresh(this.y,this.y)}}else if(b==="{"||b==="}"){c=this.x;e=this.y;i=this.ydisp;var m=g=false,l=-1;a=this.y+(b==="{"?-1:1);h=this.ydisp;var j;if(b==="{"){if(a<0){a++;h>0&&h--}}else if(b==="}")if(a>=this.rows){a--;h<this.ybase&&h++}for(;;){f=this.lines[h+a];for(j=0;j<this.cols;j++)if(f[j][1]>" "){if(l===-1)l=0;g=true;break}else if(j===
this.cols-1){if(l===-1)l=1;else if(l===0)m=true;else if(l===1)if(g)m=true;break}if(m)break;if(b==="{"){a--;if(a<0){a++;if(h>0)h--;else break}}else if(b==="}"){a++;if(a>=this.rows){a--;if(h<this.ybase)h++;else break}}}if(!m)if(b==="{")h=a=0;else if(b==="}"){a=this.rows-1;h=this.ybase}this.x=0;this.y=a;this.scrollDisp(-this.ydisp+h);this.visualMode&&this.selectText(c,this.x,e+i,this.ydisp+this.y)}else if(b==="/"||b==="?")this.visualMode||this.enterSearch(b==="/");else return false};d.prototype.keySearch=
function(a,b){if(b==="\u001b")this.leaveSearch();else if(b==="\r"||!this.searchMode&&(b==="n"||b==="N")){this.leaveSearch();var c=this.entry;if(c){a=this.x;for(var e=this.y,i=this.ydisp,h=false,g=false,f=this.x+1,m=this.ydisp+this.y,l,j=b==="N"?this.searchDown:!this.searchDown;;){for(b=this.lines[m];f<this.cols;){for(l=0;l<c.length;l++){if(f+l>=this.cols)break;if(b[f+l][1]!==c[l])break;else if(b[f+l][1]===c[l]&&l===c.length-1){h=true;break}}if(h)break;f+=l+1}if(h)break;f=0;if(j){m--;if(m<0){if(g)break;
g=true;m=this.ybase+this.rows-1}}else{m++;if(m>this.ybase+this.rows-1){if(g)break;g=true;m=0}}}if(h){if(m-this.ybase<0){l=m;m=0;if(l>this.ybase){m=l-this.ybase;l=this.ybase}}else{l=this.ybase;m-=this.ybase}this.x=f;this.y=m;this.scrollDisp(-this.ydisp+l);this.visualMode&&this.selectText(a,this.x,e+i,this.ydisp+this.y)}else this.refresh(0,this.rows-1)}else this.refresh(0,this.rows-1)}else if(b==="\u0008"||b===""){if(this.entry.length!==0){a=this.ydisp+this.rows-1;this.entry=this.entry.slice(0,-1);
l=this.entryPrefix.length+this.entry.length;this.lines[a][l]=[this.lines[a][l][0]," "];this.x--;this.refresh(this.rows-1,this.rows-1);this.refresh(this.y,this.y)}}else if(b.length===1&&b>=" "&&b<="~"){a=this.ydisp+this.rows-1;this.entry+=b;l=this.entryPrefix.length+this.entry.length-1;this.lines[a][l]=[this.defAttr&-512|4,b];this.x++;this.refresh(this.rows-1,this.rows-1);this.refresh(this.y,this.y)}else return false};d.charsets={};d.charsets.SCLD={"`":"\u25c6",a:"\u2592",b:"\t",c:"\u000c",d:"\r",
e:"\n",f:"\u00b0",g:"\u00b1",h:"\u2424",i:"\u000b",j:"\u2518",k:"\u2510",l:"\u250c",m:"\u2514",n:"\u253c",o:"\u23ba",p:"\u23bb",q:"\u2500",r:"\u23bc",s:"\u23bd",t:"\u251c",u:"\u2524",v:"\u2534",w:"\u252c",x:"\u2502",y:"\u2264",z:"\u2265","{":"\u03c0","|":"\u2260","}":"\u00a3","~":"\u00b7"};d.charsets.UK=null;d.charsets.US=null;d.charsets.Dutch=null;d.charsets.Finnish=null;d.charsets.French=null;d.charsets.FrenchCanadian=null;d.charsets.German=null;d.charsets.Italian=null;d.charsets.NorwegianDanish=
null;d.charsets.Spanish=null;d.charsets.Swedish=null;d.charsets.Swiss=null;d.charsets.ISOLatin=null;var s=this.String,u=this.setTimeout,C=this.setInterval;t._cache={};t.distance=function(a,b,c,e,i,h){return Math.pow(30*(a-e),2)+Math.pow(59*(b-i),2)+Math.pow(11*(c-h),2)};d.EventEmitter=r;d.inherits=A;d.on=p;d.off=v;d.cancel=o;if(typeof module!=="undefined")module.exports=d;else this.Terminal=d}).call(function(){return this||(typeof window!=="undefined"?window:global)}());
