#!/bin/sh

#Include common scripts
SZF_DockerDSM_COMMON_UTIL="/var/packages/Docker/target/ddsm/plugins/DockerDSMCommon.sh"
. ${SZF_DockerDSM_COMMON_UTIL}

case $1 in
	--sdk-mod-ver)
	#Print SDK support version
	echo "1.0";
	;;
	--name)
	#Print package name
	echo "";
	;;
	--pkg-ver)
	#Print package version
	echo "1.0";
	;;
	--vendor)
	#Print package vendor
	echo "Synology";
	;;
	--pre)
		DDSM_LIST=""
		SLAVE_LIST=`echo $SLAVES | tr "," "\n"`
		# create case, 2 interface transfer to 1 interface, check slave
		if [ "xcreate" = "x${ACTION}" ]; then
			for SLAVE in ${SLAVE_LIST}; do
				DDSM_LIST+=`$SZF_DDSM_CTL_TOOL --get-ddsm-name-by-iface $SLAVE`" "
			done
		elif [ "xdelete" = "x${ACTION}" ]; then
		# delete case, 1 interface transfer to 2 interface, check master
			DDSM_LIST+=`$SZF_DDSM_CTL_TOOL --get-ddsm-name-by-iface $MASTER`
		else
			#igonre this case
			exit 0
		fi
		for DDSM in $DDSM_LIST; do
			RUNNING=`$SZF_DOCKER_TOOL inspect --format '{{.State.Running}}' $DDSM`
			if [ $? -eq 0 ] && [ "$RUNNING" == "true" ]; then
				StopDockerDSM $DDSM
				# record container id for resume docker dsm on permit event
				ID=`$SZF_DOCKER_TOOL inspect --format '{{.Id}}' $DDSM`
				/bin/mkdir -p /var/run/synoddsm/pause_id/
				/bin/touch /var/run/synoddsm/pause_id/"$ID"
			fi
		done
        ;;
	--post)
		DDSM_LIST=""
		SLAVE_LIST=`echo $SLAVES | tr "," "\n"`
		# create case, 2 interface transfer to 1 interface, check slave
		if [ "xcreate" = "x${ACTION}" ]; then
			for SLAVE in ${SLAVE_LIST}; do
				DDSM_LIST+=`$SZF_DDSM_CTL_TOOL --get-ddsm-name-by-iface $SLAVE`" "
			done
		elif [ "xdelete" = "x${ACTION}" ]; then
		# delete case, 1 interface transfer to 2 interface, check master
			DDSM_LIST+=`$SZF_DDSM_CTL_TOOL --get-ddsm-name-by-iface $MASTER`
		else
		# ignore this case
			exit 0
		fi
		# wait resolve.conf ready, otherwise, container will failed to start
		time=0
		while true; do
			if [ "$time" -ge '120' ] || [ -f /etc/resolv.conf ]; then
				break
			fi
			sleep 1;
			time=$(($time+1))
		done
		for DDSM in $DDSM_LIST; do
			if [ "xcreate" = "x${ACTION}" ]; then
				for SLAVE in ${SLAVE_LIST}; do
					$SZF_DDSM_CTL_TOOL --update-iface $SLAVE $MASTER
				done
			fi
			if [ "xdelete" = "x${ACTION}" ]; then
				for SLAVE in ${SLAVE_LIST}; do
					PHY_SLAVE=${SLAVE#ovs_}
					CONNECT=`cat /sys/class/net/${PHY_SLAVE}/carrier`
					if [ "x${CONNECT}" = "x1" ]; then
						break;
					fi
				done
				if [ "x${CONNECT}" != "x1" ]; then
					SLAVE=`echo ${SLAVE_LIST} | cut -f 1 -d " "`
				fi
				$SZF_DDSM_CTL_TOOL --update-iface $MASTER $SLAVE
			fi
			ID=`$SZF_DOCKER_TOOL inspect --format '{{.Id}}' $DDSM`
			if [ -f /var/run/synoddsm/pause_id/"$ID" ]; then
				if [ -f /etc/resolv.conf ]; then
					StartDockerDSM $DDSM
				fi
				# remove pause flag
				/bin/rm /var/run/synoddsm/pause_id/"$ID"
			fi
		done
	;;
	*)
	echo "Usage: $0 --sdk-mod-ver|--name|--pkg-ver|--vendor|--pre|--post"
	;;
esac

