#!/bin/sh

# include common scripts
SZF_DockerDSM_COMMON_UTIL="/var/packages/Docker/target/ddsm/plugins/DockerDSMCommon.sh"
. ${SZF_DockerDSM_COMMON_UTIL}

# get input share name
share_name=$1
old_volume_path=$2
new_volume_path=$3

# check if any ddsm using this share
DDSM=`$SZF_DDSM_CTL_TOOL --get-ddsm-name-by-share $share_name`

if [ $? -eq 1 ]; then
	# check new path fs type
	fstype=`synofstool --get-fs-type ${new_volume_path}`

	if [ "x${fstype}" != "xbtrfs" ]; then
		echo ${DDSM}
		exit 1
	fi
fi

exit 0
