#!/bin/sh

SZF_DockerDSM_COMMON_UTIL="/var/packages/Docker/target/ddsm/plugins/DockerDSMCommon.sh"
. ${SZF_DockerDSM_COMMON_UTIL}

case $1 in
    --sdk-mod-ver)
        #Print SDK support version
		echo "1.0";
    ;;
    --name)
        #Print package name
		echo "Docker DSM";
    ;;
    --pkg-ver)
        #Print package version
		echo "1.0";
    ;;
    --vendor)
        #Print package vendor
		echo "Synology Inc.";
    ;;
    --pre)
	    if [ "xdelete" != "x${ACTION}" ]; then
		    exit 0
	    fi

	    # stop all running DDSM
	    /usr/syno/bin/synowebapi --exec api=SYNO.Docker.DDSM method=stop version=1
	;;
    --post)
	    if [ "xdelete" != "x${ACTION}" ]; then
		    exit 0
	    fi
    ;;
    *)
        echo "Usage: $0 --sdk-mod-ver|--name|--pkg-ver|--vendor|--pre|--post"
    ;;
esac
