/* Copyright (c) 2015 Synology Inc. All rights reserved. */

Ext.ns("SYNO.SDS.Docker.Utils");SYNO.SDS.Docker.Utils.Helper={containerNameRegex:/^[a-zA-Z0-9][a-zA-Z0-9-]+$/,containerNameValidator:function(b){var a=SYNO.SDS.Docker.Utils.Helper;if(b.match(a.containerNameRegex)){return true}return a.T("common","alphanumeric")},T:function(c,a){try{return _TT("SYNO.SDS.Docker.Application",c,a)||_T(c,a)}catch(b){return _T(c,a)}},getRealMemory:function(){var a=_D("mem_default_mb");SYNO.API.Request({api:"SYNO.Core.System",method:"info",version:1,callback:function(c,b){if(c){a=b.ram_size}}});return function(){return a}}(),getErrorTemplate:function(a){return this.errorMapping[a]||this.T("error","error_error_system")},logError:function(a){this.getError.apply(this,arguments)},getError:function(d){var c=this.getErrorTemplate(d),a=[c].concat(Array.prototype.slice.call(arguments,1)),b=String.format.apply(null,a);SYNO.Debug("error[",d,"]: ",b);return b},mask:function(a,b){if(undefined!==b){a.getEl().mask(b)}else{a.getEl().mask()}},maskLoading:function(a){a.getEl().mask(_WFT("common","loading"),"x-mask-loading")},maskLoadingOnce:function(b,a){if(a.maskLoaded===undefined){this.maskLoading(b);a.maskLoaded=true}},unmask:function(a){a.getEl().unmask()},relativeTime:function(c){var b=new Date(c),a=new Date();if(a<b){c=a.getTime()-1}return Ext.util.Format.relativeTime(c)},shortFileSize:function(b,a){a=a||false;if(a){if(b<1000){return b+" B"}else{if(b<1000000){return(Math.round(b/1000))+" K"}else{if(b<1000000000){return(Math.round(b/1000000))+" M"}else{if(b<1000000000000){return(Math.round(b/1000000000))+" G"}else{if(b<1000000000000000){return(Math.round(b/1000000000000))+" T"}else{return(Math.round(b/1000000000000000))+" P"}}}}}}else{if(b<1024){return b+" B"}else{if(b<1048576){return(Math.round(((b*10)/1024))/10)+" K"}else{if(b<1073741824){return Math.round(((b)/1048576))+" M"}else{if(b<1099511627776){return(Math.round(((b*100)/1073741824))/100)+" G"}else{if(b<1125899906842624){return(Math.round(((b*100)/1099511627776))/100)+" T"}else{return(Math.round(((b*100)/1125899906842624))/100)+" P"}}}}}}}};(function(){var a=function(b){return SYNO.SDS.Docker.Utils.Helper.T("error",b)};SYNO.SDS.Docker.Utils.Helper.errorMapping={WEBAPI_ERR_NOT_ALLOW_DEMO:116,116:SYNO.SDS.Docker.Utils.Helper.T("common","error_demo"),WEBAPI_ERR_DOCKER_FILE_EXIST:1000,1000:a("container_exist"),WEBAPI_ERR_CONTAINER_RUNNING:1001,1001:a("error_error_system"),WEBAPI_ERR_BROKEN_PROFILE:1002,1002:a("error_error_system"),WEBAPI_ERR_DOCKER_API_HELPER_FAIL:1003,1003:a("error_error_system"),WEBAPI_ERR_DOCKER_API_FAIL_LOG:1004,1004:a("docker_api_fail_log"),WEBAPI_ERR_REGISTRY_GET_ERR:1050,1050:a("error_error_system"),WEBAPI_ERR_REGISTRY_MANAGER_FAIL:1051,1051:a("error_error_system"),WEBAPI_ERR_REGISTRY_REMOTE_FAIL:1052,1052:a("registry_remote_fail"),WEBAPI_ERR_REGISTRY_BAD_RESULT:1053,1053:a("registry_bad_result"),WEBAPI_DOCKER_SUCCESS:1200,1200:"",WEBAPI_ERR_DOCKER_BAD_PARAMETER:1201,1201:a("error_error_system"),WEBAPI_ERR_DOCKER_UNKOWN:1202,1202:a("error_error_system"),WEBAPI_ERR_CONTAINER_FAIL_ATTACH:1300,1300:a("error_error_system"),WEBAPI_ERR_CONTAINER_NOT_EXIST:1301,1301:a("container_not_exist"),WEBAPI_ERR_CONTAINER_CONFLICT:1302,1302:a("error_error_system"),WEBAPI_ERR_CONTAINER_PORT_CONFLICT:1303,1303:a("container_port_conflict"),WEBAPI_ERR_CONTAINER_BAD_CMD_PARAM:1304,1304:a("bad_cmd_param"),WEBAPI_ERR_IMAGE_CONFLICT:1400,1400:a("image_delete_depend_error"),WEBAPI_ERR_IMAGE_NOT_EXIST:1401,1401:a("image_not_exist"),WS_ERR_CLIENT_ATTACH:1500,1500:a("ws_client_attach"),WS_ERR_EXEC_END:1501,1501:a("ws_exec_end"),WS_ERR_UNKNOWN:1502,1502:a("ws_close"),WS_ATTACH_SUCC:1503,1503:"",WS_ATTACH_CLIENT:1504,1504:a("term_attach_fail"),WS_ATTACH_FAIL_TTY:1505,1505:a("term_attach_fail_tty")}})();Ext.define("SYNO.SDS.Docker.Container.StatusUtil",{singleton:true,status:{run:"running",stop:"stopped"},statusCode:{unselected:1,run:2,stop:4,synopackage:8,exporting:16},stat2StatCode:function(a){var b=a.status===this.status.run?this.statusCode.run:this.statusCode.stop;if(a.is_package){b|=this.statusCode.synopackage}if(a.exporting){b|=this.statusCode.exporting}return b}});Ext.define("SYNO.SDS.Docker.Overview.UsageBlocks",{extend:"Ext.Container",helper:SYNO.SDS.Docker.Utils.Helper,constructor:function(a){this.callParent([this.fillConfig(a)])},fillConfig:function(a){this.percent=new Ext.BoxComponent({cls:"docker-percent"});this.progressbar=new Ext.ProgressBar({cls:"docker-progress",animate:true});var c={scope:this,data:this.onData,afterrender:this._onResize,resize:this._onResize};Ext.apply(c,a.listeners);delete a.listeners;var b={items:[{xtype:"box",cls:"docker-icon"},{xtype:"container",cls:"docker-right",itemId:"rightContents",items:[{xtype:"box",cls:"docker-header",html:a.header},{xtype:"container",itemId:"percentWrapper",cls:"docker-percent-wrapper",items:[this.percent]},this.progressbar]},{xtype:"box",cls:"x-clear"}],listeners:c};Ext.apply(b,a);return b},_onResize:function(){this.getComponent("rightContents").setWidth(this.getWidth()-50-100-16)},sizeNUnit:function(a){return this.helper.shortFileSize(a).match(/(.+) (\w)/).slice(1)},onData:function(c,e,a){if(e===undefined){this.percent.update(""+c);this.progressbar.updateProgress(c*0.01)}else{var b=this.sizeNUnit(c),d=this.sizeNUnit(this.helper.getRealMemory()*1024*1024),f;if(a){f=String.format('{0}<div class="docker-unit">{1}</div>',b[0],b[1])}else{f=String.format('{0}<div class="docker-unit">{1}</div><span class="docker-ram-total"> / {2}<div class="docker-unit">{3}</div></span>',b[0],b[1],d[0],d[1])}this.percent.update(f);this.progressbar.updateProgress(e*0.01)}}});Ext.define("SYNO.SDS.Docker.Overview.TopGraph",{extend:"Ext.Container",helper:SYNO.SDS.Docker.Utils.Helper,statusUtil:SYNO.SDS.Docker.Container.StatusUtil,constructor:function(a){this.callParent([this.fillConfig(a)])},fillConfig:function(a){var c={owner:this,appWin:a.appWin};this.usageBlocks={cpu:new SYNO.SDS.Docker.Overview.UsageBlocks(Ext.apply({type:"cpu",header:this.helper.T("overview","cpu_usage"),cls:"docker-block docker-cpu"},c)),memory:new SYNO.SDS.Docker.Overview.UsageBlocks(Ext.apply({type:"memory",header:this.helper.T("overview","ram_usage"),cls:"docker-block docker-memory"},c))};var b={cls:"syno-sds-docker-overview-usage",items:[this.usageBlocks.cpu,this.usageBlocks.memory,{xtype:"box",cls:"x-clear"}],listeners:{scope:this,data:this.onData,resize:this._onResize}};Ext.apply(b,a);return b},onData:function(a){this.usageBlocks.cpu.fireEvent("data",a.overview.cpu);this.usageBlocks.memory.fireEvent("data",a.overview.memory,a.overview.memoryPercent)},_onResize:function(c,b){var a=((b-8-2)/2);this.usageBlocks.cpu.setWidth(a);this.usageBlocks.memory.setWidth(a)}});Ext.define("SYNO.SDS.Docker.Overview.CardView",{extend:"SYNO.ux.FleXcroll.DataView",constructor:function(a){this.owner=a.owner;var b=Ext.apply({trackResetOnLoad:false,cls:"syno-docker-overview-running",itemSelector:".item-wrap",tpl:this.createTpl(),listeners:{scope:this,resize:this.onViewResize}},a);this.callParent([b]);this.mon(this.store,"load",this._onStoreLoad,this)},createTpl:function(){return new Ext.XTemplate('<tpl for=".">','<div data-name={name} class="syno-sds-docker-overview-card">','<div class="syno-sds-docker-overview-card-header">','<div class="syno-sds-docker-overview-card-container-icon"></div>','<div class="syno-sds-docker-overview-card-info">','<h3 ext:qtip="{name}">{name}</h3>','<p ext:qtip="{image}">{image}</p>',"<p>{uptime}</p>","</div>","</div>",'<div class="syno-sds-docker-overview-card-status">','<div class="syno-sds-docker-overview-card-chartarea">','<div class="syno-sds-docker-overview-card-chart syno-sds-docker-overview-card-cpu-chart">','<div class="syno-sds-docker-overview-card-bar">','<div class="syno-sds-docker-overview-card-bar-progress" style="height: {cpuPercent};"></div>',"</div>","</div>",'<div class="syno-sds-docker-overview-card-chart syno-sds-docker-overview-card-mem-chart">','<div class="syno-sds-docker-overview-card-bar">','<div class="syno-sds-docker-overview-card-bar-progress" style="height: {memoryPercent};"></div>',"</div>","</div>","</div>",'<div class="syno-sds-docker-overview-card-legend">','<div class="syno-sds-docker-overview-card-legend-wrapper syno-sds-docker-overview-card-cpu-legend">',"<label>CPU</label>","<span>{cpu}</span>","</div>",'<div class="syno-sds-docker-overview-card-legend-wrapper syno-sds-docker-overview-card-mem-legend">',"<label>RAM</label>","<span>{memory}</span>","</div>","</div>","</div>","</div>","</tpl>",'<div class="x-clear"></div>')},_onStoreLoad:function(){this.adjustMargin();var c=this.getEl().select(".syno-sds-docker-overview-card"),a="syno-sds-docker-overview-card-bar-transition",b=this.store;c.each(function(e){var h=e.getAttribute("data-name"),f=b.getById(h),g=e.select(".syno-sds-docker-overview-card-cpu-chart .syno-sds-docker-overview-card-bar-progress"),i=e.select(".syno-sds-docker-overview-card-mem-chart .syno-sds-docker-overview-card-bar-progress"),d;if(!f.states.isNew){d=f.states.oldRecord;g.setHeight(d.cpuPercent);i.setHeight(d.memoryPercent)}});setTimeout(function(){c.each(function(d){d.addClass("syno-sds-docker-overview-card-float-transition");var g=d.getAttribute("data-name"),e=b.getById(g),f=d.select(".syno-sds-docker-overview-card-cpu-chart .syno-sds-docker-overview-card-bar-progress"),h=d.select(".syno-sds-docker-overview-card-mem-chart .syno-sds-docker-overview-card-bar-progress");if(!e.states.isNew){f.addClass(a).setHeight(e.get("cpuPercent"));h.addClass(a).setHeight(e.get("memoryPercent"))}})},0)},onViewResize:function(){this.adjustMargin()},adjustMargin:function(){var a=this.getEl().select(".syno-sds-docker-overview-card");if(a.elements.length===0){return}var f=10;var b=this.getWidth()-f;var d=a.elements.length;var c=a.elements[0].getWidth();var g=10;var e=Math.floor((b+g)/(c+g));var i=0;var h=0;if(e>=d){i=g;h=d}else{i=(b-e*c)/(e-1);h=e}a.each(function(k,l,j){j+=1;if(j%h===0){k.setStyle("marginRight",0)}else{k.setStyle("marginRight",i+"px")}})}});Ext.namespace("SYNO.SDS.Docker.Utils");SYNO.SDS.Docker.Utils.DockerHub={domain:"registry.hub.docker.com",domainRegex:/^(https?:\/\/)?registry.hub.docker.com/,repoRegex:/^(https:\/\/registry.hub.docker.com)\/(?:u\/)?([A-Za-z0-9_-]+\/[A-Za-z0-9_.-]+)\/?$/,shortname:"Docker Hub",isDockerHubShortName:function(a){return this.shortname===a},isDockerHub:function(a){return this.domainRegex.match(a)},formDockerHubUrl:function(a){var b=a.match(/^([^\/]*\/)?([^\/]*)$/);if(!b){return null}return String.format("https://{0}/{1}/{2}/",this.domain,(b[1])?"u":"_",(a))}};Ext.define("SYNO.SDS.Docker.Overview.RunningContainers",{extend:"SYNO.ux.Panel",helper:SYNO.SDS.Docker.Utils.Helper,statusUtil:SYNO.SDS.Docker.Container.StatusUtil,dockerHubHelper:SYNO.SDS.Docker.Utils.DockerHub,constructor:function(a){this.callParent([this.fillConfig(a)])},fillConfig:function(a){this.store=this.createStore(a);this.view=this.createView(a);var b={layout:"fit",store:this.store,items:[this.view],listeners:{scope:this,data:this.onData}};Ext.apply(b,a);return b},createView:function(a){return new SYNO.SDS.Docker.Overview.CardView({plugins:[new SYNO.SDS.Docker.Utils.PreserveStates()],panel:this,owner:this.owner,appWin:a.appWin,store:this.store})},createStore:function(a){return new Ext.data.JsonStore({fields:[{name:"name",mapping:"name"},{name:"image",mapping:"image"},{name:"cpu",mapping:"cpu"},{name:"cpuPercent",mapping:"cpuPercent"},{name:"memory",mapping:"memory"},{name:"memoryPercent",mapping:"memoryPercent"},{name:"uptime",mapping:"up_time"},{name:"status",mapping:"status"}],autoDestroy:true,root:"items",idProperty:"name",sortInfo:{field:"name",direction:"ASC"}})},loadStore:function(d,e){var a=[],c={},b=this.helper.getRealMemory()*1024*1024;a=d.filter(function(f){return f.status===this.statusUtil.status.run},this).map(function(f){f.up_time=this.helper.relativeTime(f.up_time*1000);f.image=f.image.replace(this.dockerHubHelper.domain+"/","");return f},this);a.each(function(f,g){c[f.name]=g});Ext.each(e,function(f){var g=c[f.name];if(undefined!==a[g]){a[g].cpu=f.cpu+"%";a[g].cpuPercent=f.cpu+"%";a[g].memory=this.helper.shortFileSize(f.memory);a[g].memoryPercent=Ext.util.Format.round(f.memory*100/b,2)+"%"}},this);this.store.loadData({items:a})},onRowClick:function(){var a=this.getSelectionModel().getSelections();SYNO.SDS.AppLaunch("SYNO.SDS.Docker.ContainerDetail.Instance",a[0])},onData:function(a){this.loadStore(a.containers,a.resources);if(a.containers.length===0){this.helper.mask(this.view,this.helper.T("overview","no_container"))}else{this.helper.unmask(this.view)}}});Ext.define("SYNO.SDS.Docker.Overview.Panel",{extend:"SYNO.ux.Panel",refreshInterval:3000,helper:SYNO.SDS.Docker.Utils.Helper,constructor:function(a){this.callParent([this.fillConfig(a)]);this.pollingTask=this.createPollingTask()},fillConfig:function(a){var c={owner:this,appWin:a.appWin};this.processData=null;this.panelGraph=new SYNO.SDS.Docker.Overview.TopGraph(c);this.panelRunning=new SYNO.SDS.Docker.Overview.RunningContainers(c);this.dataListeners=[this.panelGraph,this.panelRunning];var b={items:[this.panelGraph,{xtype:"syno_fieldset",title:this.helper.T("overview","running_container"),collapsible:false,items:[this.panelRunning]}],listeners:{scope:this,activate:this.onActivate,deactivate:this.onDeactivate,resize:this.onPanelResize}};Ext.apply(b,a);return b},createPollingTask:function(){return this.addWebAPITask({scope:this,interval:this.refreshInterval,compound:{stopwhenerror:true,params:[{api:"SYNO.Docker.Container",method:"list",version:1,params:{limit:-1,offset:0}},{api:"SYNO.Docker.Container.Resource",method:"get",version:1}]},callback:function(e,c,d,b){this.helper.unmask(this);if(!c.has_fail){var a=c.result;this.onData(a)}else{this.onException(c.result)}}})},dataPreprocess:function(a){var b={containers:a[0].data.containers,resources:a[1].data.resources};b.containers=b.containers.filter(function(c){return c.status===SYNO.SDS.Docker.Container.StatusUtil.status.run});b.resources=b.resources.map(function(c){c.cpu=Ext.util.Format.round(c.cpu,2);return c});b.overview=b.resources.reduce(function(d,c){return{cpu:Ext.util.Format.round(d.cpu+parseFloat(c.cpu),2),memory:d.memory+parseInt(c.memory,10),memoryPercent:Ext.util.Format.round(d.memoryPercent+parseFloat(c.memoryPercent),2)}},{cpu:0,memory:0,memoryPercent:0});return b},onData:function(a){this.processData=this.dataPreprocess(a);Ext.each(this.dataListeners,function(b){b.fireEvent("data",this.processData)},this)},onException:function(a){a.each(function(b){if(!b.success){this.helper.logError(b.error.code)}},this)},onPanelResize:function(e,d,a){var b=this.panelRunning.getSize(),c={width:d-10,height:a-200};this.panelRunning.setSize(c);this.panelGraph.fireEvent("resize",this.panelGraph,c.width,c.height,b.width,b.height);this.panelRunning.fireEvent("resize",this.panelRunning,c.width,c.height,b.width,b.height)},onActivate:function(){this.helper.maskLoadingOnce(this,this);this.pollingTask.start(true)},onDeactivate:function(){this.pollingTask.stop()}});Ext.define("SYNO.SDS.Docker.EditorGridPanel",{extend:"SYNO.ux.EditorGridPanel",helper:SYNO.SDS.Docker.Utils.Helper,constructor:function(){this.callParent(arguments);this.colModel.columns.each(function(b){var a=b.getCellEditor();if(a){a.grid=this;this.mon(a,"hide",this.isEditorValid,this);this.mon(a,"specialkey",function(d,c){if(c.getCharCode()===c.ENTER){return this.isValid(true)}},this)}},this);this.mon(this.store,"remove",function(){this.stopEditing()},this);this.mon(this.store,"add",function(b,a,c){this.colModel.columns.each(function(e){var d=e.getCellEditor();if(d){d.mon(d,"show",function(){this.field.clearInvalid()},null,{single:true})}},this)},this)},isEditorValid:function(b){var a=this.view.getCell(b.row,b.col);if(false===b.field.isValid()){a.addClassName("x-cell-invalid")}else{if(a.hasClassName("x-cell-invalid")){a.removeClassName("x-cell-invalid")}}},isCellValid:function(c,e){if(!this.colModel.isCellEditable(c,e)){return true}var b=this.colModel.getCellEditor(c,e);if(!b){return true}var a=this.store.getAt(e);if(!a){return true}var d=this.colModel.getDataIndex(c);b.field.setValue(a.data[d]);return b.field.isValid(true)},isValid:function(g){var e=this.colModel.getColumnCount();var d=this.store.getCount();var b,f;var a=true;for(b=0;b<d;b++){for(f=0;f<e;f++){a=this.isCellValid(f,b);if(!a){break}}if(!a){break}}if(g&&!a){this.startEditing(b,f)}return a},dumpStoreData:function(){var a=[];this.store.each(function(b){var c={};Ext.apply(c,b.data);delete c.dirty;a.push(c)});return a},loadStoreData:function(a){this.store.loadData(a)}});Ext.define("SYNO.SDS.Docker.Container.ProfileUI",{extend:Object,helper:SYNO.SDS.Docker.Utils.Helper,getNameCfg:function(a){return[{xtype:"syno_textfield",name:"name",allowBlank:false,minLength:2,maxLength:64,fieldLabel:this.helper.T("container","container_name"),validator:this.helper.containerNameValidator}]},getNameValue:function(a){var b=a.form;var c={};if(b&&b.findField("name")){c.name=b.findField("name").getValue()}return c},setNameValue:function(a,c){var b=a.form;if(b&&b.findField("name")&&c.name){b.findField("name").setValue(c.name)}},validateName:function(b,f){var d=b.form;var c=true,e,a;if(!d){return c}a=d.findField("name");e=a.getValue();c=a.isValid();if(false===c&&f){a.focus()}return c},getPortCfg:function(a){var b=this.getPortGrid(a);return[{xtype:"syno_displayfield",fieldLabel:this.helper.T("container","port_setting")},b,{xtype:"syno_checkbox",name:"enable_publish_all_ports",boxLabel:this.helper.T("container","auto_port_mapping")}]},getPortGrid:function(a){if(this.portGrid&&!this.portGrid.isDestroyed){return this.portGrid}this.portGrid=new SYNO.SDS.Docker.EditorGridPanel({height:180,clicksToEdit:1,forceValidation:true,enableHdMenu:false,selModel:new Ext.grid.RowSelectionModel({singleSelect:true}),store:new Ext.data.JsonStore({autoDestroy:true,fields:[{name:"host_port",type:"int"},{name:"container_port",type:"int"},{name:"type",type:"string"}]}),tbar:[{xtype:"syno_button",tooltip:_T("common","add"),cls:"syno-docker-btn syno-docker-add-btn",scope:this,handler:function(){var c=this.portGrid;var b=c.getStore();if(b.getCount()){if(""===b.getAt(0).get("host_port")){return c.startEditing(0,0)}else{if(""===b.getAt(0).get("container_port")){return c.startEditing(0,1)}}}var d=new b.recordType({dirty:false,host_port:"",container_port:"",type:"tcp"});c.stopEditing();b.insert(0,d);c.startEditing(0,0)}},{xtype:"syno_button",tooltip:this.helper.T("common","delete"),cls:"syno-docker-btn syno-docker-del-btn",scope:this,handler:function(){var c=this.getPortGrid();var b=c.getStore();b.remove(c.getSelectionModel().getSelected())}}],colModel:new Ext.grid.ColumnModel({defaults:{width:120,sortable:false},columns:[{header:this.helper.T("container","local_port"),dataIndex:"host_port",editor:{xtype:"syno_numberfield",vtype:"port",validator:this.checkPortUnique}},{header:this.helper.T("container","container_port"),dataIndex:"container_port",editor:{xtype:"syno_numberfield",vtype:"port",validator:this.checkPortUnique}},{header:this.helper.T("common","type"),dataIndex:"type",editor:new SYNO.ux.ComboBox({typeAhead:true,triggerAction:"all",lazyRender:true,mode:"local",allowBlank:false,store:new Ext.data.ArrayStore({fields:["value","display"],data:[["tcp","TCP"],["udp","UDP"]]}),valueField:"value",displayField:"display"}),renderer:function(d,c,b){switch(d){case"tcp":return"TCP";case"udp":return"UDP";default:return"TCP"}}}]}),viewConfig:{markDirty:false},listeners:{afteredit:function(b){b.record.commit()}}});return this.portGrid},getPortValue:function(a){var b=a.form;return{port_bindings:this.getPortGrid().dumpStoreData(),enable_publish_all_ports:b.findField("enable_publish_all_ports").getValue()}},setPortValue:function(a,c){var b=a.form;if(c.port_bindings&&0<c.port_bindings.length){this.getPortGrid().loadStoreData(c.port_bindings)}if(b&&b.findField("enable_publish_all_ports")&&c.enable_publish_all_ports){b.findField("enable_publish_all_ports").setValue(c.enable_publish_all_ports)}},validatePort:function(a,b){return this.getPortGrid().isValid(b)},getResourceCfg:function(a){return[{xtype:"syno_checkbox",name:"enable_resource_limit",boxLabel:this.helper.T("container","resource_limit")},{xtype:"syno_compositefield",fieldLabel:this.helper.T("container","cpu_priority"),name:"cpu_composite",indent:1,items:[{xtype:"syno_radio",name:"cpu_priority",inputValue:10,boxLabel:this.helper.T("container","low")},{xtype:"syno_radio",name:"cpu_priority",inputValue:50,boxLabel:this.helper.T("container","med"),checked:true},{xtype:"syno_radio",name:"cpu_priority",inputValue:90,boxLabel:this.helper.T("container","high")}]}]},getResourceValue:function(b){var c=b.form,a={cpu_priority:0,memory_limit:0};if(c.findField("enable_resource_limit").getValue()){a.cpu_priority=c.findField("cpu_priority").getGroupValue()}return a},setResourceValue:function(a,c){var b=a.form;if(!c.cpu_priority){return}b.findField("enable_resource_limit").setValue(true);b.setValues(c)},enableResourceGroup:function(b){var a;a=new SYNO.ux.Utils.EnableCheckGroup(b.form,"enable_resource_limit",["cpu_composite"])},validateResource:function(a,b){return true},getShortcutCfg:function(a){return[{xtype:"syno_checkbox",name:"enable_shortcut",boxLabel:this.helper.T("container","create_shortcut")},{xtype:"syno_radio",indent:1,boxLabel:this.helper.T("container","status_page"),name:"shortcut_type",inputValue:"status",checked:true},{xtype:"syno_compositefield",indent:1,hideLabel:true,items:[{xtype:"syno_radio",name:"shortcut_type",inputValue:"web",boxLabel:this.helper.T("container","web_page")},{xtype:"syno_textfield",indent:1,name:"web_page_url",vtype:"url",allowBlank:false,width:261,value:location.protocol+"//"+location.hostname}]}]},enableShortcutGroup:function(b){var a,c;a=new SYNO.ux.Utils.EnableCheckGroup(b.form,"enable_shortcut",["shortcut_type","web_page_url"]);c=new SYNO.ux.Utils.EnableRadioGroup(b.form,"shortcut_type",{web:["web_page_url"]})},getShortcutValue:function(b){var c=b.form;var a={enable_shortcut:false};if(c&&c.findField("enable_shortcut").getValue()){a={enable_shortcut:true,enable_status_page:("status"===c.findField("shortcut_type").getGroupValue()),enable_web_page:("web"===c.findField("shortcut_type").getGroupValue())}}if(a.enable_web_page){a.web_page_url=c.findField("web_page_url").getValue()}return{shortcut:a}},setShortcutValue:function(b,d){var c=b.form;if(d&&d.shortcut){var a={enable_shortcut:d.shortcut.enable_shortcut,shortcut_type:d.shortcut.enable_web_page?"web":"status",web_page_url:d.shortcut.web_page_url};c.setValues(a)}},validateShortcut:function(b,d){var c=b.form;var a=c.findField("enable_shortcut").getValue();if(!a){return true}if("web"===c.findField("shortcut_type").getGroupValue()){return c.findField("web_page_url").isValid()}return true},getVolumeCfg:function(a){var b=this.getVolumeGrid(a);return[{xtype:"syno_compositefield",fieldLabel:this.helper.T("container","volume_setting_title"),itemId:"volume_bindings",items:[b]}]},getVolumeGrid:function(a){if(this.volumeGrid&&!this.volumeGrid.isDestroyed){return this.volumeGrid}var b=new SYNO.ux.EnableColumn({header:this.helper.T("container","read_only"),dataIndex:"read_only",enableFastSelectAll:true,menuDisabled:true,sortable:false,width:120,resizable:true,align:"center",tooltip:this.helper.T("container","read_only")});this.volumeGrid=new SYNO.SDS.Docker.EditorGridPanel({height:180,enableHdMenu:false,clicksToEdit:1,forceValidation:true,itemId:"volume_grid",selModel:new Ext.grid.RowSelectionModel({singleSelect:true}),store:new Ext.data.JsonStore({autoDestroy:true,fields:[{name:"host_volume_file",type:"string"},{name:"mount_point",type:"string"},{name:"read_only",type:"bool"}]}),tbar:[{xtype:"syno_button",tooltip:this.helper.T("container","add_file"),itemId:"add_file",text:this.helper.T("container","add_file"),scope:this,handler:function(){this.onAddMount("file")}},{xtype:"syno_button",tooltip:this.helper.T("container","add_folder"),itemId:"add_folder",text:this.helper.T("container","add_folder"),scope:this,handler:function(){this.onAddMount("folder")}},"->",{xtype:"syno_button",tooltip:this.helper.T("common","delete"),itemId:"delete_mount",btnStyle:"red",text:this.helper.T("common","delete"),scope:this,handler:function(){var d=this.getVolumeGrid();var c=d.getStore();c.remove(d.getSelectionModel().getSelected())}}],plugins:[b],colModel:new Ext.grid.ColumnModel({defaults:{sortable:false},columns:[{header:this.helper.T("container","file_folder"),width:160,dataIndex:"host_volume_file"},{header:this.helper.T("container","mount_path"),width:160,dataIndex:"mount_point",editor:{xtype:"syno_textfield",validator:this.linuxPathValidator,validator2:this.checkColumUnique}},b]}),viewConfig:{markDirty:false},listeners:{afteredit:function(c){c.record.commit()}}});return this.volumeGrid},onAddMount:function(d){var c=this.getVolumeGrid();var a=c.getStore();var e={type:"open"};if(a.getCount()){if(false===c.isCellValid(1,0)){return c.startEditing(0,1)}}if("folder"===d){e.type="chooseDir"}var b=new SYNO.SDS.Utils.FileChooser.Chooser({owner:this.ownerCt,usage:e,title:_T("common","add"),folderToolbar:true,gotoPath:"/docker",treeFilter:function(g,f){if(f&&(f.spath==="/home")){return false}return true},listeners:{scope:this,choose:function(k,j,g){var i=this.getVolumeGrid();var h=i.getStore();var f=h.recordType;var l=new f({dirty:false,host_volume_file:j.path,mount_point:"",read_only:true});i.stopEditing();h.insert(0,l);i.startEditing(0,1);k.close()}}});b.open()},linuxPathValidator:function(b){for(var a=0;a<b.length;a++){if("\\"===b.charAt(a)){return false}}if(b.charAt(0)!="/"){return false}if(b.charAt(0)=="/"&&b.charAt(1)=="/"){return false}if(0===b.length||1024<b.length){return false}if(this.validator2){return this.validator2.call(this,b)}return true},getVolumeValue:function(b){var a=this.getVolumeGrid().dumpStoreData().map(function(c){c.type=c.read_only?"ro":"rw";delete c.read_only;return c});return{volume_bindings:a}},setVolumeValue:function(b,c){if(c&&c.volume_bindings&&0<c.volume_bindings.length){var a=c.volume_bindings.map(function(e){var d=Object.clone(e);d.read_only=d.type=="ro";delete d.type;return d});this.getVolumeGrid().loadStoreData(a)}},validateVolume:function(a,b){return this.getVolumeGrid().isValid(b)},getLinkCfg:function(a){var b=this.getLinkGrid(a);return[{xtype:"syno_compositefield",fieldLabel:this.helper.T("container","link_setting"),itemId:"link_bindings",items:[b]}]},getLinkGrid:function(a){if(this.linkGrid&&!this.linkGrid.isDestroyed){return this.linkGrid}var b=new SYNO.API.JsonStore({api:"SYNO.Docker.Container",version:1,method:"list",baseParams:{limit:-1,offset:0},autoDestroy:true,root:"containers",totalProperty:"total",fields:["name"],appWindow:this,autoLoad:true,listeners:{scope:this,load:function(d,c,e){d.remove(c.find(function(f){return(f.data.name===this.containerId)},this))}}});this.linkGrid=new SYNO.SDS.Docker.EditorGridPanel({itemId:"link_grid",height:180,enableHdMenu:false,clicksToEdit:1,forceValidation:true,selModel:new Ext.grid.RowSelectionModel({singleSelect:true}),store:new Ext.data.JsonStore({autoDestroy:true,fields:[{name:"link_container",type:"string"},{name:"alias",type:"string"}]}),tbar:[{xtype:"syno_button",tooltip:_T("common","add"),cls:"syno-docker-btn syno-docker-add-btn",scope:this,handler:function(){var f=this.getLinkGrid();var d=f.getStore();var c=d.recordType;var e=f.colModel.getColumnAt(0).editor.store;if(0===e.getCount()){return this.ownerCt.getMsgBox().alert("","There is no other container")}if(d.getCount()){if(""===d.getAt(0).get("link_container")){return f.startEditing(0,0)}if(""===d.getAt(0).get("alias")){return f.startEditing(0,1)}}var g=new c({dirty:false,link_container:"",alias:""});f.stopEditing();d.insert(0,g);f.startEditing(0,0)}},{xtype:"syno_button",tooltip:_T("common","delete"),cls:"syno-docker-btn syno-docker-del-btn",scope:this,handler:function(){var d=this.getLinkGrid();var c=d.getStore();c.remove(d.getSelectionModel().getSelected())}}],colModel:new Ext.grid.ColumnModel({defaults:{sortable:false},columns:[{header:this.helper.T("container","container_name"),dataIndex:"link_container",editor:new SYNO.ux.ComboBox({forceSelection:true,typeAhead:true,triggerAction:"all",lazyRender:true,store:b,valueField:"name",displayField:"name",allowBlank:false,listeners:{scope:this,focus:{fn:function(c){c.onTriggerClick()},buffer:100},select:function(f,c,d){var e=this.getLinkGrid();if(0!==f.gridEditor.row){return}e.startEditing(0,1)}}})},{header:this.helper.T("common","alias"),dataIndex:"alias",editor:{xtype:"syno_textfield",allowBlank:false,validator:this.checkColumUnique}}]}),viewConfig:{markDirty:false},listeners:{afteredit:function(c){c.record.commit()}}});return this.linkGrid},getLinkValue:function(a){return{links:this.getLinkGrid().dumpStoreData()}},setLinkValue:function(a,b){if(b&&b.links){this.getLinkGrid().loadStoreData(b.links)}},validateLink:function(a,b){return this.getLinkGrid().isValid(b)},getEnvCfg:function(a){return[{xtype:"syno_fieldset",title:this.helper.T("container","privilege_setting"),items:[{xtype:"syno_checkbox",name:"privileged",boxLabel:this.helper.T("container","use_high_privilege"),listeners:{scope:this,focus:function(b){if(!b.checked){this.ownerCt.getMsgBox().alert("",this.helper.T("container","privilege_warning"))}}}}]},{xtype:"syno_fieldset",title:this.helper.T("container","env_variables"),items:[this.getEnvGrid(a)]},{xtype:"syno_fieldset",title:this.helper.T("common","command"),items:[{xtype:"syno_textarea",name:"cmd",anchor:"100%",hideLabel:true,emptyText:"/usr/bin/sql.sh start",listeners:{afterrender:function(b){b.el.setHeight(50)},blur:function(){this.emptyText=this.readOnly?" ":"/usr/bin/sql.sh start";this.applyEmptyText()},focus:function(){this.emptyText=" ";this.applyEmptyText()},keydown:function(b,d,c){if(d.keyCode===d.ENTER||d.keyCode===186){d.preventDefault()}}}}]}]},getEnvGrid:function(a){if(this.envGrid&&!this.envGrid.isDestroyed){return this.envGrid}this.envGrid=new SYNO.SDS.Docker.EditorGridPanel({itemId:"env_grid",height:180,enableHdMenu:false,clicksToEdit:1,forceValidation:true,selModel:new Ext.grid.RowSelectionModel({singleSelect:true}),store:new Ext.data.JsonStore({autoDestroy:true,fields:[{name:"key",type:"string"},{name:"value",type:"string"}]}),tbar:[{xtype:"syno_button",tooltip:_T("common","add"),cls:"syno-docker-btn syno-docker-add-btn",scope:this,handler:function(){var d=this.getEnvGrid();var c=d.getStore();var b=c.recordType;if(c.getCount()){if(""===c.getAt(0).get("key")){return d.startEditing(0,0)}if(""===c.getAt(0).get("value")){return d.startEditing(0,1)}}var e=new b({dirty:false,key:"",value:""});d.stopEditing();c.insert(0,e);d.startEditing(0,0)}},{xtype:"syno_button",tooltip:_T("common","delete"),cls:"syno-docker-btn syno-docker-del-btn",scope:this,handler:function(){var c=this.getEnvGrid();var b=c.getStore();b.remove(c.getSelectionModel().getSelected())}}],colModel:new Ext.grid.ColumnModel({defaults:{sortable:false},columns:[{header:this.helper.T("container","header_variable"),dataIndex:"key",editor:{xtype:"syno_textfield",allowBlank:false,validator:this.checkColumUnique}},{header:this.helper.T("container","header_value"),dataIndex:"value",editor:{xtype:"syno_textfield",allowBlank:false}}]}),viewConfig:{markDirty:false},listeners:{afteredit:function(b){b.record.commit()}}});return this.envGrid},getEnvValue:function(a){var b=a.form;var c={cmd:b.findField("cmd").getValue(),env_variables:this.getEnvGrid().dumpStoreData(),privileged:false};if(b.findField("privileged")){c.privileged=b.findField("privileged").getValue()}if(Ext.isEmpty(c.cmd)){delete c.cmd}return c},setEnvValue:function(a,c){var b=a.form;if(c&&c.env_variables){this.getEnvGrid().loadStoreData(c.env_variables)}if(b&&b.findField("cmd")&&c&&c.cmd){b.findField("cmd").setValue(c.cmd)}if(b&&b.findField("privileged")&&c&&Ext.isDefined(c.privileged)){b.findField("privileged").setValue(c.privileged)}},validateEnv:function(a,b){return this.getEnvGrid().isValid(b)},getSummaryGrid:function(a){if(this.summaryGrid&&!this.summaryGrid.isDestroyed){return this.summaryGrid}this.summaryGrid=new SYNO.ux.GridPanel(Ext.apply({border:false,itemId:"summary_grid",stripeRows:true,height:210,columns:[{header:_T("status","header_item"),width:100,sortable:false,dataIndex:"name",renderer:function(c,b){b.attr='ext:qtip="'+Ext.util.Format.htmlEncode(c)+'"';return c}},{header:_T("status","header_value"),width:220,sortable:false,dataIndex:"value",renderer:function(c,b){b.attr='ext:qtip="'+Ext.util.Format.htmlEncode(c)+'"';return c}}],store:new Ext.data.ArrayStore({fields:["name","value"],idIndex:0,autoLoad:false})},a));return this.summaryGrid},loadSummaryGrid:function(g){var d=this.getSummaryGrid();var c={10:this.helper.T("container","low"),50:this.helper.T("container","med"),90:this.helper.T("container","high")};var f={tcp:"TCP",udp:"UDP"};var e={ro:"Yes",rw:"No"};var b={privileged:this.helper.T("container","privilege_setting"),name:this.helper.T("container","container_name"),cpu_priority:this.helper.T("container","cpu_priority"),shortcut:_T("desktop","shortcut"),cmd:this.helper.T("common","command"),port_bindings:this.helper.T("container","port_setting"),volume_bindings:this.helper.T("common","volume"),links:this.helper.T("wizard","links"),env_variables:this.helper.T("container","env_variables")};var a=[];Object.keys(b).each(function(h){if(g.hasOwnProperty(h)){var j=g[h];if(h==="port_bindings"&&(!Ext.isEmpty(j)||g.enable_publish_all_ports)){j=j.map(function(k){var l=Object.clone(k);l.type=f[k.type];return l});if(g.enable_publish_all_ports){j.push({host_port:"49153-65535",container_port:this.helper.T("container","any_ports"),type:"tcp"})}j=this.renderValueByTable(j,[this.helper.T("container","local_port"),this.helper.T("container","container_port"),this.helper.T("common","type")],["host_port","container_port","type"])}else{if(h==="volume_bindings"&&!Ext.isEmpty(j)){j=j.map(function(k){var l=Object.clone(k);l.type=e[k.type];return l});j=this.renderValueByTable(j,[this.helper.T("container","file_folder"),this.helper.T("container","mount_path"),this.helper.T("container","read_only")],["host_volume_file","mount_point","type"])}else{if(h==="links"&&!Ext.isEmpty(j)){j=this.renderValueByTable(j,[this.helper.T("container","container_name"),this.helper.T("common","alias")],["link_container","alias"])}else{if(h==="env_variables"&&!Ext.isEmpty(j)){j=this.renderValueByTable(j,[this.helper.T("container","header_variable"),this.helper.T("container","header_value")],["key","value"])}else{if(h==="image"){return}else{if(h==="name"){j=Ext.util.Format.htmlEncode(j)}else{if(h==="cpu_priority"){j=c[j]||this.helper.T("container","auto")}else{if(h==="shortcut"){var i="";if(!j||!j.enable_shortcut){return}if(j.enable_status_page){i=this.helper.T("container","status_page")}if(j.enable_web_page&&!Ext.isEmpty(j.web_page_url)){i+=(0===i.length)?"":",&nbsp;";i+=this.helper.T("container","web_page");i+="("+Ext.util.Format.htmlEncode(j.web_page_url)+")"}j=i}else{if(h==="cmd"&&!Ext.isEmpty(j)){}else{if(h==="privileged"&&!Ext.isEmpty(j)){if(!j){return}j=this.helper.T("container","use_high_privilege")}else{return}}}}}}}}}}a.push([b[h],j])}},this);d.store.loadData(a)},renderValueByTable:function(f,g,e,a){var d,b,c="";if(!Ext.isArray(e)||!Ext.isArray(g)){return c}c+='<table class="cell-table-view"><tbody>';c+="<tr>";for(d=0;d<g.length;d++){c+="<th>"+g[d]+"</th>"}c+="</tr>";for(d=0;d<f.length;d++){c+="<tr>";for(b=0;b<g.length;b++){c+='<td ext:qtip="'+f[d][e[b]]+'">'+f[d][e[b]]+"</td>"}c+="</tr>"}c+="</tbody></table>";return c},checkColumUnique:function(e){var a=this.gridEditor.grid.getStore(),b=a.fields.keys[this.gridEditor.col],d,c=0;for(d=0;d<a.data.length;d++){if(e==a.data.itemAt(d).get(b)){c++}if(c==2){break}}if(d!==a.data.length){return SYNO.SDS.Docker.Utils.Helper.T("container","already_exist")}return true},checkPortUnique:function(g){var a=this.gridEditor.grid.getStore(),c=a.fields.keys[this.gridEditor.col],b="type",f,e={tcp:0,udp:0};for(f=0;f<a.data.length;f++){var d=a.data.itemAt(f).get(b);if(g==a.data.itemAt(f).get(c)){e[d]++}if(e[d]==2){return SYNO.SDS.Docker.Utils.Helper.T("container","already_exist")}}return true},getErrorMsg:function(a,b){var c;if(this.helper.errorMapping.WEBAPI_ERR_DOCKER_FILE_EXIST===a.code){c=this.helper.getError(a.code,b.profile.name)}else{if(a.errors!==undefined&&a.errors.errors){c=this.helper.getError(a.code,a.errors.errors)}else{c=this.helper.getError(a.code)}}return c}});Ext.ns("SYNO.SDS.Docker.Image");Ext.define("SYNO.SDS.Docker.Image.WizardAdvance",{extend:"SYNO.SDS.ModalWindow",helper:SYNO.SDS.Docker.Utils.Helper,constructor:function(a){this.callParent([this.fillConfig(a)])},fillConfig:function(a){var b={width:650,height:550,owner:a.owner,closable:true,layout:"fit",title:this.helper.T("wizard","advance_setting_title"),buttons:[{xtype:"syno_button",btnStyle:"blue",text:this.helper.T("common","apply"),scope:this,handler:this.applyHandler},{xtype:"syno_button",btnStyle:"grey",text:this.helper.T("common","cancel"),scope:this,handler:this.cancelHandler}],items:[this.panel=this.initPanel(a)]};Ext.apply(b,a);return b},initPanel:function(a){return new SYNO.SDS.Docker.Image.WizardAdvancePanel(a)},applyHandler:function(){if(false===this.panel.validateProfile()){return}this.owner.refreshData(this.panel.getProfile());this.close()},cancelHandler:function(){this.close()}});Ext.define("SYNO.SDS.Docker.Image.WizardAdvancePanel",{extend:"SYNO.ux.TabPanel",constructor:function(a){Ext.apply(this,new SYNO.SDS.Docker.Container.ProfileUI());this.data={};this.callParent([this.fillConfig(a)]);this.mon(this,"afterrender",function(){this.setProfile()})},fillConfig:function(a){var b={activeTab:0,cls:"syno-sds-docker-profile",items:[{title:this.helper.T("common","volume"),itemId:"volume",xtype:"syno_formpanel",layout:"fit",items:[this.getVolumeGrid(a)],listeners:{scope:this,activate:function(){this.getVolumeGrid().getView().refresh()}}},{title:this.helper.T("wizard","links"),itemId:"links",xtype:"syno_formpanel",layout:"fit",items:[this.getLinkGrid(a)],listeners:{scope:this,activate:function(){this.getLinkGrid().getView().refresh()}}},{title:this.helper.T("wizard","environment"),itemId:"environment",xtype:"syno_formpanel",items:this.getEnvCfg(),listeners:{scope:this,activate:function(){this.getEnvGrid().getView().refresh()}}}]};Ext.apply(b,a);return b},getProfile:function(){var a={};Ext.apply(a,this.getVolumeValue(this.items.get("volume")));Ext.apply(a,this.getLinkValue(this.items.get("links")));Ext.apply(a,this.getEnvValue(this.items.get("environment")));return a},setProfile:function(a){Ext.apply(this.data,a);this.setVolumeValue(this.items.get("volume"),this.data);this.setLinkValue(this.items.get("links"),this.data);this.setEnvValue(this.items.get("environment"),this.data)},validateProfile:function(){return(this.validate(this.items.get("volume"),this.validateVolume)&&this.validate(this.items.get("links"),this.validateLink)&&this.validate(this.items.get("environment"),this.validateEnv))},validate:function(a,b){var c=b.call(this,a,false);if(false===c){this.activate(a);b.call(this,a,true);this.ownerCt.setStatusError({text:_T("common","forminvalid"),clear:true})}return c}});Ext.define("SYNO.SDS.Docker.Container.BasicProfile",{extend:"SYNO.ux.FormPanel",helper:SYNO.SDS.Docker.Utils.Helper,constructor:function(a){Ext.apply(this,new SYNO.SDS.Docker.Container.ProfileUI());this.data={};this.callParent([this.fillConfig(a)]);this.mon(this,"afterlayout",this.enableGroup,this,{single:true})},enableGroup:function(){this.enableResourceGroup(this);this.enableShortcutGroup(this)},fillConfig:function(b){Ext.apply(b,{mem_max_mb:this.helper.getRealMemory()});var a=this.getPortCfg();a.shift();var c=[];c=c.concat(this.getResourceCfg(b));c=c.concat(this.getShortcutCfg());c.push({xtype:"syno_displayfield"});c=c.concat(a);var d=Ext.apply({title:this.helper.T("container","basic_options"),itemId:"basic",items:c},b);return d},getProfile:function(){var a={};Ext.apply(a,this.getPortValue(this));Ext.apply(a,this.getResourceValue(this));Ext.apply(a,this.getShortcutValue(this));return a},setProfile:function(a){Ext.apply(this.data,a);this.setPortValue(this,this.data);this.setResourceValue(this,this.data);this.setShortcutValue(this,this.data)},validateProfile:function(){return this.validate(this.validatePort)&&this.validate(this.validateResource)&&this.validate(this.validateShortcut)},validate:function(a){var b=a.call(this,this,false);if(false===b){this.owner.panel.activate(this);a.call(this,this,true);this.owner.setStatusError({text:_T("common","forminvalid"),clear:true})}return b}});Ext.define("SYNO.SDS.Docker.Container.Editor",{extend:"SYNO.SDS.Docker.Image.WizardAdvance",helper:SYNO.SDS.Docker.Utils.Helper,constructor:function(a){this.callParent([a]);this.insertBasicFormPanel(a);this.mon(this,"show",function(){this.loadContainerProfile()});this.mon(this,"close",function(){this.parent.onEditClose(this.containerId)})},loadContainerProfile:function(){this.setStatusBusy({text:_T("common","loading")});this.sendWebAPI({scope:this,api:"SYNO.Docker.Container",method:"get",version:1,params:{name:this.containerId},callback:function(d,b,c,a){this.clearStatusBusy();this.panel.get("environment").form.findField("cmd").setReadOnly(true);if(d&&b&&b.profile){this.setProfile(b.profile)}else{this.getMsgBox().alert("",_T("common","error_system"))}}})},isProfileDirty:function(){var a=this.getProfile();return(Ext.encode(this.origProfile)!==Ext.encode(a))},setProfile:function(a){this.panel.setProfile(a);this.basic.setProfile(a);this.origProfile=this.getProfile();this.panel.get("environment").form.findField("cmd").emptyText=" ";this.panel.get("environment").form.findField("cmd").applyEmptyText()},getProfile:function(){var a={};Ext.apply(a,this.panel.getProfile());Ext.apply(a,this.basic.getProfile());return a},applyHandler:function(){if(false===this.validateProfile()){return}if(false===this.isProfileDirty()){this.cancelHandler();return}this.setStatusBusy({text:_T("common","loading")});this.sendWebAPI({scope:this,api:"SYNO.Docker.Container",method:"set_start",version:1,params:{name:this.containerId,override:true,profile:this.getProfile()},callback:function(d,b,c,a){this.clearStatusBusy();if(d){this.close();this.parent.onEditAPIStart(b.task_id,this.containerId)}else{this.setStatusError({text:this.helper.getError(b.code),clear:true})}}})},insertBasicFormPanel:function(a){this.basic=new SYNO.SDS.Docker.Container.BasicProfile({owner:this});this.panel.insert(0,this.basic);this.panel.setActiveTab(0)},validateProfile:function(){return this.panel.validateProfile()&&this.basic.validateProfile()}});Ext.define("SYNO.SDS.Docker.Container.Toolbar",{extend:"SYNO.ux.Toolbar",statusUtil:SYNO.SDS.Docker.Container.StatusUtil,helper:SYNO.SDS.Docker.Utils.Helper,constructor:function(a){this.callParent([this.fillConfig(a)])},fillConfig:function(a){var d=this.statusUtil.statusCode;var c={actions:{start:new Ext.Action({itemId:"start",text:this.helper.T("container","start"),scope:a.owner,enableStatus:d.stop,disableStatus:d.synopackage,handler:a.owner.btnStart}),stop:new Ext.Action({itemId:"stop",text:this.helper.T("container","stop"),scope:a.owner,enableStatus:d.run,disableStatus:d.synopackage,handler:a.owner.btnStop}),restart:new Ext.Action({itemId:"restart",text:this.helper.T("container","restart"),scope:a.owner,enableStatus:d.run,disableStatus:d.synopackage,handler:a.owner.btnRestart}),fstop:new Ext.Action({itemId:"fstop",text:this.helper.T("container","force_stop"),scope:a.owner,enableStatus:d.run,disableStatus:d.synopackage,handler:a.owner.btnFstop}),reset:new Ext.Action({itemId:"reset",text:this.helper.T("container","clear"),scope:a.owner,enableStatus:d.stop,disableStatus:d.synopackage|d.exporting,handler:a.owner.btnReset}),"delete":new Ext.Action({itemId:"delete",text:this.helper.T("common","delete"),scope:a.owner,enableStatus:d.stop,disableStatus:d.synopackage|d.exporting,handler:a.owner.btnDelete})},setting:{duplicate:new Ext.Action({itemId:"duplicate",text:this.helper.T("container","duplicate"),scope:a.owner,enableStatus:d.run|d.stop,disableStatus:d.synopackage|d.exporting,handler:a.owner.btnDuplicate,denyMultiple:true}),"import":new Ext.Action({disabled:false,itemId:"import",text:this.helper.T("container","import"),scope:a.owner,enableStatus:d.unselected|d.run|d.stop,handler:a.owner.btnImport}),"export":new Ext.Action({itemId:"export",text:this.helper.T("container","export"),scope:a.owner,enableStatus:d.run|d.stop,disableStatus:d.synopackage|d.exporting,handler:a.owner.btnExport,denyMultiple:true})}};var e={details:new Ext.Action({itemId:"details",text:this.helper.T("container","detail"),scope:a.owner,enableStatus:d.run|d.stop,handler:a.owner.btnDetails,denyMultiple:true}),edit:new Ext.Action({itemId:"edit",text:this.helper.T("container","edit"),scope:a.owner,enableStatus:d.stop,disableStatus:d.synopackage|d.exporting,handler:a.owner.btnEdit,denyMultiple:true}),actions:new Ext.Action({itemId:"actions",text:this.helper.T("container","action"),menu:new Ext.menu.Menu({items:Object.values(c.actions)}),enableStatus:d.run|d.stop,disableStatus:d.synopackage}),setting:new Ext.Action({disabled:false,itemId:"setting",text:this.helper.T("common","common_settings"),menu:new Ext.menu.Menu({defaults:{disabled:true},items:Object.values(c.setting)}),enableStatus:d.unselected|d.run|d.stop})};this.actionGroup=new SYNO.SDS.Utils.ActionGroup(Object.values(e).concat(Object.values(c.actions)).concat(Object.values(c.setting)));this.actionGroupToplevel=new SYNO.SDS.Utils.ActionGroup(Object.values(e));var b={defaults:{disabled:true},items:Object.values(e)};Ext.apply(b,a);return b}});Ext.define("SYNO.SDS.Docker.Container.ListView",{extend:"SYNO.ux.ExpandableListView",helper:SYNO.SDS.Docker.Utils.Helper,statusUtil:SYNO.SDS.Docker.Container.StatusUtil,constructor:function(a){var b=Ext.apply({cls:"syno-docker-containerlist"},a);this.callParent([b]);this.addTplRenderer();this.mon(this.store,"load",this._onStoreLoad,this)},createTpl:function(){return new Ext.XTemplate('<tpl for=".">','<div data-name="{name}" class="item-wrap {cls}">','<div class="item-summary">','<div class="docker-mainarea {[this.getStoppedClass(values.status)]}">','<div class="docker-titlewrap docker-left">','<div ext:qtip="{name}" class="item-title">{name}</div>','<div ext:qtip="{image}" class="item-status">{image}</div>',"</div>",'<div class="docker-cpumem-wrap docker-left">','<div class="docker-cpumen docker-cpu">','<div class="syno-sds-docker-container-info">','<div class="docker-left docker-title">CPU</div>','<div class="docker-right docker-number">{cpu}</div>','<div class="x-clear"></div>',"</div>",'<div class="syno-sds-docker-container-bar">','<div class="docker-bar-progress" style="width: {cpu}"></div>',"</div>","</div>","</div>",'<div class="docker-cpumem-wrap docker-left">','<div class="docker-cpumen docker-memory">','<div class="syno-sds-docker-container-info">','<div class="docker-left docker-title">RAM</div>','<div class="docker-right docker-number">{memory}</div>','<div class="x-clear"></div>',"</div>",'<div class="syno-sds-docker-container-bar">','<div class="docker-bar-progress" style="width: {memoryPercent}"></div>',"</div>","</div>","</div>",'<div class="x-clear"></div>',"</div>",'<div class="docker-rightarea">','<div class="docker-status docker-left">','<div class="item-title">{[this.getTranslateStatus(values.status, values.exporting)]}</div>','<div class="item-status">{[ values.status === SYNO.SDS.Docker.Container.StatusUtil.status.run ? values.up_time : "" ]}</div>',"</div>",'<div class="docker-left docker-viewport {[ this.getViewportClass(values) ]}">','<div class="docker-switch-btn"></div>','<div class="docker-viewport-container">','<div class="docker-switch-on"></div>','<div class="docker-switch-off"></div>',"</div>","</div>",'<div class="x-clear"></div>',"</div>",'<div class="x-clear"></div>',"</div>","</div>","</tpl>",'<div class="x-clear"></div>')},addTplRenderer:function(){var a=this.tpl,b=this;a.getStoppedClass=function(c){return c===b.statusUtil.status.run?"":"docker-stopped"};a.getTranslateStatus=function(c,d){if(d){return b.helper.T("container","exporting")}return b.helper.T("container","status_"+c)};a.getViewportClass=function(c){var d;if(c.switchStatus){d=c.switchStatus===SYNO.SDS.Docker.Container.StatusUtil.status.run}else{d=c.status===SYNO.SDS.Docker.Container.StatusUtil.status.run}return d?"docker-switch-active":""}},_onStoreLoad:function(){this.getEl().select(".item-wrap").each(function(a,f,d){var e=a.getAttribute("data-name"),b=this.store.getById(e);this.progressbarAnimation(a,b);this.bindSwitchClick(a,b,d)},this)},onUpdate:function(c,a,b){if(b==="commit"){this.store.each(function(d){d.data.cls=d.data.cls.replace("syno-ux-expandable-add","");d.data.cls=d.data.cls.replace("syno-ux-expandable-remove","")})}this.callParent(arguments);if(b==="commit"){this._onStoreLoad()}},progressbarAnimation:function(b,d){var e=b.select(".docker-cpu .docker-bar-progress"),f=b.select(".docker-memory .docker-bar-progress"),c="docker-progressbar-transition",a;if(!d.states.isNew){a=d.states.oldRecord;e.setWidth(a.cpu);f.setWidth(a.memoryPercent);setTimeout(function(h,i,g){return function(){h.addClass(c).setWidth(g.get("cpu"));i.addClass(c).setWidth(g.get("memoryPercent"))}}(e,f,d),0)}},bindSwitchClick:function(a,b,d){var c=a.select(".docker-viewport");this.mun(c,"click");this.mon(c,"click",function(g,f){if(b.get("is_package")===true){this.appWin.getMsgBox().alert("",this.helper.T("container","package_deny_operation"));return}this.owner.view.select(d);if(b.get("status")===this.statusUtil.status.run){this.owner.btnStop()}else{this.owner.btnStart()}},this)},toggleBtnAnimation:function(e,c){var b=this.owner.store.getById(e),f=this.owner.view.getNode(b),d=Ext.get(f).select(".docker-viewport"),a="docker-switch-active";if(c){d.addClass(a)}else{d.removeClass(a)}}});Ext.namespace("SYNO.SDS.Docker.Utils");Ext.define("SYNO.SDS.Docker.Utils.FileChooser",{extend:"SYNO.SDS.Utils.FileChooser.Chooser",helper:SYNO.SDS.Docker.Utils.Helper,constructor:function(a){this.callParent([Ext.apply({scope:this,superuser:true,treeFilter:function(c,b){if(b&&(b.spath==="/home")){return false}return true}},a)]);this.cardview=this.findBy(function(b){return b.getItemId()==="cardview"})[0];this.mon(this,"choose",this.onChoose,this)},initTreeConfig:function(a){var c=this.callParent([a]);var b=[];b.push({cls:"root_node",text:"Upload",draggable:false,allowDrop:false,expanded:false,allowChildren:false,expandable:false,leaf:true,id:"upload_from_computer"});c.root.attributes.children=b.concat(c.root.attributes.children);return c},onTreeSelectionChange:function(b,a){if("upload_from_computer"===a.id){this.cardview.layout.setActiveItem("form");return}this.cardview.layout.setActiveItem("grid");this.callParent(arguments)},initFormConfig:function(a){this.fileUploadButton=new SYNO.ux.FileButton({fieldLabel:this.helper.T("common","file"),name:"filename",listeners:{scope:this,change:this.onFileUploadChange}});this.formpanel=new SYNO.SDS.Utils.FormPanel({itemId:"form",webapi:a.webapi.uploader,fileUpload:true,trackResetOnLoad:true,frame:false,border:false,labelWidth:161,items:[{xtype:"syno_fieldset",title:_T("itunes","itunes_path"),items:[this.fileUploadButton]}],listeners:{scope:this,activate:this.onFormActivate,deactivate:this.onFormDeactivate}});return this.formpanel},initGridConfig:function(a){var b=this.callParent([a]);var d=this.initFormConfig(a);var c={itemId:"cardview",layout:"card",region:"center",border:false,activeItem:0,items:[b,d]};return c},applyHandler:function(){if(this.grid.isVisible()){this.callParent(arguments);return}this.getProgressInstance();this.formpanel.getForm().submit({clientValidation:false,progress:this.onProgrss,scope:this,callback:this.onUploadCallback})},getProgressInstance:function(){if(!this.progress||!this.progress.isVisible()){this.progress=this.getMsgBox().progress("","uploading...","")}return this.progress},onProgress:function(a){},onChoose:function(b,a){b.close();this.sendWebAPI(Ext.apply({params:{path:a.path},scope:b,callback:b.onChooseCallback},b.webapi.chooser))},onUploadCallback:function(d,a,c){this.getProgressInstance().updateProgress(1);this.getProgressInstance().close();var b=this.webapi.uploader;Ext.apply(b,c);this.close();if(this.callback){this.callback.call(this.scope||{},d,a,b)}},onChooseCallback:function(d,a,c){var b=this.webapi.chooser;b.params=c;if(this.callback){this.callback.call(this.scope,d,a,b)}},onFormActivate:function(){this.onFileUploadChange()},onFormDeactivate:function(){var a=this.items.get(1);var b=a.items.get(1);b.enable()},onFileUploadChange:function(){var a=this.items.get(1);var b=a.items.get(1);if(this.fileUploadButton.getValue()===""){b.disable()}else{b.enable()}}});Ext.define("SYNO.SDS.Docker.Container.FileChooser",{extend:"SYNO.SDS.Docker.Utils.FileChooser",helper:SYNO.SDS.Docker.Utils.Helper,constructor:function(a){this.callParent([Ext.apply({webapi:{uploader:{api:"SYNO.Docker.Container.Profile",method:"upload",version:1},chooser:{api:"SYNO.Docker.Container.Profile",method:"import",version:1}},listeners:{scope:this,cancel:this._onCancel,close:this._onClose}},a)]);this.mon(this.formpanel.getForm(),"beforeaction",function(c,d){var b=c.items.items[0].getValue();if(!b.match(/\.json$/)){c.webapi.api="SYNO.Docker.Container"}return true},this)},onChoose:function(b,a){b.close();if(!a.path.match(/\.json$/)){b.webapi.chooser.api="SYNO.Docker.Container"}this.sendWebAPI(Ext.apply({params:{path:a.path},scope:b,callback:b.onChooseCallback},b.webapi.chooser))},_onCancel:function(){this.isCanceled=true},_onClose:function(){this.panel.focus();if(!this.isCanceled){this.panel.getEl().mask()}}});Ext.define("SYNO.SDS.Docker.Container.ExportContainerWizard",{extend:"SYNO.SDS.ModalWindow",helper:SYNO.SDS.Docker.Utils.Helper,constructor:function(a){this.callParent([this.fillConfig(a)])},fillConfig:function(a){this.formPanel=this.createFormPanel(a);var b={title:this.helper.T("container","export"),width:550,height:450,layout:"fit",buttons:[{xtype:"syno_button",btnStyle:"blue",text:this.helper.T("common","export"),scope:this,handler:this.onConfirm},{xtype:"syno_button",text:this.helper.T("common","cancel"),scope:this,handler:this.onCancel}],items:[this.formPanel]};Ext.apply(b,a);return b},createFormPanel:function(a){return new SYNO.ux.FormPanel({items:[{xtype:"syno_fieldset",title:this.helper.T("container","export_type"),items:[{itemId:"config",xtype:"syno_radio",name:"export_type",value:"config",boxLabel:this.helper.T("container","container_settings"),checked:true},{xtype:"syno_displayfield",indent:1,value:this.helper.T("container","container_settings_desc")},{itemId:"container",xtype:"syno_radio",name:"export_type",value:"container",boxLabel:this.helper.T("container","container_settings_container"),listeners:{scope:this,check:this.onContainerChecked}},{xtype:"syno_displayfield",indent:1,value:this.helper.T("container","container_settings_container_desc")}]},this.exportTargetField=new SYNO.ux.FieldSet({title:this.helper.T("container","export_target"),items:[{itemId:"volume",xtype:"syno_radio",name:"export_target",value:"volume",boxLabel:this.helper.T("container","export_to_diskstation"),checked:true,listeners:{scope:this,check:this.onVolumeChecked}},this.fileChooseField=new SYNO.ux.CompositeField({hideLabel:true,indent:1,items:[{itemId:"file_btn",xtype:"syno_button",hideLabel:true,text:this.helper.T("mediaservice","root_directory_path"),scope:this,handler:this.onPathChoose},{itemId:"volume_path",xtype:"syno_textfield",name:"volume_path",value:"",hideLabel:true,disabled:true}]}),{itemId:"local",xtype:"syno_radio",name:"export_target",value:"local",boxLabel:this.helper.T("container","export_to_local")}]})]})},onVolumeChecked:function(a,b){if(b){this.fileChooseField.innerCt.getComponent("file_btn").enable()}else{this.fileChooseField.innerCt.getComponent("file_btn").disable()}},onContainerChecked:function(a,b){if(b){this.exportTargetField.getComponent("volume").setValue(true);this.exportTargetField.getComponent("local").disable()}else{this.exportTargetField.getComponent("local").enable()}},onPathChoose:function(){var a=this.fileChooseField.innerCt.getComponent("volume_path");var b=new SYNO.SDS.Utils.FileChooser.Chooser({owner:this,title:_T("common","add"),folderToolbar:true,usage:{type:"chooseDir"},gotoPath:"/docker",treeFilter:function(d,c){if(c&&(c.spath==="/home")){return false}return true},listeners:{scope:this,choose:function(e,d,c){a.setValue(d.path);e.close()}}});b.open()},onConfirm:function(){var a=this.fileChooseField.innerCt.getComponent("volume_path"),c=this.formPanel.getForm().getValues(),b={api:c.export_type==="config"?"SYNO.Docker.Container.Profile":"SYNO.Docker.Container",method:"export",version:1,params:{name:this.containerName}};if(c.export_target==="volume"){if(a.getValue().length===0){this.setStatusError({text:this.helper.T("service","warning_select_dest"),clear:true});return}b.params.path=a.getValue();this.helper.maskLoading(this);this.sendWebAPI(Ext.apply({scope:this,callback:function(e,d){this.helper.unmask(this);if(!e){this.owner.getMsgBox().alert("",this.helper.getError(d.code))}else{this.close()}}},b))}else{this.downloadWebAPI({webapi:b,scope:this,callback:function(d,e,g,f){this.owner.getMsgBox().alert("",this.helper.getError(f.code))}});this.close()}},onCancel:function(){this.close()}});Ext.define("SYNO.SDS.Docker.Utils.Shortcut",{extend:"Ext.util.Observable",helper:SYNO.SDS.Docker.Utils.Helper,constructor:function(a){Ext.apply(this,a);this.addEvents("exception")},refreshByContainerName:function(a){this.owner.sendWebAPI({scope:this,api:"SYNO.Docker.Container",method:"get",version:1,params:{name:a},callback:function(e,c,d,b){if(!e||undefined===c.profile){this.fireEvent("exception",c)}else{this.refresh(c.profile)}}})},refresh:function(c){var a=c.shortcut,e={data:{name:c.name}},d={},b={className:"SYNO.SDS.Docker.ContainerDetail.Instance",icon:"images/docker_shortcut_{0}.png",needHide:false,title:c.name,param:e};d[this.helper.T("shortcut","open_status")]=e;b.launchParams=d;if(false===a.enable_shortcut){this.remove(c.name);return}if(true===a.enable_web_page){Ext.apply(b,{type:"url",url:a.web_page_url})}this.replace(c.name,b)},getDesktopShortcutObj:function(b){var a=SYNO.SDS.Desktop.iconItems.find(function(c){return c.managerItemConfig.className==="SYNO.SDS.Docker.ContainerDetail.Instance"&&b==c.managerItemConfig.param.data.name});return a},replace:function(e,c){var b=this.getDesktopShortcutObj(e),d=false,a;if(!b){d=true}else{a=b.managerItemConfig;if(!SYNO.ux.Utils.checkObjectConsistency(c,a)){this.remove(e);d=true}}if(d){SYNO.SDS.Desktop.addLaunchItem(c)}},remove:function(b){b=b.find===undefined?[b]:b;var a=SYNO.SDS.Desktop.iconItems.filter(function(c){return c.managerItemConfig.className==="SYNO.SDS.Docker.ContainerDetail.Instance"&&b.find(function(d){return d==c.managerItemConfig.param.data.name})});a.each(function(c){c.remove()})},recover:function(){this.owner.sendWebAPI({scope:this,api:"SYNO.Docker.Container",method:"list",version:1,params:{offset:0,limit:-1},callback:function(d,b,c,a){if(!d){this.fireEvent("exception",b)}else{b.containers.each(function(e){this.refreshByContainerName(e.name)},this)}}})}});Ext.define("SYNO.SDS.Docker.Utils.PreserveStates",{extend:Object,constructor:function(a){Ext.apply(this,a);this.cachedStoreData={}},init:function(a){this.dataview=a;var b=a.store;this.cacheStoreData(b);a.mon(b,"load",this.onStoreLoad,this);a.mon(b,"update",this.onStoreUpdate,this)},onStoreLoad:function(a){a.each(function(b){b.states=b.states||{};b.states.isNew=this.isNew(b);b.states.oldRecord=this.cachedStoreData[b.id]?this.cachedStoreData[b.id].data:{}},this);this.cacheStoreData(a)},onStoreUpdate:function(c,a,b){if(b===Ext.data.Record.COMMIT){this.cachedStoreData[a.id]=a}},cacheStoreData:function(a){this.cachedStoreData={};a.each(function(b){this.cachedStoreData[b.id]=b},this)},isNew:function(a){return this.cachedStoreData[a.id]===undefined}});Ext.define("SYNO.SDS.Docker.Container.DuplicateDialog",{extend:"SYNO.SDS.ModalWindow",helper:SYNO.SDS.Docker.Utils.Helper,constructor:function(a){this.callParent([this.fillConfig(a)])},fillConfig:function(a){this.formPanel=this.createFormPanel(a);var b={title:this.helper.T("container","new_name"),width:450,height:150,buttons:[{xtype:"syno_button",btnStyle:"blue",text:this.helper.T("common","choose"),scope:this,handler:this.onConfirm},{xtype:"syno_button",text:this.helper.T("common","cancel"),scope:this,handler:this.onCancel}],items:[this.formPanel]};Ext.apply(b,a);return b},createFormPanel:function(a){return new SYNO.ux.FormPanel({items:[{xtype:"syno_textfield",allowBlank:false,minlength:2,maxlength:64,name:"newname",fieldLabel:this.helper.T("container","new_name"),validator:this.helper.containerNameValidator,value:a.nameDefault}]})},onConfirm:function(){var a=this.formPanel.form.findField("newname");if(a.isValid()){this.sendAPI.call(this.scope,a.value);this.close()}},onCancel:function(){this.close()}});Ext.define("SYNO.SDS.Docker.Container.Panel",{extend:"SYNO.ux.Panel",refreshInterval:3000,dataViewAnimationDuration:700,opacity:0.5,helper:SYNO.SDS.Docker.Utils.Helper,statusUtil:SYNO.SDS.Docker.Container.StatusUtil,constructor:function(a){this.callParent([this.fillConfig(a)]);this.pollingTask=this.createPollingTask()},fillConfig:function(a){this.ignoreDeactivate=false;this.shortcutHelper=new SYNO.SDS.Docker.Utils.Shortcut({owner:this});this.runningIds={};this.tbar=new SYNO.SDS.Docker.Container.Toolbar({owner:this,appWin:a.appWin});this.actionGroup=this.tbar.actionGroup;this.actionGroupToplevel=this.tbar.actionGroupToplevel;this.store=this.createStore(a);this.view=this.createView(a);this.restartTask=new Ext.util.DelayedTask(function(){this.pollingTask.restart(true)},this);this.editPollingTasks={};var b=Ext.apply({tbar:this.tbar,layout:"fit",items:[this.view],listeners:{scope:this,activate:this.onActivate,deactivate:this.onDeactivate}},a);return b},createView:function(a){return new SYNO.SDS.Docker.Container.ListView({appWin:a.appWin,owner:this,store:this.store,itemSelector:".item-wrap",trackResetOnLoad:false,plugins:[new SYNO.SDS.Docker.Utils.PreserveStates(),new SYNO.ux.DataViewAnimation({duration:this.dataViewAnimationDuration}),new SYNO.ux.DataViewMask({opacity:this.opacity})],listeners:{scope:this,beforeselect:this.onBeforeSelect,selectionchange:this.onSelectionChange,contextmenu:this.onRowContextMenu,dblclick:this.btnDetails}})},createStore:function(a){var b=this;return new Ext.data.JsonStore({autoDestroy:true,root:"items",idProperty:"name",fields:[{name:"status",sortType:function(c){return c===b.statusUtil.status.run?0:(c==b.statusUtil.status.stop?1:2)}},{name:"image"},{name:"name",sortType:function(c){return c.toLowerCase()}},{name:"image"},{name:"cpu"},{name:"memory"},{name:"memoryPercent"},{name:"up_time"},{name:"sortIndex"},{name:"is_package"},{name:"exporting"}],hasMultiSort:true,multiSortInfo:{sorters:[{field:"name",direction:"ASC"}],direction:"ASC"},listeners:{scope:this,datachanged:this.onStoreDataChanged}})},createPollingTask:function(){return this.addWebAPITask({scope:this,interval:this.refreshInterval,compound:{stopwhenerror:true,params:[{api:"SYNO.Docker.Container",method:"list",version:1,params:{limit:-1,offset:0}},{api:"SYNO.Docker.Container.Resource",method:"get",version:1}]},callback:function(d,b,c,a){this.helper.unmask(this.view);if(!b.has_fail){if(b.result[0].data.containers.length===0){this.helper.mask(this.view,this.helper.T("container","no_container"))}this.loadData(b.result)}else{this.onException(b.result)}}})},loadData:function(a){var d=a[0].data.containers,e=a[1].data.resources,b=[],c={};b=d.map(function(f){f.up_time=this.helper.relativeTime(f.up_time*1000);var g=f.image.match(/^([^\/]*\.[^\/]*)\/(.*)/);if(g){f.image=g[2]}return f},this);Ext.each(b,function(f,g){c[f.name]=g},this);Ext.each(e,function(f){var g=c[f.name];if(undefined!==b[g]){b[g].cpu=Ext.util.Format.round(f.cpu,2)+"%";b[g].memory=this.helper.shortFileSize(f.memory);b[g].memoryPercent=f.memoryPercent+"%"}},this);this.store.loadData({items:b});setTimeout((function(){this.view.autoUpdateScrollbar()}).createDelegate(this),this.dataViewAnimationDuration)},getSelections:function(){return this.view.getSelectedRecords()},onStoreDataChanged:function(a){var b=Object.keys(this.runningIds);Ext.each(b,function(c){if(!a.getById(c)){this.enableSelection(c)}},this)},maskRow:function(a){this.view.maskItem(a);this.disableSelection(a)},unmaskRow:function(b){this.enableSelection(b);try{this.view.unmaskItem(b)}catch(a){SYNO.Debug(a)}},API:function(a){var b=this.getSelections();Ext.each(b,function(d){var c={appWindow:this.appWin,api:a.api||"SYNO.Docker.Container",method:a.method,version:1,params:{name:d.data.name},scope:this,callback:this.onAPICallback({selection:d,delayRestart:a.delayRestart,blockUnmask:a.blockUnmask===undefined?false:a.blockUnmask,userCallback:Ext.isFunction(a.callback)?a.callback:Ext.emptyFn})};if(undefined!==a.params){Ext.apply(c.params,a.params)}this.sendWebAPI(c);if(!a.blockMask){this.maskRow(d.id)}},this)},onAPICallback:function(a){return function(d,c){if(!d||!a.blockUnmask){this.unmaskRow(a.selection.id)}if(!d){var b=(c.errors&&c.errors.errors)?c.errors.errors:"";this.getMsgBox().alert("alert",this.helper.getError(c.code,b))}else{this.pollingTask.stop();a.userCallback.call(this,c,a.selection.id);if(a.delayRestart){this.restartTask.delay(1000)}else{this.restartTask.delay(100)}}}},disableSelection:function(a){this.view.clearSelections();this.runningIds[a]=true},enableSelection:function(a){delete this.runningIds[a]},btnStart:function(a,b){this.API({method:"start",delayRestart:true,callback:function(c,e){var d=this.store.getById(e);d.beginEdit();d.set("cpu",Ext.util.Format.round(c.cpu,2)+"%");d.set("memory",this.helper.shortFileSize(c.memory));d.set("memoryPercent",c.memoryPercent+"%");d.set("up_time",this.helper.relativeTime(new Date().getTime()-1));d.set("status",this.statusUtil.status.run);d.set("switchStatus",this.statusUtil.status.stop);d.commit();this.view.toggleBtnAnimation(e,true);if(c.start_dependent_container===true){var f=c.dependent_container.join(",");this.getMsgBox().alert("",String.format(this.helper.T("container","started_depend_containers"),f))}}})},btnStop:function(a,b){this.API({method:"stop",delayRestart:true,callback:function(c,e){var d=this.store.getById(e);d.beginEdit();d.set("cpu","0%");d.set("memoryPercent","0%");d.set("status",this.statusUtil.status.stop);d.set("switchStatus",this.statusUtil.status.run);d.commit();this.view.toggleBtnAnimation(e,false)}})},btnRestart:function(a,b){this.API({method:"restart",delayRestart:true,callback:function(c,e){var d=this.store.getById(e);d.beginEdit();d.set("cpu",Ext.util.Format.round(c.cpu,2)+"%");d.set("memory",this.helper.shortFileSize(c.memory));d.set("memoryPercent",c.memoryPercent+"%");d.set("up_time",this.helper.relativeTime(new Date().getTime()-1));d.set("status",this.statusUtil.status.run);d.commit()}})},btnFstop:function(a,c){var b=this;this.getMsgBox().confirm("confirm",this.helper.T("container","force_stop_confirm"),function(d){if(d==="yes"){b.API({method:"signal",params:{signal:9},delayRestart:true,callback:function(e,g){var f=this.store.getById(g);f.beginEdit();f.set("status","stopped");f.commit()}})}})},btnReset:function(b,e){var d=this,c=this.getSelections().map(function(f){return String.format("<b>{0}</b>",f.data.name)}),a=String.format(this.helper.T("container","clear_confirm"),this.getSelections().length);this.getMsgBox().confirm("confirm",String.format("<span ext:qtip='{0}'>{1}</span>",c.join("<br>"),a),function(f){if(f==="yes"){d.API({method:"delete",params:{force:false,preserve_profile:true}})}})},btnDelete:function(a,e){var d=this,b=this.getSelections().map(function(f){return String.format("<b>{0}</b>",f.data.name)}),c=String.format(this.helper.T("container","delete_confirm"),this.getSelections().length);this.getMsgBox().confirm("confirm",String.format("<span ext:qtip='{0}'>{1}</span>",b.join("<br>"),c),function(f){if(f==="yes"){d.API({blockUnmask:true,method:"delete",params:{force:false,preserve_profile:false},callback:d.onDeleteDone})}})},btnDuplicate:function(b,e){var d=this.getSelections(),c=d[0],a=new SYNO.SDS.Docker.Container.DuplicateDialog({owner:this.appWin,nameDefault:c.data.name+"-copy",scope:this,sendAPI:function(f){this.API({blockMask:true,blockUnmask:true,api:"SYNO.Docker.Container.Profile",method:"duplicate",params:{new_name:f},callback:this.onDupDone});var g=new SYNO.SDS.Docker.Utils.WelcomeDialog({owner:this.appWin,appWin:this.appWin,width:350,height:180,userSettingKey:"container-duplicate",title:this.helper.T("container","hint"),items:[{xtype:"box",html:this.helper.T("container","duplicate_warn")}]});g.open()}});a.open()},btnEdit:function(a,b){var d=this.getSelections()[0].id;this.maskRow(d);this.ignoreDeactivate=true;var c=new SYNO.SDS.Docker.Container.Editor({containerId:d,title:_T("common","alt_edit")+" - "+d,owner:this.appWin,parent:this});c.open()},btnImport:function(b,c){var a=new SYNO.SDS.Docker.Container.FileChooser({owner:this.appWin,panel:this,scope:this,callback:function(f,d,e){this.getEl().unmask();if(f){this.pollingTask.restart(true)}else{var g=d.errors?d.errors.errors:"";this.getMsgBox().alert("",this.helper.getError(d.code,g))}}});a.show()},btnExport:function(a,b){var d=this.getSelections()[0].id;var c=new SYNO.SDS.Docker.Container.ExportContainerWizard({owner:this.appWin,containerName:d});c.open()},btnDetails:function(a,c){var b=this.getSelections();if(b.length===1){SYNO.SDS.AppLaunch("SYNO.SDS.Docker.ContainerDetail.Instance",b[0],true)}},getMsgBox:function(){this.ignoreDeactivate=true;return this.appWin.getMsgBox()},onEditAPIStart:function(a,b){this.maskRow(b);this.initEditPollingTask(a,b)},onEditClose:function(a){this.unmaskRow(a)},initEditPollingTask:function(a,b){if(a in this.editPollingTasks){return}this.editPollingTasks[a]=this.addWebAPITask({scope:this,interval:this.refreshInterval,api:"SYNO.Docker.Container",method:"set_status",version:1,params:{task_id:a},callback:function(f,d,e,c){if(false===f){this.getMsgBox().alert("",this.helper.getError(d.code,d.errors.errors));this.unmaskRow(b);this.removeEditPollingTask(a)}else{if(d.finished){this.shortcutHelper.refreshByContainerName(b);this.unmaskRow(b);this.removeEditPollingTask(a)}}}}).start(true)},removeEditPollingTask:function(a){if(this.editPollingTasks[a]){this.editPollingTasks[a].stop();delete this.editPollingTasks[a]}},onDeleteDone:function(a,b){this.shortcutHelper.remove(b)},onDupDone:function(a,b){this.shortcutHelper.recover()},onBeforeSelect:function(d,c,b){var a=this.view.getRecord(c).id;if(this.runningIds[a]){return false}return true},onSelectionChange:function(){var b=this.getSelections(),a;this.actionGroup.disableAll();switch(b.length){case 0:this.onSelection(this.statusUtil.statusCode.unselected);break;case 1:a=b[0].data.status;this.onSelection(this.statusUtil.stat2StatCode(b[0].data));break;default:this.onSelectionMultiple(b)}},onSelection:function(b){var a=this.actionGroup;Ext.each(a.getArray(),function(d){var c=d.initialConfig.enableStatus&b,e=(d.initialConfig.disableStatus!==undefined)&&(d.initialConfig.disableStatus&b);if(c&&!e){d.enable()}})},onSelectionMultiple:function(a){var b=a.reduce(function(d,e){var c=this.statusUtil.stat2StatCode(e.data);if(d.indexOf(c)==-1){d.push(c)}return d}.createDelegate(this),[]);Ext.each(this.actionGroup.getArray(),function(c){var d=b.reduce(function(g,f){var e=c.initialConfig.enableStatus&f,h=(c.initialConfig.disableStatus!==undefined)&&(c.initialConfig.disableStatus&f);return g&&e&&!h&&!c.initialConfig.denyMultiple},true);if(d){c.enable()}})},onRowContextMenu:function(b,f,c,d){this.view.select(f);var a=this.actionGroupToplevel.getArray().filter(function(g){return !g.initialConfig.disabled}),e=new SYNO.ux.Menu({autoDestroy:true,items:a});e.showAt(d.getXY());d.preventDefault()},onException:function(a){Ext.each(a,function(b){if(!b.success){this.helper.logError(b.error.code)}},this)},onActivate:function(){if(!this.ignoreDeactivate){this.helper.maskLoadingOnce(this.view,this);this.pollingTask.start(true)}this.ignoreDeactivate=false},onDeactivate:function(){if(!this.ignoreDeactivate){this.pollingTask.stop()}}});Ext.define("SYNO.SDS.Docker.Registry.TagDialog",{extend:"SYNO.SDS.ModalWindow",helper:SYNO.SDS.Docker.Utils.Helper,constructor:function(a){this.callParent([this.fillConfig(a)])},fillConfig:function(a){this.store=this.createTagStore(a);this.formPanel=this.createFormPanel(a);var b={title:this.helper.T("registry","choose_tag"),width:450,height:150,buttons:[{xtype:"syno_button",btnStyle:"blue",text:this.helper.T("common","choose"),scope:this,handler:this.onChoose},{xtype:"syno_button",text:this.helper.T("common","cancel"),scope:this,handler:this.onCancel}],items:[this.formPanel],listeners:{scope:this,beforeshow:{single:true,fn:this.onBeforeShow}},scope:this};Ext.apply(b,a);return b},createTagStore:function(a){return new SYNO.API.JsonStore({appWindow:a.owner,autoDestroy:true,fields:[{name:"tag",mapping:"tag"}],api:"SYNO.Docker.Registry",method:"tags",version:1,scope:this,baseParams:a.query,listeners:{scope:this,load:this.onLoad,exception:this.onException}})},createFormPanel:function(a){return new SYNO.ux.FormPanel({items:[{xtype:"syno_combobox",typeAhead:true,forceSelection:true,allowBlank:false,triggerAction:"all",displayField:"tag",name:"tag",store:this.store,fieldLabel:this.helper.T("registry","choose_tag_instruction")}]})},onChoose:function(a){this.chooseHandler.call(this.scope,this.query,this.formPanel.getForm().getValues().tag);this.close()},onCancel:function(a){this.close()},onBeforeShow:function(){this.store.load();return false},onLoad:function(a){if(_S("demo_mode")){this.owner.getMsgBox().alert(this.helper.T("error","error_error"),this.helper.T("registry","demo_cannot_download"));this.close();return}if(this.store.data.length===0){this.owner.getMsgBox().alert(this.helper.T("error","error_error"),this.helper.T("error","error_error_system"));this.close();return}this.formPanel.getForm().setValues(this.store.getAt(0).data);if(this.store.data.length===1){this.onChoose()}else{this.show()}},onException:function(d,a,e,b,c){this.owner.getMsgBox().alert(this.helper.T("error","error_error"),this.helper.getError(c.code));this.close()}});Ext.define("SYNO.SDS.Docker.Image.AddFromUrlDialog",{extend:"SYNO.SDS.ModalWindow",helper:SYNO.SDS.Docker.Utils.Helper,dockerHubHelper:SYNO.SDS.Docker.Utils.DockerHub,constructor:function(a){this.callParent([this.fillConfig(a)])},fillConfig:function(a){this.formPanel=this.createFormPanel();var b={title:this.helper.T("image","add_from_url"),layout:"fit",width:460,height:320,items:[this.formPanel],buttons:[{xtype:"syno_button",btnStyle:"blue",text:this.helper.T("common","add"),scope:this,handler:this.onAddClick},{xtype:"syno_button",text:this.helper.T("common","cancel"),scope:this,handler:this.onCancelClick}]};Ext.apply(b,a);return b},createFormPanel:function(){var b=new SYNO.ux.FieldSet({title:this.helper.T("registry","url"),collapsible:false,items:[{xtype:"syno_textfield",name:"url",allowBlank:false,fieldLabel:this.helper.T("image","image_url_instruction")}]});var a=new SYNO.ux.FieldSet({title:this.helper.T("common","optional"),collapsible:false,items:[{xtype:"syno_textfield",name:"username",fieldLabel:this.helper.T("registry","username_optional")},{xtype:"syno_textfield",name:"password",textType:"password",fieldLabel:this.helper.T("registry","password_optional")},{xtype:"syno_checkbox",name:"enable_trust_SSC",boxLabel:this.helper.T("registry","trust_ssc")}]});return new SYNO.ux.FormPanel({items:[b,a]})},onAddClick:function(){if(!this.formPanel.getForm().isValid()){return}var c=this.formPanel.getForm().getValues();var b=null;c.enable_trust_SSC=(c.enable_trust_SSC=="true");if((b=c.url.match(this.dockerHubHelper.repoRegex))){c.url=b[1];c.repo=b[2].replace(/^_\//,"")}else{if(Ext.form.VTypes.url(c.url)&&(b=c.url.match(/(.*)v1\/repositories\/([A-Za-z0-9_-]+\/?[A-Za-z0-9_-]*)\/?$/))){c.url=b[1];c.repo=b[2]}else{if((b=c.url.match(/^([A-Za-z0-9_-]+\/?[A-Za-z0-9_-]*)\/?$/))){c.url="https://"+this.dockerHubHelper.domain;c.repo=b[1]}else{if((b=c.url.match(/^((?:https?:\/\/)?[^\/]*)\/([A-Za-z0-9_-]+\/?[A-Za-z0-9_-]*)\/?$/))){c.url=(/^http/.test(b[1]))?b[1]:"http://"+b[1];c.repo=b[2]}else{this.owner.getMsgBox().alert(this.helper.T("error","error_error"),String.format(this.helper.T("image","invalid_registry_url"),c.url));return}}}}this.helper.maskLoading(this);var a=new SYNO.SDS.Docker.Registry.TagDialog({owner:this.owner,query:c,scope:this,chooseHandler:this.onTagChoose});this.waitPullImage=false;this.mon(a,"close",this.onTagDialogClose,this);a.open()},onCancelClick:function(){this.close()},onTagChoose:function(c,a){var b=this.formPanel.getForm().getValues();if("https://registry.hub.docker.com"===c.url){c.url="https://docker.io"}var d={tag:a,repository:c.repo,registry:c.url,username:b.username,password:b.password};this.sendWebAPI({api:"SYNO.Docker.Image",method:"pull_start",version:1,scope:this,callback:this.onPullImageCallback,params:d});this.waitPullImage=true},onTagDialogClose:function(){if(!this.waitPullImage){this.helper.unmask(this)}},onPullImageCallback:function(c,b,a){if(!c){this.owner.getMsgBox().alert(this.helper.T("error","error_error"),b.errors||this.helper.T("error","error_error_system"));this.helper.unmask(this);return}this.close()}});Ext.namespace("SYNO.SDS.Docker.Utils");SYNO.SDS.Docker.Utils.Parser={mergeOpts:function(b,a){Object.keys(a).each(function(c){if(Ext.isArray(b[c])&&Ext.isArray(a[c])){b[c]=b[c].concat(a[c])}else{b[c]=a[c]}});return b},parseDockerRun:function(e){var d=null;var f={};var c="";var g="";var a="";var b=false;if(!(d=e.match(/^\s*docker run(.*)/))){SYNO.Debug("Invalid cmd:",e);return{parsedData:null,unSuppotedOpts:e}}c=d[1];while(1){if((d=c.match(/^\s*-(\w+)(.*)/))){b=true;a=this.parseDockerRunShortOpts(d[1],d[2])}else{if((d=c.match(/^\s*--([a-zA-Z0-9\-]+)(.*)/))){b=false;a=this.parseDockerRunOpt(d[1],d[2])}else{break}}if(a.unSuppotedOpt.length!==0){a.unSuppotedOpt=(b?" -":" --")+a.unSuppotedOpt}f=this.mergeOpts(f,a.parsedOpt);c=a.remainCmd;g+=a.unSuppotedOpt}if((d=c.match(/^\s*(\S+)\s*(.*)/))){f.image=d[1];f.cmd=d[2]}return{parsedData:f,unSuppotedOpts:g.strip()}},parseDockerRunShortOpts:function(c,a){var b=this;return c.split("").reduce(function(e,g,d,h){var f=null;if(d==h.length-1){f=b.parseDockerRunOpt(g,a)}else{f=b.parseDockerRunOpt(g,"")}e.parsedOpt=b.mergeOpts(e.parsedOpt,f.parsedOpt);e.remainCmd=f.remainCmd;e.unSuppotedOpt+=f.unSuppotedOpt;return e},{parsedOpt:{},remainCmd:"",unSuppotedOpt:""})},parseDockerRunOpt:function(a,b){if(a in this.dockerRunOptFuncs){return this.dockerRunOptFuncs[a](a,b)}else{return this.dockerRunOptFuncs.unknown(a,b)}},dockerRunOptFuncs:function(){var a={};var c="";var j="";var n=null;var e=function(t){var s=t.match(/^(?:=|\s+)([^"'\s]+|"(?:\\"|[^"])*"|'(?:\\'|[^'])*')(.*)/);if(s){return{arg:s[1].replace(/^('|")|('|")$/g,""),remain:s[2]}}return{arg:"",remain:t}};var o=function(s){return function(t,u){a={};c="";j="";n=e(u);s(t,u);return{parsedOpt:a,remainCmd:c,unSuppotedOpt:j}}};var b=o(function(s,t){if(n.arg!=="false"||n.arg!=="true"){c=t}else{c=n.remain}});var d=o(function(s,t){c=n.remain;a.env_variables=n.arg.split(",").map(function(u){var v=u.split("=");return(v.length===2)?{key:v[0],value:v[1]}:undefined}).filter(function(u){return u!==undefined})});var m=o(function(s,t){c=n.remain;a.links=n.arg.split(",").map(function(u){var v=u.split(":");return(v.length===2)?{link_container:v[0],alias:v[1]}:undefined}).filter(function(u){return u!==undefined})});var f=o(function(s,t){c=n.remain;a.name=n.arg});var r=o(function(s,t){if(n.arg!=="false"||n.arg!=="true"){c=t;a.enable_publish_all_ports=true}else{c=n.remain;a.enable_publish_all_ports=(n.arg==="true")}});var g=o(function(s,t){c=n.remain;a.port_bindings=n.arg.split(",").map(function(u){var v=u.split(":");return(v.length==2)?{host_port:parseInt(v[0],10),container_port:parseInt(v[1],10),type:"tcp"}:undefined}).filter(function(u){return u!==undefined})});var q=o(function(s,t){if(n.arg!=="false"||n.arg!=="true"){c=t;a.privileged=true}else{c=n.remain;a.privileged=(n.arg==="true")}});var l=o(function(s,t){c=n.remain;a.volume_bindings=n.arg.split(",").map(function(u){var v=u.split(":");return(v.length===2||v.length===3)?{host_volume_file:v[0],mount_point:v[1],type:(v[2])?v[2]:"rw"}:undefined}).filter(function(u){return u!==undefined})});var i=o(function(s,t){c=n.remain;j=s});var k=o(function(s,t){if(n.arg!=="false"||n.arg!=="true"){c=t}else{c=n.remain}j=s});var p=o(function(s,t){if(n.arg!=="false"||n.arg!=="true"){c=t}else{c=n.remain}});var h=o(function(s,t){c=t;j=s});return{d:b,detach:b,e:d,env:d,link:m,name:f,P:r,"publish-all":r,p:g,publish:g,privileged:q,v:l,volume:l,t:p,tty:p,a:i,attach:i,"add-host":i,c:i,"cpu-shares":i,"cap-add":i,"cap-drop":i,cidfile:i,cpuset:i,device:i,dns:i,"dns-search":i,entrypoint:i,"env-file":i,expose:i,h:i,hostname:i,i:k,interactive:k,"lxc-conf":i,m:i,memory:i,net:i,restart:i,rm:k,"security-opt":i,"sig-proxy":k,u:i,user:i,w:i,workdir:i,unknown:h}}()};Ext.define("SYNO.SDS.Docker.Image.Wizard",{extend:"SYNO.SDS.Wizard.ModalWindow",helper:SYNO.SDS.Docker.Utils.Helper,parser:SYNO.SDS.Docker.Utils.Parser,constructor:function(a){Ext.apply(this,new SYNO.SDS.Docker.Container.ProfileUI());this.data={image:a.image};this.owner=a.owner;this.callParent([this.fillConfig(a)]);this.getSteps("first_step").form.findField("name").focus(true,350)},fillConfig:function(a){this.shortcutHelper=new SYNO.SDS.Docker.Utils.Shortcut({owner:this});var b=[];var d="";if(a.dockerRun){b.push(this.getImageStep({itemId:"image_step",nexId:"first_step"}))}d=a.image.split(":")[0]+"("+a.image.split(":")[1]+")";b=b.concat([this.getFirstStep({itemId:"first_step",nextId:"second_step"}),this.getSecondStep({itemId:"second_step",nextId:"summary_step"}),this.getSummaryStep({itemId:"summary_step"})]);var c={dsmStyle:"v5",cls:"syno-sds-docker-profile",title:String.format(this.helper.T("wizard","create_container_imageinfo"),d),width:700,height:500,steps:b,listeners:{scope:this,beforeclose:this.onBeforeClose}};Ext.apply(c,a);return c},getImageStep:function(a){var b=[];b=b.concat([{xtype:"syno_displayfield"},{xtype:"syno_displayfield",value:this.helper.T("wizard","command_parser_help")},{xtype:"syno_compositefield",fieldLabel:this.helper.T("wizard","run_command"),items:[{xtype:"syno_textfield",name:"cmd",width:380},{xtype:"syno_button",text:String.format("test"),hidden:true,scope:this,handler:function(d){var e=d.previousSibling().getValue();var f=this.parser.parseDockerRun(e);this.owner.getMsgBox().alert(String.format("Data"),String.format("ParsedData:")+"<br />"+Ext.encode(f.parsedData)+"<br />"+String.format("UnSuppotedOpts:")+"<br />"+f.unSuppotedOpts)}}]}]);var c=Ext.apply({headline:this.helper.T("wizard","docker_run_parser"),xtype:"syno_formpanel",border:false,items:b,activate:function(){},getNext:function(){var d=this.form.findField("cmd").getValue();var e=this.owner.parser.parseDockerRun(d);if(e.unSuppotedOpts!==""){this.owner.getMsgBox().alert(String.format("UnSupportedOpts"),this.owner.helper.T("wizard","unsupported_opts")+"<br />"+e.unSuppotedOpts)}if(e.parsedData){e.parsedData.image=this.owner.data.image;this.owner.refreshData(e.parsedData)}return this.nextId}},a);return c},getFirstStep:function(a){var b=[];b=b.concat(this.getNameCfg());b=b.concat(this.getPortCfg());var c=Ext.apply({headline:String.format(this.helper.T("wizard","step_num"),1),xtype:"syno_formpanel",border:false,items:b,activate:function(){this.owner.portGrid.setHeight(180);var d=this.owner.refreshData();this.owner.setNameValue(this,d);this.owner.setPortValue(this,d)},getNext:function(){if(false===this.owner.validateName(this,true)||false===this.owner.validatePort(this,true)){return false}return this.nextId}},a);return c},getSecondStep:function(a){var b=[];Ext.apply(a,{mem_max_mb:this.helper.getRealMemory()});b=b.concat(this.getResourceCfg(a));b.push({xtype:"syno_displayfield"});b=b.concat(this.getShortcutCfg());var c=Ext.apply({headline:String.format(this.helper.T("wizard","step_num"),2),xtype:"syno_formpanel",border:false,items:b,activate:function(){var d=this.owner.refreshData();this.owner.enableShortcutGroup(this);this.owner.enableResourceGroup(this);this.owner.setResourceValue(this,d)},getNext:function(){if(false===this.owner.validateShortcut(this,true)){return false}return this.nextId}},a);return c},getSummaryStep:function(a){var b=[];b=b.concat([this.getSummaryGrid({enableHdMenu:false,tbar:["->",{xtype:"syno_button",text:this.helper.T("wizard","advance_setting"),scope:this,handler:this.getAdvanceWindow}]}),{xtype:"syno_checkbox",boxLabel:this.helper.T("wizard","run_immediately"),name:"is_run_instantly"}]);var c=Ext.apply({xtype:"syno_formpanel",headline:this.helper.T("wizard","summary"),description:this.helper.T("wizard","apply_text"),items:b,activate:function(){var d=this.owner.refreshData();this.owner.loadSummaryGrid(d)},getNext:function(){var d={profile:this.owner.refreshData(),is_run_instantly:this.form.findField("is_run_instantly").getValue()};this.owner.helper.mask(this.owner,this.owner.helper.T("wizard","applying"));this.sendWebAPI({api:"SYNO.Docker.Container",method:"create",version:1,params:d,scope:this,callback:function(h,e,f){this.owner.getEl().unmask();var g;if(h){if(e&&true===e.start_dependent_container&&e.dependent_container){g=this.owner.helper.T("container","started_depend_containers");g=String.format(g,e.dependent_container.join(", "));this.owner.getMsgBox().alert("",g,function(){this.owner.close()},this)}else{this.owner.close()}this.owner.shortcutHelper.refresh(d.profile);return}g=this.owner.getErrorMsg(e,f);if(1004===e.code){this.owner.owner.getMsgBox().alert("",g);this.owner.close();return}this.owner.getMsgBox().alert("",g,function(i){var j=this.wizard.getSteps("first_step");if(1303===this.resp.code){j.mon(j,"activate",function(){var l=this.wizard.getPortGrid();var o=this.resp.errors.errors;var m,n,k;for(m=0,n=l.store.getCount();m<n;m++){k=l.store.getAt(m);if(l.store.getAt(0).data.host_port==o){l.startEditing(m,0);break}}},this,{single:true})}if(1000===this.resp.code||1202===this.resp.code){j.mon(j,"activate",function(k){k.form.findField("name").focus(true)},this,{single:true})}if(1000===this.resp.code||1202===this.resp.code||1303===this.resp.code){this.wizard.goBack();this.wizard.goBack()}},{wizard:this.owner,resp:e},e)}});return false}},a);return c},getAdvanceWindow:function(){var a=new SYNO.SDS.Docker.Image.WizardAdvance({data:this.data,owner:this});a.open();a.mon(a,"close",function(){this.getStep("summary_step").activate()},this)},refreshData:function(c){var b=this.getStep("first_step");var a=this.getStep("second_step");Ext.apply(this.data,this.getNameValue(b));Ext.apply(this.data,this.getPortValue(b));Ext.apply(this.data,this.getResourceValue(a));Ext.apply(this.data,this.getShortcutValue(a));if(c){Ext.apply(this.data,c);this.setNameValue(b,this.data);this.setPortValue(b,this.data);this.enableShortcutGroup(a);this.enableResourceGroup(a);this.setResourceValue(a,this.data)}return this.data},getSteps:function(a){return this.items.itemAt(0).items.get(a)},onBeforeClose:function(){}});Ext.define("SYNO.SDS.Docker.Image.ListView",{extend:"SYNO.ux.ExpandableListView",helper:SYNO.SDS.Docker.Utils.Helper,dockerHubHelper:SYNO.SDS.Docker.Utils.DockerHub,constructor:function(a){var b=Ext.apply({trackResetOnLoad:false,itemSelector:".item-wrap",cls:"syno-sds-docker-image-list"},a);this.callParent([b]);this.addTplRenderer()},createTpl:function(){return new Ext.XTemplate('<tpl for=".">','<div class="item-wrap {cls}">','<div class="item-summary">',"<div>","{[this.genRepositroy(values)]}","{[this.genRegistry(values)]}","</div>","</div>",'<div class="item-detail" ext:qtip="{description}">{description}</div>','<div class="item-info">',"{[this.genVsize(values)]}","</div>",'<div class="x-clear"></div>',"</div>","</tpl>")},addTplRenderer:function(){var a=this.tpl;var b=this;a.genRepositroy=function(d){var f=d.fixd_repository?d.fixd_repository:d.repository;var c=d.registry;var g="";if(c&&c.length!==0){f=f.substr(c.length+1)}if(b.dockerHubHelper.isDockerHub(d.registry)){g=String.format('<a class="item-title-link" href="{0}"></a>',b.dockerHubHelper.formDockerHubUrl(f))}var e=[d.tag];if(d.tags){e=d.tags}return String.format('<div class="item-title" ext:qtip="{0}">{0}:{1}{2}</div>',f,e.join(" | "),g)};a.genRegistry=function(d){var c=d.registry;var f=null;if(b.owner.registryMap&&(f=b.owner.registryMap[c])){c=f}var e=b.helper.T("common","registry")+": "+c;return String.format('<div class="item-status" ext:qtip="{0}">{0}</div>',e)};a.genVsize=function(c){return(c.created)?"<div class='item-vsize'>"+c.virtual_size+"</div>":"<div class='item-vsize item-downloading' ext:qtip='"+b.helper.T("image","downloading_text")+"'>"+c.virtual_size+"</div>"}},onClick:function(c,b,a){this.callParent(arguments);if(Ext.isString(b.href)){window.open(b.href)}}});Ext.ns("SYNO.SDS.Docker.Image");Ext.define("SYNO.SDS.Docker.Image.Panel",{helper:SYNO.SDS.Docker.Utils.Helper,extend:"SYNO.ux.Panel",refreshInterval:3000,constructor:function(a){this.callParent([this.fillConfig(a)])},fillConfig:function(a){this.store=this.createStore();this.actionGroup=this.createActionGroup();this.tbar=this.createTBar();this.listView=this.createListView(a);this.isSkipPullListEvent=true;this.sortMapper={mapping:{},mappingDefault:10000,get:function(c){return undefined!==this.mapping[c]?this.mapping[c]:this.mappingDefault},set:function(c,d){this.mapping[c]=d;return this},clear:function(){delete this.mapping;this.mapping={};return this}};var b={title:this.helper.T("common","image"),tbar:this.tbar,layout:"fit",items:[this.listView],listeners:{scope:this,beforerender:this.onBeforeRender,activate:this.onActivate,deactivate:this.onDeactivate,pullList:this.onPullList}};Ext.apply(b,a);return b},createTBar:function(){return new SYNO.ux.Toolbar({defaultType:"syno_button",items:[this.actionGroup.getArray()]})},createActionGroup:function(b){var a=new SYNO.ux.Menu({items:[{text:this.helper.T("image","add_from_url"),itemId:"add_url",scope:this,handler:this.onAddFromUrl},{text:this.helper.T("image","add_from_file"),itemId:"add_file",scope:this,handler:this.onAddFromFile}]});var c=new SYNO.ux.Menu({items:[{text:this.helper.T("image","launch_wizard"),itemId:"launch_wizard",scope:this,handler:this.onLaunch},{text:this.helper.T("image","launch_docker_run"),itemId:"launch_docker_run",scope:this,handler:this.onDockerRunLaunch}]});return new SYNO.SDS.Utils.ActionGroup([new Ext.Action({text:this.helper.T("common","add"),itemId:"add",menu:a}),new SYNO.ux.SplitButton({text:this.helper.T("image","launch"),itemId:"launch",disabled:true,scope:this,handler:this.onLaunch,menu:c}),new Ext.Action({text:this.helper.T("common","delete"),itemId:"delete",disabled:true,scope:this,handler:this.onDelete})])},createStore:function(b){var a=["id","registry","repository","tag","created","size","virtual_size","description","sort_index","tags","fixd_repository"];return new Ext.data.JsonStore({autoDestroy:true,idProperty:"",root:"images",fields:a,sortInfo:{field:"repository",direction:"ASC"},hasMultiSort:true,multiSortInfo:{sorters:[{field:"sort_index",direction:"ASC"},{field:"repository"},{field:"tag"}],direction:"ASC"}})},createListView:function(a){return new SYNO.SDS.Docker.Image.ListView({panel:this,owner:this,store:this.store,listeners:{scope:this,selectionchange:this.onSelectionChange,dblclick:this.onRowDblClick}})},onBeforeRender:function(){this.pollingTask=this.addWebAPITask({scope:this,interval:this.refreshInterval,compound:{stopwhenerror:true,params:[{api:"SYNO.Docker.Image",method:"list",version:1,params:{limit:-1,offset:0}},{api:"SYNO.Docker.Registry",method:"get",version:1,params:{limit:-1,offset:0}}]},callback:function(d,b,c,a){this.helper.unmask(this.listView);if(!b.has_fail&&b.result&&b.result.length==2){this.loadData(b.result[0].data,b.result[1].data)}else{this.onException(b.result)}}})},requestDownloadStatus:function(a){var b=a.map(function(c){return{api:"SYNO.Docker.Image",method:"pull_status",version:1,params:{task_id:c}}});this.sendWebAPI({compound:{stopwhenerror:false,params:b},scope:this,callback:function(g,e,f,d){var c=false;this.downloadingImages=e.result.map(function(h){if(!h.success){this.helper.logError(h.error.code);return undefined}if(h.data.finished===1){return undefined}if(h.data.repository===undefined){c=true;return undefined}return{repository:h.data.repository,tag:h.data.tag,virtual_size:this.helper.shortFileSize(parseInt(h.data.downloaded*1024*1024,10))}},this).filter(function(h){return h!==undefined});this.startPollingTaskOnce(c)}})},startPollingTaskOnce:function(a){if(a){this.helper.maskLoading(this.listView);return}if(!this.isStartPollingTask){this.isStartPollingTask=true;this.pollingTask.start(true)}},initImagePullPolling:function(){this.downloadingImages=[];this.isSkipPullListEvent=false;this.isStartPollingTask=false;this.appWin.triggerImagePullListPolling()},destroyImagePullPolling:function(){this.downloadingImages=null;this.isSkipPullListEvent=true;this.isStartPollingTask=false;this.pollingTask.stop()},loadData:function(b,a){if(!b||!a){return}this.registryMap=a.registries.reduce(function(d,c){d[c.url.replace(/https?:\/\//,"")]=c.name;return d},{});if(this.downloadingImages){b.images=b.images.concat(this.downloadingImages.filter(function(d){var c=false;b.images.each(function(e){if((e.repository===d.repository)&&(e.tags.indexOf(d.tag)!==-1)){c=true;return false}});return !c}))}if(b.images.length!==0){b.images=b.images.map(function(d){if(d.created){d.created=this.helper.relativeTime(d.created*1000);d.virtual_size=this.helper.shortFileSize(d.virtual_size,true)}if(d.tags){d.tags=d.tags.sort();d.tag=d.tags.last()}var c=d.repository.match(/^([^\/]*\.[^\/]*)\/(.*)/);if(c){if("docker.io"===c[1]){d.fixd_repository="registry.hub.docker.com/"+c[2];d.registry="registry.hub.docker.com"}else{d.registry=c[1]}}else{d.fixd_repository="registry.hub.docker.com/"+d.repository;d.registry="registry.hub.docker.com"}d.sort_index=this.sortMapper.get(d.repository+":"+d.tag);return d},this).filter(function(c){return c.repository!="<none>"})}if(b.images.length===0){this.helper.mask(this.listView,this.helper.T("image","image_empty"))}this.store.loadData(b);this.store.each(function(c,d){this.sortMapper.set(c.get("repository")+":"+c.get("tag"),d)},this)},doDelete:function(){var a=this.listView.getSelectedRecords();if(a.length===0){return}this.helper.maskLoading(this.listView);this.destroyImagePullPolling();this.sendWebAPI({api:"SYNO.Docker.Image",method:"delete",version:1,scope:this,callback:function(e,b,c){if(!e){this.appWin.getMsgBox().alert("alert",this.helper.getError(b.code))}else{var d="";Object.keys(b.image_objects).each(function(f){var g=b.image_objects[f];Object.keys(g).each(function(h){var i=g[h];if(this.helper.errorMapping.WEBAPI_DOCKER_SUCCESS===i.error){return}d+=this.helper.getError(i.error,"<b>"+f+":"+h+"</b>","<b>"+i.containers.join(", ")+"</b>")+"<br />"},this)},this);if(d!==""){this.appWin.getMsgBox().alert("alert",d)}}this.initImagePullPolling()},params:{images:a.map(function(b){return b.data})}});this.listView.clearSelections()},onException:function(a){a.each(function(b){if(!b.success){this.helper.logError(b.error.code)}},this)},onPullList:function(b,a){if(this.isSkipPullListEvent){return}if(!b||!Ext.isArray(a.admin)){this.downloadingImages=[];this.startPollingTaskOnce();return}this.requestDownloadStatus(a.admin)},onActivate:function(){this.helper.maskLoadingOnce(this.listView,this);this.initImagePullPolling()},onDeactivate:function(){this.destroyImagePullPolling();this.sortMapper.clear()},onAddFromUrl:function(b){var a=new SYNO.SDS.Docker.Image.AddFromUrlDialog({owner:this.appWin});a.open()},onAddFromFile:function(c){var d=this.ownerCt;var a=d.ownerCt;var b=new SYNO.SDS.Docker.Utils.FileChooser({owner:a,webapi:{uploader:{api:"SYNO.Docker.Image",method:"upload",version:1},chooser:{api:"SYNO.Docker.Image",method:"import",version:1}},scope:this,callback:function(g,e,f){this.helper.unmask(d);if(!g){this.appWin.getMsgBox().alert(this.helper.T("error","error_error"),this.helper.getError(e.code))}},listeners:{scope:this,cancel:function(){b.isCanceled=true},close:function(){d.focus();if(!b.isCanceled){this.helper.maskLoading(d)}else{b.isCanceled=false}}}});b.show()},onDelete:function(){var c=this;var b=this.listView.getSelectedRecords();if(b.length===0){return}var a=String.format(this.helper.T("image","delete_confirm"),b.length);this.appWin.getMsgBox().confirm("confirm",a,function(d){if(d==="yes"){c.doDelete()}})},onLaunch:function(){this.doLaunch(false)},onDockerRunLaunch:function(){this.doLaunch(true)},doLaunch:function(b){var a=this.listView.getSelectedRecords()[0];if(!a){return}var d=a.data.repository;if(a.data.tag){d+=":"+a.data.tag}var c=new SYNO.SDS.Docker.Image.Wizard({owner:this.appWin,image:d,dockerRun:b});c.open()},onSelectionChange:function(c){var a=this.listView.getSelectedRecords();var b=a.filter(function(d){return !d.data.created});if(b.length!==0){this.actionGroup.disable("delete");this.actionGroup.disable("launch");return}switch(a.length){case 0:this.actionGroup.disable("delete");this.actionGroup.disable("launch");break;case 1:this.actionGroup.enable("delete");this.actionGroup.enable("launch");break;default:this.actionGroup.enable("delete");this.actionGroup.disable("launch")}},onRowDblClick:function(){var a=this.listView.getSelectedRecords()[0];if(!a||!a.data.created){return}this.onLaunch()}});Ext.define("SYNO.SDS.Docker.Registry.EditRegistryDialog",{extend:"SYNO.SDS.ModalWindow",helper:SYNO.SDS.Docker.Utils.Helper,fakePwd:12345678,constructor:function(a){this.callParent([this.fillConfig(a)])},fillConfig:function(a){this.formPanel=this.createFormPanel(a);var b={title:this.helper.T("registry","edit_registry"),layout:"fit",width:500,height:500,items:[this.formPanel],buttons:[{xtype:"syno_button",text:this.helper.T("registry","confirm"),scope:this,handler:this.onConfirm},{xtype:"syno_button",text:this.helper.T("common","cancel"),scope:this,handler:this.onCancel}],listeners:{scope:this,afterrender:{single:true,fn:this.onAfterRender}}};Ext.apply(b,a);return b},createFormPanel:function(a){var c=new SYNO.ux.FieldSet({title:this.helper.T("registry","site_info"),collapsible:false,items:[{xtype:"syno_textfield",name:"name",allowBlank:false,fieldLabel:this.helper.T("registry","registry_name"),validator:this.validateRegistryName.createDelegate(this)},{xtype:"syno_textfield",allowBlank:false,name:"url",vtype:"url",fieldLabel:this.helper.T("registry","registry_url")},{xtype:"syno_checkbox",name:"enable_trust_SSC",boxLabel:this.helper.T("registry","trust_ssc")}]});var b=new SYNO.ux.FieldSet({title:this.helper.T("registry","login_info"),collapsible:false,items:[{xtype:"syno_textfield",name:"username",fieldLabel:this.helper.T("registry","username_optional")},{xtype:"syno_textfield",textType:"password",name:"password",fieldLabel:this.helper.T("registry","password_optional"),listeners:{scope:this,focus:this.onPasswordFocus}}]});return new SYNO.ux.FormPanel({items:[c,b]})},validateRegistryName:function(a){if(this.record&&this.record.data.name==a){return true}if(this.store.findExact("name",a)!=-1){return this.helper.T("registry","conflict_name")}return true},sendCreateAPI:function(){var a=this.formPanel.getForm().getValues();a.enable_trust_SSC=(a.enable_trust_SSC=="true");this.sendWebAPI({appWindow:this.owner,api:"SYNO.Docker.Registry",method:"create",version:1,scope:this,callback:this.onRequestCallback,params:a})},sendSetAPI:function(){var a=this.formPanel.getForm().getValues();a.enable_trust_SSC=(a.enable_trust_SSC=="true");a.oldname=this.record.data.name;a.password=((a.password==this.fakePwd)&&(!this.isPwdEdited))?"":a.password;this.sendWebAPI({api:"SYNO.Docker.Registry",method:"set",version:1,scope:this,callback:this.onRequestCallback,params:a})},onAfterRender:function(){if(this.record){this.record.data.password=this.fakePwd;this.formPanel.getForm().setValues(this.record.data)}},onPasswordFocus:function(a){a.setValue(null);this.isPwdEdited=true},onConfirm:function(a){if(!this.formPanel.getForm().isValid()){return false}if(this.record){this.sendSetAPI()}else{this.sendCreateAPI()}this.helper.maskLoading(this);return true},onCancel:function(){this.close()},onRequestCallback:function(c,b,a){if(!c){this.owner.getMsgBox().alert(this.helper.T("error","error_error"),this.helper.getError(b.code))}this.close();this.store.load()}});Ext.define("SYNO.SDS.Docker.Registry.SettingDialog",{extend:"SYNO.SDS.ModalWindow",helper:SYNO.SDS.Docker.Utils.Helper,dockerHubHelper:SYNO.SDS.Docker.Utils.DockerHub,constructor:function(a){this.callParent([this.fillConfig(a)])},fillConfig:function(a){this.actionGroup=this.createActionGroup();this.tbar=this.createTBar();this.store=this.createStore(a);this.gridPanel=this.createGridPanel(a);var b={tbar:this.tbar,title:this.helper.T("registry","registry_setting"),layout:"fit",width:500,height:500,buttons:[{xtype:"syno_button",text:this.helper.T("common","close"),scope:this,handler:this.close}],items:[this.gridPanel],listeners:{scope:this,show:{single:true,fn:this.onShow}}};Ext.apply(b,a);return b},createActionGroup:function(){return new SYNO.SDS.Utils.ActionGroup([new Ext.Action({text:this.helper.T("common","add"),itemId:"add",scope:this,handler:this.onAddClick}),new Ext.Action({text:this.helper.T("common","alt_edit"),itemId:"edit",scope:this,handler:this.onEditClick}),new Ext.Action({text:this.helper.T("common","delete"),itemId:"delete",scope:this,handler:this.onDeleteClick}),new Ext.Action({text:this.helper.T("registry","use"),itemId:"use",scope:this,handler:this.onUseClick})])},createTBar:function(){return new SYNO.ux.Toolbar({defaultType:"syno_button",items:[this.actionGroup.getArray()]})},createStore:function(a){return new SYNO.API.JsonStore({autoDestroy:true,appWindow:a.owner,fields:[{name:"name",mapping:"name"},{name:"url",mapping:"url"},{name:"enable_trust_SSC",mapping:"enable_trust_SSC"},{name:"username",mapping:"username"},{name:"using",defaultValue:""}],api:"SYNO.Docker.Registry",method:"get",version:1,scope:this,root:"registries",baseParams:{offset:0,limit:-1},listeners:{scope:this,load:this.onLoad,beforeload:this.onBeforeLoad,exception:this.onException}})},createGridPanel:function(a){var b=new Ext.grid.ColumnModel({defaults:{sortable:true},columns:[{header:this.helper.T("common","repository"),dataIndex:"name"},{header:this.helper.T("registry","url"),dataIndex:"url"},{header:this.helper.T("registry","using"),dataIndex:"using"}]});return new SYNO.ux.GridPanel({cm:b,padding:"10px",height:400,ds:this.store,enableHdMenu:false,selModel:new Ext.grid.RowSelectionModel({singleSelect:true,listeners:{scope:this,selectionchange:this.onSelectionChange}})})},openEditDialog:function(a){var b=new SYNO.SDS.Docker.Registry.EditRegistryDialog({owner:this.owner,store:this.store,record:a});b.open()},sendDeleteAPI:function(a){this.sendWebAPI({api:"SYNO.Docker.Registry",method:"delete",version:1,scope:this,callback:this.onRequestCallback,params:{name:a.data.name}})},sendUsingAPI:function(a){this.sendWebAPI({api:"SYNO.Docker.Registry",method:"using",version:1,scope:this,callback:this.onRequestCallback,params:{name:a.data.name}})},onShow:function(a){this.store.load()},onAddClick:function(a,b){this.openEditDialog()},onEditClick:function(a,b){this.openEditDialog(this.gridPanel.getSelectionModel().getSelected())},onDeleteClick:function(b){var a=this.gridPanel.getSelectionModel().getSelected();if(!a){return}this.sendDeleteAPI(a);this.helper.maskLoading(this)},onUseClick:function(b){var a=this.gridPanel.getSelectionModel().getSelected();if(!a){return}if(a.data.using!==""){return}this.sendUsingAPI(a);this.helper.mask(this);this.searchPanel.resetSearch();this.searchPanel.setUsingRegistry(a.data.name)},onLoad:function(c){var a=this.store.find("name",this.store.reader.jsonData.using);var b=this.store.getAt(a);b.set("using","*");b.commit();this.actionGroup.disable("edit");this.actionGroup.disable("delete");this.helper.unmask(this)},onBeforeLoad:function(a){this.helper.maskLoading(this)},onException:function(d,a,e,b,c){this.helper.unmask(this);this.owner.getMsgBox().alert(this.helper.T("error","error_error"),this.helper.getError(c.code));this.close()},onSelectionChange:function(a){var b=a.getSelected();if(!b){this.actionGroup.disable("edit");this.actionGroup.disable("delete");return}if(this.dockerHubHelper.isDockerHubShortName(a.getSelected().data.name)){this.actionGroup.disable("edit");this.actionGroup.disable("delete")}else{this.actionGroup.enable("edit");this.actionGroup.enable("delete")}},onRequestCallback:function(c,b,a){if(!c){this.owner.getMsgBox().alert(this.helper.T("error","error_error"),this.helper.getError(b.code))}this.helper.unmask(this);this.store.load()}});Ext.define("SYNO.SDS.Docker.Registry.ListView",{extend:"SYNO.ux.ExpandableListView",helper:SYNO.SDS.Docker.Utils.Helper,dockerHubHelper:SYNO.SDS.Docker.Utils.DockerHub,constructor:function(a){var b=Ext.apply({cls:"syno-sds-docker-registry-list"},a);this.callParent([b]);this.addTplRenderer()},createTpl:function(){return new Ext.XTemplate('<tpl for=".">','<div class="item-wrap {cls}">','<div class="item-summary">',"<div>","{[this.genRepository(values)]}","</div>","</div>",'<div class="item-detail" ext:qtip="{description}">{description}</div>','<div class="item-info-wrap">',"{[this.genOfficial(values)]}",'<div class="item-count" ext:qtip="'+this.helper.T("registry","star_count")+'">{star_count}</div>',"</div>",'<div class="x-clear"></div>',"</div>","</tpl>")},addTplRenderer:function(){var a=this.tpl;var b=this;a.genRepository=function(c){var d="";if(b.dockerHubHelper.isDockerHub(c.registry)){d=String.format('<a class="item-title-link" href="{0}"></a>',b.dockerHubHelper.formDockerHubUrl(c.repo))}return String.format('<div class="item-title" ext:qtip="{0}">{0}{1}</div>',c.repo,d)};a.genOfficial=function(c){return(c.is_official)?'<div class="item-official" ext:qtip="'+b.helper.T("registry","official_image")+'"></div>':""}},onClick:function(c,b,a){this.callParent(arguments);if(Ext.isString(b.href)){window.open(b.href)}}});Ext.define("SYNO.SDS.Docker.Registry.Panel",{extend:"SYNO.ux.Panel",helper:SYNO.SDS.Docker.Utils.Helper,dockerHubHelper:SYNO.SDS.Docker.Utils.DockerHub,pageSize:50,bbarMargin:10,constructor:function(a){this.callParent([this.fillConfig(a)])},fillConfig:function(a){this.imageStore=this.createImageStore(a);this.listView=this.createListView(a);this.blankPanel=this.createBlankPanel(a);this.formPanel=this.createFormPanel();this.bbar=this.createBBar();var b={title:this.helper.T("common","registry"),bbar:this.bbar,items:[this.formPanel,this.blankPanel,this.listView],listeners:{scope:this,resize:this.onPanelResize,afterrender:this.onAfterRender}};Ext.apply(b,a);return b},createImageStore:function(a){return new SYNO.API.JsonStore({appWindow:a.appWin,autoDestroy:true,fields:[{name:"repo",mapping:"name"},{name:"description",mapping:"description"},{name:"tag",defaultValue:"latest"},{name:"is_automated",mapping:"is_automated"},{name:"is_official",mapping:"is_official"},{name:"star_count",mapping:"star_count"},{name:"registry",mapping:"registry"}],api:"SYNO.Docker.Registry",method:"search",version:1,root:"data",scope:this,listeners:{scope:this,beforeload:this.onStoreBeforeLoad,load:this.onStoreLoad,exception:this.onStoreException}})},createFormPanel:function(){this.downloadBtn=new SYNO.ux.Button({text:this.helper.T("backup","download"),scope:this,disabled:true,handler:this.onChoose});var a=new SYNO.ux.Button({text:this.helper.T("common","common_settings"),scope:this,handler:this.onSetting});this.searchFilter=new SYNO.ux.TextFilter({width:300,itemId:"search",name:"q",emptyText:"",listeners:{scope:this,keydown:this.onSearchKeyDown,keyup:this.onSearchKeyUp}});this.searchBtn=new SYNO.ux.Button({text:this.helper.T("registry","search"),scope:this,handler:this.onSearchClick});return new SYNO.SDS.Utils.FormPanel({height:37,bodyStyle:"padding: 0; border-bottom: 1px solid #D7E1EB",items:[{xtype:"syno_compositefield",hideLabel:true,items:[this.downloadBtn,a,{xtype:"syno_displayfield",width:18},this.searchFilter,this.searchBtn]}]})},createBlankPanel:function(a){return new SYNO.ux.Panel({cls:"syno-sds-docker-registry-blank",html:["<p>",this.helper.T("registry","registry_empty"),"</p>"].join("")})},createListView:function(a){return new SYNO.SDS.Docker.Registry.ListView({panel:this,owner:this,store:this.imageStore,multiSelect:false,singleSelect:true,itemSelector:".item-wrap",listeners:{scope:this,contextmenu:this.onRowContextMenu,selectionchange:this.onRowSelectionChange,dblclick:this.onRowDblClick}})},createBBar:function(){return new SYNO.ux.PagingToolbar({store:this.imageStore,pageSize:this.pageSize,displayInfo:true,style:"margin-bottom: "+this.bbarMargin+"px;"})},setSearchBtn:function(){if(this.searchRequest){this.searchBtn.setText(this.helper.T("common","cancel"));this.searchBtn.handler=this.onSearchAbort}else{this.searchBtn.setText(this.helper.T("registry","search"));this.searchBtn.handler=this.onSearchClick}},searchFinal:function(){this.searchRequest=null;this.setSearchBtn();this.searchFilter.enable();this.helper.unmask(this.listView)},resetSearch:function(){this.bbar.hide();this.imageStore.loadData({data:[]});this.blankPanel.show()},fetchUsingRegistry:function(){this.sendWebAPI({api:"SYNO.Docker.Registry",method:"get",version:1,scope:this,callback:function(c,b,a){if(c){this.setUsingRegistry(b.using)}else{this.setUsingRegistry("")}},params:{limit:-1,offset:0}})},setUsingRegistry:function(a){if(this.dockerHubHelper.isDockerHubShortName(a)){this.isSearchDockerHub=true;this.searchFilter.emptyText=this.helper.T("registry","search_hub_empty")}else{this.isSearchDockerHub=false;this.searchFilter.emptyText=this.helper.T("registry","search_empty")}this.onSearchKeyUp()},onSearchClick:function(b){var a=this.searchFilter.getValue();if(this.isSearchDockerHub&&(a==="")){this.appWin.getMsgBox().alert(this.helper.T("error","error_error"),this.helper.T("registry","search_empty_error"));return}this.resetSearch();this.blankPanel.hide();this.helper.maskLoading(this.listView);var c={offset:0,limit:this.pageSize,page_size:this.pageSize};this.searchRequest=this.sendWebAPI({api:"SYNO.Docker.Registry",method:"search",version:1,scope:this,callback:this.onSearchCallback,params:Ext.apply(c,this.formPanel.getForm().getValues())});this.setSearchBtn();this.searchFilter.disable()},onSearchKeyDown:function(c,b){var a=this.searchFilter.getValue();if((b.getCharCode()==b.ENTER)&&!this.searchRequest&&(!this.isSearchDockerHub||(a!==""))){this.onSearchClick()}},onSearchKeyUp:function(){var a=this.searchFilter.getValue();if(a===""){this.searchFilter.applyEmptyText()}},onSearchCallback:function(c,b,a){this.searchFinal();if(!c){this.appWin.getMsgBox().alert(this.helper.T("error","error_error"),this.helper.getError(b.code));return}this.imageStore.loadData(b);this.oldQuery={q:a.q};this.bbar.show()},onSearchAbort:function(){Ext.Ajax.abort(this.searchRequest);this.searchFinal()},onDetail:function(c){var a=this.listView.getSelectedRecords()[0];if(!a){return}var b=this.dockerHubHelper.formDockerHubUrl(a.data.repo);if(b){window.open(b)}},onChoose:function(c){var b=this.listView.getSelectedRecords()[0];if(!b){return}var a=new SYNO.SDS.Docker.Registry.TagDialog({owner:this.appWin,query:{repo:b.data.repo},scope:this,chooseHandler:this.onTagChoose});this.waitPullImage=false;this.mon(a,"close",this.onTagDialogClose,this);this.helper.maskLoading(this);a.open()},onTagChoose:function(b,a){var c={tag:a,repository:b.repo};this.sendWebAPI({api:"SYNO.Docker.Image",method:"pull_start",version:1,scope:this,callback:this.onTagChooseCallback,params:c});this.waitPullImage=true},onTagDialogClose:function(){if(!this.waitPullImage){this.helper.unmask(this)}},onTagChooseCallback:function(c,b,a){this.helper.unmask(this);if(!c){this.appWin.getMsgBox().alert(this.helper.T("error","error_error"),this.helper.getError(b.code));return}this.appWin.triggerImagePullListPolling()},onRowDblClick:function(a){this.onChoose()},onAfterRender:function(){this.bbar.hide();this.fetchUsingRegistry()},onPanelResize:function(e,d,a){var c=this.formPanel.getSize();c.width=d;this.formPanel.setSize(c);var b=this.listView.getSize();var f={width:d,height:a-c.height-27-this.bbarMargin};this.listView.setSize(f);this.listView.fireEvent("resize",this.listView,f.width,f.height,b.width,b.height);this.blankPanel.setSize(f);this.blankPanel.fireEvent("resize",this.blankPanel,f.width,f.height,b.width,b.height)},onSetting:function(b){var a=new SYNO.SDS.Docker.Registry.SettingDialog({owner:this.appWin,searchPanel:this});a.open()},onStoreBeforeLoad:function(a,b){if(this.oldQuery){b.params.q=this.oldQuery.q}this.helper.maskLoading(this.listView)},onStoreLoad:function(){this.helper.unmask(this.listView)},onStoreException:function(d,a,e,b,c){this.appWin.getMsgBox().alert(this.helper.T("error","error_error"),this.helper.getError(c.code));this.helper.unmask(this.listView)},onRowContextMenu:function(c,g,d,e){this.listView.select(g);var a=this.listView.getSelectedRecords()[0];var b=[{text:this.helper.T("registry","image_download"),itemId:"choose",scope:this,handler:this.onChoose}];if(this.dockerHubHelper.isDockerHub(a.data.registry)){b.push({text:this.helper.T("registry","open_docker_hub_page"),itemId:"detail",scope:this,handler:this.onDetail})}var f=new SYNO.ux.Menu({autoDestroy:true,items:b});f.showAt(e.getXY())},onRowSelectionChange:function(b,a){if(a.length===0){this.downloadBtn.disable()}else{this.downloadBtn.enable()}}});Ext.define("SYNO.SDS.Docker.Log.Panel",{extend:"SYNO.ux.GridPanel",helper:SYNO.SDS.Docker.Utils.Helper,pageSize:1000,constructor:function(a){this.callParent([this.fillConfig(a)])},fillConfig:function(a){this.store=this.createStore(a);this.toolBar=this.createTBar();this.bottomBar=this.createBBar();var b={store:this.store,enableHdMenu:false,colModel:this.createColumnModel(),tbar:this.toolBar,bbar:this.bottomBar,autoExpandColumn:true,viewConfig:{trackResetOnLoad:false},listeners:{scope:this,activate:this.onActivate}};Ext.apply(b,a);return b},createStore:function(a){return new SYNO.API.JsonStore({autoDestroy:true,appWindow:a.appWin,api:"SYNO.Docker.Log",method:"list",version:1,root:"logs",remoteSort:true,paramNames:{start:"offset",sort:"sort_by",dir:"sort_dir"},fields:[{name:"event"},{name:"level"},{name:"log_type"},{name:"time"},{name:"user"}],sortInfo:{field:"time",direction:"DESC"},listeners:{scope:this,exception:this.onStoreLoadException,beforeload:this.onBeforeStoreLoad,load:this.onStoreLoad}})},createTBar:function(){var a=new SYNO.ux.Menu({items:[{text:this.helper.T("log","html_type"),itemId:"export_html",scope:this,handler:this.btnExportHTML},{text:this.helper.T("log","csv_type"),itemId:"export_csv",scope:this,handler:this.btnExportCSV}]});return new SYNO.ux.Toolbar({items:[new Ext.Action({itemId:"clear",text:_TT("SYNO.SDS.LogCenter.Instance","logview","btn_clear"),scope:this,handler:this.btnClear}),new SYNO.ux.SplitButton({itemId:"export",text:_TT("SYNO.SDS.LogCenter.Instance","logview","btn_export"),scope:this,handler:this.btnExportHTML,menu:a}),"->",{xtype:"syno_combobox",itemId:"level",displayField:"display",valueField:"value",store:new Ext.data.ArrayStore({fields:["value","display"],data:[["",this.helper.T("log","log_all")],["information",this.helper.T("log","info_level")],["warning",this.helper.T("log","warn_level")],["error",this.helper.T("log","error_level")]]}),value:"",listeners:{scope:this,select:this.onChangeLevel}},{xtype:"syno_textfilter",itemId:"filter",enumAction:"load",queryAction:"load",store:this.store,pageSize:this.pageSize,queryParam:"filter_content",queryDelay:300}]})},createBBar:function(){return new SYNO.ux.PagingToolbar({store:this.store,pageSize:this.pageSize,displayInfo:true})},createColumnModel:function(){return new Ext.grid.ColumnModel({columns:[{header:this.helper.T("log","log_time"),dataIndex:"time",sortable:true,width:40},{header:this.helper.T("log","log_type"),dataIndex:"level",sortable:true,width:20},{header:this.helper.T("log","log_action"),dataIndex:"event",sortable:false,width:120,renderer:function(e,b,a,f,d,c){return String.format("<div class='{0}' ext:qtip='{1}'>{1}</div>",SYNO.SDS.Utils.SelectableCLS,e)}},{header:this.helper.T("log","log_account"),dataIndex:"user",sortable:true,width:20}]})},btnClear:function(){var a=this;this.appWin.getMsgBox().confirm("confirm",this.helper.T("log","log_cfrm_clear"),function(b){if(b==="yes"){a.sendWebAPI({api:"SYNO.Docker.Log",version:1,scope:a,method:"clear",callback:function(d,c){if(d){this.refreshStore()}else{this.appWin.getMsgBox().alert("",this.helper.getError(c.code))}}})}})},btnExportHTML:function(){this.btnExport("html")},btnExportCSV:function(){this.btnExport("csv")},btnExport:function(a){this.downloadWebAPI({webapi:{version:1,api:"SYNO.Docker.Log",method:"export",params:{format:a,loglevel:this.toolBar.get("level").value,filter_content:this.toolBar.get("filter").value,datefrom:0,dateto:0}},scope:this,callback:function(b,c,e,d){this.appWin.getMsgBox().alert("alert",this.helper.getError(d.code))}})},refreshStore:function(){this.bottomBar.doRefresh();this.helper.maskLoadingOnce(this,this)},onActivate:function(){this.refreshStore()},onBeforeStoreLoad:function(a,b){Ext.apply(b.params,{loglevel:this.toolBar.get("level").value,filter_content:this.toolBar.get("filter").value,datefrom:0,dateto:0})},onStoreLoad:function(){this.helper.unmask(this)},onStoreLoadException:function(b,e,c,d,a){this.appWin.getMsgBox().alert("alert",this.helper.getError(a.code))},onChangeLevel:function(){this.refreshStore()}});Ext.define("SYNO.SDS.Docker.Utils.WelcomeDialog",{extend:"SYNO.SDS.ModalWindow",helper:SYNO.SDS.Docker.Utils.Helper,constructor:function(a){this.callParent([this.fillConfig(a)]);this.mon(this,"beforeshow",this.onBeforeShow,this)},fillConfig:function(a){SYNO.Assert(a.userSettingKey!==undefined);this.userSettingKey="WelcomDialog-"+a.userSettingKey;var b={title:"",layout:"fit",width:550,height:350,useStatusBar:false,footerStyle:"padding: 0 0 20px 0",fbar:{buttonAlign:"center",items:[{xtype:"syno_button",text:this.helper.T("common","ok"),scope:this,handler:this._onClose}]},items:[{xtype:"syno_panel",style:"padding: 0 20px",layout:"border",items:[{xtype:"syno_panel",region:"center",layout:"fit",items:a.items},{xtype:"syno_panel",region:"south",layout:"fit",height:40,items:[{xtype:"syno_checkbox",boxLabel:this.helper.T("common","dont_alert_again"),listeners:{scope:this,check:this.onChecked}}]}]}]};delete a.userSettingKey;delete a.items;Ext.apply(b,a);return b},onBeforeShow:function(){if(this.appWin.appInstance.getUserSettings(this.userSettingKey)){this.close.defer(100,this);return false}},onChecked:function(a,b){this.appWin.appInstance.setUserSettings(this.userSettingKey,b)},_onClose:function(){this.close()}});Ext.define("SYNO.SDS.Docker.Application",{extend:"SYNO.SDS.AppInstance",appWindowName:"SYNO.SDS.Docker.MainWindow"});Ext.define("SYNO.SDS.Docker.MainWindow",{extend:"SYNO.SDS.PageListAppWindow",defaultWinSize:{width:994,height:570},helper:SYNO.SDS.Docker.Utils.Helper,refreshInterval:5000,imagePanelRefreshInterval:3000,constructor:function(a){this.callParent([this.fillConfig(a)])},fillConfig:function(a){var b={width:this.defaultWinSize.width,height:this.defaultWinSize.height,minWidth:this.defaultWinSize.width,minHeight:this.defaultWinSize.height,cls:"syno-sds-docker",activePage:"SYNO.SDS.Docker.Overview.Panel",listItems:[{text:this.helper.T("common","overview"),iconCls:"icon-overview",fn:"SYNO.SDS.Docker.Overview.Panel"},{text:this.helper.T("common","registry"),iconCls:"icon-registry",fn:"SYNO.SDS.Docker.Registry.Panel"},{text:this.helper.T("common","image"),iconCls:"icon-image",fn:"SYNO.SDS.Docker.Image.Panel"},{text:this.helper.T("common","container"),iconCls:"icon-container",fn:"SYNO.SDS.Docker.Container.Panel"},{text:this.helper.T("container_detail","log"),iconCls:"icon-log",fn:"SYNO.SDS.Docker.Log.Panel"}],listeners:{scope:this,afterrender:{single:true,fn:this.onAfterRender}}};Ext.apply(b,a);return b},createPage:function(b){var c=Ext.getClassByName(b);var a=new c({appWin:this});a.itemId=b;return a},setNotification:function(c,a){var b=this.getPageList().getNodeById(c);if(!b||!a){return}var d=Ext.DomQuery.select(".syno-sds-docker-notification",b.getUI().elNode);if(d.length>0){if(parseInt(d[0].innerText,10)===a&&!d[0].hasClassName("notification-hide")){return}d[0].innerText=a;d[0].className="syno-sds-docker-notification";setTimeout(function(){d[0].className="syno-sds-docker-notification notification-show"},0)}else{Ext.DomHelper.append(b.getUI().elNode,"<div class='syno-sds-docker-notification notification-show'>"+a+"</div>")}},clearNotification:function(b){var a=this.getPageList().getNodeById(b);if(!a){return}var c=Ext.DomQuery.select(".syno-sds-docker-notification",a.getUI().elNode);if(c.length>0){c[0].className="syno-sds-docker-notification notification-hide"}},imagePullListPolling:function(){this.pollList({task_id_prefix:"SYNO_DOCKER_IMAGE_PULL",extra_group_tasks:["admin"],scope:this,callback:function(d,b,c,a){if(!d||!Ext.isArray(b.admin)){this.clearNotification("SYNO.SDS.Docker.Image.Panel")}else{this.setNotification("SYNO.SDS.Docker.Image.Panel",b.admin.length)}if(this.activePage&&(this.activePage.itemId==="SYNO.SDS.Docker.Image.Panel")){this.activePage.fireEvent("pullList",d,b)}}})},triggerImagePullListPolling:function(){this.imagePullListPollingTask.restart(true)},onSelectionChange:function(a,b){if(b.id==="SYNO.SDS.Docker.Image.Panel"){this.imagePullListPollingTask.intervalData=this.imagePanelRefreshInterval}else{this.imagePullListPollingTask.intervalData=this.refreshInterval}this.triggerImagePullListPolling();this.callParent(arguments)},onActivate:function(){this.callParent(arguments);this.imagePullListPollingTask.start(true);if(this.activePage&&Ext.isFunction(this.activePage.fireEvent)){this.activePage.fireEvent("activate",this.activePage)}},onDeactivate:function(){this.callParent(arguments);this.imagePullListPollingTask.stop();if(this.activePage&&Ext.isFunction(this.activePage.fireEvent)){this.activePage.fireEvent("deactivate",this.activePage)}},onAfterRender:function(){var a=new SYNO.SDS.Docker.Utils.Shortcut({owner:this});a.recover();this.imagePullListPollingTask=this.addTask({scope:this,interval:this.refreshInterval,run:this.imagePullListPolling});var c=Ext.id();var b=new SYNO.SDS.Docker.Utils.WelcomeDialog({cls:"docker-welcome-help",owner:this,appWin:this,height:340,closable:true,userSettingKey:"welcome",title:this.helper.T("common","welcome_to_docker"),items:[{xtype:"box",html:String.format(this.helper.T("common","welcome_desc"),c),listeners:{scope:this,afterrender:function(){Ext.get(c).on("click",this.onClickHelp,this)}}}],fbar:{buttonAlign:"center",items:[{cls:"syno-ux-button-blue",xtype:"syno_button",text:this.helper.T("common","welcome_open_help"),scope:this,handler:function(){b.close();this.onClickHelp()}}]},listeners:{scope:this,close:function(){this.pageList.selectModule(this.activePage);this.launchPage(this.activePage)}}});b.open()}});Ext.define("SYNO.SDS.Docker.Utils.Socket",{extend:Object,constructor:function(b,a){if(a){this._socket=new WebSocket(b,a)}else{this._socket=new WebSocket(b)}this._handlers={};this._open=this._open.bind(this);this._message=this._message.bind(this);this._close=this._close.bind(this);this._socket.addEventListener("open",this._open);this._socket.addEventListener("message",this._message);this._socket.addEventListener("close",this._close);Object.defineProperties(this,{connecting:{get:function(){return this._socket.readyState===0}},connected:{get:function(){return this._socket.readyState===1}},disconnecting:{get:function(){return this._socket.readyState===2}},disconnected:{get:function(){return this._socket.readyState===3}}})},_open:function(a){this._apply("connect",[a])},_message:function(b){var a=JSON.parse(b.data);this._apply(a[0],a.slice(1))},_close:function(a){this._apply("disconnect",[a]);this._handlers=null;this._open=null;this._message=null;this._close=null},_apply:function(b,a){if(!this._handlers[b]){return}for(var c=0;c<this._handlers[b].length;++c){this._handlers[b][c].apply(this,a)}},on:function(a,b){if(!this._handlers[a]){this._handlers[a]=[]}this._handlers[a].push(b)},emit:function(){var a=Array.prototype.map.call(arguments,function(b){return b});if(this.connected){this._socket.send(Ext.encode(a))}},destroy:function(){this._socket.close()}});SYNO.SDS.Docker.Utils.Socket.browserSupported=function(){return typeof(window.WebSocket)!=="undefined"};Ext.define("SYNO.SDS.Docker.ContainerDetail.TermSocket",{extend:"SYNO.SDS.Docker.Utils.Socket",constructor:function(a){var b=(window.location.protocol==="http:")?"ws://":"wss://";this.callParent([[b,window.location.hostname,":",window.location.port,"/docker/ws"].join("")]);this.role=a?"monitor":"terminal"},enter:function(a){this.container=a;this.emit("enter",a,this.role)},attach:function(a,b){b=b||false;this.tty_id=a;this.emit("attach",this.tty_id,b)}});Ext.define("SYNO.SDS.Docker.ContainerDetail.Term",{extend:"SYNO.ux.Panel",helper:SYNO.SDS.Docker.Utils.Helper,constructor:function(a){this.callParent([this.fillConfig(a)])},fillConfig:function(a){this.socket=this.createSocket(a);this.term=this.createTerm();var b={cls:"syno-sds-docker-term",padding:"0px 0px 16px 16px",layout:"fit",items:[{xtype:"container",cls:"syno-sds-docker-term-outline",layout:"fit",items:[{type:"box",cls:"syno-sds-docker-term-wrapper",listeners:{scope:this,afterrender:this.onAfterRender}}]}],listeners:{scope:this,activate:this.onActivate,beforedestroy:this.onBeforeDestroy}};Ext.apply(b,a);return b},createSocket:function(b){var a=new SYNO.SDS.Docker.ContainerDetail.TermSocket();a.on("connect",function(c){a.enter(b.container)}.bind(this));a.on("enter",function(c){if(c){a.attach(b.tty_id)}else{b.appWin.getMsgBox().alert("error",this.helper.T("error","term_enter_fail"))}}.bind(this));a.on("attach",function(c){switch(c){case SYNO.SDS.Docker.Utils.Helper.errorMapping.WS_ATTACH_SUCC:this.attached=true;a.emit("resize",this.term.rows,this.term.cols);break;case SYNO.SDS.Docker.Utils.Helper.errorMapping.WS_ATTACH_CLIENT:b.appWin.getMsgBox().confirm("attach",this.helper.getError(c),function(d){if(d==="yes"){a.attach(b.tty_id,true)}else{this.closeByDetached=true;this.socketClosing=true;this.socket.destroy()}},this);break;case SYNO.SDS.Docker.Utils.Helper.errorMapping.WS_ATTACH_FAIL_TTY:b.appWin.getMsgBox().alert("error",this.helper.getError(c));this.socketClosing=true;this.socket.destroy();break}}.bind(this));a.on("data",function(c){this.term.write(c)}.bind(this));a.on("close",function(c){if(c===SYNO.SDS.Docker.Utils.Helper.errorMapping.WS_ERR_CLIENT_ATTACH){this.closeByDetached=true}if(c!==SYNO.SDS.Docker.Utils.Helper.errorMapping.WS_ERR_EXEC_END){b.appWin.getMsgBox().alert("error",this.helper.getError(c,Ext.util.Format.htmlEncode(this.name)))}this.socketClosing=true}.bind(this));a.on("disconnect",function(c){if(!this.isDestroyed&&!this.destroying&&!this.socketClosing){b.appWin.getMsgBox().alert("error",this.helper.T("error","ws_close"));this.helper.logError(c.code)}if(!this.isDestroyed&&!this.destroying){this.helper.mask(this)}this.socketClosing=false;this.attached=false;this.fireEvent("termclose",this)}.bind(this));return a},createTerm:function(a){var b=new Terminal({cols:80,rows:24,screenKeys:true,useFocus:true,cursorBlink:true});b.on("data",function(c){this.socket.emit("data",c)}.bind(this));return b},onAfterRender:function(){var a=this.items.items[0];var b=a.items.items[0];this.term.open(b.getEl().query(".x-panel-body")[0]);this.termOpened=true},onBeforeDestroy:function(){this.socket.destroy();this.term.destroy()},onActivate:function(){if(this.termOpened){this.term.element.focus()}},onResize:function(c,j){this.callParent(arguments);var d=5;var m=8;var i=16;var e=6+1;var f=1;var h=16;var a=16;var b=c-(d+e+f)*2-h;var k=j-(d+e+f)*2-a;var g=Math.floor(b/m);var l=Math.floor(k/i);this.term.resize(g,l);if(this.attached){this.socket.emit("resize",l,g)}}});Ext.define("SYNO.SDS.Docker.Utils.SearchField",{extend:"SYNO.ux.SearchField",filter:function(){var b=this.getValue();var a=this.baseParams||{};if(!this.store){return}if(this.localFilter===true){if(b){this.store.filter(this.localFilterField,b,true)}else{this.store.clearFilter(false)}return}Ext.apply(a,{start:0,limit:this.pageSize});if(b){a.action=this.queryAction;a[this.queryParam]=b}else{a.action=this.enumAction}this.store.load({params:a})}});Ext.define("SYNO.SDS.Docker.ContainerDetail.PanelLogs",{extend:"SYNO.ux.Panel",pageSize:1000,helper:SYNO.SDS.Docker.Utils.Helper,constructor:function(a){this.callParent([this.fillConfig(a)])},fillConfig:function(a){this.nodeMap={};this.focusDocId=null;this.stores=this.createStores(a);this.toolBar=this.createTbar();this.treePanel=this.createTreePanel();this.gridPanels=this.createGridPanels(this.stores);this.gridPanelWrapper=this.createGridPanelWrapper(this.gridPanels);var b={title:this.helper.T("container_detail","log"),cls:"docker-container-log-panel",tbar:this.toolBar,layout:"border",border:false,items:[this.treePanel,this.gridPanelWrapper],listeners:{scope:this,containerchange:this.onContainerChange,afterrender:this.onAfterRender,activate:this.onActivate}};Ext.apply(b,a);return b},createStores:function(b){var c={appWindow:b.appWin,autoDestroy:true,root:"logs",idProperty:"docid",fields:[{name:"docid",mapping:"docid",sortType:function(d){return parseInt(d,10)}},{name:"time",mapping:"created"},{name:"logs",mapping:"text"},{name:"stream",mapping:"stream"}],sortInfo:{field:"docid",direction:"ASC"}};var a={log:new SYNO.API.JsonStore(Ext.apply({api:"SYNO.Docker.Container.Log",method:"get",version:1,listeners:{scope:this,exception:this.onException,beforeload:this.onBeforeLogStoreLoad,load:this.onLogStoreLoad}},c)),search:new SYNO.API.JsonStore(Ext.apply({api:"SYNO.Docker.Container.Log",method:"search",version:1,listeners:{scope:this,exception:this.onException,beforeload:this.onBeforeSearchStoreLoad,load:this.onStoreLoad}},c))};return a},createTbar:function(){return new SYNO.ux.Toolbar({items:[{xtype:"syno_splitbutton",text:this.helper.T("common","export"),menu:{xtype:"menu",items:[{text:this.helper.T("log","html_type"),scope:this,handler:this.exportHTML},{text:this.helper.T("log","csv_type"),scope:this,handler:this.exportCSV}]},scope:this,handler:this.exportHTML},"->",{xtype:"syno_textfilter",itemId:"filter",enumAction:"load",queryAction:"load",store:this.stores.search,pageSize:this.pageSize,queryParam:"filter",queryDelay:300,baseParams:{name:""},onTriggerClick:function(){if(this.getValue()){this.setValue("")}this.focus(false,200)}}]})},createGridPanelWrapper:function(a){return new SYNO.ux.Panel({region:"center",layout:"card",activeItem:1,defaults:{border:false},items:[a.search,a.log]})},createGridPanels:function(a){return{search:new SYNO.ux.GridPanel({store:a.search,enableHdMenu:true,colModel:this.createColumnModel(true),bbar:this.createBBar(this.stores.search),autoExpandColumn:true,view:this.createView()}),log:new SYNO.ux.GridPanel({store:a.log,enableHdMenu:true,colModel:this.createColumnModel(),bbar:this.createBBar(this.stores.log),autoExpandColumn:true,view:this.createView()})}},createBBar:function(a){return new SYNO.ux.PagingToolbar({store:a,pageSize:this.pageSize,displayInfo:true})},createColumnModel:function(a){var b=[{id:"time",header:this.helper.T("helptoc","time"),dataIndex:"time",width:20,renderer:function(h,e,d,i,g,f){return Date.parseDate(h,"Y-m-d H:i:s").format("H:i:s")}},{header:this.helper.T("container_detail","log"),dataIndex:"logs",width:120,renderer:function(h,e,d,i,g,f){return String.format('<pre class="{0}" ext:qtip="{1}">{1}</pre>',SYNO.SDS.Utils.SelectableCLS,Ext.util.Format.htmlEncode(Ext.util.Format.htmlEncode(h)))}},{header:this.helper.T("common","stream"),dataIndex:"stream",width:20}];if(a){var c=this;b.push({header:this.helper.T("welcome","welcome_go"),dataIndex:"docid",width:20,renderer:function(h,e,d,i,g,f){return String.format("<div class='docker-container-log-goto' data-docid='{0}' ext:qtip='{1}'></div>",h,c.helper.T("welcome","welcome_go"))},listeners:{scope:this,click:function(f,e,h,g){var d=e.store.getAt(h);this.onClickSearchGoto(d)}}});Ext.apply(b[0],{width:40,renderer:function(h,e,d,i,g,f){return Date.parseDate(h,"Y-m-d H:i:s").toLocaleString()}})}return new Ext.grid.ColumnModel({defaultSortable:false,columns:b})},createView:function(){return new SYNO.ux.FleXcroll.grid.BufferView({rowHeight:24,borderHeight:0,owner:this,trackResetOnLoad:false})},createTreePanel:function(){return new SYNO.ux.TreePanel({itemId:"tree",cls:"docker-container-log-treepanel",width:200,bodyStyle:"padding: 0px 20px 0px 0px",region:"west",border:false,collapsable:true,split:true,useArrows:true,rootVisible:false,root:new Ext.tree.TreeNode(),selModel:new Ext.tree.DefaultSelectionModel({listeners:{scope:this,selectionchange:{fn:this.onTreeSelectionChange,scope:this,buffer:100},beforeselect:this.onBeforeTreeSelectionChange}})})},reloadTreePanel:function(){this.helper.mask(this);this.sendWebAPI({api:"SYNO.Docker.Container.Log",method:"get_date_list",version:1,params:{name:this.getContainerName()},scope:this,callback:function(c,a){if(!c){this.onException(a)}else{if(a.dates.length>0){var b=this.parseTreeNode(a.dates);this.createTreeNode(b);this.selectFirstTreeNode();this.helper.unmask(this)}else{this.helper.mask(this,this.helper.T("common","no_log"))}}}})},parseTreeNode:function(c){var b=c.map(function(d){return d.match(/\d+-\d+/)[0]}).uniq(),a={};c.each(function(d){var e=d.match(/^\d+-\d+/)[0],f=d.match(/\d+-\d+$/)[0];if(a[e]===undefined){a[e]={text:e,children:[]}}a[e].children.push({text:f,date:d,leaf:true})});return[{id:"docker-container-log-search-node",text:"Search Result",leaf:true,hidden:true}].concat(b.map(function(d){return a[d]}))},createTreeNode:function(c){this.nodeMap={};var b=this,a=function(g){var e=Ext.apply({},g);delete e.children;var f=new Ext.tree.TreeNode(e);if(g.children!==undefined&&g.children.length>0){Ext.each(g.children,function(h){f.appendChild(a(h))})}else{b.nodeMap[e.date]=f}return f},d=a({expanded:true,children:c});this.treePanel.setRootNode(d)},isContainerChanged:function(){var a=this.containerName;this.containerName=this.appWin.getContainerName();return a!==this.containerName},exportHTML:function(){this.exportLog("html")},exportCSV:function(){this.exportLog("csv")},exportLog:function(a){this.downloadWebAPI({webapi:{version:1,api:"SYNO.Docker.Container.Log",method:"export",params:{format:a,name:this.getContainerName()}}})},changeGrid:function(a){var b=a==="log"?1:0;this.gridPanelWrapper.layout.setActiveItem(b)},gotoLogDate:function(a){this.curDate=a;this.changeGrid("log");this.stores.log.load()},selectFirstTreeNode:function(){try{var a=this.treePanel.root.childNodes[1].childNodes[0];this.treePanel.selectPath(a.getPath())}catch(b){SYNO.debug(b)}},selectFocusRow:function(){if(this.focusDocId===null){this.scrollToBottom()}else{var a=this.stores.log.indexOfId(this.focusDocId);if(a!==-1){this.gridPanels.log.selModel.selectRow(a);this.gridPanels.log.view.focusRow(a)}this.focusDocId=null}},showSearchNode:function(){this.treePanel.root.childNodes[0].getUI().show();this.treePanel.root.childNodes[0].select()},getContainerName:function(){return this.appWin.getContainerName()},scrollToBottom:function(){this.gridPanels.log.view.ensureVisible(this.stores.log.getCount()-1,0,false)},onClickSearchGoto:function(a){var b=new Date(a.get("time")).format("Y-m-d");this.focusDocId=a.get("docid");this.toolBar.get("filter").setValue("");this.treePanel.selectPath(this.nodeMap[b].getPath())},onBeforeLogStoreLoad:function(a,b){this.helper.mask(this.gridPanelWrapper);b.params=Ext.apply({limit:this.pageSize,date:this.curDate,offset:0,name:this.getContainerName(),sort_dir:"ASC"},b.params)},onBeforeSearchStoreLoad:function(a,b){if(this.toolBar.get("filter").value.length===0){return false}this.helper.mask(this.gridPanelWrapper);this.showSearchNode();b.params=Ext.apply({limit:this.pageSize,date:this.curDate,offset:0,name:this.getContainerName(),q:this.toolBar.get("filter").value,sort_dir:"ASC"},b.params)},onStoreLoad:function(a){this.helper.unmask(this.gridPanelWrapper)},onLogStoreLoad:function(){this.onStoreLoad.apply(this,arguments);this.selectFocusRow()},onException:function(a){this.appWin.getMsgBox().alert("alert",this.helper.getError(a.code))},onContainerChange:function(){this.toolBar.get("filter").baseParams.name=this.getContainerName();this.reloadTreePanel()},onBeforeTreeSelectionChange:function(a,b,c){if(b.isLeaf()===false){return false}},onTreeSelectionChange:function(a,b){if(b.isLeaf()===false){return false}if(b.attributes.date!==undefined){this.gotoLogDate(b.attributes.date)}else{this.changeGrid("search")}},onAfterRender:function(){this.onContainerChange()},onActivate:function(){if(this.isContainerChanged()){this.onContainerChange()}}});Ext.define("SYNO.SDS.Docker.ContainerDetail.PanelOverview",{extend:"SYNO.ux.Panel",statusUtil:SYNO.SDS.Docker.Container.StatusUtil,helper:SYNO.SDS.Docker.Utils.Helper,procDefault:{cpu:0,memory:0,memoryPercent:0},cpuPriorityMap:{"0":SYNO.SDS.Docker.Utils.Helper.T("container","med"),"10":SYNO.SDS.Docker.Utils.Helper.T("container","low"),"50":SYNO.SDS.Docker.Utils.Helper.T("container","med"),"90":SYNO.SDS.Docker.Utils.Helper.T("container","high")},constructor:function(a){this.callParent([this.fillConfig(a)])},fillConfig:function(a){this.lastIsRunning=null;this.tbar=new SYNO.SDS.Docker.ContainerDetail.Toolbar({owner:this,panel:a.owner,appWin:a.appWin});this.actionGroup=this.tbar.getActionGroup();this.stores=this.createStores();this.grids=this.createGridPanels();this.panels=this.createPanels(a);var b={cls:"syno-sds-docker-container-overview",tbar:this.tbar,title:this.helper.T("container_detail","overview"),layout:"border",items:[this.panels.top,this.panels.bottom],listeners:{scope:this,infoready:this.onInfoReady,infochange:this.onInfoChange,procdata:this.onProcData,procexception:this.onProcException}};Ext.apply(b,a);return b},createStores:function(){return{general:new Ext.data.ArrayStore({autoDestroy:true,fields:["key","value"],idIndex:0,autoLoad:false}),port:new Ext.data.JsonStore({root:"port_bindings",autoDestroy:true,fields:[{name:"container_port",type:"int"},{name:"host_port",type:"int"},{name:"type"}]}),volume:new Ext.data.JsonStore({root:"volume_bindings",autoDestroy:true,fields:[{name:"host_volume_file"},{name:"mount_point"},{name:"type"}]}),links:new Ext.data.JsonStore({root:"links",autoDestroy:true,fields:[{name:"link_container"},{name:"alias"}]}),env:new Ext.data.JsonStore({root:"env_variables",autoDestroy:true,fields:[{name:"key"},{name:"value"}]})}},createGridPanels:function(){var a={enableHdMenu:false,layout:"fit",disableSelection:true};return{general:new SYNO.ux.GridPanel(Ext.apply({cls:"docker-container-grid-keyval",title:this.helper.T("log","general"),hideHeaders:true,store:this.stores.general,colModel:new Ext.grid.ColumnModel({columns:[{dataIndex:"key",renderer:function(f,c,b,g,e,d){return f+":"}},{dataIndex:"value"}]})},a)),port:new SYNO.ux.GridPanel(Ext.apply({title:this.helper.T("container","port_setting"),store:this.stores.port,colModel:new Ext.grid.ColumnModel({columns:[{header:this.helper.T("container","local_port"),dataIndex:"host_port"},{header:this.helper.T("container","container_port"),dataIndex:"container_port"},{header:this.helper.T("common","type"),dataIndex:"type"}]})},a)),volume:new SYNO.ux.GridPanel(Ext.apply({title:this.helper.T("common","volume"),store:this.stores.volume,colModel:new Ext.grid.ColumnModel({columns:[{header:this.helper.T("container","file_folder"),dataIndex:"host_volume_file"},{header:this.helper.T("container","mount_path"),dataIndex:"mount_point"},{header:this.helper.T("common","type"),dataIndex:"type"}]})},a)),links:new SYNO.ux.GridPanel(Ext.apply({title:this.helper.T("wizard","links"),store:this.stores.links,colModel:new Ext.grid.ColumnModel({columns:[{header:this.helper.T("container","container_name"),dataIndex:"link_container"},{header:this.helper.T("common","alias"),dataIndex:"alias"}]})},a)),env:new SYNO.ux.GridPanel(Ext.apply({cls:"docker-container-grid-keyval",title:this.helper.T("container","env_variables"),store:this.stores.env,hideHeaders:true,colModel:new Ext.grid.ColumnModel({columns:[{dataIndex:"key",renderer:function(f,c,b,g,e,d){return f}},{dataIndex:"value"}]})},a))}},createPanels:function(a){var c={owner:this,appWin:a.appWin},b={},e=this;var d=function(){this.getComponent("rightContents").setWidth(this.getWidth()-72-30-14)};b.cpu=new SYNO.SDS.Docker.Overview.UsageBlocks(Ext.apply({flex:1,type:"cpu",header:this.helper.T("overview","cpu_usage"),cls:"docker-block docker-cpu",listeners:{resize:d}},c));b.memory=new SYNO.SDS.Docker.Overview.UsageBlocks(Ext.apply({flex:1,type:"memory",header:this.helper.T("overview","ram_usage"),cls:"docker-block docker-memory",listeners:{resize:d}},c));b.top=new SYNO.ux.Panel({region:"north",title:"Title",height:234,header:true,border:false,setStatus:function(f){var g=this.header;if(g.child("div")){g.child("div").remove()}g.createChild({tag:"div",cls:"docker-container-overview-label",html:e.helper.T("container","status"+f)})},cls:"docker-container-top",layout:"hbox",layoutConfig:{align:"stretch"},items:[{flex:1,xtype:"syno_panel",layout:"fit",items:[this.grids.general]},{flex:1,xtype:"syno_panel",layout:"vbox",layoutConfig:{align:"stretch"},items:[b.cpu,b.memory]}]});b.bottom=new SYNO.ux.Panel({region:"center",border:false,cls:"docker-container-bottom",layout:"hbox",layoutConfig:{align:"stretch"},items:[{xtype:"syno_tabpanel",cls:"docker-container-bottom-left",flex:1,activeTab:0,items:[this.grids.port,this.grids.volume,this.grids.links]},{xtype:"syno_panel",header:true,cls:"docker-container-bottom-right",flex:1,title:this.helper.T("container","env_variables"),layout:"fit",items:[this.grids.env]}]});return b},renderProc:function(a){this.panels.cpu.fireEvent("data",a.cpu);this.panels.memory.fireEvent("data",a.memory,a.memoryPercent,true)},renderInfo:function(){var f=this,e=this.owner.getDockerInfo().details,d=this.owner.getDockerInfo().profile,b="port,volume,links,env".split(",").map(function(h){return f.stores[h]});if(true===d.enable_publish_all_ports){$H(e.NetworkSettings.Ports).toArray().each(function(j){if(j.key===null||j.value===null){return}var h=j.key.split("/"),i={};i.container_port=parseInt(h[0],10);i.host_port=parseInt(j.value[0].HostPort,10);i.type=h[1];if(SYNO.ux.Utils.checkArrayInclude(d.port_bindings,i)){return}d.port_bindings.push(i)})}Ext.each(b,function(h){h.loadData(d)},this);var a=d.shortcut.enable_shortcut===false?this.helper.T("common","disabled"):d.shortcut.enable_status_page===true?this.helper.T("container","status_page"):String.format("{0}: {1}",this.helper.T("container","web_page"),d.shortcut.web_page_url);var g=this.cpuPriorityMap[d.cpu_priority];var c=[[this.helper.T("common","up_time"),this.helper.relativeTime(parseInt(e.up_time,10)*1000)],[this.helper.T("common","desktop_shortcut"),a],[this.helper.T("container","cpu_priority"),g],[this.helper.T("container_detail","command"),d.cmd]];if(!this.owner.isRunning()){c=c.slice(1)}this.stores.general.loadData(c);this.panels.top.setTitle(this.appWin.getContainerName());this.panels.top.setStatus(this.owner.isRunning()?"Running":"Stopped")},onInfoReady:function(){this.helper.mask(this)},onInfoChange:function(){var c=this.owner.isRunning(),a=this.actionGroup,b=this.owner.getDockerInfo(),d={status:b.details.status,is_package:b.profile.is_package};if(this.lastIsRunning!==c){this.lastIsRunning=c;a.disableAll();Ext.each(a.getArray(),function(f){var g=this.statusUtil.stat2StatCode(d),e=f.initialConfig.enableStatus&g,h=(f.initialConfig.disableStatus!==undefined)&&(f.initialConfig.disableStatus&g);if(e&&!h){f.enable()}},this);if(c===false){this.renderProc(this.procDefault)}}this.helper.unmask(this);this.renderInfo()},onProcData:function(a){var b=a.processes.reduce(function(c,d){c.cpu+=d.cpu;c.memory+=d.memory;c.memoryPercent+=d.memoryPercent;return c},Ext.apply({},this.procDefault));b.cpu=Ext.util.Format.round(b.cpu,2);b.memoryPercent=Ext.util.Format.round(b.memoryPercent,2);this.renderProc(b)},onProcException:function(a){this.helper.logError(a.code)}});Ext.define("SYNO.SDS.Docker.ContainerDetail.PanelProc",{extend:"SYNO.ux.GridPanel",helper:SYNO.SDS.Docker.Utils.Helper,constructor:function(a){this.callParent([this.fillConfig(a)])},fillConfig:function(b){this.store=this.createStore(b);var a=new Ext.grid.ColumnModel({defaults:{width:120,sortable:true},columns:[{header:this.helper.T("container_detail","pid"),dataIndex:"pid"},{header:this.helper.T("common","command"),dataIndex:"command"},{header:this.helper.T("container_detail","cpu"),dataIndex:"cpu"},{header:this.helper.T("container_detail","memory"),dataIndex:"memory",renderer:function(d){return Ext.util.Format.fileSize(d)}}]});var c={title:this.helper.T("container_detail","process"),store:this.store,enableHdMenu:false,colModel:a,autoExpandColumn:true,listeners:{scope:this,infochange:this.onInfoChange,procdata:this.onProcData,procexception:this.onProcException,activate:this.onActivate}};Ext.apply(c,b);return c},createStore:function(a){return new Ext.data.JsonStore({autoDestroy:true,fields:[{name:"pid"},{name:"command"},{name:"cpu"},{name:"memory"}],root:"processes",sortInfo:{field:"pid",direction:"ASC"}})},detectMaskGrid:function(){if(!this.owner.isRunning()){this.helper.mask(this,this.helper.T("container_detail","container_stopped"));this.store.removeAll()}else{this.helper.unmask(this)}},onInfoChange:function(){this.detectMaskGrid()},onProcData:function(a){this.store.loadData(a)},onProcException:function(a){this.helper.logError(a.code)},onActivate:function(){this.detectMaskGrid();if(this.owner.isRunning()&&null!==this.owner.getProcData()){this.onProcData(this.owner.getProcData())}}});Ext.define("SYNO.SDS.Docker.ContainerDetail.PanelTerm",{extend:"SYNO.ux.Panel",helper:SYNO.SDS.Docker.Utils.Helper,constructor:function(a){this.callParent([this.fillConfig(a)])},fillConfig:function(a){this.ttyList={};this.actionGroup=this.createActionGroup();this.toolBar=this.createTBar();this.termContainer=this.createTermContainer();this.treePanel=this.createTreePanel();this.socket=null;var b={title:this.helper.T("container_detail","terminal"),tbar:this.toolBar,layout:"border",border:false,cls:"docker-container-term-panel",items:[this.treePanel,this.termContainer],listeners:{scope:this,containerchange:this.onContainerChange,infochange:this.onInfoChange,activate:this.onActivate,beforedestroy:this.onBeforeDestroy}};Ext.apply(b,a);return b},createTreePanel:function(){return new SYNO.ux.TreePanel({width:200,region:"west",bodyStyle:"padding: 0px 20px 0px 0px",border:false,collapsable:true,split:true,useArrows:true,rootVisible:false,root:new Ext.tree.TreeNode(),selModel:new Ext.tree.DefaultSelectionModel({listeners:{scope:this,selectionchange:{fn:this.onTermSelectChange,scope:this,buffer:100}}}),listeners:{scope:this,click:this.onTermClick}})},createActionGroup:function(){var a=new SYNO.ux.Menu({items:[{text:this.helper.T("container_detail","create_with_cmd"),scope:this,handler:this.onCreateTerm,itemId:"create_with_cmd"}]});return new SYNO.SDS.Utils.ActionGroup([new SYNO.ux.SplitButton({text:this.helper.T("common","create"),scope:this,handler:this.doCreateTerm.bind(this,""),itemId:"create",menu:a}),new Ext.Action({itemId:"rename",text:this.helper.T("container_detail","rename"),scope:this,handler:this.onRename,disabled:true}),new Ext.Action({itemId:"delete",text:this.helper.T("common","delete"),scope:this,handler:this.onDeleteTerm,disabled:true})])},createTBar:function(){return new SYNO.ux.Toolbar({defaultType:"syno_button",items:[this.actionGroup.getArray()]})},createMonitorSocket:function(){var a=new SYNO.SDS.Docker.ContainerDetail.TermSocket(true);a.on("connect",function(b){a.enter(this.appWin.getContainerName())}.bind(this));a.on("enter",function(b){if(!b){this.appWin.getMsgBox().alert("error",this.helper.T("error","term_enter_fail"))}}.bind(this));a.on("list",function(c){for(var b=0;b<c.length;b+=2){this.ttyList[c[b]]=c[b+1]}this.reloadTree();if(this.termContainer.items.length===0){this.selectTerm(this.appWin.getContainerName())}}.bind(this));a.on("title",function(b,d){if(this.ttyList[b]){this.ttyList[b]=d;var c=this.termContainer.getComponent(b);if(c){c.name=d}this.reloadTree()}}.bind(this));a.on("disconnect",function(b){if(!this.isDestroyed&&!this.destroying&&!this.socketClosing){this.appWin.getMsgBox().alert("error",this.helper.T("error","ws_close"));this.helper.logError(b.code)}this.socketClosing=false}.bind(this));return a},createTermContainer:function(){return new SYNO.ux.Panel({region:"center",layout:"card",defaults:{border:false}})},resetPanel:function(){this.treePanel.setRootNode(new Ext.tree.TreeNode());this.ttyList={};this.termContainer.removeAll();if(this.socket){this.socketClosing=true;this.socket.destroy();this.socket=null}},selectTerm:function(a){var b=this.treePanel.root.findChild("id",a);if(!b){return}this.treePanel.selectPath(b.getPath())},openTerm:function(a){var b=new SYNO.SDS.Docker.ContainerDetail.Term({appWin:this.appWin,container:this.appWin.getContainerName(),name:this.ttyList[a],tty_id:a,itemId:a});this.mon(b,"termclose",this.updateActionGroup,this);return b},reopenTerm:function(a){var c=this.termContainer.layout.activeItem;var b=this.termContainer.getComponent(a);if(b){this.termContainer.remove(b)}b=this.openTerm(a);this.termContainer.add(b);this.termContainer.doLayout();if(c){this.termContainer.layout.setActiveItem(c.tty_id)}},switchTerm:function(a){if(a===null){if(this.termContainer.layout.activeItem){this.termContainer.layout.activeItem.hide()}return}var b=this.termContainer.getComponent(a);if(!b){b=this.openTerm(a);this.termContainer.add(b);this.termContainer.doLayout()}this.termContainer.layout.setActiveItem(a);if(this.termContainer.layout.activeItem.hidden){this.termContainer.layout.activeItem.show()}},closeTerm:function(a){var b=this.termContainer.getComponent(a);if(!b){return}this.termContainer.remove(b);delete this.ttyList[a];this.reloadTree();this.selectTerm(this.appWin.getContainerName())},isNeedShowCloseConfirm:function(){if(!this.socket||this.treePanel.root.childNodes.length<2){return false}return true},closeAllTerm:function(){var a=this.appWin.getContainerName();Object.keys(this.ttyList).forEach(function(b){if(b===a){return}this.socket.emit("delete",b)},this)},reloadTree:function(){var e=this.treePanel.getSelectionModel().getSelectedNode();var b=this.appWin.getContainerName();var d=Object.keys(this.ttyList).sort(function(g,f){if(g===b){return -1}if(f===b){return 1}if(g<f){return -1}if(g>f){return 1}return 0});var c=d.map(function(f){return new Ext.tree.TreeNode({id:f,text:Ext.util.Format.htmlEncode(this.ttyList[f]),leaf:true})},this);var a=new Ext.tree.TreeNode({expanded:true});c.each(function(f){a.appendChild(f)});this.treePanel.setRootNode(a);if(e){this.selectTerm(e.id)}},updateActionGroup:function(){this.actionGroup.disable("rename");this.actionGroup.disable("delete");if(!this.termContainer.layout.activeItem){return}var a=this.termContainer.layout.activeItem;if(a.tty_id!==this.appWin.getContainerName()&&!a.closeByDetached){this.actionGroup.enable("delete")}if(a.socket.connecting||a.socket.connected){this.actionGroup.enable("rename")}},isContainerChanged:function(){var a=this.containerName;this.containerName=this.appWin.getContainerName();return a!==this.containerName},onCreateTerm:function(){this.appWin.getMsgBox().prompt("CMD","CMD",function(a,b){if(a==="ok"){this.doCreateTerm(b)}},this)},doCreateTerm:function(a){a=a||"/bin/bash";this.socket.emit("create",a)},onRename:function(){var a=this.treePanel.getSelectionModel().getSelectedNode();if(!a){return}this.appWin.getMsgBox().prompt("Title",this.helper.T("container_detail","terminal_title"),function(b,c){if(b==="ok"){this.doRename(a.id,c)}},this)},doRename:function(b,a){this.socket.emit("title",b,a)},onDeleteTerm:function(){var b=this.treePanel.getSelectionModel().getSelectedNode();if(!b){return}var a=this.termContainer.getComponent(b.id);if(a&&!a.attached&&!a.closeByDetached){this.doDeleteTerm(b.id,true);return}var c=String.format(this.helper.T("container_detail","term_delete_confirm"),b.text);this.appWin.getMsgBox().confirm("Delete",c,function(d){if(d==="yes"){this.doDeleteTerm(b.id)}},this)},doDeleteTerm:function(a,b){if(!b){this.socket.emit("delete",a)}this.closeTerm(a)},onTermClick:function(b){var a=this.termContainer.getComponent(b.id);if(!a){return}if(a.closeByDetached){this.appWin.getMsgBox().confirm("reopen",this.helper.T("container_detail","term_reopen_confirm"),function(c){if(c==="yes"){this.reopenTerm(b.id)}},this)}},onTermSelectChange:function(){var a=this.treePanel.getSelectionModel().getSelectedNode();if(a===null){this.switchTerm(null)}else{this.switchTerm(a.id)}this.updateActionGroup()},onContainerChange:function(){if(!SYNO.SDS.Docker.Utils.Socket.browserSupported()){this.helper.mask(this,this.helper.T("container_detail","browser_not_supported_ws"));return}if(!this.owner.isRunning()){this.helper.mask(this,this.helper.T("container_detail","container_stopped"));return}this.helper.unmask(this);this.resetPanel();this.socket=this.createMonitorSocket()},onInfoChange:function(){if(!SYNO.SDS.Docker.Utils.Socket.browserSupported()){this.helper.mask(this,this.helper.T("container_detail","browser_not_supported_ws"));return}if(!this.owner.isRunning()){this.helper.mask(this,this.helper.T("container_detail","container_stopped"));this.resetPanel();return}this.helper.unmask(this);if(!this.socket){this.socket=this.createMonitorSocket()}},onActivate:function(){this.onInfoChange();if(this.isContainerChanged()){this.onContainerChange()}else{if(this.termContainer.layout.activeItem){this.termContainer.layout.activeItem.fireEvent("activate")}}},onBeforeDestroy:function(){if(this.socket){this.socket.destroy()}}});Ext.define("SYNO.SDS.Docker.ContainerDetail.Panel",{extend:"SYNO.ux.TabPanel",refreshIntervals:{proc:3000,info:5000},helper:SYNO.SDS.Docker.Utils.Helper,statusUtil:SYNO.SDS.Docker.Container.StatusUtil,constructor:function(a){this.callParent([this.fillConfig(a)])},fillConfig:function(a){this.dockerInfo=null;this.procData=null;this.procPollingTask=null;this.infoPollingTask=null;this.panels=this.createPanels(a);var b={activeTab:"overview",items:Object.values(this.panels),listeners:{scope:this,containerchange:this.onContainerChange,infoready:this.onInfoReady,tabchange:this.onTabChange,winactivate:this.onActivate,windeactivate:this.onDeactivate}};Ext.apply(b,a);return b},createPanels:function(a){var b={owner:this,appWin:a.appWin};return{overview:new SYNO.SDS.Docker.ContainerDetail.PanelOverview(Ext.apply({itemId:"overview"},b)),process:new SYNO.SDS.Docker.ContainerDetail.PanelProc(Ext.apply({itemId:"process"},b)),logs:new SYNO.SDS.Docker.ContainerDetail.PanelLogs(Ext.apply({itemId:"logs"},b)),term:new SYNO.SDS.Docker.ContainerDetail.PanelTerm(Ext.apply({itemId:"term"},b))}},isRunning:function(){return this.getDockerInfo()&&this.getDockerInfo().details.status===this.statusUtil.status.run},getDockerInfo:function(){return this.dockerInfo},getProcData:function(){return this.procData},startInfoPolling:function(){if(this.appWin.infoReady()&&this.infoPollingTask&&!this.infoPollingTask.running&&this.activeTab&&this.activeTab.itemId!=="logs"){this.infoPollingTask.start(true)}},stopInfoPolling:function(){if(!this.infoPollingTask){return}this.infoPollingTask.stop()},restartInfoPolling:function(){if(this.infoPollingTask){this.stopInfoPolling()}this.infoPollingTask=this.createInfoPollingTask();this.startInfoPolling()},startProcPolling:function(){if(this.appWin.infoReady()&&this.procPollingTask&&!this.procPollingTask.running&&this.activeTab&&this.activeTab.itemId!=="logs"){this.procPollingTask.start(true)}},stopProcPolling:function(){if(!this.procPollingTask){return}this.procPollingTask.stop()},restartProcPolling:function(){if(this.procPollingTask){this.stopProcPolling()}this.procPollingTask=this.createProcPollingTask();this.startProcPolling()},updateInfo:function(){this.stopInfoPolling();this.sendWebAPI(Ext.apply(this.fillInfoAPI(),{callback:function(d,b,c,a){this.startInfoPolling();if(d){this.onDockerInfo(arguments)}else{this.onDockerInfoException(arguments)}}}))},createProcPollingTask:function(){return this.addWebAPITask({scope:this,interval:this.refreshIntervals.proc,version:1,api:"SYNO.Docker.Container",method:"get_process",params:{name:this.appWin.getContainerName()},callback:function(d,b,c,a){if(d){this.onProcData(arguments)}else{this.onProcException(b)}}})},createInfoPollingTask:function(){return this.addWebAPITask(Ext.apply({interval:this.refreshIntervals.info},this.fillInfoAPI()))},fillInfoAPI:function(){return{scope:this,api:"SYNO.Docker.Container",method:"get",version:1,params:{name:this.appWin.getContainerName()},callback:function(d,b,c,a){if(d){this.onDockerInfo(arguments)}else{this.onDockerInfoException(b)}}}},statusHelper:{status:null,isStatusChanged:function(b){var a=this.status!==null&&b!==this.status;this.status=b;return a}},isNeedShowCloseConfirm:function(){return this.panels.term.isNeedShowCloseConfirm()},closeAllTerm:function(){this.panels.term.closeAllTerm()},onTabChange:function(){if(this.activeTab&&this.activeTab.itemId==="logs"){this.stopInfoPolling();this.stopProcPolling()}else{this.startInfoPolling();this.startProcPolling()}},onInfoReady:function(){this.restartInfoPolling();this.restartProcPolling()},onContainerChange:function(){this.onInfoReady();this.activate("overview");if(this.activeTab){this.activeTab.fireEvent("containerchange")}},onActivate:function(){this.startProcPolling();this.startInfoPolling();if(this.activeTab){this.activeTab.fireEvent("activate")}},onDeactivate:function(){this.stopProcPolling();this.stopInfoPolling();if(this.activeTab){this.activeTab.fireEvent("deactivate")}},onDockerInfo:function(b){this.dockerInfo=b[1];if(this.dockerInfo.profile===null){var a=new SYNO.SDS.Docker.Utils.Shortcut({owner:this}),d=this.appWin.getContainerName(),c=this.helper.getError(this.helper.errorMapping.WEBAPI_ERR_CONTAINER_NOT_EXIST,d);a.remove(d);this.appWin.getMsgBox().alert("",c,function(){this.appWin.close()},this);return}if(this.statusHelper.isStatusChanged(this.isRunning())){if(this.isRunning()){this.startProcPolling()}else{this.stopProcPolling()}}if(this.activeTab){this.activeTab.fireEvent("infochange",b)}},onDockerInfoException:function(a){if(this.activeTab){this.activeTab.fireEvent("infoexception",a)}},onProcData:function(a){this.procData=a[1];this.procData.processes=this.procData.processes.map(function(b){b.cpu=Ext.util.Format.round(parseFloat(b.cpu),2);b.memory=parseInt(b.memory,10);b.memoryPercent=Ext.util.Format.round(parseFloat(b.memoryPercent),2);return b});if(this.activeTab){this.activeTab.fireEvent("procdata",this.procData)}},onProcException:function(a){if(this.activeTab){this.activeTab.fireEvent("procexception",a)}}});Ext.define("SYNO.SDS.Docker.ContainerDetail.Toolbar",{extend:"SYNO.ux.Toolbar",statusUtil:SYNO.SDS.Docker.Container.StatusUtil,helper:SYNO.SDS.Docker.Utils.Helper,constructor:function(a){this.callParent([this.fillConfig(a)])},fillConfig:function(a){var c=this.statusUtil.statusCode;var d={start:new Ext.Action({itemId:"start",text:this.helper.T("container","start"),enableStatus:c.stop,disableStatus:c.synopackage,scope:this,handler:this.btnStart}),stop:new Ext.Action({itemId:"stop",text:this.helper.T("container","stop"),enableStatus:c.run,disableStatus:c.synopackage,scope:this,handler:this.btnStop}),restart:new Ext.Action({itemId:"restart",text:this.helper.T("container","restart"),enableStatus:c.run,disableStatus:c.synopackage,scope:this,handler:this.btnRestart}),fstop:new Ext.Action({itemId:"fstop",text:this.helper.T("container","force_stop"),enableStatus:c.run,disableStatus:c.synopackage,scope:this,handler:this.btnFstop})};this.actionGroup=new SYNO.SDS.Utils.ActionGroup(Object.values(d));var b={height:40,items:Object.values(d)};Ext.apply(b,a);return b},API:function(b){b.params=b.params||{};b.params.name=this.appWin.getContainerName();this.helper.mask(this.panel);var a={version:1,api:"SYNO.Docker.Container",method:b.method,params:b.params,scope:this,callback:this.btnCallback};this.sendWebAPI(a)},btnCallback:function(b,a){this.helper.unmask(this.panel);if(!b){this.appWin.getMsgBox().alert("alert",this.helper.getError(a.code))}else{this.panel.updateInfo()}},btnStart:function(){this.API({method:"start"})},btnStop:function(){this.API({method:"stop"})},btnFstop:function(){this.API({method:"signal",params:{signal:9}})},btnRestart:function(){this.API({method:"restart"})},getActionGroup:function(){return this.actionGroup}});Ext.define("SYNO.SDS.Docker.ContainerDetail.Instance",{extend:"SYNO.SDS.AppInstance",appWindowName:"SYNO.SDS.Docker.ContainerDetail.Main"});Ext.define("SYNO.SDS.Docker.ContainerDetail.Main",{extend:"SYNO.SDS.AppWindow",helper:SYNO.SDS.Docker.Utils.Helper,defaultWinSize:{width:930,height:540},constructor:function(a){this.callParent([this.fillConfig(a)])},fillConfig:function(a){this.containerName=null;this.panel=new SYNO.SDS.Docker.ContainerDetail.Panel({owner:this,appWin:this});var b={cls:"syno-sds-docker-container-status",pinable:false,width:this.defaultWinSize.width,height:this.defaultWinSize.height,minWidth:this.defaultWinSize.width,minHeight:this.defaultWinSize.height,splitWindow:true,showHelp:false,layout:"fit",items:[this.panel],listeners:{scope:this,beforeclose:{single:true,fn:this.onBeforeClose}}};Ext.apply(b,a);return b},infoReady:function(){return this.containerName!==null},getContainerName:function(){return this.containerName},onOpen:function(a){this.callParent(arguments);this.openDetail(a.data)},onRequest:function(a){this.callParent(arguments);this.openDetail(a.data)},onActivate:function(){this.callParent(arguments);this.panel.fireEvent("winactivate")},onDeactivate:function(){this.panel.fireEvent("beforedeactivate");this.callParent(arguments);this.panel.fireEvent("windeactivate")},openDetail:function(a){var b=(null!==this.containerName)&&(this.containerName!==a.name);this.containerName=a.name;this.setTitle(this.containerName);this.panel.fireEvent("infoready");if(b){this.panel.fireEvent("containerchange")}},onBeforeClose:function(){if(!this.panel.isNeedShowCloseConfirm()){return}this.getMsgBox().confirm("comfirm",this.helper.T("container_detail","term_close_all_confirm"),function(a){if(a==="yes"){this.panel.closeAllTerm()}this.close()},this);return false}});Ext.define("SYNO.SDS.Docker.Utils.APILoadingDialog",{extend:"SYNO.SDS.ModalWindow",constructor:function(a){this.callParent([this.fillConfig(a)])},fillConfig:function(a){if(!a.APIRequest){SYNO.Debug("APILoadingDialog should specify monitoring APIRequest")}this.progressBar=this.createProgressBar();var b={title:"Loading",width:450,height:100,scope:this,fbar:new Ext.Toolbar({items:[{xtype:"syno_button",text:"Cancel",scope:this,handler:this.onCancel}],enableOverflow:false}),items:[this.progressBar]};Ext.apply(b,a);return b},createProgressBar:function(){return new Ext.ProgressBar({cls:"syno-sds-docker-waiting-progress",width:440,value:1})},onCancel:function(){Ext.Ajax.abort(this.APIRequest);if(Ext.isFunction(this.abortHandler)){this.abortHandler.call(this.scope,this.transaction)}this.close()}});