#!/bin/sh
# Copyright (c) 2000-2012 Synology Inc. All rights reserved.

RCNETWORK="/etc/rc.network"
AP_PREFIX="/etc/dhcpd/dhcpd-lbr0-lbr0"
DHCP_PKG_ETC="/var/packages/DHCPServer/target/etc"

check_ap_enable()
{
	local info=${AP_PREFIX}.info
	if [ -e ${info} ]; then
		local enable=`/bin/get_key_value ${info} enable`
		if [ "${enable}" = "yes" ]; then
			return 1
		fi
	fi
	return 0
}

disable_dhcp_server()
{
	check_ap_enable
	local ap_enable=$?
	for info_file in `ls /etc/dhcpd/dhcpd*.info | grep -v lbr0 | grep -v dhcpd.info`; do
		mv ${info_file} ${DHCP_PKG_ETC}
	done
	if [ ${ap_enable} -eq 0 ]; then
		${RCNETWORK} nat-stop-dhcp
	else
		${RCNETWORK} nat-restart-dhcp
	fi
}

enable_dhcp_server()
{
	for info_file in `ls ${DHCP_PKG_ETC}/dhcpd*.info`; do
		mv ${info_file} /etc/dhcpd/
	done
	${RCNETWORK} nat-restart-dhcp
}

case "$1" in
	start)
		enable_dhcp_server
	;;
	stop)
		disable_dhcp_server
	;;
	*)
	echo "Usage: $0 {start|stop}"
	exit 1
esac
exit $?
