#!/bin/sh
# Copyright (c) 2000-2012 Synology Inc. All rights reserved.

DHCPD_DIR="/etc/dhcpd/"
DHCPD_PKG_DIR="/var/packages/DHCPServer/target/etc"
LEASE_FILE="${DHCPD_PKG_DIR}/dhcpd.conf.leases"
LOG_FILE="${DHCPD_PKG_DIR}/dhcpd-leases.log"
TMP_FILE="${DHCPD_PKG_DIR}/tmp-dhcpd-leases.log"
TMP_RECORD="/tmp/tmp_lease"

del_leases() { # $2: mac
	local mac=$2
	grep -v "${mac}" ${LOG_FILE} > ${TMP_RECORD}
	cp ${TMP_RECORD} ${LOG_FILE}
}

renew_record() { # $1: expired $2 mac $3 ip $4 hostname $5 iface
	local record=$@
	local mac=$2
	local iface=$5

	grep -v "${mac}" ${LOG_FILE} > ${TMP_RECORD}
	echo "${record}" >> ${TMP_RECORD}
	cp ${TMP_RECORD} ${LOG_FILE}
}

add_new_record() {
	local record="$@"

	if [ -s ${LOG_FILE} ]; then
		sed -i "1 i${record}" ${LOG_FILE}
	else
		echo ${record} > ${LOG_FILE}
	fi
}

get_new_record() {
	local mac="$2"
	local ip="$3"
	local hostname="$4"
	NEW_RECORD="${DNSMASQ_LEASE_EXPIRES} ${mac} ${ip} ${hostname} ${DNSMASQ_INTERFACE}"
}

# record format: action mac ip hostname
NEW_RECORD=$@
ACTION=`echo ${NEW_RECORD} | awk '{print $1}'`

if [ "${DNSMASQ_INTERFACE}" = "" ]; then
	exit 0
fi
get_new_record ${NEW_RECORD}

case "${ACTION}" in
	old)
		renew_record ${NEW_RECORD}
		;;
	add)
		add_new_record ${NEW_RECORD}
		;;
	del)
		del_leases ${NEW_RECORD}
		;;
	*)
		;;
esac

exit 0
