#!/bin/sh
# Copyright (c) 2000-2012 Synology Inc. All rights reserved.

DHCPD_DIR="/etc/dhcpd/"
DHCPD_PKG_DIR="/var/packages/DHCPServer/target/etc"
LEASE_FILE="${DHCPD_PKG_DIR}/dhcpd.conf.leases"
LOG_FILE="${DHCPD_PKG_DIR}/dhcpd-leases.log"
TMP_FILE="${DHCPD_PKG_DIR}/tmp-dhcpd-leases.log"

remove_expired_leases() {
	# get current time  with epoch format
	local current_time=`/bin/date +%s`
	if [ -e ${TMP_FILE} ]; then
		rm ${TMP_FILE}
	fi
	if [ -s ${LOG_FILE} ]; then
		awk -v CTIME=${current_time} '$1>CTIME {print $0}' ${LOG_FILE} >> ${TMP_FILE}
		cp ${TMP_FILE} ${LOG_FILE}
	fi
}

add_new_record() { # $1: action,$2: mac,$3: ip,$4: hostname
	local mac=$2
	local ip=$3
	local hostname=$4
	local record="${DNSMASQ_LEASE_EXPIRES} ${mac} ${ip} ${hostname} ${DNSMASQ_INTERFACE}"
	if [ -s ${LOG_FILE} ]; then
		sed -i "1 i${record}" ${LOG_FILE}
	else
		echo ${record} > ${LOG_FILE}
	fi
}
# record format: action mac ip hostname
NEW_RECORD=$*
ACTION=`echo ${NEW_RECORD} | awk '{print $1}'`
if [ "${ACTION}" = "old" ]; then
	exit 0
fi
remove_expired_leases
add_new_record ${NEW_RECORD}

exit 0
