#!/bin/sh

CARDDAV_SERVER_PKG="/var/packages/CardDAVServer"
CARDDAV_USER_SET_BIN="${CARDDAV_SERVER_PKG}/target/tools/synocarddav_user_set"

UserAddressbookMigrate()
{
	if [ ! -z "$org_name" ] && [ "$org_name" != "$new_name" ]; then
		$CARDDAV_USER_SET_BIN -o $org_name -n $new_name
	fi
}

case $1 in
	--sdk-mod-ver)
		#Print SDK support version
		echo "1.0";
		;;
	--name)
		#Print package name
		echo "CardDAVServer";
		;;
	--pkg-ver)
		#Print package version
		echo "1.0";
		;;
	--vendor)
		#Print package vendor
		echo "Synology";
		;;
	--post)
		usr_idx=1;
		usr_cnt=$(($NITEMS + 1));
		while [ "$usr_idx" != "$usr_cnt" ]
		do
			eval "org_name=\$ORIGIN_USER_NAME_$usr_idx"
			eval "new_name=\$USER_NAME_$usr_idx"

			UserAddressbookMigrate
			usr_idx=$(($usr_idx + 1));
		done
		;;
	*)
		echo "Usage: $0 --sdk-mod-ver|--name|--pkg-ver|--vendor|--pre|--post"
		;;

esac
exit 0

