#!/usr/bin/python
import argparse
from twisted.python import hashlib
from uuid import uuid4

def main():
    parser = argparse.ArgumentParser(description='Do something of DB operation')
    parser.add_argument('--checkGUID', help="Check or Set GUID", nargs=1, metavar=('username'), dest='checkGUID')
    parser.add_argument('--getMD5', help="get MD5", nargs=1, metavar=('text'), dest='getMD5')
    parser.add_argument('--getUUID', action='store_true', default=True, help="get UUID")
    args = parser.parse_args()

    if args.checkGUID:
        from twistedcaldav.directory.nss import CheckAndSetGUID
        CheckAndSetGUID("CardDAV", args.checkGUID[0])
    elif args.getMD5:
        print hashlib.md5(args.getMD5[0]).hexdigest()
    elif args.getUUID:
        print str(uuid4())
    else:
        parser.print_help()
    return

if __name__ == "__main__":
    main()
