#!/bin/sh
SCRIPTNAME="calendarserver_start_stop.sh"
PRIVATE_LOCATION="/var/packages/CardDAVServer/target"
calendarserver_start()
{
        ${PRIVATE_LOCATION}/usr/bin/caldavd -f ${PRIVATE_LOCATION}/etc/syno_caldavd.plist
        #busywaiting for processes ready
        local COUNT=120
        while true; do
                COUNT_PID=`ls ${PRIVATE_LOCATION}/var/run/*.pid | grep -c pid`
                if  [ 3 -eq ${COUNT_PID} -o 0 -eq $COUNT ]; then
                        break
                fi
                sleep 1
                COUNT=$((COUNT-1))
        done
}
calendarserver_stop()
{
        kill -9 `cat ${PRIVATE_LOCATION}/var/run/caldavd.pid`
        rm -f ${PRIVATE_LOCATION}/var/run/caldavd.pid 

        for i in `ls ${PRIVATE_LOCATION}/var/run/*.pid`;
        do
                kill -9 `cat $i`
                rm -f $i
        done
        #busywaiting for all processes stop
        local COUNT=120
        while true; do
                COUNT_CARDDAV=`ps -w -w | grep -v grep | grep -c caldav`
                if [ 0 -eq ${COUNT_CARDDAV} -o 0 -eq $COUNT ]; then
                        break
                fi
                sleep 1
                COUNT=$((COUNT-1))
        done
}

case "$1" in
        start)
                calendarserver_start
                exit 0
                ;;
        stop)
                calendarserver_stop
                exit 0
                ;;
        restart)
                calendarserver_stop
                calendarserver_start
                ;;
        *)
                echo "Usage: $SCRIPTNAME {start|stop|restart}" >&2
                exit 3
                ;;
esac
