import sqlite3, os
from time import gmtime, strftime
from twisted.python import log

__all__ = [
    "ShortNameGUIDMapping"
]
def logger(msg):
        log_file_path = "/var/packages/CardDAVServer/target/etc/carddavserver_error.log"
        log_file = open(log_file_path, 'a+')
        log_file.write(strftime("%Y-%m-%d %H:%M:%S", gmtime()) + ": " + msg + '\n')
        log_file.close()

class ShortNameGUIDMapping(object):
    def __init__(self, db_path):
        self.db_path = db_path
        if(not os.path.isfile(self.db_path)):
            logger(self.db_path)
            self.conn = sqlite3.connect(self.db_path)
            self.cursor = self.conn.cursor()
            self.cursor.execute("create table mapping (short_name text, GUID text, PRIMARY KEY (GUID))")
        else:
            self.conn = sqlite3.connect(self.db_path)
            self.cursor = self.conn.cursor()
    def is_GUID_exist(self, GUID):
        self.cursor.execute("select count(1) from mapping where GUID=?", (GUID,))
        result = self.cursor.fetchone()
        return result[0]

    def insert_shortname_GUID_mapping(self, short_name, GUID):
        self.cursor.execute("insert into mapping values (?, ?)", (short_name, GUID,))
        self.conn.commit()

    def get_shortname_from_GUID(self, GUID):
        self.cursor.execute("select short_name from mapping where GUID=?", (GUID,))
        result = self.cursor.fetchone()
        return result[0]
