#!/usr/bin/python
from time import gmtime, strftime
from lxml import etree
import simplejson, argparse

content_keys = ['HTTPPort', 'SSLPort'] #FIXME 
boolean_keys = ['EnableSSL', 'RedirectHTTPToHTTPS']

def logger(msg):
        log_file_path = "/var/packages/CardDAVServer/target/etc/carddavserver_error.log"
        print msg
        log_file = open(log_file_path, 'a+')
        log_file.write(strftime("%Y-%m-%d %H:%M:%S", gmtime()) + ": " + msg + '\n')
        log_file.close()

def xpath_get(key):
        return "//key[text()='" + key + "']"

def modify_content_key(tree, key, value): 
        key_node=tree.xpath(xpath_get(key))
        if not key_node:
                logger("This key: " + i + " cannot be cound in xml conf file! Error!")
        key_node[0].getnext().text = str(value)
        return tree

def translate_content_keys(tree, json):
        for i in content_keys:
                try:
                        json[i]
                except KeyError:
                        logger("This key: " + i + " cannot be cound in json conf file! Error!")
                        continue
                #FIXME use previous func
                key=tree.xpath(xpath_get(i))
                if not key:
                        logger("This key: " + i + " cannot be cound in xml conf file! Error!")
                        continue
                key[0].getnext().text = str(json[i])
        return tree

def translate_boolean_keys(tree, json): #XXX deal with only boolean nodes in first layer inside plist
        parent=tree.xpath("/plist/dict")
        if not parent:
                logger("Root: /plist/dict in xml conf cannot be found! Error!")
                return tree
        for i in boolean_keys:
                try:
                        json[i]
                except KeyError:
                        logger("This key: " + i + " cannot be cound in json conf file! Error!")
                        continue
                key=tree.xpath(xpath_get(i))
                if not key:
                        logger("This key: " + i + " cannot be cound in xml conf file! Error!")
                        continue#FIXME remove continue => insert new key
                if json[i]:
                        result = "true"
                else:
                        result = "false"
                old_node = key[0].getnext()
                new_node = etree.Element(result)
                parent[0].replace(old_node, new_node)
        return tree

def xml_tree_get(xml_conf):
        try:
                calender_server_xml_conf_fp = open(xml_conf, 'r+')
        except IOError:
                logger("Fail to open xml conf file! Error!")
                calender_server_xml_conf_fp.close()
                return None
        try:
                xml_tree = etree.parse(calender_server_xml_conf_fp)
        except:
                logger("Fail to parse xml conf file! Error!")
                calender_server_xml_conf_fp.close()
                return None
        calender_server_xml_conf_fp.close()
        return xml_tree

def main():
        parser = argparse.ArgumentParser(description='Transfer syno_json conf file into calendar server native xml conf file.')
        parser.add_argument('--dump', help="dump xml conf from json", nargs=2, metavar=('json_conf', 'xml_conf'), dest='dump')
        parser.add_argument('--modify', help="modify a key in conf", nargs=3, metavar=('xml_conf', 'key', 'value'), dest='modify')
        args = parser.parse_args()

        if args.dump:
                json_conf = args.dump[0]
                xml_conf = args.dump[1]
                try:
                        syno_json_conf_fp = open(json_conf, 'r')
                except IOError:
                        logger("Fail to open json conf file! Error!")
                        return
                try:
                        syno_json_obj = simplejson.load(syno_json_conf_fp)
                except:
                        logger("Fail to parse json conf file! Error!")
                        return  #FIXME return -1
                xml_tree = xml_tree_get(xml_conf)
                for category in syno_json_obj:
                        xml_tree = translate_content_keys(xml_tree, syno_json_obj[category])#FIXME research xml_tree : return from function
                        xml_tree = translate_boolean_keys(xml_tree, syno_json_obj[category])
                syno_json_conf_fp.close()
        elif args.modify:
                xml_conf = args.modify[0]
                key = args.modify[1]
                value = args.modify[2]
                xml_tree = xml_tree_get(xml_conf)
                xml_tree =  modify_content_key(xml_tree, key, value)
        else:
                parser.print_help()
                return

        xml_tree.write(xml_conf)

if __name__ == "__main__":
        main()
