#!/usr/bin/python
# Copyright (c) 2000-2014 Synology Inc. All rights reserved.

from utils import *

def getSynoBuildNumber():
    versionFilePath = '/etc.defaults/VERSION'
    if not os.path.isfile(versionFilePath):
        SYSLOG(syslog.LOG_ERR, "file not exist: " + versionFilePath)
        return None
    else:
        val = execute("get_key_value /etc.defaults/VERSION buildnumber")
        if 0 >= len(val):
            SYSLOG(syslog.LOG_ERR, "len > 0 :" + len(val))
            return None
        else:
            return val[0]

class RuleDictResult(DictResult):
    _non_comp_version = [DEFAULT_NON_COMP_VERSION]
    _group = [GROUP_COMPANY]
    _category = CATEGORY_SECURITY_SETTING
    _severity = LEVEL_WARNING
    _strId = 'rule_disallow_iframe'
    _non_comp_product = ['rt1900ac']

    try:
        _plat = getSynoInfoValue("unique")[0].split('_')[2]
        _version = getSynoBuildNumber()
        _version = int(_version)
        if 5565 <= _version:
            _strId = 'rule_disallow_iframe_v2'
        else:
            _strId = 'rule_disallow_iframe'
    except Exception as e:
        _strId = 'rule_disallow_iframe'

    def getStatus(self):
        resp = execWebAPI("SYNO.Core.Security.DSM.Embed", "get", 1)

        if not resp or not resp["success"]:
            return SZ_ERROR

        return SZ_PASS if resp["data"]["enable_block"] else SZ_FAIL

    def getMethod(self):
        method = {METHOD_ACTION: METHOD_ACTION_LINK,
				METHOD_ACTION_VAL: 'SYNO.SDS.AdminCenter.Application:SYNO.SDS.AdminCenter.Security.Main:DSMTab'}
        return method

    def getAction(self):
		action = {
			ACTION_STR_KEY : 'action',
			ACTION_REPLACE_VAR : {}
		}
		action[ACTION_REPLACE_VAR]['%0'] = "_T('dsmsetting', 'session_legend')"
		action[ACTION_REPLACE_VAR]['%1'] = "_T('dsmsetting', 'check_frame_options')"
		return action
