#!/usr/bin/env python
# coding: utf-8
# Copyright (c) 2000-2014 Synology Inc. All rights reserved.

from utils import *
from datetime import *

def getSynoBuildNumber():
    versionFilePath = '/etc.defaults/VERSION'
    if not os.path.isfile(versionFilePath):
        SYSLOG(syslog.LOG_ERR, "file not exist: " + versionFilePath)
        return None
    else:
        val = execute("get_key_value /etc.defaults/VERSION buildnumber")
        if 0 >= len(val):
            SYSLOG(syslog.LOG_ERR, "len > 0 :" + len(val))
            return None
        else:
            return val[0]

class RuleDictResult(DictResult):
    _non_comp_version = [DEFAULT_NON_COMP_VERSION]
    _group = [GROUP_HOME, GROUP_COMPANY]
    _category = CATEGORY_MALWARE
    _severity = LEVEL_DANGER
    _strId = "rule_dsm_self_check"

    try:
        _plat = getSynoInfoValue("unique")[0].split('_')[2]
        _version = getSynoBuildNumber()
        _version = int(_version)
        if 5565 <= _version:
            _strId = 'rule_dsm_self_check_v2'
        else:
            _strId = 'rule_dsm_self_check'
    except Exception as e:
        _strId = 'rule_dsm_self_check'

    _logPath = "/var/log/selfcheck/dsm.full.result"
    _errorFiles = []
    _WhiteList = ['/bin/zarafa-admin', '/bin/zarafa-fsck', '/bin/zarafa-passwd', '/bin/zarafa-archiver', '/bin/zarafa-gateway', '/bin/zarafa-server', '/bin/zarafa-autorespond', '/bin/zarafa-ical', '/bin/zarafa-spooler', '/bin/zarafa-dagent', '/bin/zarafa-monitor', '/bin/zarafa-stats', '/bin/zarafa-search']
    _knownList5565 = {
        '/lib/python2.7/site-packages/samba/dcerpc/atsvc.so': {
            'hash': '5074a72d98a79cc1f367b0d2860bde49f558857c'
        },
        '/lib/python2.7/site-packages/samba/dcerpc/auth.so': {
            'hash': 'a3fd0a110310955f96c1096ef8d55245a99ffd98'
        },
        '/lib/python2.7/site-packages/samba/dcerpc/dfs.so': {
            'hash': '38fa6279a1c3b1b373e033569983c4058505751a'
        },
        '/lib/python2.7/site-packages/samba/dcerpc/dns.so': {
            'hash': '38f548a1a3e67ed1f0409d95cd6bfb69f610508d'
        },
        '/lib/python2.7/site-packages/samba/dcerpc/dnsp.so': {
            'hash': '19dce0cbec643bfc5254e625d2ba01264b34a093'
        },
        '/lib/python2.7/site-packages/samba/dcerpc/dnsserver.so': {
            'hash': '4ef728d586f018f17fbda245dfc2a017c35f5f9c'
        },
        '/lib/python2.7/site-packages/samba/dcerpc/drsblobs.so': {
            'hash': '0f664d8decd6fededde4aa543a524b35cd5ede17'
        },
        '/lib/python2.7/site-packages/samba/dcerpc/drsuapi.so': {
            'hash': 'c28b462346f35619cad3cc17d1f790ef3facfb19'
        },
        '/lib/python2.7/site-packages/samba/dcerpc/echo.so': {
            'hash': 'd102394645b54f0111bd6d7ce8a0ebbce892e344'
        },
        '/lib/python2.7/site-packages/samba/dcerpc/epmapper.so': {
            'hash': 'ce2e587010b32ff2bdbb0e42a7a900904bc4815a'
        },
        '/lib/python2.7/site-packages/samba/dcerpc/idmap.so': {
            'hash': '87b1fc470f51e96973d1b423307c17d76bd7c2b2'
        },
        '/lib/python2.7/site-packages/samba/dcerpc/initshutdown.so': {
            'hash': '171c7c03cf9b9bc3f80f8c44d1a0e65c8ce1c01d'
        },
        '/lib/python2.7/site-packages/samba/dcerpc/irpc.so': {
            'hash': 'abd645a36e1e1ef3989cb59464d7d115d6150c67'
        },
        '/lib/python2.7/site-packages/samba/dcerpc/krb5pac.so': {
            'hash': 'f4530f34a3b6e937f50067f66e28ccd26e5f7812'
        },
        '/lib/python2.7/site-packages/samba/dcerpc/lsa.so': {
            'hash': '7696b54b1df237c7b4fd9d1bb2b05a1deff853e5'
        },
        '/lib/python2.7/site-packages/samba/dcerpc/mgmt.so': {
            'hash': '42b85cfa6642798f061d32dfdfc610b654246891'
        },
        '/lib/python2.7/site-packages/samba/dcerpc/misc.so': {
            'hash': '27ab0b43e45dd89c5d03062c4931c7956fb00d3a'
        },
        '/lib/python2.7/site-packages/samba/dcerpc/nbt.so': {
            'hash': 'e474cb035a4047f1ad65227f5d68efd09a15f4fd',
            'size': '172732'
        },
        '/lib/python2.7/site-packages/samba/dcerpc/netlogon.so': {
            'hash': '4d910197e8ee9d9227e9cb31da9f5ddcb6171ecb'
        },
        '/lib/python2.7/site-packages/samba/dcerpc/samr.so': {
            'hash': '928fb912aab1e3fcb0b18e9970e52d6617b83dc7'
        },
        '/lib/python2.7/site-packages/samba/dcerpc/security.so': {
            'hash': '6946bb4e9cf83e8556a4df8f021b7c3305009205'
        },
        '/lib/python2.7/site-packages/samba/dcerpc/server_id.so': {
            'hash': 'b314d038ed1131905341cb382b0ce8090ffef1b8'
        },
        '/lib/python2.7/site-packages/samba/dcerpc/smb_acl.so': {
            'hash': '2f219234c4b2d1bc4c6169f9fb20aa4a2dac2c86'
        },
        '/lib/python2.7/site-packages/samba/dcerpc/srvsvc.so': {
            'hash': '25e325fcbfb79fc4464a89cb3ed2699f47935d48'
        },
        '/lib/python2.7/site-packages/samba/dcerpc/svcctl.so': {
            'hash': 'a224482a8653083ff9010e0e8eaf7a5d4a67484b',
            'size': '106936',
        },
        '/lib/python2.7/site-packages/samba/dcerpc/unixinfo.so': {
            'hash': '4cd00f3c282e7710992435c053142b64759328b8'
        },
        '/lib/python2.7/site-packages/samba/dcerpc/winbind.so': {
            'hash': '750e03b69fe6a5bb5d08cc7b6416c2583fd1729c'
        },
        '/lib/python2.7/site-packages/samba/dcerpc/winreg.so': {
            'hash': '040c58ea094234161267691f2ddac9bd1a9f81bf',
            'size': '85508'
        },
        '/lib/python2.7/site-packages/samba/dcerpc/wkssvc.so': {
            'hash': 'cf4709d615604916b21571cf35ec95a7872cbad7'
        },
        '/lib/python2.7/site-packages/samba/dcerpc/xattr.so': {
            'hash': '5fd8c1ddaf4a7f97d37b4101712646fe390838d2'
        },
        '/lib/samba/libpopt_samba3.so': {
            'hash': '7ef07bbea4cf22fca81364f49033191ec28118e3'
        },
        '/lib/samba/libsmbd_base.so': {
            'hash': 'db1ae4e599dcfcf6bb45636b13fec1410df6db86'
        },
        '/usr/syno/synoman/webman/modules/StorageManager/volumehandler.cgi': {
            'hash': 'c5d24b603c216164a6e0200fbf4fa42284d4abad',
            'size': '96056'
        }
    }

    def getBuildNumber(self):
        return execute("get_key_value /etc.defaults/VERSION buildnumber")[0]

    def getStatus(self):
        if os.path.exists(self._logPath):
            os.unlink(self._logPath)

        execute("/usr/syno/bin/synoselfcheck dsm full")

        try:
            with open(self._logPath) as log:
                for line in log:
                    if not line.strip():
                        continue

                    filename = line.split(" ")[0]

                    if filename in self._WhiteList:
                        continue

                    if self.getBuildNumber() == "5565":
                        if filename in self._knownList5565:
                            obj = self._knownList5565[filename]
                            if 'hash' in obj and 'hash' in line and obj['hash'] in line:
                                continue
                            if 'size' in obj and 'size' in line and obj['size'] in line:
                                continue

                    if filename not in self._errorFiles:
                        self._errorFiles.append(filename)
        except Exception as e:
            SYSLOG(3, e)
            return SZ_ERROR

        return SZ_PASS if len(self._errorFiles) == 0 else SZ_FAIL

    def getMethod(self):
        return {
            METHOD_ACTION: METHOD_ACTION_LINK,
            METHOD_ACTION_VAL: 'SYNO.SDS.SupportForm.Application:SYNO.SDS.SupportForm.Application',
            METHOD_LINK_APP_STR: 'helptoc:support_center'
        }

    def getAction(self):
        return {ACTION_STR_KEY: 'action', ACTION_REPLACE_VAR: {
            '_FILES_': ', '.join(self._errorFiles)
        }}
