#!/usr/bin/python
#! coding: utf-8
# Copyright (c) 2000-2014 Synology Inc. All rights reserved.

from utils import *

class RuleDictResult(DictResult):
    _non_comp_version = [DEFAULT_NON_COMP_VERSION]
    _group = [GROUP_HOME, GROUP_COMPANY]
    _category = CATEGORY_SECURITY_SETTING
    _severity = LEVEL_WARNING
    _strId = 'rule_rc_file_check'

    """ please implement the following functions """
    def getStatus(self):
        files = self._search_()
        self._pass_ = len(files) == 0
        self._vars_ = {"%0": ", ".join(files)}

        return SZ_PASS if self._pass_ else SZ_FAIL
    def getMethod(self):
        method = {
            METHOD_ACTION: METHOD_ACTION_FIXME,
        }
        return method
    def getAction(self):
        if self._pass_:
            return {}
        else:
            action = {
                ACTION_STR_KEY : 'action',
                ACTION_REPLACE_VAR : self._vars_
            }
            return action
    def fixmeAction(self):
        import os

        files = self._search_()

        ## Comment all line by '#'
        ## NOTE: All file in __FILES__ will do
        ##    1. add prefix '#'
        ##    2. chmod to 000
        for path in files:
            with open(path) as f:
                lines = f.read().split('\n')
            with open(path, 'w') as f:
                lines = ["#%s" %_ for _ in lines]
                f.write("\n".join(lines))
            os.chmod(path, 0)

        return True

    def _search_(self):
        import os

        SZ_RC_LOCAL_PATH = "/etc/rc.local"
        SZ_USER_RC_FILE_PATH = "/usr/local/etc/rc.d"

        ret = []
        if self._check_(SZ_RC_LOCAL_PATH):
            ret += [SZ_RC_LOCAL_PATH]

        if os.path.isdir(SZ_USER_RC_FILE_PATH):
            for d in os.listdir(SZ_USER_RC_FILE_PATH):
                path = "%s/%s" %(SZ_USER_RC_FILE_PATH, d)
                if self._check_(path):
                    realPath = ''
                    if os.path.islink(path):
                        realPath = os.readlink(path)
                    if realPath:
                        path = "%s(%s)" % (path, realPath.split('/')[3])
                    else:
                        path = "%s(%s)" % (path, "Unknown Package")
                    ret += [path]
        return ret
    def _check_(self, path):
        import os

        if not os.path.isfile(path):
            return False
        else:
            with open(path) as f:
                lines = f.read().split("\n")
            for line in lines:
                if not line.startswith("#"):
                    return True
            else:
                return False

