#!/usr/bin/python
#! coding: utf-8
# Copyright (c) 2000-2014 Synology Inc. All rights reserved.

from utils import *

def getSynoBuildNumber():
    versionFilePath = '/etc.defaults/VERSION'
    if not os.path.isfile(versionFilePath):
        SYSLOG(syslog.LOG_ERR, "file not exist: " + versionFilePath)
        return None
    else:
        val = execute("get_key_value /etc.defaults/VERSION buildnumber")
        if 0 >= len(val):
            SYSLOG(syslog.LOG_ERR, "len > 0 :" + len(val))
            return None
        else:
            return val[0]

class RuleDictResult(DictResult):
    _non_comp_version = [DEFAULT_NON_COMP_VERSION]
    _group = [GROUP_HOME, GROUP_COMPANY]
    _category = CATEGORY_MALWARE
    _severity = LEVEL_DANGER
    _strId = 'rule_malware_profile_check'

    try:
        _plat = getSynoInfoValue("unique")[0].split('_')[2]
        _version = getSynoBuildNumber()
        _version = int(_version)
        if 5565 <= _version:
            _strId = 'rule_malware_profile_check_v2'
        else:
            _strId = 'rule_malware_profile_check'
    except Exception as e:
        _strId = 'rule_malware_profile_check'

    """ please implement the following functions """
    def getStatus(self):
        ret = self.RunCRoutine("ProfileCheck")
        self._pass_ = ret["status"] == "success"
        self._vars_ = ret["var"]

        return StrMap[ret["status"]]
    def getMethod(self):
        method = {
            METHOD_ACTION: METHOD_ACTION_FIXME,
        }
        return method
    def getAction(self):
        action = {
            ACTION_STR_KEY : 'action',
            ACTION_REPLACE_VAR : self._vars_
        }
        return action
    def fixmeAction(self):
        ret = self.RunCRoutine("ProfileCheck", runFixme=True)
        return 'success' == ret["status"]

