#!/bin/sh
# Copyright (c) 2000-2014 Synology Inc. All rights reserved.

LOCALARCH_DEST=""
LOCALARCH_ENABLE=false

SyslogLocalarchConfigGen(){
    LocalarchSettingGet "syslog-archive"
    LocalarchConfDataClear
    touch ${SYSLOGNG_CONFIG_ARCHIVE}
    LocalarchDestProcess
    LocalarchLogProcess
}

SyslogLocalarchConfigClr(){
    LocalarchConfDataClear
}

########################

LocalarchSettingGet(){
    synoservicecfg --is-enabled syslog-archive
    if [ "1" = "$?" ]; then
        LOCALARCH_ENABLE=true
    fi

    if [ -f "${SYSLOGNG_SERVER_SETTING}" ]; then
        LOCALARCH_DEST=`/bin/get_key_value ${SYSLOGNG_SERVER_SETTING} arch_dest`
    else
        echo "Syslog setting file does not exist!";
        exit 1;
    fi
    if [ ! -e "$LOCALARCH_DEST" ]; then
        local RegisterShare=`synoservicecfg --get-field-info "${1}" share | sed 's/\[\(.*\)\]/\1/'`
        local SharePath=`synoshare --get $RegisterShare | grep 'Path .......' |sed 's/\s*Path \.\.\.\.\.\.\.\[\(.*\)\]/\1/'`
        local SlashNum=$((`echo "${SharePath}" | grep -o "/" |wc -l` + 2))
        local SubPath=`echo $LOCALARCH_DEST | cut -d'/' -f${SlashNum}-`
        if [ -z $SubPath ] ; then
            LOCALARCH_DEST=${SharePath}
        else
            LOCALARCH_DEST=${SharePath}'/'${SubPath}
        fi
    fi
}

LocalarchConfDataClear(){
    rm -rf ${SYSLOGNG_CONFIG_ARCHIVE} > /dev/null 2>&1
}

LocalarchDestProcess(){
    cat ${SYSLOGNG_ARCHIVE_TEMPLATE_FOLDER}/arch_dest_db.template | sed -e "s=__SYNO_DB_PATH__=${LOCALARCH_DEST}/SYNOSYSLOGDB__LOCALARCH.DB=" >> ${SYSLOGNG_CONFIG_ARCHIVE}
}

LocalarchLogProcess(){
    echo "log { source(s_syno_syslog); destination(d_syno_local_arch_db); flags(flow_control); };" >> ${SYSLOGNG_CONFIG_ARCHIVE}
}
