/* Copyright (c) 2015 Synology Inc. All rights reserved. */

Ext.ns("SYNO.SDS.ResourceMonitor.Performance.Chart");Ext.define("SYNO.SDS.ResourceMonitor.Performance.Detail.Header",{extend:"Ext.Container",constructor:function(a){var c=this;var b=Ext.apply({layout:{type:"hbox",pack:"end"},height:32,style:"margin: 5px 0px 0px 0px;",topLayer:a.topLayer,items:[],listeners:{activate:this.onActivate,scope:this}},a.config);if(!Ext.isEmpty(a.type_combo)){c.type_label=c.createTypeLabel();c.type_combo=c.createTypeCombo(a.type_combo.data);b.items.push(c.type_label);b.items.push(c.type_combo)}c.history_combo=c.createHistoryCombo();c.history_label=c.createHistoryLabel();b.items.push(c.history_label);b.items.push(c.history_combo);this.callParent([b])},createHistoryLabel:function(){return new SYNO.ux.DisplayField({style:"text-align: right;",value:_T("rsrcmonitor","time_range")+":",hidden:true})},createHistoryCombo:function(){return new SYNO.ux.ComboBox({xtype:"syno_combobox",itemId:"history_combo",width:150,margins:{top:0,right:0,bottom:0,left:10},triggerAction:"all",editable:false,valueField:"history",displayField:"displayText",value:"current",mode:"local",autoScroll:false,hidden:true,store:new Ext.data.ArrayStore({fields:["history","displayText"],data:[["current",_T("rsrcmonitor","realtime")],["day",_T("rsrcmonitor","last_24_hours")],["week",_T("rsrcmonitor","last_7_days")],["month",_T("rsrcmonitor","last_30_days")],["year",_T("rsrcmonitor","last_12_months")]]}),listeners:{select:{scope:this,fn:this.headerChange}}})},createTypeLabel:function(){return new SYNO.ux.DisplayField({style:"text-align: right;",value:_T("rsrcmonitor","chart")+":"})},createTypeCombo:function(a){return new SYNO.ux.ComboBox({itemId:"type_combo",width:185,margins:{top:0,right:20,bottom:0,left:10},triggerAction:"all",editable:false,mode:"local",autoScroll:false,valueField:"type",displayField:"displayText",value:a[0][0],store:new Ext.data.ArrayStore({fields:["type","displayText"],data:a}),listeners:{select:{scope:this,fn:this.headerChange}}})},headerChange:function(){var a=this.getContentConfig();this.topLayer.setTimeRange(a.history);this.fireEvent("contentSelect",a)},reloadContent:function(a){if(this.history_combo){this.history_combo.setValue(a.history)}if(this.type_combo){this.type_combo.setValue(a.type)}this.fireEvent("contentSelect",a)},getContentConfig:function(){var a={};if(this.history_combo){a.history=this.history_combo.value}else{a.history="current"}if(this.type_combo){a.type=this.type_combo.value}return a},setToRealTime:function(){var a=this;if(!a.history_combo){return}a.history_combo.setValue("current");a.headerChange()},onActivate:function(){var a=this.getContentConfig();if(this.history_combo.hidden){return}if(a.history!==this.topLayer.time_range){a.history=this.topLayer.time_range;this.reloadContent(a)}}});Ext.define("SYNO.SDS.ResourceMonitor.Performance.Chart.Current",{extend:"Ext.Panel",totalTime:180,constructor:function(d){var e=this,b={},a,c=0;b={store:[],border:false,dataType:"normal"};Ext.apply(b,d);this.callParent([b]);if(d.lines){for(c=0;c<d.lines.length;++c){a=d.lines[c];e.store.push(new SYNO.SDS.ResourceMonitor.Performance.DataSet({totalTime:e.totalTime,lineType:a.lineType,itemId:a.itemId||"store"+c,color:a.color,trackColor:a.trackColor||a.color,trackOrder:a.trackOrder||0,lineName:a.lineName}))}}},initEvents:function(){var a=this;SYNO.SDS.ResourceMonitor.Performance.Chart.Current.superclass.initEvents.call(this,arguments);a.mon(a,"resize",a.drawChart,a);a.mon(a.topLayer.appWin,"server_change",a.clearStoreData,a)},drawChart:function(){var c=this,b=[],a=0;if(c.isDestroyed||!c.body||c.body.getSize(true).width<=1||c.body.getSize(true).height<=1){return}for(a=0;a<c.store.length;++a){b.push(c.store[a].genSeries())}Flotr.draw(c.body.dom,b,c.getChartType())},updateStores:function(d){var c=this,a=0,b=false;Ext.each(c.store,function(e){b=d.every(function(g,f,h){return e.itemId!==g.itemId});if(b){return false}});if(!b&&d.length===c.store.length){return}c.store=[];for(a=0;a<d.length;++a){c.store.push(new SYNO.SDS.ResourceMonitor.Performance.DataSet({totalTime:c.totalTime,lineType:d[a].lineType,color:d[a].color,itemId:d[a].itemId,lineName:d[a].lineName}))}},pushValueById:function(c,d){var b=this,a=0;Ext.each(c,function(f,e,g){for(a=0;a<b.store.length;++a){if(b.store[a].itemId===f.itemId){b.store[a].pushData(f.value,d);return}}})},pushValue:function(d,e){var c=this,b=0,a=0;for(b=c.store.length-1;b>=0;--b){c.store[b].pushData(d[b]+a,e);if(c.aggregate){a+=d[b]}}},clearStoreData:function(){var b=this,a=0;for(a=b.store.length-1;a>=0;--a){b.store[a].clear()}},getChartType:function(){var d=this,c={},a=0,b=0,e=0;c.mouse={track:true,trackAll:true,position:"nw",sensibility:2,radius:0,lineColor:null,trackFormatter:d.trackFormatter.createDelegate(d),trackStyle:""};c.crosshair={mode:"x",color:"#FA4444",hideCursor:false,lineWidth:2};c.shadowSize=0;a=(d.store[0])?d.store[0].getLastTime():0;b=a-d.totalTime;c.xaxis={min:b,max:a,noTicks:0,minLabelHeight:14};c.grid={verticalLines:false,horizontalLines:true,color:"#b4bec8",outlineWidth:1,backgroundColor:"#f5faff"};switch(d.dataType){case"percent":c.yaxis={min:0,max:100,noTicks:5,minLabelWidth:21,color:"#505a64"};break;case"bytes":e=d.getMaxDataValue();if(!Ext.isNumber(e)||e<100*1024){e=100*1024}else{e=e*1.1}c.yaxis={max:e,min:0,tickDecimals:0,noTicks:5,minLabelWidth:21,mode:"bytes",color:"#505a64"};break;case"normal":e=d.getMaxDataValue();if(!Ext.isNumber(e)||e<10){e=10}else{e=e*1.1}c.yaxis={max:e,min:0,tickDecimals:0,noTicks:5,minLabelWidth:21,color:"#505a64"};break;default:return}c.y2axis={showLabels:false};if(d.chartTitle){c.title=d.chartTitle;c.titleCls="performance-chart-title"}return c},getMaxDataValue:function(){var c=this,a=0,b=0;for(b=0;b<c.store.length;++b){if(a<c.store[b].getMaxDataValue()){a=c.store[b].getMaxDataValue()}}return a},trackFormatter:function(d){var i=this,f=d.nearest.allSeries,g=d.index,e=[],b,c=0,h=0,j,a=[];if(0===d.index&&d.mx+1<d.x){return""}b=new Date(f[0].data[g][0]*1000);b=b.format("Y/m/d H:i:s");for(h=f.size()-1;h>=0;--h){e[h]=f[h].data[g][1]-c;if(i.aggregate){c+=e[h]}}for(h=0;h<f.size();++h){if("percent"===i.dataType){j=e[h]+"%"}else{if("bytes"===i.dataType){j=Ext.util.Format.fileSize(e[h])+"/s"}else{if("normal"===i.dataType){j=e[h]}}}a.push({name:f[h].lineName,value:j,color:f[h].trackColor||f[h].color,order:f[h].trackOrder||0})}a=a.sort(function(l,k){return(l.order>k.order)?1:-1});return SYNO.SDS.ResourceMonitor.Performance.Chart.Util.getStyledInfoList(b,a)}});Ext.define("SYNO.SDS.ResourceMonitor.Performance.Chart.History",{extend:"Ext.Panel",aggregate:false,lines:[],timeAxis:"day",dataType:"percent",dataBase:1,data:{},dataSize:0,constructor:function(b){var a={border:false};Ext.apply(a,b);this.callParent([a])},initEvents:function(){var a=this;SYNO.SDS.ResourceMonitor.Performance.Chart.History.superclass.initEvents.call(this,arguments);a.mon(a,"resize",function(){if(a.data){a.drawChart()}},a)},setChartConfig:function(a){var b=this;if(!a){return false}if(Ext.isDefined(a.aggregate)){b.aggregate=a.aggregate}if(Ext.isDefined(a.lines)){b.lines=a.lines}if(Ext.isDefined(a.timeAxis)){b.timeAxis=a.timeAxis}if(Ext.isDefined(a.dataType)){b.dataType=a.dataType}if(Ext.isDefined(a.dataBase)){b.dataBase=a.dataBase}if(Ext.isDefined(a.data)){b.data=a.data}if(Ext.isDefined(a.dataSize)){b.dataSize=a.dataSize}if(Ext.isDefined(a.endTime)){b.endTime=a.endTime}if(Ext.isDefined(a.timeInterval)){b.timeInterval=a.timeInterval}if(Ext.isDefined(a.chartTitle)){b.chartTitle=a.chartTitle}else{b.chartTitle=null}},drawChart:function(){var b=this,c=0,a;if(b.isDestroyed||!b.body||b.body.getSize(true).width<=1||b.body.getSize(true).height<=1){return}a=b.genSeries();c=b.getMaxDataValue(a);Flotr.draw(b.body.dom,a,b.getChartType(c))},genSeries:function(){var m=this,g=[],f=m.data,h=0,e=0,n=m.lines.length,d=[],k,c=new Date(),a=m.endTime,l=c.getTimezoneOffset()*60,b=1;if("bytes"===m.dataType){b=m.dataBase}if(m.aggregate){f=m.aggregateData()}for(h=0;h<n;++h){d=[];k=m.lines[h].itemId;a=m.endTime;if(!Ext.isDefined(f[k])){continue}for(e=f[k].size()-1;e>=0;--e){d.push([(a-l)*1000,f[k][e]*b]);a-=m.timeInterval}g.push({data:d.reverse(),lines:m.lines[h].lineType,color:m.lines[h].color,lineName:m.lines[h].lineName,trackColor:m.lines[h].trackColor||m.lines[h].color,trackOrder:m.lines[h].trackOrder||0})}return g},aggregateData:function(){var d=this,c=0,b=0,a=d.lines.length,f=0,e=SYNO.Util.copy(d.data);for(c=0;c<d.dataSize;++c){f=0;for(b=a-1;b>=0;--b){f+=e[d.lines[b].itemId][c];e[d.lines[b].itemId][c]=f}}return e},getChartType:function(c){var b=this,a={};a.mouse={track:true,trackAll:true,position:"nw",sensibility:2,radius:0,lineColor:null,trackFormatter:b.trackFormatter.createDelegate(b),trackStyle:""};a.crosshair={mode:"x",color:"#FA4444",hideCursor:false,lineWidth:2};a.shadowSize=0;a.grid={verticalLines:false,horizontalLines:true,color:"#b4bec8",outlineWidth:1,backgroundColor:"#f5faff"};switch(b.timeAxis){case"day":a.xaxis={mode:"time",timeFormat:"%H",noTicks:12,minLabelHeight:14};break;case"week":a.xaxis={mode:"time",timeFormat:"%d",noTicks:7,minLabelHeight:14};break;case"month":a.xaxis={mode:"time",timeFormat:"%d",noTicks:15,minLabelHeight:14};break;case"year":a.xaxis={mode:"time",timeFormat:"%b",noTicks:12,minLabelHeight:14};break;default:return}switch(b.dataType){case"percent":a.yaxis={min:0,max:100,minLabelWidth:21,noTicks:5,color:"#505a64"};break;case"bytes":if(!Ext.isNumber(c)||c<100*1024){c=100*1024}else{c=c*1.1}a.yaxis={max:c,min:0,tickDecimals:0,noTicks:5,minLabelWidth:21,mode:"bytes",color:"#505a64"};break;case"normal":if(!Ext.isNumber(c)||c<10){c=10}else{c=c*1.1}a.yaxis={max:c,min:0,tickDecimals:0,noTicks:5,minLabelWidth:21,color:"#505a64"};break;default:return}a.y2axis={showLabels:false};if(b.chartTitle){a.title=b.chartTitle;a.titleCls="performance-chart-title"}return a},getMaxDataValue:function(d){var c=0,b=0,a=0;for(c=0;c<d.length;++c){for(b=0;b<d[c].data.length;++b){if(a<d[c].data[b][1]){a=d[c].data[b][1]}}}return a},trackFormatter:function(d){var j=this,f=d.nearest.allSeries,g=d.index,e=[],c=0,h=0,b=new Date(),i=b.getTimezoneOffset()*60*1000,a=[],k;for(h=f.size()-1;h>=0;--h){e[h]=f[h].data[g][1]-c;if(j.aggregate){c+=e[h]}}for(h=0;h<f.size();++h){if("percent"===j.dataType){k=e[h]+"%"}else{if("bytes"===j.dataType){k=Ext.util.Format.fileSize(e[h])}else{if("normal"===j.dataType){k=e[h]}}}a.push({name:f[h].lineName,color:f[h].trackColor||f[h].color,order:f[h].trackOrder||0,value:k})}a=a.sort(function(m,l){return(m.order>l.order)?1:-1});b=new Date(f[0].data[g][0]+i);b=b.format("Y/m/d H:i");return SYNO.SDS.ResourceMonitor.Performance.Chart.Util.getStyledInfoList(b,a)}});SYNO.SDS.ResourceMonitor.Performance.Chart.Util={getStyledInfoList:function(b,d){var c,a;c='<table class="info-list-table">';c+='<tr><td class="info-list-top-l"></td><td colspan="2" class="info-list-top-m"></td><td class="info-list-top-r"></td></tr>';c+='<tr><td class="info-list-time-l"></td><td colspan="2" class="info-list-time-text">'+b+'</td><td class="info-list-time-r"></td></tr>';for(a=0;a<d.size();++a){c+='<tr style="color:'+d[a].color+'"><td class="info-list-content-l"></td><td class="info-list-content-name">'+d[a].name+'</td><td align="right" class="info-list-content-value">'+d[a].value+'</td><td class="info-list-content-r"></td></tr>'}c+='<tr><td class="info-list-bottom-l"></td><td colspan="2" class="info-list-bottom-m"></td><td class="info-list-bottom-r"></td></tr>';c+="</table>";return c}};Ext.define("SYNO.SDS.ResourceMonitor.Performance.DataSet",{extend:"Ext.util.Observable",constructor:function(b){this.data=[];var a=Ext.apply({totalTime:180,lineType:{}},b);Ext.apply(this,a);this.callParent([a])},pushData:function(d,e){var c=this,a=e-c.totalTime,b=0;if(c.getLastTime()>=e){c.data=[]}c.data.push([e,d]);for(b=0;c.data[b][0]<a;++b){}if(2<=b){c.data=c.data.slice(b-2)}},genSeries:function(){var a=this;return{data:a.data,lines:a.lineType,lineName:a.lineName,color:a.color,trackColor:a.trackColor||a.color,trackOrder:a.trackOrder||1}},getLastTime:function(){var a=this;if(a.data.length>0){return a.data[a.data.length-1][0]}else{return 0}},getMaxDataValue:function(){var b=this,c=0,a=0;for(a=0;a<b.data.length;++a){if(b.data[a][1]>c){c=b.data[a][1]}}return c},clear:function(){this.data.clear()},getLastDataValue:function(){if(this.data.last()){return this.data.last()[1]}return 0}});SYNO.SDS.ResourceMonitor.Performance.TotalTime=3*60;Ext.define("SYNO.SDS.ResourceMonitor.Performance.Overview.Main",{extend:"Ext.Container",constructor:function(f){var e={xtype:"box",height:33,border:false};var c=new SYNO.SDS.ResourceMonitor.Performance.Overview.RowOne({topLayer:f.topLayer,appWin:f.appWin,flex:1});var a={xtype:"box",height:9,border:false};var d=new SYNO.SDS.ResourceMonitor.Performance.Overview.RowTwo({topLayer:f.topLayer,appWin:f.appWin,flex:1});var b=Ext.apply({layout:"vbox",layoutConfig:{align:"stretch"},items:[e,c,a,d,e],listeners:{activate:this.onActivate,scope:this}},f);this.callParent([b])},onActivate:function(){this.items.each(function(a){if(Ext.isFunction(a.onActivate)){a.onActivate()}},this)}});Ext.define("SYNO.SDS.ResourceMonitor.Performance.Overview.RowOne",{extend:"Ext.Container",constructor:function(d){var b=new SYNO.SDS.ResourceMonitor.Performance.Overview.CPU({itemId:"cpu",topLayer:d.topLayer,flex:1});var e=new SYNO.SDS.ResourceMonitor.Performance.Overview.Memory({itemId:"memory",topLayer:d.topLayer,flex:1});var f=new SYNO.SDS.ResourceMonitor.Performance.Overview.Disk({itemId:"disk",topLayer:d.topLayer,fillColor:"#f23a6d",flex:1});var a={xtype:"box",width:18,border:false};var c=Ext.apply({layout:"hbox",layoutConfig:{align:"stretch"},items:[b,a,e,a,f]},d);this.callParent([c])},onActivate:function(){this.items.each(function(a){if(Ext.isFunction(a.onActivate)){a.onActivate()}},this)}});Ext.define("SYNO.SDS.ResourceMonitor.Performance.Overview.RowTwo",{extend:"Ext.Container",constructor:function(d){var b={xtype:"box",flex:1},a={xtype:"box",width:18,border:false};var c=Ext.apply({layout:"hbox",layoutConfig:{align:"stretch"},items:[]},d);if("yes"!==d.appWin._D("usbstation")){c.items.push(new SYNO.SDS.ResourceMonitor.Performance.Overview.Disk({itemId:"space",topLayer:d.topLayer,summary_title:("yes"===_D("support_iscsi_target","no"))?_T("rsrcmonitor","space"):_T("tree","leaf_volume"),colors:["#5a4878"],fillColor:"#6940b2",dataRoot:"space",flex:1}));c.items.push(a)}c.items.push(new SYNO.SDS.ResourceMonitor.Performance.Overview.Network({itemId:"network",topLayer:d.topLayer,flex:1}));if("yes"===d.appWin._D("usbstation")){c.items.push(a);c.items.push(b)}c.items.push(a);c.items.push(b);this.callParent([c])},onActivate:function(){this.items.each(function(a){if(Ext.isFunction(a.onActivate)){a.onActivate()}},this)}});Ext.define("SYNO.SDS.ResourceMonitor.Performance.Overview.Base",{extend:"Ext.Panel",summary_title:"Base",colors:["#00A8F0"],totalTime:SYNO.SDS.ResourceMonitor.Performance.TotalTime,lastChartData:null,defaultSelect:false,constructor:function(b){var a=Ext.apply({border:false,layout:"vbox",items:[{itemId:"header",xtype:"box",height:18},{itemId:"chart",xtype:"box",flex:1},{itemId:"footer",xtype:"box",height:24}],listeners:{scope:this,afterRender:{fn:function(){this.body.removeClass("x-panel-body")}}}},b);this.callParent([a])},initEvents:function(){SYNO.SDS.ResourceMonitor.Performance.Overview.Base.superclass.initEvents.apply(this,arguments);var a=this;a.mon(a.topLayer,"data_comming",function(b){a.updateData(b)});a.mon(a.topLayer,"resize",a.drawResize,a);a.mon(a.topLayer.appWin,"server_change",a.clearLastData,a)},drawResize:function(){var b=this,a=b.get("chart");if(null===b.lastChartData){return}if(b.isDestroyed||!b.topLayer.isVisible()||!b.isVisible()){return}if("overview_main"!==b.topLayer.activeTab.itemId){return}b.updateChartWidth();b.doLayout();b.flotr=Flotr.draw(a.getEl().dom,b.lastChartData.series,b.lastChartData.chartType)},drawChart:function(b,e,d,a){var f=this,c=f.get("chart"),h=f.get("header"),g=f.get("footer");f.lastChartData={series:b,chartType:e,header:d,footer:a};if(f.isDestroyed||!f.topLayer.isVisible()||!f.isVisible()){return}if("overview_main"!==f.topLayer.activeTab.itemId){return}h.update(d);g.update(a);f.updateChartWidth();f.doLayout();f.flotr=Flotr.draw(c.getEl().dom,b,e)},updateChartWidth:function(){var a=this.get("chart"),c=this.get("header"),b=this.get("footer");a.setWidth(this.getWidth());c.setWidth(this.getWidth());b.setWidth(this.getWidth())},getChartType:function(){return{colors:this.colors,grid:{color:"#b4bec8",outlineWidth:1,backgroundColor:"#f5faff"},maxOutset:1,xaxis:{showLabels:false,noTicks:0,max:this.totalTime,min:0},yaxis:{showLabels:false,noTicks:5,max:100,min:0},x2axis:{showLabels:false},y2axis:{showLabels:false},shadowSize:0}},clearLastData:function(){var a=this;if(a.lastChartData){a.lastChartData.series.each(function(b){b.data.clear()},a)}},onActivate:function(){var a=this;if(null===a.lastChartData){return}a.drawChart(a.lastChartData.series,a.lastChartData.chartType,a.lastChartData.header,a.lastChartData.footer)}});Ext.define("SYNO.SDS.ResourceMonitor.Performance.Overview.CPU",{extend:"SYNO.SDS.ResourceMonitor.Performance.Overview.Base",summary_title:_T("rsrcmonitor","cpu"),colors:["#479ea1"],constructor:function(a){this.callParent([a]);this.usageSet=new SYNO.SDS.ResourceMonitor.Performance.DataSet({lineType:{lineWidth:1,fill:true,fillColor:"#23dfd4",fillOpacity:0.7}})},updateData:function(h){if(!h.time||!h.cpu){return}var d=this,g=h.time,f=h.cpu,c=d.getChartType(),e=f.user_load+f.system_load,b,a;d.usageSet.pushData(e,g);c.xaxis.max=d.usageSet.getLastTime();c.xaxis.min=c.xaxis.max-d.totalTime;b='<div class="cpu-title">'+d.summary_title+"</div>";a="<div><span class=cpu-content>"+_T("rsrcmonitor","utilization")+"&nbsp(%)</span><span class=cpu-content-value>"+e+"%</span></div>";d.drawChart([d.usageSet.genSeries()],c,b,a)}});Ext.define("SYNO.SDS.ResourceMonitor.Performance.Overview.Memory",{extend:"SYNO.SDS.ResourceMonitor.Performance.Overview.Base",summary_title:_T("rsrcmonitor","memory"),colors:["#b29446"],constructor:function(a){this.callParent([a]);this.usageSet=new SYNO.SDS.ResourceMonitor.Performance.DataSet({lineType:{lineWidth:1,fill:true,fillColor:"#fdc125",fillOpacity:0.7}})},updateData:function(h){if(!h.time||!h.memory){return}var d=this,f=h.memory,g=h.time,c=d.getChartType(),e=f.real_usage,b,a;d.usageSet.pushData(e,g);c.xaxis.max=d.usageSet.getLastTime();c.xaxis.min=c.xaxis.max-d.totalTime;b='<div class="mem-title">'+d.summary_title+"</div>";a="<div><span class=mem-content>"+_T("rsrcmonitor","utilization")+"&nbsp(%)</span><span class=mem-content-value>"+e+"%</span></div>";d.drawChart([d.usageSet.genSeries()],c,b,a)}});Ext.define("SYNO.SDS.ResourceMonitor.Performance.Overview.Disk",{extend:"SYNO.SDS.ResourceMonitor.Performance.Overview.Base",summary_title:_T("rsrcmonitor","disk"),colors:["#93465c"],dataRoot:"disk",constructor:function(a){this.callParent([a]);this.utilsSet=new SYNO.SDS.ResourceMonitor.Performance.DataSet({lineType:{lineWidth:1,fillColor:a.fillColor,fill:true,fillOpacity:0.7}})},updateData:function(h){if(!h.time||!h){return}var e=this,f=h[e.dataRoot],g=h.time,d=e.getChartType(),a,b,c;if(!f.total||!h[e.dataRoot]){return}a=f.total.utilization;e.utilsSet.pushData(a,g);d.xaxis.max=e.utilsSet.getLastTime();d.xaxis.min=d.xaxis.max-e.totalTime;c='<div class="disk-title">'+this.summary_title+"</div>";b="<div><span class=disk-content>"+_T("rsrcmonitor","utilization")+"&nbsp(%)</span><span class=disk-content-value>"+a+"%</span></div>";e.drawChart([e.utilsSet.genSeries()],d,c,b)}});Ext.define("SYNO.SDS.ResourceMonitor.Performance.Overview.Network",{extend:"SYNO.SDS.ResourceMonitor.Performance.Overview.Base",summary_title:_T("rsrcmonitor","network"),colors:["#64803d"],constructor:function(a){this.callParent([a]);this.speedSet=new SYNO.SDS.ResourceMonitor.Performance.DataSet({lineType:{lineWidth:1,fillColor:"#85c728",fill:true,fillOpacity:0.7}})},updateData:function(d){if(!d.time||!d.network){return}var k=this,h=d.network,c=d.time,j=k.getChartType(),a=0,e=0,f=0,g=0,b;for(g=0;g<h.length;++g){if("total"===h[g].device){e=h[g].rx;f=h[g].tx;break}}if("total"!==h[g].device){return}k.speedSet.pushData(e+f,c);j.xaxis.max=k.speedSet.getLastTime();j.xaxis.min=j.xaxis.max-k.totalTime;a=k.speedSet.getMaxDataValue()*1.1;if(a<100*1024){a=100*1024}j.yaxis.max=a;b='<div class="network-title">'+this.summary_title+"</div>";k.drawChart([k.speedSet.genSeries()],j,b,k.getOverviewHtml(h[g]))},getOverviewHtml:function(a){return"<div><span class=network-content-out>"+Ext.util.Format.fileSize(a.tx)+"/s</span><span class=network-content-in>"+Ext.util.Format.fileSize(a.rx)+"/s</span></div>"}});Ext.define("SYNO.SDS.ResourceMonitor.Performance.CPU.Main",{extend:"Ext.Container",constructor:function(b){var a=Ext.apply({layout:"anchor",items:[],listeners:{activate:this.onActivate,scope:this}},b);this.callParent([a])},createComponent:function(c){var d=this,a=c.showHistory,b=false;if(!d.chartHeader){d.chartHeader=new SYNO.SDS.ResourceMonitor.Performance.Detail.Header({header_title:_T("rsrcmonitor","cpu"),topLayer:c.topLayer});d.add(d.chartHeader);if(!d.content){d.content=new SYNO.SDS.ResourceMonitor.Performance.CPU.Content({topLayer:c.topLayer,anchor:"100% -37",header:d.chartHeader});d.add(d.content)}b=true}else{d.chartHeader.setToRealTime()}if(a===d.chartHeader.history_combo.hidden){if(a){d.chartHeader.history_combo.show();d.chartHeader.history_label.show()}else{d.chartHeader.history_combo.hide();d.chartHeader.history_label.hide()}b=true}if(b){d.doLayout(false,true)}},onActivate:function(){this.items.each(function(a){if(Ext.isFunction(a.onActivate)){a.onActivate()}},this)}});Ext.define("SYNO.SDS.ResourceMonitor.Performance.CPU.Content",{extend:"Ext.Container",constructor:function(b){var a={layout:"card",activeItem:0,items:[new SYNO.SDS.ResourceMonitor.Performance.CPU.Current({itemId:"current",topLayer:b.topLayer,controlLayer:this}),new SYNO.SDS.ResourceMonitor.Performance.CPU.History({itemId:"history",topLayer:b.topLayer,controlLayer:this})]};Ext.apply(a,b);this.callParent([a]);this.mon(b.header,"contentSelect",this.changeContent,this)},changeContent:function(a){if("current"===a.history){this.layout.setActiveItem("current")}else{this.layout.setActiveItem("history");this.get("history").setType(a.history)}},setToRealTime:function(){this.header.setToRealTime()},onActivate:function(){var a=this.layout.activeItem;if(Ext.isDefined(a)&&Ext.isFunction(a.onActivate)){a.onActivate()}}});Ext.define("SYNO.SDS.ResourceMonitor.Performance.CPU.Current",{extend:"Ext.Panel",constructor:function(b){this.chart=new SYNO.SDS.ResourceMonitor.Performance.Chart.Current({itemId:"total_chart",chartTitle:_T("rsrcmonitor","utilization")+" (%)",flex:1,topLayer:b.topLayer,aggregate:true,totalTime:SYNO.SDS.ResourceMonitor.Performance.CurrentTotalTime,lines:[{itemId:"cpu_others",lineName:_T("rsrcmonitor","iowait"),color:"#3d85cc",trackColor:"#3d85cc",trackOrder:3,lineType:{lineWidth:0,fill:true,fillOpacity:1}},{itemId:"cpu_system",lineName:_T("rsrcmonitor","cpu_system"),color:"#55b1f2",trackColor:"#55b1f2",trackOrder:2,lineType:{fill:true,fillOpacity:1,lineWidth:1}},{itemId:"cpu_user",lineName:_T("rsrcmonitor","cpu_user"),color:"#aee239",trackColor:"#aee239",trackOrder:1,lineType:{fill:true,fillOpacity:1,lineWidth:1}}],dataType:"percent"});var a={layout:"vbox",layoutConfig:{align:"stretch"},border:false,items:[this.chart,new SYNO.SDS.ResourceMonitor.Performance.CPU.Current.Footer({itemId:"footer",topLayer:b.topLayer,height:115})]};Ext.apply(a,b);this.callParent([a])},initEvents:function(){var a=this;SYNO.SDS.ResourceMonitor.Performance.CPU.Current.superclass.initEvents.apply(a,arguments);a.mon(a.topLayer,"data_comming",function(b){a.updateData(b)});a.mon(a,"activate",a.onActivate,a)},updateData:function(c){if(!c.time||!c.cpu){return}var a=this,b=c.cpu,d=c.time;a.chart.pushValue([b.other_load,b.system_load,b.user_load],d);a.chart.drawChart()},onActivate:function(){this.chart.drawChart()}});Ext.define("SYNO.SDS.ResourceMonitor.Performance.CPU.Current.Footer",{extend:"Ext.Panel",constructor:function(a){var c=this;this.legendId={};var b={layout:"hbox",border:false,margins:{top:0,right:0,bottom:0,left:25},items:[{xtype:"box",itemId:"util_table",height:96,minWidth:246,border:false,html:c.createUtilTbl()},{xtype:"box",border:false,height:50,flex:1},{xtype:"box",itemId:"load_table",height:96,minWidth:246,border:false,html:c.createLoadAvarageTbl()}]};Ext.apply(b,a);this.callParent([b])},initEvents:function(){SYNO.SDS.ResourceMonitor.Performance.CPU.Current.Footer.superclass.initEvents.apply(this,arguments);var a=this;a.mon(a.topLayer,"data_comming",function(b){a.updateData(b)})},updateData:function(e){if(!e.cpu){return}var b=this,d=e.cpu,a={},c={};a={utilization:d.user_load+d.system_load,user:d.user_load,system:d.system_load,others:d.other_load};c={"1min":Math.round(d["1min_load"])/100,"5min":Math.round(d["5min_load"])/100,"15min":Math.round(d["15min_load"])/100};b.updateUtilTbl(a);b.updateLoadAvarageTbl(c);b.doLayout()},createUtilTbl:function(){var c=this,b=c.legendId,a;b.util=Ext.id();b.user=Ext.id();b.system=Ext.id();b.others=Ext.id();a='<table class="legend-header"> <tbody><tr><td>'+_T("rsrcmonitor","utilization")+'</td><td style="float: right;"><span id='+b.util+' class="legend-header-value">0</span><span class="legend-value-unit-large" style="padding-left: 8px;">%</td></tr></tbody> </table><div class="legend-header-bar"></div><table class="legend-util-content"> <tbody><tr><td rowspan="2" class="legend-color-user legend-color-item"></td><td class="legend-value-header" style="min-width: 72px; width: 72px;">'+_T("rsrcmonitor","cpu_user")+'</td><td rowspan="2" class="legend-color-system legend-color-item"></td><td class="legend-value-header" style="min-width: 72px; width: 72px;">'+_T("rsrcmonitor","cpu_system")+'</td><td rowspan="2" class="legend-color-others legend-color-item"></td><td class="legend-value-header" style="min-width: 72px; width: 72px;">'+_T("rsrcmonitor","iowait")+"</td></tr><tr><td><span id="+b.user+' class="legend-value">0</span><span class="legend-value-unit">%</span></td><td><span id='+b.system+' class="legend-value">0</span><span class="legend-value-unit">%</span></td><td><span id='+b.others+' class="legend-value">0</span><span class="legend-value-unit">%</span></td></tr></tbody> </table>';return a},updateUtilTbl:function(a){var b=this;Ext.fly(b.legendId.util).update(""+a.utilization);Ext.fly(b.legendId.user).update(""+a.user);Ext.fly(b.legendId.system).update(""+a.system);Ext.fly(b.legendId.others).update(""+a.others)},createLoadAvarageTbl:function(){var c=this,b=c.legendId,a;b._1min=Ext.id();b._5min=Ext.id();b._15min=Ext.id();a='<table class="legend-header"> <tbody><tr><td>'+_T("rsrcmonitor","load_average")+'</td></tr></tbody> </table><div class="legend-header-bar"></div><table class="legend-avg-content"> <tbody><tr><td rowspan="2" class="legend-color-average legend-color-item"></td><td class="legend-value-header" style="min-width: 72px; width: 72px;">1 '+_T("rsrcmonitor","minute")+'</td><td rowspan="2" class="legend-color-average legend-color-item"></td><td class="legend-value-header" style="min-width: 72px; width: 72px;">5 '+_T("rsrcmonitor","minutes")+'</td><td rowspan="2" class="legend-color-average legend-color-item"></td><td class="legend-value-header" style="min-width: 72px; width: 72px;">15 '+_T("rsrcmonitor","minutes")+'</td></tr><tr><td class="legend-value" id='+b._1min+'>0</td><td class="legend-value" id='+b._5min+'>0</td><td class="legend-value" id='+b._15min+">0</td></tr></tbody> </table>";return a},updateLoadAvarageTbl:function(b){var a=this;Ext.fly(a.legendId._1min).update(b["1min"]+"");Ext.fly(a.legendId._5min).update(b["5min"]+"");Ext.fly(a.legendId._15min).update(b["15min"]+"")}});Ext.define("SYNO.SDS.ResourceMonitor.Performance.CPU.History",{extend:"Ext.Container",constructor:function(c){var d=this,b={},a;a='<table><tbody><tr><td style="min-width: 80px"><div class = "legend-color-dot legend-color-user"></div>'+_T("rsrcmonitor","cpu_user")+'</td><td style="min-width: 80px"><div class = "legend-color-dot legend-color-system"></div>'+_T("rsrcmonitor","cpu_system")+'</td><td style="min-width: 80px"><div class = "legend-color-dot legend-color-others"></div>'+_T("rsrcmonitor","iowait")+"</td></tr></tbody></table>";d.chart=new SYNO.SDS.ResourceMonitor.Performance.Chart.History({chartTitle:_T("rsrcmonitor","utilization")+" (%)",flex:1});b={layout:"vbox",layoutConfig:{align:"stretch"},items:[d.chart,{xtype:"box",margins:{top:2,right:0,bottom:0,left:23},height:113,border:false,html:a}]};Ext.apply(b,c);this.callParent([b])},setType:function(b){var a=this;a.topLayer.setStatusLoading();SYNO.API.Request({api:"SYNO.Core.System.Utilization",appWindow:a.topLayer.appWin,method:"get",version:1,params:{type:"history",resource:["cpu"],time_range:b},scope:a,callback:a.LoadHistoryData})},LoadHistoryData:function(a,d,e,c){var b=this;if(b.isDestronyed){return}b.topLayer.clearStatusLoading();if(!a||!d){b.topLayer.appWin.showAlert(_T(d.err_session,d.err_key),b.controlLayer.setToRealTime,b.controlLayer);return}if(!Ext.isDefined(d.data_size)||0===d.data_size){b.topLayer.appWin.showAlert(_T("rsrcmonitor","no_history"),b.controlLayer.setToRealTime,b.controlLayer);return}b.drawCharts(d,e)},drawCharts:function(b,d){var a=this,e={},c;if(!b){return}c={fill:true,fillOpacity:1,lineWidth:1};e={chartTitle:_T("rsrcmonitor","utilization")+" (%)",aggregate:true,lines:[{itemId:"other_load",lineName:_T("rsrcmonitor","iowait"),color:"#3d85cc",trackColor:"#3d85cc",trackOrder:3,lineType:{lineWidth:0,fill:true,fillOpacity:1}},{itemId:"system_load",lineName:_T("rsrcmonitor","cpu_system"),color:"#55b1f2",trackColor:"#55b1f2",trackOrder:2,lineType:c},{itemId:"user_load",lineName:_T("rsrcmonitor","cpu_user"),color:"#aee239",trackColor:"#aee239",trackOrder:1,lineType:c}],timeAxis:d.time_range,dataType:"percent",data:b.cpu,dataSize:b.data_size,endTime:b.time,timeInterval:b.interval};a.chart.setChartConfig(e);a.chart.drawChart()}});Ext.define("SYNO.SDS.ResourceMonitor.Performance.Memory.Main",{extend:"Ext.Container",constructor:function(b){var a=Ext.apply({layout:"anchor",items:[],listeners:{activate:{fn:this.onActivate,scope:this}}},b);this.callParent([a])},createComponent:function(c){var d=this,b=false,a=c.showHistory;if(!d.chartHeader){d.chartHeader=new SYNO.SDS.ResourceMonitor.Performance.Detail.Header({header_title:_T("rsrcmonitor","memory"),topLayer:c.topLayer,type_combo:{data:[["usage",_T("rsrcmonitor","physical_memory")],["swap",_T("rsrcmonitor","swap")]]}});d.add(d.chartHeader);if(!d.content){d.content=new SYNO.SDS.ResourceMonitor.Performance.Memory.Content({topLayer:c.topLayer,anchor:"100% -37",header:d.chartHeader});d.add(d.content)}b=true}else{d.chartHeader.setToRealTime()}if(a===d.chartHeader.history_combo.hidden){if(a){d.chartHeader.history_combo.show();d.chartHeader.history_label.show()}else{d.chartHeader.history_combo.hide();d.chartHeader.history_label.hide()}b=true}if(b){d.doLayout(false,true)}},onActivate:function(){this.items.each(function(a){if(Ext.isFunction(a.onActivate)){a.onActivate()}},this)}});Ext.define("SYNO.SDS.ResourceMonitor.Performance.Memory.Content",{extend:"Ext.Container",constructor:function(b){var a={itemId:"content",layout:"card",activeItem:0,items:[new SYNO.SDS.ResourceMonitor.Performance.Memory.CurrentPhysical({itemId:"current_usage",topLayer:b.topLayer,controlLayer:this}),new SYNO.SDS.ResourceMonitor.Performance.Memory.CurrentSwap({itemId:"current_swap",topLayer:b.topLayer,controlLayer:this}),new SYNO.SDS.ResourceMonitor.Performance.Memory.History({itemId:"history",topLayer:b.topLayer,controlLayer:this})]};Ext.apply(a,b);this.callParent([a]);this.mon(b.header,"contentSelect",this.changeContent,this)},changeContent:function(a){if(!Ext.isDefined(a.type)){a.type="usage"}if("current"===a.history){this.layout.setActiveItem("current_"+a.type)}else{this.layout.setActiveItem("history");this.get("history").setType(a.history,a.type)}},setToRealTime:function(){this.header.setToRealTime()},onActivate:function(){var a=this.layout.activeItem;if(Ext.isDefined(a)&&Ext.isFunction(a.onActivate)){a.onActivate()}}});Ext.define("SYNO.SDS.ResourceMonitor.Performance.Memory.CurrentPhysical",{extend:"Ext.Panel",lastPollingData:null,constructor:function(c){var d=this;d.pieId={used:Ext.id(),buff:Ext.id(),cached:Ext.id(),free:Ext.id(),reserved:Ext.id()};d.sumarryId={total:Ext.id(),totalUnit:Ext.id(),util:Ext.id()};var b='<div style="width: 100%;"><span class="pie-title">'+_T("rsrcmonitor","memory_composition")+'</span><span style="float:right"><span class="legend-value-header-large"  style="display:inline-block; padding-right: 12px;">'+_T("rsrcmonitor","total")+"</span><span id="+d.sumarryId.total+' class="legend-value" style="display:inline-block; padding-right: 8px; padding-left: 0px;">0</span><span id='+d.sumarryId.totalUnit+' class="legend-value-unit-large" style="padding-right: 28px;">MB</span><span class="legend-value-unit-large" style="display:inline-block; padding-right:12px;">'+_T("rsrcmonitor","utilization")+"</span><span id="+d.sumarryId.util+' class="legend-value" style="display:inline-block; padding-right: 8px; padding-left: 0px;">0</span><span class="legend-value-unit-large">%</span></span></div><div class="pie-chart"><div id='+d.pieId.reserved+' class="legend-color-reserved pie-item"></div> <div id='+d.pieId.used+' class="legend-color-used pie-item"></div><div id='+d.pieId.buff+' class="legend-color-buff pie-item"></div> <div id='+d.pieId.cached+' class="legend-color-cached pie-item"></div><div id='+d.pieId.free+' class="legend-color-free pie-last-item"></div> </div>';d.legendId={legend:Ext.id(),used:Ext.id(),usedUnit:Ext.id(),buff:Ext.id(),buffUnit:Ext.id(),cached:Ext.id(),cachedUnit:Ext.id(),free:Ext.id(),freeUnit:Ext.id(),reserved:Ext.id(),reservedUnit:Ext.id()};var e="<div id="+d.legendId.legend+' style="position: absolute; top: 73px;"><table class="info-list-table"><tbody><tr><td rowspan="2" class="legend-color-reserved legend-color-item""></td><td class="legend-value-header">'+_T("rsrcmonitor","reserved")+'</td><td rowspan="2" class="legend-color-used legend-color-item"></td><td class="legend-value-header">'+_T("rsrcmonitor","memroy_used")+'</td><td rowspan="2" class="legend-color-buff legend-color-item""></td><td class="legend-value-header">'+_T("rsrcmonitor","memroy_buff")+'</td><td rowspan="2" class="legend-color-cached legend-color-item""></td><td class="legend-value-header">'+_T("rsrcmonitor","memory_cached")+'</td><td rowspan="2" class="legend-color-free legend-color-item""></td><td class="legend-value-header">'+_T("rsrcmonitor","memory_free")+"</td></tr><tr><td><span id="+d.legendId.reserved+' class="legend-value">0</span><span id='+d.legendId.reservedUnit+' class="legend-value-unit">MB</span></td><td><span id='+d.legendId.used+' class="legend-value">0</span><span id='+d.legendId.usedUnit+' class="legend-value-unit">MB</span></td><td><span id='+d.legendId.buff+' class="legend-value">0</span><span id='+d.legendId.buffUnit+' class="legend-value-unit">MB</span></td><td><span id='+d.legendId.cached+' class="legend-value">0</span><span id='+d.legendId.cachedUnit+' class="legend-value-unit">MB</span></td><td><span id='+d.legendId.free+' class="legend-value">0</span><span id='+d.legendId.freeUnit+' class="legend-value-unit">MB</span></td></tr></tbody></table></div>';this.chart=new SYNO.SDS.ResourceMonitor.Performance.Chart.Current({chartTitle:_T("rsrcmonitor","utilization")+" (%)",flex:1,topLayer:c.topLayer,totalTime:SYNO.SDS.ResourceMonitor.Performance.CurrentTotalTime,lines:[{itemId:"memory_util",lineName:_T("rsrcmonitor","utilization"),color:"#105398",trackColor:"#30a9ff",lineType:{lineWidth:1,fill:true,fillColor:"#30a9ff",fillOpacity:0.7}}],dataType:"percent"});var a=Ext.apply({layout:"vbox",layoutConfig:{align:"stretch"},border:false,items:[this.chart,{xtype:"container",margins:{top:2,right:0,bottom:0,left:23},height:133,style:{position:"relative"},itemId:"legend",border:false,items:[{xtype:"box",itemId:"pie",html:b},{xtype:"box",html:e}]}]},c);this.callParent([a])},initEvents:function(){var a=this;SYNO.SDS.ResourceMonitor.Performance.Memory.CurrentPhysical.superclass.initEvents.apply(this,arguments);a.mon(a.topLayer,"data_comming",function(b){a.updateData(b.memory,b.time)});a.mon(a,"resize",a.onResizeThis,a);a.mon(a,"activate",a.onActivate,a)},onResizeThis:function(){var a=this,b=a.lastPollingData;if(!b){return}a.updateRetanglePieChart(b);a.updateLegend(b)},onActivate:function(){var a=this,b=a.lastPollingData;if(!b){return}a.doLayout();a.updateRetanglePieChart(b);a.updateLegend(b);a.updateSumarry(b);a.chart.drawChart()},updateData:function(a,e){var b=this,d=a,c={};c={total:d.total_real*1024,used:(d.total_real-d.avail_real-d.cached-d.buffer)*1024,buffer:d.buffer*1024,cached:d.cached*1024,free:d.avail_real*1024,util:d.real_usage,reserved:(d.memory_size-d.total_real)*1024,ramsize:d.memory_size*1024};b.lastPollingData=c;b.updateRetanglePieChart(c);b.updateLegend(c);b.updateSumarry(c);b.updateChart(c,e)},updateRetanglePieChart:function(f){var e=this,c=e.get("legend").get("pie").getWidth(),g=Math.round((f.reserved*c)/f.ramsize),a=Math.round((f.used*c)/f.ramsize),d=Math.round((f.buffer*c)/f.ramsize),h=Math.round((f.cached*c)/f.ramsize),b=c-g-a-d-h;Ext.fly(e.pieId.reserved).setWidth(g-1);Ext.fly(e.pieId.used).setWidth(a-1);Ext.fly(e.pieId.buff).setWidth(d-1);Ext.fly(e.pieId.cached).setWidth(h-1);Ext.fly(e.pieId.free).setWidth(b)},updateLegend:function(e){var d=this,c=d.topLayer.fileSizeUnit(e.used),g=d.topLayer.fileSizeUnit(e.buffer),b=d.topLayer.fileSizeUnit(e.cached),f=d.topLayer.fileSizeUnit(e.free),a=d.topLayer.fileSizeUnit(e.reserved);Ext.fly(d.legendId.used).update(c.size);Ext.fly(d.legendId.usedUnit).update(c.unit);Ext.fly(d.legendId.buff).update(g.size);Ext.fly(d.legendId.buffUnit).update(g.unit);Ext.fly(d.legendId.cached).update(b.size);Ext.fly(d.legendId.cachedUnit).update(b.unit);Ext.fly(d.legendId.free).update(f.size);Ext.fly(d.legendId.freeUnit).update(f.unit);Ext.fly(d.legendId.reserved).update(a.size);Ext.fly(d.legendId.reservedUnit).update(a.unit)},updateSumarry:function(c){var b=this,a=b.topLayer.fileSizeUnit(c.ramsize);Ext.fly(b.sumarryId.total).update(a.size);Ext.fly(b.sumarryId.totalUnit).update(a.unit);Ext.fly(b.sumarryId.util).update(c.util)},updateChart:function(b,c){var a=this;a.chart.pushValue([b.util],c);a.chart.drawChart()}});Ext.define("SYNO.SDS.ResourceMonitor.Performance.Memory.CurrentSwap",{extend:"Ext.Panel",lastPollingData:null,constructor:function(c){var d=this,b={},a,e;d.chart=new SYNO.SDS.ResourceMonitor.Performance.Chart.Current({flex:1,topLayer:c.topLayer,chartTitle:_T("rsrcmonitor","si_descr")+" / "+_T("rsrcmonitor","so_descr"),totalTime:SYNO.SDS.ResourceMonitor.Performance.CurrentTotalTime,lines:[{itemId:"swap_si",lineName:_T("rsrcmonitor","si_descr"),color:"#0086e6",trackColor:"#0086e6"},{itemId:"swap_so",lineName:_T("rsrcmonitor","so_descr"),color:"#1eb300",trackColor:"#1eb300"}],dataType:"bytes"});d.flow={swapin:Ext.id(),swapinUnit:Ext.id(),swapout:Ext.id(),swapoutUnit:Ext.id()};a='<div><table><tbody><tr><td rowspan="2" class="legend-color-swapin legend-color-item"></td><td class="legend-value-header">'+_T("rsrcmonitor","si_descr")+'</td><td rowspan="2" class="legend-color-swapout legend-color-item"></td><td class="legend-value-header">'+_T("rsrcmonitor","so_descr")+"</td></tr><tr><td><span id="+d.flow.swapin+' class="legend-value">0</span><span id='+d.flow.swapinUnit+' class="legend-value-unit">Kb/s</span></td><td><span id='+d.flow.swapout+' class="legend-value">0</span><span id='+d.flow.swapoutUnit+' class="legend-value-unit" >Kb/s</td></tr></tbody></table></div>';d.swap={total:Ext.id(),totalUnit:Ext.id(),used:Ext.id(),usedUnit:Ext.id(),utilization:Ext.id()};e='<div style="position: absolute; top: 0px; right: 0px;"><table><tbody><tr><td rowspan="2" class="legend-color-summary legend-color-item"></td><td class="legend-value-header">'+_T("rsrcmonitor","total")+'</td><td rowspan="2" class="legend-color-summary legend-color-item"></td><td class="legend-value-header">'+_T("rsrcmonitor","memroy_used")+'</td><td rowspan="2" class="legend-color-summary legend-color-item"></td><td class="legend-value-header">'+_T("rsrcmonitor","utilization")+"</td></tr><tr><td><span id="+d.swap.total+' class="legend-value">0</span><span id='+d.swap.totalUnit+' class="legend-value-unit">MB</span></td><td><span id='+d.swap.used+' class="legend-value">0</span><span id='+d.swap.usedUnit+' class="legend-value-unit" >0MB</span></td><td><span id='+d.swap.utilization+' class="legend-value">0</span><span class="legend-value-unit">%</span></td></tr></tbody></table></div>';b=Ext.apply({layout:"vbox",layoutConfig:{align:"stretch"},border:false,cls:"resource-monitor-swap",style:{position:"relative"},items:[d.chart,{xtype:"box",margins:{top:3,right:0,bottom:0,left:23},height:112,html:a+e}]},c);this.callParent([b])},initEvents:function(){var a=this;SYNO.SDS.ResourceMonitor.Performance.Memory.CurrentSwap.superclass.initEvents.apply(this,arguments);a.mon(a.topLayer,"data_comming",function(b){a.updateData(b.memory,b.time)});a.mon(a,"activate",a.onActivate,a)},onActivate:function(){this.chart.drawChart()},updateData:function(b,c){var a=this;a.chart.pushValue([b.si_disk*1024,b.so_disk*1024],c);a.chart.drawChart();a.updateFlow(b);a.updateSwap(b)},updateFlow:function(d){var b=this,a=b.getkbSizeUnit(d.si_disk),c=b.getkbSizeUnit(d.so_disk);Ext.fly(b.flow.swapin).update(a.size);Ext.fly(b.flow.swapinUnit).update(a.unit);Ext.fly(b.flow.swapout).update(c.size);Ext.fly(b.flow.swapoutUnit).update(c.unit)},getkbSizeUnit:function(a){var b=0,c="KB/s";if(a<1024){b=a;c="KB/s"}else{b=(Math.round((a)/1024));c="MB/s"}return{size:""+b,unit:c}},updateSwap:function(d){var c=this,b=c.topLayer.fileSizeUnit(d.total_swap*1024),a=c.topLayer.fileSizeUnit((d.total_swap-d.avail_swap)*1024);Ext.fly(c.swap.total).update(b.size);Ext.fly(c.swap.totalUnit).update(b.unit);Ext.fly(c.swap.used).update(a.size);Ext.fly(c.swap.usedUnit).update(a.unit);if(0>=d.total_swap){Ext.fly(c.swap.utilization).update("0")}else{Ext.fly(c.swap.utilization).update(""+Math.round((d.total_swap-d.avail_swap)*100/d.total_swap))}}});Ext.define("SYNO.SDS.ResourceMonitor.Performance.Memory.History",{extend:"Ext.Container",constructor:function(b){var c=this,a={};c.chart=new SYNO.SDS.ResourceMonitor.Performance.Chart.History({chartTitle:_T("rsrcmonitor","utilization")+" (%)",anchor:"100% -115"});a={layout:"anchor",items:[c.chart,{xtype:"box",height:113,style:"position: relative; margin: 2px 0px 0px 23px;",itemId:"footer"}]};Ext.apply(a,b);this.callParent([a])},setType:function(c,a){var b=this;b.topLayer.setStatusLoading();SYNO.API.Request({api:"SYNO.Core.System.Utilization",appWindow:b.topLayer.appWin,method:"get",version:1,params:{type:"history",resource:["memory"],time_range:c,graph:a},scope:b,callback:b.LoadHistoryData})},LoadHistoryData:function(a,d,e,c){var b=this;if(b.isDestronyed){return}b.topLayer.clearStatusLoading();if(!a||!d){b.topLayer.appWin.showAlert(_T(d.err_session,d.err_key),b.controlLayer.setToRealTime,b.controlLayer);return}if(!Ext.isDefined(d.data_size)||0===d.data_size){b.topLayer.appWin.showAlert(_T("rsrcmonitor","no_history"),b.controlLayer.setToRealTime,b.controlLayer);return}b.drawCharts(d,e);b.setFooter(d,e)},drawCharts:function(b,c){var a=this,d={};if(!b){return}if("usage"===c.graph){d={chartTitle:_T("rsrcmonitor","utilization")+" (%)",lines:[{itemId:"real_usage",lineName:_T("rsrcmonitor","utilization"),color:"#105398",trackColor:"#30a9ff",lineType:{lineWidth:1,fill:true,fillColor:"#30a9ff",fillOpacity:0.7}}],timeAxis:c.time_range,dataType:"percent",data:b.memory,dataSize:b.data_size,endTime:b.time,timeInterval:b.interval}}else{d={chartTitle:_T("rsrcmonitor","si_descr")+" / "+_T("rsrcmonitor","so_descr"),lines:[{itemId:"si_disk",lineName:_T("rsrcmonitor","si_descr"),color:"#0086e6",trackColor:"#0086e6"},{itemId:"so_disk",lineName:_T("rsrcmonitor","so_descr"),color:"#1eb300",trackColor:"#1eb300"}],timeAxis:c.time_range,dataType:"bytes",dataBase:1024,data:b.memory,dataSize:b.data_size,endTime:b.time,timeInterval:b.interval}}a.chart.setChartConfig(d);a.chart.drawChart()},setFooter:function(a,b){var c;if("usage"===b.graph){c='<div><table><tbody><tr> <td><div class = "legend-color-usage  legend-color-dot"></div>'+_T("rsrcmonitor","utilization")+"</td></tr></tbody></table></div>"}else{c='<div class="resource-monitor-swap"><table><tbody><tr class="legend-value-header"><td style="min-width: 80px;"><div class = "legend-color-swapin  legend-color-dot"></div>'+_T("rsrcmonitor","si_descr")+'</td><td><div class = "legend-color-swapout  legend-color-dot"></div>'+_T("rsrcmonitor","so_descr")+"</td></tr></tbody></table></div>"}this.get("footer").update(c)}});SYNO.SDS.ResourceMonitor.Performance.MaxDisplaySize=8;Ext.define("SYNO.SDS.ResourceMonitor.Performance.Disk.Main",{extend:"Ext.Panel",header_title:_T("rsrcmonitor","disk"),dataRoot:"disk",historyType:"disk",constructor:function(b){var a=Ext.apply({layout:"anchor",items:[],listeners:{activate:this.onActivate,scope:this}},b);this.callParent([a])},createComponent:function(c){var d=this,e=SYNO.SDS.ResourceMonitor.Performance.Disk.SelectorDialog,a=c.showHistory,b=false;if("space"===this.dataRoot){e=SYNO.SDS.ResourceMonitor.Performance.Space.SelectorDialog}if(!d.chartHeader){d.chartHeader=new SYNO.SDS.ResourceMonitor.Performance.Detail.Header({header_title:d.header_title,topLayer:c.topLayer,type_combo:{data:[["utilization",_T("rsrcmonitor","utilization")],["transfer_rate",_T("rsrcmonitor","transfer_rate")],["iops",_T("rsrcmonitor","iops")]]}});d.add(d.chartHeader);if(!d.content){d.content=new SYNO.SDS.ResourceMonitor.Performance.Disk.Content({topLayer:c.topLayer,mainLayer:this,dataRoot:this.dataRoot,historyType:this.historyType,anchor:"100% -37",selectorDialogClass:e,detailHeader:d.chartHeader});d.add(d.content)}b=true}else{d.chartHeader.setToRealTime();d.content.updateStorages([]);d.content.selectorDialog.clearSelections()}if(a===d.chartHeader.history_combo.hidden){if(a){d.chartHeader.history_combo.show();d.chartHeader.history_label.show()}else{d.chartHeader.history_combo.hide();d.chartHeader.history_label.hide()}b=true}if(b){d.doLayout(false,true)}},onActivate:function(){this.items.each(function(a){if(Ext.isFunction(a.onActivate)){a.onActivate()}},this)}});Ext.define("SYNO.SDS.ResourceMonitor.Performance.Disk.Content",{extend:"Ext.Panel",selectorDialog:null,defaultColors:["#e44c41","#fb6d96","#6b6dca","#80d24c","#ff8400","#fcbd00","#2fc9c2"],defaultStorages:[{itemId:"total",storageType:"total",display_name:_T("rsrcmonitor","total"),qtipName:_T("rsrcmonitor","total"),color:"#3799fa"}],storages:null,lastPollingData:null,constructor:function(b){var c=this,a={};c.storages=c.defaultStorages.clone();a=Ext.apply({layout:"anchor",border:false,autoFlexcroll:true,items:[{itemId:"content",xtype:"container",border:false,anchor:"100% -100",layout:"card",activeItem:0,items:[new SYNO.SDS.ResourceMonitor.Performance.Disk.CurrentUtilization({itemId:"utilization",topLayer:b.topLayer,controlLayer:c}),new SYNO.SDS.ResourceMonitor.Performance.Disk.CurrentTransferRate({itemId:"transfer_rate",topLayer:b.topLayer,controlLayer:c}),new SYNO.SDS.ResourceMonitor.Performance.Disk.CurrentIOPS({itemId:"iops",topLayer:b.topLayer,controlLayer:c}),new SYNO.SDS.ResourceMonitor.Performance.Disk.History({itemId:"history",topLayer:b.topLayer,controlLayer:c})]},{xtype:"box",itemId:"chart_ctl",height:40,style:"margin: 0px 0px 0px 23px;",html:c.getChartCtlHtml()},{itemId:"footer",border:false,height:42,style:{margin:"5px 0px 0px 23px",position:"relative"},items:[{xtype:"box",border:false,itemId:"footer_text"},{xtype:"syno_button",btnStyle:"gray",style:"position: absolute; bottom: 8px; right:0px",text:_T("rsrcmonitor","view_all"),handler:c.showSelectorDialog,scope:c}]}]},b);this.callParent([a])},initEvents:function(){var a=this;SYNO.SDS.ResourceMonitor.Performance.Disk.Main.superclass.initEvents.apply(this,arguments);a.mon(a.topLayer,"data_comming",function(b){if(!b||!b[a.dataRoot]){return}a.lastPollingData=b[a.dataRoot];a.removeInvalidStorages(b[a.dataRoot]);a.updateFooter(b[a.dataRoot])});a.mon(a.detailHeader,"contentSelect",a.changeContent,a);a.selectorDialog=new a.selectorDialogClass({owner:a.topLayer.appWin,topLayer:a.topLayer,dataRoot:a.dataRoot});a.mon(a.selectorDialog,"select_finish",a.updateStorages,a);a.mon(a,"activate",a.onActivate,a);a.mon(a,"beforedestroy",a.destroyed,a)},onActivate:function(){var b=this,a=b.get("content"),c=a.layout.activeItem;if(c&&Ext.isFunction(c.onActivate)){c.onActivate()}},setToRealTime:function(){this.detailHeader.setToRealTime()},changeContent:function(c){var b=this,a=b.get("content");if("utilization"===c.type){a.boxMinHeight=null}else{a.boxMinHeight=380}a.anchorSpec=null;b.doLayout();if("current"===c.history){a.layout.setActiveItem(c.type);b.updateFooter(b.lastPollingData)}else{a.layout.setActiveItem("history");a.get("history").setType(c.history,c.type);b.updateFooter()}},showSelectorDialog:function(){this.selectorDialog.show()},getChartCtlHtml:function(){var c=this,b='<div><table class="ctl-table"><tbody><tr>',a=0;for(a=0;a<c.storages.length;++a){if(0===a%4&&0!==a){b+="</tr><tr>"}b+='<td ext:qtip="'+c.storages[a].qtipName+'"><div class = "legend-color-dot" style="background-color:'+c.storages[a].color+'"></div>'+c.storages[a].display_name+"</td>"}b+="</tr></tbody><table></div>";return b},removeInvalidStorages:function(a){var d=this,b=false,c=false,e=[];Ext.each(d.storages,function(f){if("total"===f.itemId){return}c=a[f.storageType].every(function(g){if(g.device===f.itemId){return false}return true});if(c){b=true}else{e.push(f)}});if(b){d.updateStorages(e)}},updateStorages:function(e){var d=this,c=false,a=[],b;Ext.each(d.storages,function(f){c=e.every(function(h,g,i){return f.itemId!==h.id});if(true!==c){a.push(f)}});Ext.each(e,function(g,f){c=a.every(function(i,h,j){return g.id!==i.itemId});if(true===c){b=g;b.color=d.getAColor(a);a.splice(f,0,b)}});d.storages=d.defaultStorages.concat(a);d.get("chart_ctl").update(d.getChartCtlHtml());d.fireEvent("storagesUpdate")},getAColor:function(a){var d=this,c=false,b=d.defaultColors[0];Ext.each(d.defaultColors,function(e){c=a.every(function(g,f,h){return e!==g.color});if(c){b=e;return false}});return b},updateFooter:function(f){var e=this,h=e.get("footer").get("footer_text"),b,d,c=e.get("content").layout.activeItem.itemId;if("history"===c){h.update("<div></div>");return}d=f.total;if(!Ext.isDefined(d)){return false}if("utilization"===c){b='<div><table><tbody><tr><td rowspan="2" class="legend-color-total legend-color-item"></td><td class="legend-value-header">'+_T("rsrcmonitor","utilization")+'</td></tr><tr><td><span class="legend-value">'+d.utilization+'</span><span class="legend-value-unit">%</span></td></tr></tbody></table></div>'}else{if("transfer_rate"===c){var g=e.topLayer.fileSizeUnit(d.read_byte),a=e.topLayer.fileSizeUnit(d.write_byte);b='<div><table><tbody><tr><td rowspan="2" class="legend-color-gray legend-color-item"></td><td class="legend-value-header">'+_T("rsrcmonitor","read_speed")+'</td><td rowspan="2" class="legend-color-gray legend-color-item"></td><td class="legend-value-header">'+_T("rsrcmonitor","write_speed")+'</td></tr><tr><td><span class="legend-value">'+g.size+'</span><span class="legend-value-unit">'+g.unit+'/s</span></td><td><span class="legend-value">'+a.size+'</span><span class="legend-value-unit">'+a.unit+"/s</span></td></tr></tbody></table></div>"}else{if("iops"===c){b='<div><table><tbody><tr><td rowspan="2" class="legend-color-gray legend-color-item"></td><td class="legend-value-header">'+_T("rsrcmonitor","read")+'</td><td rowspan="2" class="legend-color-gray legend-color-item"></td><td class="legend-value-header">'+_T("rsrcmonitor","write")+'</td></tr><tr><td><span class="legend-value">'+d.read_access+'</span><span class="legend-value-unit">/s</span></td><td><span class="legend-value">'+d.write_access+'</span><span class="legend-value-unit">/s</span></td></tr></tbody></table></div>'}else{b="<div></div>"}}}h.update(b)},getStoragesToDraw:function(){var b=this,c=SYNO.SDS.ResourceMonitor.Performance,d=[],a=0;for(a=0;a<c.MaxDisplaySize&&a<b.storages.length;++a){d.push(Ext.apply(b.storages[a],{lineType:{fill:false},lineName:b.storages[a].display_name||b.storages[a].itemId}))}return d},destroyed:function(){this.selectorDialog.destroy();delete this.selectorDialog}});Ext.define("SYNO.SDS.ResourceMonitor.Performance.Disk.SelectorDialog",{extend:"SYNO.SDS.ModalWindow",lastCommingData:null,grids:null,dataRoot:"disk",constructor:function(b){var c=this;c.selectionCheck={};c.grids=b.grids||[c.createHddGrid(b)];var a={title:_T("rsrcmonitor","view_all"),topLayer:b.topLayer,height:300,width:650,layout:"fit",items:[{xtype:"syno_tabpanel",itemId:"storage_tabs",activeTab:0,deferredRender:false,items:c.grids}],buttons:[{text:_WFT("common","ok"),btnStyle:"blue",itemId:"ok_btn",handler:c.okHandler,scope:c},{text:_WFT("common","close"),itemId:"close_btn",handler:c.closeHandler,scope:c}],listeners:{show:{fn:function(){if(c.lastCommingData){c.updateGrids(c.lastCommingData)}}}}};Ext.apply(a,b);this.callParent([a])},initEvents:function(){var a=this;SYNO.SDS.ResourceMonitor.Performance.Disk.SelectorDialog.superclass.initEvents.apply(this,arguments);a.mon(a.topLayer,"data_comming",function(b){a.lastCommingData=b[a.dataRoot];if(a.isVisible()){a.updateGrids(b[a.dataRoot])}});Ext.each(a.grids,function(b){a.mon(b.getSelectionModel(),"afterselect",a.checkExceedMaxSelection,a)})},updateGrids:function(a){Ext.each(this.grids,function(b){b.getStore().loadData(a[b.itemId])})},createHddGrid:function(c){var b=SYNO.SDS.ResourceMonitor.Performance.Disk.Utility,a="device",d=b.defaultSorter;if("yes"===c.owner._D("supportsas")){a="display_name";d=b.sasSorter}return this.createStorageGrid({itemId:"disk",title:_T("rsrcmonitor","disk"),nameIndex:a,displayNameSorter:d,deviceNameRenderer:b.shortExpansionDiskName,topLayer:c.topLayer})},createStorageGrid:function(d){var a=new Ext.data.JsonReader({idProperty:"device",fields:[{name:"device"},{name:"display_name",sortType:d.displayNameSorter},{name:"utilization"},{name:"read_byte",type:"integer"},{name:"write_byte",type:"integer"},{name:"read_access",type:"integer"},{name:"write_access",type:"integer"}]});var e=new SYNO.SDS.ResourceMonitor.Performance.Disk.SelectorDialog.SelectModel({width:30});var b=function(j,g,f){var i=f.get("display_name"),h=Ext.util.Format.htmlEncode(i);g.attr='ext:qtip="'+h+'"';if(d.deviceNameRenderer){return Ext.util.Format.htmlEncode(d.deviceNameRenderer(i,d.topLayer))}else{return h}};var c={store:new Ext.data.Store({autoDestroy:true,reader:a,sortInfo:{field:d.nameIndex,direction:"ASC"}}),colModel:new Ext.grid.ColumnModel({defaults:{sortable:true,menuDisabled:true,width:100,height:20},columns:[e,{header:_T("common","name"),width:160,dataIndex:d.nameIndex,renderer:b},{header:_T("rsrcmonitor","utilization")+"(%)",dataIndex:"utilization"},{header:_T("rsrcmonitor","read_speed")+"(/s)",renderer:Ext.util.Format.fileSize,dataIndex:"read_byte"},{header:_T("rsrcmonitor","write_speed")+"(/s)",renderer:Ext.util.Format.fileSize,dataIndex:"write_byte"},{header:_T("rsrcmonitor","read")+"(/s)",dataIndex:"read_access"},{header:_T("rsrcmonitor","write")+"(/s)",dataIndex:"write_access"}]}),sm:e,viewConfig:{forceFit:true,onLoad:Ext.emptyFn,listeners:{beforerefresh:function(f){f.scrollTop=f.scroller.dom.scrollTop},refresh:function(f){f.scroller.dom.scrollTop=f.scrollTop}}},columnLines:true,frame:false,cls:"resource-monitor-performance"};Ext.apply(c,d);return new SYNO.ux.GridPanel(c)},getSelections:function(){var b=this,a=[];Ext.each(b.grids,function(c){a=a.concat(b.getGridSelections(c))});return a},getGridSelections:function(b){var c=this,a=[],e=b.getSelectionModel();a=e.getSelections().map(function(g){var f={itemId:g.get("device"),device:g.get("device"),storageType:b.itemId};if(b.deviceNameRenderer){f.display_name=b.deviceNameRenderer(g.get("display_name"),c.topLayer)}else{f.display_name=g.get("display_name")}f.qtipName=g.get("display_name");return f});var d=function(h,f){var g=b.nameIndex;if("display_name"===g&&b.deviceNameRenderer){g="qtipName"}return b.displayNameSorter(h[g])>b.displayNameSorter(f[g])};a.sort(d);return a},saveSelections:function(){Ext.each(this.grids,function(a){a.getSelectionModel().saveSelections()})},resetSelections:function(){Ext.each(this.grids,function(a){a.getSelectionModel().resetSelections()})},clearSelections:function(){Ext.each(this.grids,function(a){a.getSelectionModel().clearSelections(true);a.getSelectionModel().clearCheckSelections()})},okHandler:function(){var b=this,a=[];a=b.getSelections();if(a.size()>=SYNO.SDS.ResourceMonitor.Performance.MaxDisplaySize){return}b.clearStatus();b.saveSelections();b.fireEvent("select_finish",a);b.hide()},closeHandler:function(){var a=this;a.hide();a.clearStatus();a.resetSelections()},checkExceedMaxSelection:function(){var b=this,c=String.format(_T("rsrcmonitor","exceeded_max_disk_selection"),SYNO.SDS.ResourceMonitor.Performance.MaxDisplaySize-1),a=[];a=b.getSelections();if(a.size()>=SYNO.SDS.ResourceMonitor.Performance.MaxDisplaySize){b.setStatusError({text:c})}else{b.clearStatus()}return}});Ext.define("SYNO.SDS.ResourceMonitor.Performance.Disk.SelectorDialog.SelectModel",{extend:"Ext.grid.CheckboxSelectionModel",checkSelections:[],constructor:function(a){var b=this;b.headerCheckId=Ext.id();b.header="<div id="+b.headerCheckId+' class="x-grid3-row-checker">&#160;</div>';this.callParent([a])},initEvents:function(){SYNO.SDS.ResourceMonitor.Performance.Disk.SelectorDialog.SelectModel.superclass.initEvents.apply(this,arguments);this.grid.mon(this.grid.getStore(),"load",this.checkSelectAll,this);this.grid.mon(this.grid.getStore(),"load",this.fireAfterSelectEvent,this)},handleMouseDown:function(){},checkSelectAll:function(){var a=this;if(a.getCount()===a.grid.getStore().getCount()&&a.getCount()!==0){Ext.get(a.headerCheckId).addClass("x-grid3-hd-checker-on")}else{Ext.get(a.headerCheckId).removeClass("x-grid3-hd-checker-on")}},fireAfterSelectEvent:function(){this.fireEvent("afterselect")},onMouseDown:function(b,a){SYNO.SDS.ResourceMonitor.Performance.Disk.SelectorDialog.SelectModel.superclass.onMouseDown.apply(this,arguments);this.checkSelectAll();this.fireAfterSelectEvent()},onHdMouseDown:function(c,a){var b=this;if(a.hasClassName("x-grid3-hd-checker-on")){Ext.get(b.headerCheckId).removeClass("x-grid3-hd-checker-on");b.clearSelections()}else{Ext.get(b.headerCheckId).addClass("x-grid3-hd-checker-on");b.selectAll()}b.fireAfterSelectEvent()},saveSelections:function(){var a=this;a.checkSelections=a.getSelections()},resetSelections:function(){var b=this,a=b.grid.getStore();b.clearSelections(true);a.each(function(c){Ext.each(b.checkSelections,function(d){if(c.id===d.id){b.selectRow(a.indexOf(c),true,true);return false}})});b.checkSelectAll()},clearCheckSelections:function(){this.checkSelections.clear()}});SYNO.SDS.ResourceMonitor.Performance.Disk.Utility={getValueFromComingDataById:function(c,a,e,d){var b=0;if("total"===e){return c.total[d]}Ext.each(c[a],function(g,f,h){if(g.device===e){b=g[d];return false}return true});return b},shortExpansionDiskName:function(a,e){if("yes"!==e.appWin._D("supportsas")){return a}var b=_T("volume","volume_expansion"),f=_T("volume","volume_disk"),d,c;if("("+b!==a.substr(0,b.length+1)){return a}d=a.match(/\d+/g);if(null===d||2!==d.length){return a}c="{0} - "+f+" {1}";return String.format(c,d[0],d[1])},volumeSorter:function(a){if("volume"===a.substr(0,6)){return parseInt(a.substr(6),10)}return a},defaultSorter:function(a){return a},sasSorter:function(c){var b,d=0,a=0;b=c.match(/\d+/g);if(null===b){return c}if(1===b.length){d=0;a=parseInt(b[0],10)}else{d=parseInt(b[0],10);a=parseInt(b[1],10)}return d*1000+a}};Ext.define("SYNO.SDS.ResourceMonitor.Performance.Disk.CurrentTransferRate",{extend:"Ext.Panel",constructor:function(b){var c=this,a={};c.readChart=new SYNO.SDS.ResourceMonitor.Performance.Chart.Current({chartTitle:_T("rsrcmonitor","read_speed"),anchor:"100% 50%",totalTime:SYNO.SDS.ResourceMonitor.Performance.CurrentTotalTime,dataType:"bytes",topLayer:b.topLayer});c.writeChart=new SYNO.SDS.ResourceMonitor.Performance.Chart.Current({chartTitle:_T("rsrcmonitor","write_speed"),anchor:"100% 50%",totalTime:SYNO.SDS.ResourceMonitor.Performance.CurrentTotalTime,dataType:"bytes",topLayer:b.topLayer});a={layout:"anchor",border:false,items:[c.readChart,c.writeChart]};Ext.apply(a,b);this.callParent([a])},initEvents:function(){var a=this;SYNO.SDS.ResourceMonitor.Performance.Disk.CurrentTransferRate.superclass.initEvents.apply(this,arguments);a.mon(a.topLayer,"data_comming",function(b){a.updateData(b[a.controlLayer.dataRoot],b.time)});a.mon(a,"activate",a.onActivate,a)},updateData:function(e,f){var c=this,b=SYNO.SDS.ResourceMonitor.Performance.Disk.Utility,g=[],d=[],a=c.controlLayer.getStoragesToDraw();c.readChart.updateStores(a);c.writeChart.updateStores(a);Ext.each(a,function(i,h,j){g.push({itemId:i.itemId,value:b.getValueFromComingDataById(e,i.storageType,i.itemId,"read_byte")});d.push({itemId:i.itemId,value:b.getValueFromComingDataById(e,i.storageType,i.itemId,"write_byte")})});c.readChart.pushValueById(g,f);c.writeChart.pushValueById(d,f);c.readChart.drawChart();c.writeChart.drawChart()},onActivate:function(){var a=this;a.readChart.drawChart();a.writeChart.drawChart()}});Ext.define("SYNO.SDS.ResourceMonitor.Performance.Disk.CurrentUtilization",{extend:"Ext.Panel",constructor:function(b){var c=this,a={};c.utilChart=new SYNO.SDS.ResourceMonitor.Performance.Chart.Current({chartTitle:_T("rsrcmonitor","utilization")+" (%)",totalTime:SYNO.SDS.ResourceMonitor.Performance.CurrentTotalTime,dataType:"percent",topLayer:b.topLayer});a={layout:"fit",border:false,items:[c.utilChart]};Ext.apply(a,b);this.callParent([a])},initEvents:function(){var a=this;SYNO.SDS.ResourceMonitor.Performance.Disk.CurrentUtilization.superclass.initEvents.apply(this,arguments);a.mon(a.topLayer,"data_comming",function(b){a.updateData(b[a.controlLayer.dataRoot],b.time)});a.mon(a,"activate",a.onActivate,a)},updateData:function(e,f){var d=this,c=SYNO.SDS.ResourceMonitor.Performance.Disk.Utility,b=[],a=d.controlLayer.getStoragesToDraw();d.utilChart.updateStores(a);Ext.each(a,function(h,g,i){b.push({itemId:h.itemId,value:c.getValueFromComingDataById(e,h.storageType,h.itemId,"utilization")})});d.utilChart.pushValueById(b,f);d.utilChart.drawChart()},onActivate:function(){var a=this;a.utilChart.drawChart()}});Ext.define("SYNO.SDS.ResourceMonitor.Performance.Disk.CurrentIOPS",{extend:"Ext.Panel",constructor:function(b){var c=this,a={};c.readChart=new SYNO.SDS.ResourceMonitor.Performance.Chart.Current({chartTitle:_T("rsrcmonitor","read"),anchor:"100% 50%",totalTime:SYNO.SDS.ResourceMonitor.Performance.CurrentTotalTime,dataType:"normal",topLayer:b.topLayer});c.writeChart=new SYNO.SDS.ResourceMonitor.Performance.Chart.Current({chartTitle:_T("rsrcmonitor","write"),anchor:"100% 50%",totalTime:SYNO.SDS.ResourceMonitor.Performance.CurrentTotalTime,dataType:"normal",topLayer:b.topLayer});a={layout:"anchor",border:false,items:[c.readChart,c.writeChart]};Ext.apply(a,b);this.callParent([a])},initEvents:function(){var a=this;SYNO.SDS.ResourceMonitor.Performance.Disk.CurrentIOPS.superclass.initEvents.apply(this,arguments);a.mon(a.topLayer,"data_comming",function(b){a.updateData(b[a.controlLayer.dataRoot],b.time)});a.mon(a,"activate",a.onActivate,a)},updateData:function(e,f){var c=this,b=SYNO.SDS.ResourceMonitor.Performance.Disk.Utility,g=[],d=[],a=c.controlLayer.getStoragesToDraw();c.readChart.updateStores(a);c.writeChart.updateStores(a);Ext.each(a,function(i,h,j){g.push({itemId:i.itemId,value:b.getValueFromComingDataById(e,i.storageType,i.itemId,"read_access")});d.push({itemId:i.itemId,value:b.getValueFromComingDataById(e,i.storageType,i.itemId,"write_access")})});c.readChart.pushValueById(g,f);c.writeChart.pushValueById(d,f);c.readChart.drawChart();c.writeChart.drawChart()},onActivate:function(){var a=this;a.readChart.drawChart();a.writeChart.drawChart()}});Ext.define("SYNO.SDS.ResourceMonitor.Performance.Disk.History",{extend:"Ext.Panel",constructor:function(b){this.chart1=new SYNO.SDS.ResourceMonitor.Performance.Chart.History({flex:1});this.chart2=new SYNO.SDS.ResourceMonitor.Performance.Chart.History({flex:1});var a={layout:"vbox",border:false,layoutConfig:{align:"stretch",pack:"start"},items:[this.chart1,this.chart2]};Ext.apply(a,b);this.callParent([a])},initEvents:function(){var a=this;SYNO.SDS.ResourceMonitor.Performance.Disk.History.superclass.initEvents.apply(this,arguments);a.mon(a.controlLayer,"storagesUpdate",a.onStoragesUpdate,a)},onStoragesUpdate:function(){var a=this;if(!a.isVisible()||!a.history||!a.type){return false}a.setType(a.history,a.type)},setType:function(f,c){var e=this,b=[],d=e.controlLayer.historyType,a={};e.history=f;e.type=c;e.topLayer.setStatusLoading();Ext.each(e.controlLayer.getStoragesToDraw(),function(g){b.push(g.itemId)});if("disk"===d){a={disk:b}}else{if("space"===d){a={space:b}}}SYNO.API.Request({api:"SYNO.Core.System.Utilization",appWindow:e.topLayer.appWin,method:"get",version:1,params:{type:"history",resource:[d],time_range:f,interfaces:a,graph:c},scope:e,callback:e.LoadHistoryData})},LoadHistoryData:function(a,d,e,c){var b=this;if(b.isDestronyed){return}b.topLayer.clearStatusLoading();if(!a||!d){b.task.stop();b.topLayer.appWin.showAlert(_T(d.err_session,d.err_key),b.controlLayer.setToRealTime,b.controlLayer);return}if(!Ext.isDefined(d.data_size)||0===d.data_size){b.topLayer.appWin.showAlert(_T("rsrcmonitor","no_history"),b.controlLayer.setToRealTime,b.controlLayer);return}b.drawCharts(d,e)},drawCharts:function(b,c){var a=this;if("utilization"===c.graph){a.drawUtilizationChart(b,c)}if("transfer_rate"===c.graph){a.drawTransferRateChart(b,c)}if("iops"===c.graph){a.drawIopsChart(b,c)}a.doLayout()},drawUtilizationChart:function(b,e){var c=this,a=[],d={},f={};a=c.controlLayer.getStoragesToDraw();Ext.each(b[c.controlLayer.historyType],function(g){d[g.device]=g.utilization});f={flex:1,chartTitle:_T("rsrcmonitor","utilization")+" (%)",lines:a,timeAxis:e.time_range,dataType:"percent",data:d,dataSize:b.data_size,endTime:b.time,timeInterval:b.interval};c.chart1.show();c.chart2.hide();c.chart1.setChartConfig(f);c.chart1.drawChart()},drawTransferRateChart:function(b,e){var c=this,a=[],d={},f={};a=c.controlLayer.getStoragesToDraw();Ext.each(b[c.controlLayer.historyType],function(g){d[g.device]=g.read_byte});c.chart1.show();c.chart2.show();f={flex:1,chartTitle:_T("rsrcmonitor","read_speed"),lines:a,timeAxis:e.time_range,dataType:"bytes",dataBase:1,data:d,dataSize:b.data_size,endTime:b.time,timeInterval:b.interval};c.chart1.setChartConfig(f);d={};Ext.each(b[c.controlLayer.historyType],function(g){d[g.device]=g.write_byte});f.chartTitle=_T("rsrcmonitor","write_speed");f.data=d;c.chart2.setChartConfig(f);c.chart1.drawChart();c.chart2.drawChart()},drawIopsChart:function(b,e){var c=this,a=[],d={},f={};a=c.controlLayer.getStoragesToDraw();Ext.each(b[c.controlLayer.historyType],function(g){d[g.device]=g.read_access});c.chart1.show();c.chart2.show();f={flex:1,chartTitle:_T("rsrcmonitor","read"),lines:a,timeAxis:e.time_range,dataType:"normal",data:d,dataSize:b.data_size,endTime:b.time,timeInterval:b.interval};c.chart1.setChartConfig(f);d={};Ext.each(b[c.controlLayer.historyType],function(g){d[g.device]=g.write_access});f.chartTitle=_T("rsrcmonitor","write");f.data=d;c.chart2.setChartConfig(f);c.chart1.drawChart();c.chart2.drawChart()}});Ext.define("SYNO.SDS.ResourceMonitor.Performance.Space.SelectorDialog",{extend:"SYNO.SDS.ResourceMonitor.Performance.Disk.SelectorDialog",constructor:function(b){var d=this,c=[d.createVolumeGrid()];if("yes"===b.topLayer.appWin._D("support_iscsi_target_block")&&("yes"===_D("support_iscsi_target","no"))){c.push(d.createLunGrid())}var a=Ext.apply({grids:c},b);this.callParent([a])},createVolumeGrid:function(){var a=SYNO.SDS.ResourceMonitor.Performance.Disk.Utility;return this.createStorageGrid({itemId:"volume",title:_T("volume","volume"),nameIndex:"display_name",displayNameSorter:a.volumeSorter})},createLunGrid:function(){var a=SYNO.SDS.ResourceMonitor.Performance.Disk.Utility;return this.createStorageGrid({itemId:"lun",title:_T("volume","volume_iscsitrg_lun"),nameIndex:"display_name",displayNameSorter:a.defaultSorter})}});Ext.define("SYNO.SDS.ResourceMonitor.Performance.Space.Main",{extend:"SYNO.SDS.ResourceMonitor.Performance.Disk.Main",header_title:("yes"===_D("support_iscsi_target","no"))?_T("rsrcmonitor","space"):_T("tree","leaf_volume"),dataRoot:"space",historyType:"space",constructor:function(b){var a=Ext.apply({selectorDialogClass:SYNO.SDS.ResourceMonitor.Performance.Space.SelectorDialog},b);this.callParent([a])}});Ext.define("SYNO.SDS.ResourceMonitor.Performance.Network.Main",{extend:"Ext.Container",constructor:function(b){var a=Ext.apply({layout:"anchor",items:[],listeners:{activate:this.onActivate,scope:this}},b);this.callParent([a])},createComponent:function(c){var d=this,a=c.showHistory,b=false;if(!d.chartHeader){d.chartHeader=new SYNO.SDS.ResourceMonitor.Performance.Detail.Header({header_title:_T("rsrcmonitor","network"),topLayer:c.topLayer});d.add(d.chartHeader);if(!d.content){d.content=new SYNO.SDS.ResourceMonitor.Performance.Network.Content({topLayer:c.topLayer,anchor:"100% -37",header:d.chartHeader});d.add(d.content)}b=true}else{d.content.get("current").clearInterfaces();d.chartHeader.setToRealTime()}if(a===d.chartHeader.history_combo.hidden){if(a){d.chartHeader.history_combo.show();d.chartHeader.history_label.show()}else{d.chartHeader.history_combo.hide();d.chartHeader.history_label.hide()}b=true}if(b){d.doLayout(false,true)}},onActivate:function(){this.items.each(function(a){if(Ext.isFunction(a.onActivate)){a.onActivate()}},this)}});Ext.define("SYNO.SDS.ResourceMonitor.Performance.Network.Content",{extend:"Ext.Container",constructor:function(b){var a={itemId:"content",layout:"card",activeItem:0,items:[new SYNO.SDS.ResourceMonitor.Performance.Network.Current({itemId:"current",topLayer:b.topLayer,controlLayer:this}),new SYNO.SDS.ResourceMonitor.Performance.Network.History({itemId:"history",topLayer:b.topLayer,controlLayer:this})]};Ext.apply(a,b);this.callParent([a]);this.mon(b.header,"contentSelect",this.changeContent,this)},changeContent:function(a){if("current"===a.history){this.layout.setActiveItem("current")}else{this.layout.setActiveItem("history");this.get("history").setType(a.history,a.type)}},setToRealTime:function(){this.header.setToRealTime()},onActivate:function(){var a=this.layout.activeItem;if(Ext.isDefined(a)&&Ext.isFunction(a.onActivate)){a.onActivate()}}});Ext.define("SYNO.SDS.ResourceMonitor.Performance.Network.Current",{extend:"SYNO.ux.FormPanel",lastPollingData:null,constructor:function(b){var a={border:false,autoFlexcroll:true,topLayer:b.topLayer,items:[]};Ext.apply(a,b);this.callParent([a])},initEvents:function(){var a=this;SYNO.SDS.ResourceMonitor.Performance.Network.Current.superclass.initEvents.apply(a,arguments);a.mon(a.topLayer,"data_comming",function(b){a.updateData(b.network,b.time)});a.mon(a,"activate",a.onActivate,a)},onActivate:function(){this.items.each(function(a){if(Ext.isFunction(a.drawChart)){a.drawChart()}},this)},initComponent:function(){SYNO.SDS.ResourceMonitor.Performance.Network.Current.superclass.initComponent.apply(this,arguments);this.add(new SYNO.SDS.ResourceMonitor.Performance.Network.Current.Interface({topLayer:this.topLayer,itemId:"total"}))},updateData:function(c,e){var d=this,a=0,b;if(!c||!e){return}d.updateInterfaces(c);for(a=0;a<c.length;++a){b=d.get(c[a].device);if(b){b.updateData(c[a],e)}}},updateInterfaces:function(c){var d=this,f=false,a=0,b,g,e=[];if(c.length>2){d.get("total").show()}else{d.get("total").hide()}d.items.each(function(h){var i=Ext.each(c,function(j){if(j.device===h.itemId){return false}return true});if(!Ext.isDefined(i)){e.push(h)}},d);Ext.each(e,function(h){d.remove(h)});for(a=0;a<c.length;++a){b=d.get(c[a].device);if(!b){g=new SYNO.SDS.ResourceMonitor.Performance.Network.Current.Interface({topLayer:this.topLayer,itemId:c[a].device});d.insert(a,g);f=true}}if(f||e.size()>0){d.doLayout()}},clearInterfaces:function(){var a=this;a.items.each(function(b){if("total"!==b.itemId){a.remove(b)}else{b.hide()}})}});Ext.define("SYNO.SDS.ResourceMonitor.Performance.Network.Current.Interface",{extend:"Ext.Container",deviceName:"",constructor:function(c){var d,a;if("total"===c.itemId){this.deviceName=_T("rsrcmonitor","total")}else{a=c.itemId.replace(/\.\d+$/,"").replace(/\d+$/,"");if("bridge"===c.topLayer.appWin._S("net_topology")&&"wlan"===a){d="wifiap"}this.deviceName=SYNO.SDS.Utils.Network.idToString.apply(c.topLayer.appWin,[c.itemId,d])}this.chart=new SYNO.SDS.ResourceMonitor.Performance.Chart.Current({topLayer:c.topLayer,chartTitle:this.deviceName,totalTime:SYNO.SDS.ResourceMonitor.Performance.CurrentTotalTime,lines:[{itemId:"network_trans",lineName:_T("rsrcmonitor","rsrcmonitor_trans"),color:"#0086e6",trackColor:"#0086e6"},{itemId:"network_recv",lineName:_T("rsrcmonitor","rsrcmonitor_recv"),color:"#1eb300",trackColor:"#1eb300"}],height:155,margins:{top:0,right:0,bottom:0,left:0},dataType:"bytes"});var e='<div style="position: absolute; right: 0px;"><table><tbody><tr><td style="width: 105px;"> <div class="legend-color-dot legend-trans"></div>'+_T("rsrcmonitor","rsrcmonitor_trans")+'</td><td><div class="legend-color-dot legend-recv"></div>'+_T("rsrcmonitor","rsrcmonitor_recv")+"</td></tr></tbody></table></div>";var b={border:false,layout:"vbox",layoutConfig:{align:"stretch"},height:192,items:[this.chart,{xtype:"box",itemId:"legend",height:37,margins:{top:0,right:0,bottom:0,left:43},html:e}]};Ext.apply(b,c);this.callParent([b])},updateData:function(a,c){var b=this;b.chart.pushValue([a.tx,a.rx],c);b.chart.drawChart()},drawChart:function(){this.chart.drawChart()}});Ext.define("SYNO.SDS.ResourceMonitor.Performance.Network.History",{extend:"SYNO.ux.FormPanel",constructor:function(b){var a={itemId:"charts",border:false,autoFlexcroll:true,topLayer:b.topLayer,items:[]};Ext.apply(a,b);this.callParent([a])},setType:function(c){var b=this,a=[];b.controlLayer.get("current").items.items.each(function(d){if(Ext.isDefined(d.deviceName)&&"total"!==d.itemId){a.push(d.itemId)}});b.history=c;b.topLayer.setStatusLoading();SYNO.API.Request({api:"SYNO.Core.System.Utilization",appWindow:b.topLayer.appWin,method:"get",version:1,params:{type:"history",resource:["network"],time_range:c,interfaces:{network:a}},scope:b,callback:b.LoadHistoryData})},LoadHistoryData:function(a,d,e,c){var b=this;if(b.isDestronyed){return}b.topLayer.clearStatusLoading();if(!a||!d){b.topLayer.appWin.showAlert(_T(d.err_session,d.err_key),b.controlLayer.setToRealTime,b.controlLayer);return}if(!Ext.isDefined(d.data_size)||0===d.data_size){b.topLayer.appWin.showAlert(_T("rsrcmonitor","no_history"),b.controlLayer.setToRealTime,b.controlLayer);return}b.drawCharts(d,e)},drawCharts:function(b,c){var a=this;a.updateInterfaces(b,c);a.items.eachKey(function(d,e){e.drawChart()},a)},updateInterfaces:function(e,g){var c=this,b="",f,a=0,d=[];c.items.each(function(h){var i=Ext.each(e.network,function(j){if(j.device===h.itemId){return false}return true});if(!Ext.isDefined(i)){d.push(h.itemId)}},c);Ext.each(d,function(h){c.remove(h)});for(a=0;a<e.network.length;++a){b=c.get(e.network[a].device);if(!b){b=new SYNO.SDS.ResourceMonitor.Performance.Network.History.Interface({itemId:e.network[a].device});c.add(b);f=true}b.setChartConfig({topLayer:c.topLayer,timeAxis:g.time_range,data:e.network[a],dataSize:e.data_size,endTime:e.time,timeInterval:e.interval})}if(f){c.doLayout()}}});Ext.define("SYNO.SDS.ResourceMonitor.Performance.Network.History.Interface",{extend:"Ext.Container",deviceName:"",constructor:function(b){this.chart=new SYNO.SDS.ResourceMonitor.Performance.Chart.History({lines:[{itemId:"tx",lineName:_T("rsrcmonitor","rsrcmonitor_trans"),color:"#0086e6",trackColor:"#0086e6"},{itemId:"rx",lineName:_T("rsrcmonitor","rsrcmonitor_recv"),color:"#1eb300",trackColor:"#1eb300"}],height:155,margins:{top:0,right:0,bottom:0,left:0},dataType:"bytes",dataBase:1});var c='<div style="position: absolute; right: 0px;"><table><tbody><tr><td style="width: 105px;"> <div class="legend-color-dot legend-trans"></div>'+_T("rsrcmonitor","rsrcmonitor_trans")+'</td><td><div class="legend-color-dot legend-recv"></div>'+_T("rsrcmonitor","rsrcmonitor_recv")+"</td></tr></tbody></table></div>";var a={border:false,layout:"vbox",layoutConfig:{align:"stretch"},height:192,items:[this.chart,{xtype:"box",itemId:"legend",height:37,margins:{top:0,right:0,bottom:0,left:43},html:c}]};Ext.apply(a,b);this.callParent([a])},setChartConfig:function(b){var d=this,c,a=d.itemId.replace(/\.\d+$/,"").replace(/\d+$/,"");if("bridge"===b.topLayer.appWin._S("net_topology")&&"wlan"===a){c="wifiap"}b.chartTitle=SYNO.SDS.Utils.Network.idToString.apply(b.topLayer.appWin,[d.itemId,c]);d.chart.setChartConfig(b)},drawChart:function(){this.chart.drawChart()}});SYNO.SDS.ResourceMonitor.Performance.CurrentTotalTime=15*60;SYNO.SDS.ResourceMonitor.Performance.CurrentChartTotalDot=300;Ext.define("SYNO.SDS.ResourceMonitor.Performance.Main",{extend:"SYNO.SDS.Utils.TabPanel",time_range:"current",constructor:function(b){var a=Ext.apply({activeTab:0,syncTabsActiveEvent:false,cls:"resource-monitor-performance",useDefaultBtn:false,items:[new SYNO.SDS.ResourceMonitor.Performance.Overview.Main({cls:"performance-overview",itemId:"overview_main",topLayer:this,appWin:b.appWin,title:_T("rsrcmonitor","overview")}),new SYNO.SDS.ResourceMonitor.Performance.CPU.Main({cls:"performance-cpu",itemId:"cpu_main",title:_T("rsrcmonitor","cpu")}),new SYNO.SDS.ResourceMonitor.Performance.Memory.Main({cls:"performance-memory",itemId:"mem_main",title:_T("rsrcmonitor","memory")})],listeners:{scope:this,activate:this.onActivate}},b);a.items.push(new SYNO.SDS.ResourceMonitor.Performance.Disk.Main({cls:"performance-disk",itemId:"disk_main",title:_T("rsrcmonitor","disk")}));if("yes"!==b.appWin._D("usbstation")){a.items.push(new SYNO.SDS.ResourceMonitor.Performance.Space.Main({cls:"performance-disk",itemId:"space_main",title:("yes"===_D("support_iscsi_target","no"))?_T("rsrcmonitor","space"):_T("tree","leaf_volume")}))}a.items.push(new SYNO.SDS.ResourceMonitor.Performance.Network.Main({cls:"performance-network",itemId:"net_main",title:_T("rsrcmonitor","network")}));return this.callParent([Ext.apply(a)])},initEvents:function(){var a=this;SYNO.SDS.ResourceMonitor.Performance.Main.superclass.initEvents.apply(a,arguments);a.setStatusLoading();if(false===a.appWin.hasOpenConfig("is_cms_open")){a.LoadConfig()}a.mon(a.appWin,"server_change",a.onServerChange,a);a.mon(a.appWin,"server_ready",a.LoadConfig,a)},LoadConfig:function(){var a=this;SYNO.API.Request({api:"SYNO.ResourceMonitor.Setting",appWindow:a.appWin,method:"get",version:1,scope:a,callback:a.onLoadConfigDone});a.no_data=true},onLoadConfigDone:function(a,f,h,d){var c=this,e=SYNO.SDS.ResourceMonitor.Performance,g=false;if(!a){c.appWin.showAlert(_T("common","commfail"),c.appWin.close,c.appWin);return}if(Ext.isNumber(f.duration)){e.CurrentTotalTime=f.duration*60}if(Ext.isDefined(f.enable_history)&&f.enable_history){g=true}var b={showHistory:g,topLayer:c};this.items.each(function(i){if(Ext.isFunction(i.createComponent)){i.createComponent(b)}if(Ext.isFunction(i.onActivate)){i.onActivate()}},this);c.StartPollTask()},StartPollTask:function(){var a=this,b=SYNO.SDS.ResourceMonitor.Performance;if(a.performancePollTask){return}a.performancePollTask=a.pollReg({webapi:{api:"SYNO.Core.System.Utilization",appWindow:a.appWin,method:"get",version:1,params:{type:"current"}},immediate:true,interval:(b.CurrentTotalTime/b.CurrentChartTotalDot),scope:a,status_callback:a.LoadPollData})},StopPollTask:function(){if(this.performancePollTask){this.pollUnreg(this.performancePollTask);this.performancePollTask=undefined}},LoadPollData:function(a,d,e,c){var b=this;if(b.isDestroyed){return}if(!a){if(b.no_data){b.appWin.showAlert(_T("common","commfail"),b.appWin.close,b.appWin)}return}b.fireEvent("data_comming",d);if(b.no_data){b.no_data=false;if(b.isVisible()){b.clearStatusLoading()}}},clearStatusLoading:function(){this.appWin.clearStatusLoading()},setStatusLoading:function(){this.appWin.setStatusLoading()},setTimeRange:function(a){if("current"!==a&&"day"!==a&&"week"!==a&&"month"!==a&&"year"!==a){return}this.time_range=a},onActivate:function(a){if(!Ext.isDefined(a.targetReady)||false===a.targetReady){this.items.each(function(b){if(Ext.isFunction(b.onActivate)){b.onActivate()}},this)}},onServerChange:function(){this.StopPollTask()},fileSizeUnit:function(a){var b=0,c="bytes";if(a<1024){b=a;c="bytes"}else{if(a<1048576){b=Math.round(((a*10)/1024))/10;c="KB"}else{if(a<1073741824){b=Math.round(((a*10)/1048576))/10;c="MB"}else{b=Math.round(((a*10)/1073741824))/10;c="GB"}}}return{size:""+b,unit:c}}});SYNO.SDS.ResourceMonitor.PollingIntervalMs=5000;Ext.define("SYNO.SDS.ResourceMonitor.Top.Main",{extend:"SYNO.ux.GridPanel",border:false,frame:false,constructor:function(b){var a={title:_T("rsrcmonitor","process"),itemId:"top",store:this.createStore(b),colModel:this.configColumnModel(),viewConfig:{forceFit:true,onLoad:Ext.emptyFn,listeners:{beforerefresh:function(c){c.scrollTop=c.scroller.dom.scrollTop},refresh:function(c){c.scroller.dom.scrollTop=c.scrollTop}}}};Ext.apply(a,b);return this.callParent([Ext.apply(a)])},initEvents:function(){var a=this;SYNO.SDS.ResourceMonitor.Top.Main.superclass.initEvents.apply(this,arguments);a.task=a.appWin.addTask({interval:SYNO.SDS.ResourceMonitor.PollingIntervalMs,scope:a.store,run:a.store.load});a.mon(a,"activate",a.onActivate,a);a.mon(a,"deactivate",function(){a.task.stop()});a.mon(a.appWin,"server_change",a.onServerChange,a)},onServerChange:function(){this.task.stop();this.store.removeAll()},onActivate:function(a){if(a&&a.targetReady){this.mon(this.store,"load",this.clearStatusLoading,this,{single:true})}this.task.start(true)},kbfileSize:function(a){return Ext.util.Format.fileSize(a*1024)},processStatus:function(a){switch(a){case"R":return _T("rsrcmonitor","running");case"S":return _T("rsrcmonitor","sleeping");case"T":return _T("rsrcmonitor","stopped");default:return _T("rsrcmonitor","sleeping")+" ("+a+")"}},createStore:function(a){var b=this;var c=new SYNO.API.Store({api:"SYNO.Core.System",version:"1",method:"info",baseParams:{type:"process"},appWindow:a.appWin,listeners:{scope:b},reader:new Ext.data.JsonReader({idProperty:"pid",root:"process"},["command","status","cpu","mem"]),remoteSort:false,sortInfo:{field:"cpu",direction:"DESC"},autoDestroy:true});return c},configColumnModel:function(){var a=new Ext.grid.ColumnModel({columns:[{header:_T("rsrcmonitor","process_name"),dataIndex:"command",width:200,align:"left"},{header:_T("common","status"),dataIndex:"status",renderer:this.processStatus,width:100,align:"left"},{header:_T("rsrcmonitor","cpu")+"(%)",dataIndex:"cpu",renderer:function(b){return b/10},width:100,align:"left"},{header:_T("rsrcmonitor","memory"),dataIndex:"mem",renderer:this.kbfileSize,width:100,align:"left"}],defaults:{sortable:true,menuDisabled:false}});return a},setStatusLoading:function(){this.appWin.setStatusLoading()},clearStatusLoading:function(){this.appWin.clearStatusLoading()}});Ext.define("SYNO.SDS.ResourceMonitor.Setting.Main",{extend:"SYNO.SDS.Utils.FormPanel",constructor:function(a){return this.callParent([Ext.apply({useDefaultBtn:false,buttons:[{xtype:"syno_button",btnStyle:"blue",disabled:a.appWin._S("demo_mode"),tooltip:a.appWin._S("demo_mode")?_JSLIBSTR("uicommon","error_demo"):"",text:_T("common","commit"),scope:this,handler:this.applyHandler},{xtype:"syno_button",btnStyle:"grey",text:_T("common","reset"),scope:this,handler:this.resetHandler}],items:[this.createPerformanceField()]},a)])},createPerformanceField:function(){var a={xtype:"syno_fieldset",collapsible:false,title:_T("rsrcmonitor","performance"),synodefaults:{width:150},items:[{xtype:"syno_combobox",name:"duration",fieldLabel:_T("rsrcmonitor","realtime_minutes"),store:[[15,"15 "+_T("rsrcmonitor","minutes")],[30,"30 "+_T("rsrcmonitor","minutes")],[60,"60 "+_T("rsrcmonitor","minutes")],[120,"120 "+_T("rsrcmonitor","minutes")]]},{xtype:"syno_checkbox",name:"enable_history",boxLabel:_T("rsrcmonitor","enable_history")}]};return a},onLoadConfigDone:function(a,c,d,b){if(!a){return}this.getForm().setValues(c);if(this.isVisible()){this.clearStatusLoading()}},LoadConfig:function(){var a=this;SYNO.API.Request({api:"SYNO.ResourceMonitor.Setting",appWindow:a.appWin,method:"get",version:1,scope:a,callback:a.onLoadConfigDone})},initEvents:function(){var a=this;SYNO.SDS.ResourceMonitor.Setting.Main.superclass.initEvents.apply(a,arguments);a.LoadConfig();a.mon(a.appWin,"server_ready",a.LoadConfig,a)},applyHandler:function(){var a=this;if(!a.onBeforeActionApply()){return}a.appWin.getMsgBox().confirm(_T("tree","leaf_rsrcmonitor"),_T("rsrcmonitor","warring_restart"),a.confirmApply,a)},confirmApply:function(a){var c=this,b=c.getForm();if("no"===a){return}c.appWin.sendWebAPI({compound:{params:[{api:"SYNO.ResourceMonitor.Setting",method:"set",version:1,params:{enable_history:b.findField("enable_history").getValue(),duration:b.findField("duration").getValue()}},{api:"SYNO.ResourceMonitor.Setting",method:"get",version:1}]},scope:c,callback:c.onActionComplete});c.setStatusBusy({text:_T("common","saving")})},resetHandler:function(){this.getForm().reset()},onBeforeActionApply:function(){var b=this,a=b.getForm();if(!a.isDirty()){b.setStatusError({text:_T("error","nochange_subject"),clear:true});return false}if(!a.isValid()){b.setStatusError({text:_T("common","forminvalid"),clear:true});return false}return true},onActionComplete:function(a,d,e,c){var b=this;b.clearStatusBusy();if(true===a&&false===d.has_fail){b.getForm().setValues(d.result[1].data);b.appWin.close();Ext.defer(SYNO.SDS.AppLaunch,500,null,["SYNO.SDS.ResourceMonitor.Instance",b.appWin.openConfig])}else{if(false===d.result[0].success){b.appWin.showAlert(_T(d.result[0].error.errors.err_session,d.result[0].error.errors.err_key));if(d.result[1].data){b.getForm().setValues(d.result[1].data)}}}},setStatusBusy:function(a){a=a||{};Ext.applyIf(a,{text:_T("common","loading"),iconCls:"x-mask-loading"});this.el.mask(a.text,a.iconCls)},clearStatusBusy:function(){var a=this;a.el.unmask()},setStatusOK:function(a){a=a||{};Ext.applyIf(a,{text:_T("common","setting_applied"),iconCls:"x-status-valid"});this.getFooterToolbar().setStatus(a)},setStatusError:function(a){a=a||{};Ext.applyIf(a,{text:_T("common","error_system"),iconCls:"x-status-error",clear:true});this.getFooterToolbar().setStatus(a)},setStatusLoading:function(){this.appWin.setStatusLoading()},clearStatusLoading:function(){this.appWin.clearStatusLoading()}});Ext.define("SYNO.SDS.ResourceMonitor.Factory",{statics:{CurConnPanel:function(a){return new SYNO.SDS.ResourceMonitor.CurConn(a).getPanel()}}});Ext.define("SYNO.SDS.ResourceMonitor.CurConn",{extend:"Ext.util.Observable",itemsPerPage:50,lstLog:null,firstActivated:true,appInst:null,grid:null,constructor:function(b){this.topwin=b.appWin;this.appInst=b.appWin.appInstance;this.callParent(arguments);this.searchField=new SYNO.ux.TextFilter({itemId:"search",queryParam:"filter",emptyText:_T("connections","search_connections"),store:this.getCurConnStore(),pageSize:this.itemsPerPage,disabled:true});var a=new Ext.Toolbar({defaultType:"syno_button"});a.add({text:_T("log","log_save"),itemId:"bt_save",handler:this.onLogSave,scope:this,disabled:true},{text:_T("log","log_reload"),itemId:"bt_refresh",handler:function(){this.paging.doRefresh()},scope:this,disabled:true},{text:_T("connections","kick_connection_br"),itemId:"bt_kick",disabled:true,handler:this.kickConnection,scope:this},{text:_T("connections","disable_this_account"),itemId:"bt_disable_account",disabled:true,handler:this.disableUser,scope:this},"->",this.searchField);this.paging=new SYNO.ux.PagingToolbar({store:this.getCurConnStore(),displayInfo:true,pageSize:this.itemsPerPage,refreshText:_T("log","log_reload")});var c=new SYNO.ux.GridPanel({itemId:"curconn",title:_T("connections","connections_title"),store:this.getCurConnStore(),colModel:this.getCurrConCM(),tbar:a,bbar:this.paging,sm:new Ext.grid.RowSelectionModel({listeners:{selectionchange:{fn:this.updateToolBarBts,scope:this,buffer:80}}}),autoExpandColumn:"descr",loadMask:true,stripeRows:true,listeners:{scope:this,activate:function(f){if(this.topwin.hasOpenConfig("is_cms_open")||(f&&f.targetReady)){var e=this.topwin.getTargetData();if(0>e.id){return}else{if(0===e.id){this.topwin.openConfig.cms_id=undefined}else{this.topwin.openConfig.cms_id=e.id}}}var d=this.grid.getTopToolbar();d.getComponent("bt_save").enable();d.getComponent("bt_refresh").enable();this.searchField.enable();this.onLoad()}}});this.grid=c;c.mon(c,"rowcontextmenu",this.showGridCtxMenu,this)},onLoad:function(){var a=this.grid.getStore();a.removeAll();a.load({params:{start:0,limit:this.itemsPerPage}})},onLogSave:function(){if(_S("demo_mode")){this.topwin.getMsgBox().alert(this.topwin.title,_JSLIBSTR("uicommon","error_demo"));return}var a=this.grid.getStore();this.topwin.downloadWebAPI({webapi:{api:"SYNO.Core.CurrentConnection",method:"download",version:1,params:{sort_by:a.sortInfo.field,sort_direction:a.sortInfo.direction,filter:a.lastOptions.params.filter}}})},getPanel:function(){return this.grid},getCurConnStore:function(){if(this.dsCurCon){return this.dsCurCon}var a=new SYNO.API.Store({autoLoad:false,api:"SYNO.Core.CurrentConnection",method:"list",version:"1",appWindow:this.topwin,reader:new Ext.data.JsonReader({root:"items",totalProperty:"total"},["pid","time","who","type","descr","from","user_can_be_disabled","can_be_kicked"]),sortInfo:{field:"time",direction:"DESC"},remoteSort:true,listeners:{scope:this,beforeload:function(b,c){if(!Ext.isDefined(c.params.offset)){c.params.offset=c.params.start}if(!Ext.isDefined(c.params.start)){c.params.start=c.params.offset}},load:{fn:function(c,b,d){this.grid.getView().updateScroller()}}}});this.dsCurCon=a;this.topwin.addManagedComponent(a);return a},getCurrConCM:function(){if(this.cmCurrCon){return this.cmCurrCon}var a=new Ext.grid.ColumnModel({columns:[{header:_T("log","log_time"),dataIndex:"time",width:150,align:"center"},{header:_T("log","log_account"),dataIndex:"who",width:100,align:"center",renderer:this.whoRender},{header:_T("log","log_client"),dataIndex:"from",width:200,align:"center"},{header:_T("routerconf","routerconf_header_service"),dataIndex:"type",width:87,align:"center"},{id:"descr",header:_T("log","log_resource"),dataIndex:"descr",width:300,align:"left",renderer:this.htmlEncodeRender}],defaults:{sortable:true,menuDisabled:true}});this.cmCurrCon=a;return a},htmlEncodeRender:function(c,b){var a=Ext.util.Format.htmlEncode(c);b.attr='ext:qtip="'+Ext.util.Format.htmlEncode(a)+'"';return a},whoRender:function(b,a){if(b.empty()){return"-"}return b},showGridCtxMenu:function(a,d,b){b.preventDefault();var c=a.getSelectionModel();if(!c.isSelected(d)){c.selectRow(d)}this.getGridCtxMenu().showAt(b.getXY())},getGridCtxMenu:function(){if(!this.CurrConRowCtxMenu){this.CurrConRowCtxMenu=new Ext.menu.Menu({itemId:"adminCtxMenu",ignoreParentClicks:"true",items:[{itemId:"kick_conn",text:_T("connections","kick_connection"),handler:this.kickConnection,scope:this},{itemId:"disable_account",text:_T("connections","disable_this_account"),handler:this.disableUser,scope:this}]});this.topwin.addManagedComponent(this.CurrConRowCtxMenu)}return this.CurrConRowCtxMenu},kickConnection:function(){var f=this.grid.getSelectionModel();var d=f.getSelections();if(0===d.length){return}var c=[];var a=[];var e=false;for(var b=0;b<d.length;++b){if("HTTP/HTTPS"===d[b].get("type")){a.push({who:d[b].get("who"),from:d[b].get("from")})}else{c.push({pid:d[b].get("pid"),type:d[b].get("type"),who:d[b].get("who"),from:d[b].get("from")})}if(_S("user")===d[b].get("who")){e=true}}if(e){this.topwin.getMsgBox().confirm(_T("connections","connections_title"),_T("connections","confirm_kick_self"),function(g,h){if(g==="yes"){this.doKickConnection(c,a)}},this)}else{this.doKickConnection(c,a)}},doKickConnection:function(b,a){this.grid.getEl().mask(_T("common","msg_waiting"),"x-mask-loading");this.topwin.sendWebAPI({api:"SYNO.Core.CurrentConnection",method:"kick_connection",timeout:450000,params:{service_conn:b,http_conn:a},version:1,scope:this,callback:function(c,d){this.grid.getEl().unmask();if(!c){this.topwin.getMsgBox().alert("",SYNO.API.Erros.core[d.code]||_T("common","commfail"))}else{this.paging.doRefresh()}}})},disableUser:function(){var d=this.grid.getSelectionModel();var b=d.getSelections();if(0===b.length){return}var c=[];for(var a=0;a<b.length;++a){if(_S("user")===b[a].get("who")||false===b[a].get("user_can_be_disabled")){continue}c.push(b[a].get("who"))}if(0===c.length){return}this.grid.getEl().mask(_T("common","msg_waiting"),"x-mask-loading");this.topwin.sendWebAPI({api:"SYNO.Core.CurrentConnection",method:"disable_user",timeout:450000,params:{users:c},version:1,scope:this,callback:function(e,f){this.grid.getEl().unmask();if(!e){this.topwin.getMsgBox().alert("",SYNO.API.Erros.core[f.code]||_T("common","commfail"))}else{this.paging.doRefresh()}}})},updateToolBarBts:function(b){var d=0;var k=b.getSelections();var g=this.grid.getTopToolbar();var c=g.getComponent("bt_kick");var e=this.getGridCtxMenu().get("kick_conn");var h=g.getComponent("bt_disable_account");var j=this.getGridCtxMenu().get("disable_account");var a=true;var f=true;c.disable();e.disable();h.disable();j.disable();if(0===k.length||_S("demo_mode")){return}for(d=0;d<k.length;++d){if(_S("user")===k[d].get("who")||false===k[d].get("user_can_be_disabled")){f=false;break}}for(d=0;d<k.length;++d){if(false===k[d].get("can_be_kicked")){a=false;break}}if(f){h.enable();j.enable()}if(a){c.enable();e.enable()}}});Ext.define("SYNO.SDS.ResourceMonitor.Instance",{extend:"SYNO.SDS.AppInstance",appWindowName:"SYNO.SDS.ResourceMonitor.App"});Ext.define("SYNO.SDS.ResourceMonitor.App",{extend:"SYNO.SDS.PageListAppWindow",activePage:"SYNO.SDS.ResourceMonitor.Performance.Main",constructor:function(a){this.appInstance=a.appInstance;this.addEvents("afterlaunchpage");this.callParent([this.fillConfig(a)])},fillConfig:function(a){var b={itemId:"mainWin",minWidth:860,minHeight:500,width:1024,height:580};Ext.apply(b,a);return b},getPageList:function(a){var b;if(!this.pageList){b={region:"west",width:240,tbar:{items:this.getCMSComboBox()},listeners:{scope:this,single:true,load:{fn:this.onLoad,buffer:50}}};var c={listItems:[{text:_T("rsrcmonitor","performance"),iconCls:"icon-performance",fn:"SYNO.SDS.ResourceMonitor.Performance.Main"},{text:_T("rsrcmonitor","process"),iconCls:"icon-process",fn:"SYNO.SDS.ResourceMonitor.Top.Main"},{text:_T("connections","connections_title"),iconCls:"icon-connect",owner:this,fn:"SYNO.SDS.ResourceMonitor.Factory.CurConnPanel"},{text:_T("rsrcmonitor","speed_limit"),iconCls:"icon-speed",fn:"SYNO.SDS.BandwidthControl.Status"},{text:_T("common","common_settings"),fn:"SYNO.SDS.ResourceMonitor.Setting.Main"}]};Ext.apply(b,c);this.pageList=new SYNO.ux.ModuleList(b)}return this.pageList},onOpen:function(a){if(a.hasOwnProperty("cms_id")){this.on("afterlaunchpage",function(){SYNO.API.Request({api:"SYNO.CMS.DS",params:{additional:["host","http_port","https_port","extra_info"],offset:0,limit:1000,sort_by:"hostname",sort_direction:"ASC"},method:"list",version:1,param:a,scope:this,callback:this.onListServerDone})},this,{single:true})}this.callParent(arguments)},onRequest:function(a){this.callParent(arguments);if(this.hasOpenConfig("is_cms_open")){this.getCMSComboBox().setValue(a.cms_id).fireEvent("select")}},onListServerDone:function(b,d,c,j){if(!b){alert("WebAPI Fail: SYNO.CMS.Server - list");return}var h=[],k=j.param.cms_id;for(var f=0;f<d.count;f++){var a={};try{a=Ext.util.JSON.decode(d.ds_info_list[f].additional.extra_info)}catch(g){a={self:false}}h.push([d.ds_info_list[f].hostname,d.ds_info_list[f].id,d.ds_info_list[f].additional.host,d.ds_info_list[f].additional.http_port,d.ds_info_list[f].additional.https_port,a])}if(_S("is_admin")){h.push([_T("rsrcmonitor","localhost"),0,"","","",""])}if(0<h.length){this.getCMSComboBox().store=new Ext.data.ArrayStore({data:h,fields:["hostname","id","host","http_port","https_port","extra_info"]});this.getCMSComboBox().setValue(k).show();this.getActivePage().fireEvent("activate",{targetReady:true});this.fireEvent("server_ready");this.lastCMSComboBoxValue=k}else{this.showAlert(_T("common","commfail"),this.close,this)}},onLoad:function(a){this.callParent(arguments)},getCMSComboBox:function(){if(this.cmdComboBox){return this.cmdComboBox}this.cmdComboBox=new SYNO.ux.ComboBox({width:212,itemId:"client_combobox",value:-1,valueField:"id",displayField:"hostname",store:new Ext.data.ArrayStore({data:[["",-1,null,null,null,null]],fields:["hostname","id","host","http_port","https_port","extra_info"]}),hidden:true,listeners:{scope:this,select:this.onSelectCMSComboBox,beforeselect:this.onBeforeSelectCMSComboBox}});return this.cmdComboBox},onSelectCMSComboBox:function(a,b){if(this.lastCMSComboBoxValue!==this.getCMSComboBox().getValue()){this.updateOpenConfig();this.fireEvent("server_change");if(Ext.isFunction(this.findAppWindow().getActivePage().setStatusLoading)){this.findAppWindow().getActivePage().setStatusLoading()}if(!Ext.isDefined(this.openConfig.cms_id)){this.onSelectCMSComboBoxDone()}else{SYNO.API.Info.UpdateById({cms_id:this.openConfig.cms_id,callback:this.onSelectCMSComboBoxDone,args:arguments,scope:this})}}},onSelectCMSComboBoxDone:function(){this.fireEvent("server_ready");this.findAppWindow().getActivePage().fireEvent("activate",{targetReady:true});this.lastCMSComboBoxValue=this.getCMSComboBox().getValue()},onBeforeSelectCMSComboBox:function(d,b,c){var e=this,a=this.getActivePage();if(a&&Ext.isFunction(a.onPageDeactivate)){if(false===a.onPageDeactivate()){e.getCMSComboBox().setValue(b.get("id"));e.getCMSComboBox().collapse();e.confirmLostChange(function(f){if(a&&Ext.isFunction(a.onPageConfirm)){a.onPageConfirm(f)}if(f==="yes"){e.onSelectCMSComboBox(d,b)}else{e.getCMSComboBox().setValue(d.startValue)}},e);return false}}},updateOpenConfig:function(){var a=this.getTargetData();if(this.hasOpenConfig("is_cms_open")){if(0>a.id){return}else{if(0===a.id){this.openConfig.cms_id=undefined}else{this.openConfig.cms_id=a.id}}}},setStatusLoading:function(){if(true===this.isStatusLoading){return}this.isStatusLoading=true;this.getEl().mask(_T("common","loading"),"x-mask-loading")},clearStatusLoading:function(){if(true!==this.isStatusLoading){return}this.getEl().unmask();this.isStatusLoading=false},showAlert:function(e,c,b){e=e||_T("common","commfail");if(e===_T("error","volume_no_volumes")||(e===_T("error","db_connect_fail")&&"yes"===this.findAppWindow()._D("usbstation"))){var d=new SYNO.SDS.MessageBoxV5({owner:this}),a=d.fbButtons.ok;if("yes"===this.findAppWindow()._D("usbstation")){e=_T("system","require_pgsql");e+=(e?"<br>":"")+String.format(_T("pkgmgr","prompt_enable_serviece"),_T("controlpanel","metadata_title"));if(false===this.hasOpenConfig("is_cms_open")){this.mon(a,"click",function(){SYNO.SDS.AppLaunch("SYNO.SDS.AdminCenter.Application",{fn:"SYNO.SDS.AdminCenter.SystemDatabase.Main"})},this)}else{this.mon(a,"click",function(){var f=new SYNO.SDS.CMS.DSMgr({owner:this});f.onLaunchDS(this.getTargetData(),{url:"/webman/index.cgi?launchApp=SYNO.SDS.AdminCenter.Application"})},this)}}else{if(false===this.hasOpenConfig("is_cms_open")){this.mon(a,"click",function(){SYNO.SDS.AppLaunch("SYNO.SDS.StorageManager.Instance")},this)}else{this.mon(a,"click",function(){var f=new SYNO.SDS.CMS.DSMgr({owner:this});f.onLaunchDS(this.getTargetData(),{url:"/webman/index.cgi?launchApp=SYNO.SDS.StorageManager.Instance"})},this)}}d.confirm(_T("tree","leaf_rsrcmonitor"),e,null,this,Ext.MessageBox.OKCANCEL)}else{this.getMsgBox().alert(_T("tree","leaf_rsrcmonitor"),e,c,b)}},getTargetData:function(){var d={};if(true===this.hasOpenConfig("is_cms_open")){var c=this.getCMSComboBox().getValue(),a=this.getCMSComboBox().store,b=a.getAt(a.findExact("id",c)).data;d=b}return d},launchPage:function(c){var b=this.pageCt,a=b.getComponent(c);if(!a){a=this.createPage(c);b.add(a)}if(!a){return false}b.layout.setActiveItem(c);this.activePage=a;if(a instanceof Ext.TabPanel&&Ext.isFunction(a.setActiveTab)){a.setActiveTab(0)}if(a.onPageActivate){a.onPageActivate(this.openParams)}this.fireEvent("afterlaunchpage");return true}});Ext.ns("SYNO.SDS.ResourceMonitor");Ext.define("SYNO.SDS.ResourceMonitor.MiniWidget",{extend:"SYNO.SDS._SystemTray.Component",constructor:function(a){var b=this;a=Ext.apply(a,{baseCls:"resource-monitor-widget-mini",height:24});b.callParent(arguments)},onRender:function(c,a){var d=this,b=new Ext.Template('<div class="{cls}">','<div class="{cls}-wrap">','<div class="{cls}-cpu">','<div class="{cls}-cpu-text">',"</div>",'<div class="{cls}-cpu-bar">','<div class="{cls}-cpu-value">',"</div>","</div>",'<div class="x-clear"></div>',"</div>",'<div class="{cls}-mem">','<div class="{cls}-mem-text">',"</div>",'<div class="{cls}-mem-bar">','<div class="{cls}-mem-value">',"</div>","</div>",'<div class="x-clear"></div>',"</div>","</div>",'<div class="{cls}-wrap">','<div class="{cls}-upload">','<div class="{cls}-upload-text">',"</div>",'<div class="{cls}-upload-value">',"</div>",'<div class="x-clear"></div>',"</div>",'<div class="{cls}-download">','<div class="{cls}-download-text">',"</div>",'<div class="{cls}-download-value">',"</div>",'<div class="x-clear"></div>',"</div>","</div>","</div>");d.el=a?b.insertBefore(a,{cls:d.baseCls},true):b.append(c,{cls:d.baseCls},true);if(d.id){d.el.dom.id=d.id}d.memValueBar=d.el.child(String.format("div.{0}-mem-value",d.baseCls));d.cpuValueBar=d.el.child(String.format("div.{0}-cpu-value",d.baseCls));d.uploadValue=d.el.child(String.format("div.{0}-upload-value",d.baseCls));d.downloadValue=d.el.child(String.format("div.{0}-download-value",d.baseCls));d.callParent(arguments)},afterRender:function(){var a=this;a.callParent(arguments);a.setCpuValue(0);a.setMemValue(0)},setCpuValue:function(a){this.setValueBar(a,this.cpuValueBar)},setMemValue:function(a){this.setValueBar(a,this.memValueBar)},setUploadValue:function(b,a){this.setTransferValue(this.uploadValue,b,a)},setDownloadValue:function(b,a){this.setTransferValue(this.downloadValue,b,a)},setTransferValue:function(f,g,h){var a=[],b=0,c="",e='<div class="num-{0}" ext:qtip="{1}"></div>',d='<div class="unit-{0}" ext:qtip="{1}"></div>',k="",j="";g=Ext.isNumber(g)?g:0;h=Ext.isString(h)?h:"KB";g+="";a=g.split("");k=Ext.util.Format.htmlEncode(Ext.util.Format.htmlEncode(g+" "+h));for(b=0;b<a.length;b++){j=a[b];if(j==="."){j="dot"}c+=String.format(e,Ext.util.Format.htmlEncode(j),k)}c+=String.format(d,h,k);f.set({"ext:qtip":k});f.update(c)},setValueBar:function(c,b){var a=b.parent().getWidth();c=Ext.isNumber(c)?Math.min(c,100):100;b.removeClass(["high","very-high"]);if(c>90){b.addClass("very-high")}else{if(c>80){b.addClass("high")}}b.setWidth(a*c/100);b.set({"ext:qtip":Ext.util.Format.htmlEncode(Ext.util.Format.htmlEncode(c))+"&#37;"});b.parent().set({"ext:qtip":Ext.util.Format.htmlEncode(Ext.util.Format.htmlEncode(c))+"&#37;"})}});SYNO.SDS.ResourceMonitor.WidgetBriefChartMaxTime=3*60;SYNO.SDS.ResourceMonitor.PollingInterval=5;SYNO.SDS.ResourceMonitor.Widget=Ext.extend(Ext.Panel,{prevText:_JSLIBSTR("extlang","prevpage"),nextText:_JSLIBSTR("extlang","nextpage"),layout:"vbox",style:"padding-top: 8px",activeNetworkTrafficIndex:0,cls:"resource-monitor-widget",minimizable:true,toggleButtonCls:SYNO.SDS.ResourceMonitor.MiniWidget,taskButton:undefined,constructor:function(a){SYNO.SDS.ResourceMonitor.Widget.superclass.constructor.apply(this,arguments);this.initPanels()},onActivate:function(){this.isActive=true;if(this.pollTaskID){this.networkCharts.items.each(function(a){a.clearValues()})}this.startPollingTask();this.mask(_T("common","loading"))},onDeactivate:function(){this.isActive=false;this.stopPollingTask()},getDefChartCfg:function(){return{collapsed:false,baseCls:"resource-Monitor-widget-panel",totalRecords:SYNO.SDS.ResourceMonitor.BriefTotalRecords}},startPollingTask:function(){var a=this;if(a.pollTaskID){return}a.pollTaskID=a.pollReg({webapi:{api:"SYNO.Core.System.Utilization",method:"get",version:1,params:{type:"current",resource:["cpu","memory","network"]}},immediate:true,interval:SYNO.SDS.ResourceMonitor.PollingInterval,scope:a,status_callback:a.onAjaxRequestDone})},stopPollingTask:function(){if(this.pollTaskID){this.pollUnreg(this.pollTaskID);this.pollTaskID=undefined}},mask:Ext.emptyFn,unmask:Ext.emptyFn,initPanels:function(){this.cpuChart=this.initCpuChart();this.memChart=this.initMemChart();this.networkCharts=this.initNetworkPanel();this.networkIOCmp=this.initNetworkIOCmp();this.add([this.cpuChart,this.memChart,this.networkIOCmp,this.networkCharts]);this.doLayout()},initNetworkIOCmp:function(){return new SYNO.SDS.ResourceMonitor.NetworkInOutComponent({widget:this,selBtnWidth:96,width:320,height:24})},initCpuChart:function(){return new SYNO.SDS.ResourceMonitor.PercentageComponent(Ext.apply(this.getDefChartCfg(),{itemId:"cpuUsage",title:"CPU",width:322,height:24}))},doCollapse:function(){var a=this;a.getEl().setHeight(84);a.doLayout()},doExpand:function(){var a=this;a.getEl().setHeight(172);a.doLayout()},initMemChart:function(){return new SYNO.SDS.ResourceMonitor.PercentageComponent(Ext.apply(this.getDefChartCfg(),{itemId:"memoryUsage",title:"RAM",width:322,height:24}))},setActivePanel:function(){var c=this,b=c.networkCharts.get(c.activeNetworkTrafficIndex),a=c.networkCharts.getLayout();if(!b){c.activeNetworkTrafficIndex=0}c.networkIOCmp.selBtn.setText(b.deviceName);a.setActiveItem(c.activeNetworkTrafficIndex);c.networkCharts.get(c.activeNetworkTrafficIndex).drawChart();c.updateNetworkIOValue()},initNetworkPanel:function(){var a=new Ext.Panel(Ext.apply(this.getDefChartCfg(),{layout:"card",itemId:"network",activeItem:0,collapsible:false,border:false,defaults:{border:false},columnWidth:1}));return a},onAjaxRequestDone:function(a,f,g,e){var d=this,b=0,c=null;if(d.isDestroyed||!a){return}d.unmask();b=f.cpu.user_load+f.cpu.system_load;d.cpuChart.setValue(b);d.memChart.setValue(f.memory.real_usage);d.updateNetworkCharts(f.network,f.time);if(d.taskButton){c=d.networkIOCmp;d.taskButton.setMemValue(f.memory.real_usage);d.taskButton.setCpuValue(b);d.taskButton.setUploadValue(c.getConvertSize(c.TxValue),c.getUnit(c.TxValue));d.taskButton.setDownloadValue(c.getConvertSize(c.RxValue),c.getUnit(c.RxValue));d.taskButton.updateLayout()}},updateNetworkCharts:function(d,e){var c=this,b=c.networkCharts,a;c.updateNetworkInterfaces(d);Ext.each(d,function(f){a=b.get(f.device);if(a){a.pushValue([f.tx,f.rx],e)}},c);c.updateNetworkIOValue()},updateNetworkIOValue:function(){var d=this,c=d.networkIOCmp,b=d.networkCharts,a=b.get(d.activeNetworkTrafficIndex);if(!a){return}c.update(a.RxSet.getLastDataValue(),a.TxSet.getLastDataValue())},updateNetworkInterfaces:function(s){var o=this,g=o.networkCharts,m=false,f=0,e=0,c=0,b,a,r=[];g.items.each(function(i){var j=Ext.each(s,function(k){if(k.device===i.itemId){return false}return true});if(!Ext.isDefined(j)){r.push(i)}});Ext.each(r,function(i){g.remove(i)});var d=this.networkIOCmp.selMenu;var l;var n=function(i){return parseInt(i.replace(/[^\d.]/g,""),10)||0};var p=function(j,i){for(c=i.length-1;c>=0;c--){if(n(j)>=n(i[c].text)){return c+1}}};for(f=0,e=0;f<s.length;++f){if("total"===s[f].device){continue}b=g.get(s[f].device);if(!b){l=SYNO.SDS.Utils.Network.idToString(s[f].device);a=new SYNO.SDS.ResourceMonitor.Widget.NetworkInterface({itemId:s[f].device,deviceName:l,widget:this});g.insert(e,a);m=true;var h=new Ext.menu.Item({text:l,index:(d.items)?d.items.items.length:0,scope:this,hidden:false});var q=(d.items)?p(l,d.items.items):0;d.insert(q,h)}e++}if(m||r.size()>0){this.setActivePanel();this.doLayout()}}});SYNO.SDS.ResourceMonitor.NetworkInOutComponent=Ext.extend(Ext.Panel,{RxValue:0,TxValue:0,constructor:function(a){Ext.apply(this,a);SYNO.SDS.ResourceMonitor.NetworkInOutComponent.superclass.constructor.call(this,this.fillConfig());this.mon(this,"afterrender",function(){this.drawChart()},this);this.inLabel=this.getComponent("in");this.outLabel=this.getComponent("out")},fillConfig:function(){this.selBtn=new SYNO.ux.Button({itemId:"select-button",xtype:"syno_button",boxMaxWidth:90,cls:"interface-selection-button",menuAlign:"tr-br",menu:this.selMenu=new Ext.menu.Menu({cls:"resource-monitor-widget",listeners:{itemclick:{fn:this.onMenuClick,scope:this}}})});var a={cls:"resource-Monitor-networkio-cmp",width:this.width,height:this.height,border:false,items:[{xtype:"container",width:this.selBtnWidth,height:24,items:[this.selBtn],style:"float: left;"},{itemId:"out-graphic",xtype:"displayfield",cls:"networkio-cmp-icon out"},{itemId:"out",xtype:"displayfield",cls:"networkio-cmp-label blue-status out",value:0+"KB/s"},{itemId:"in-graphic",xtype:"displayfield",cls:"networkio-cmp-icon in"},{itemId:"in",xtype:"displayfield",cls:"networkio-cmp-label green-status",value:0+"KB/s"}]};return a},onMenuClick:function(a){this.widget.activeNetworkTrafficIndex=a.index;this.widget.setActivePanel()},update:function(c,a){var b=this;b.TxValue=a;b.RxValue=c;b.drawChart()},drawChart:function(){var a=this;a.inLabel.setValue(this.convertSize(a.RxValue));a.outLabel.setValue(this.convertSize(a.TxValue));a.doLayout()},convertSize:function(a){var b=this.getUnit(a)+"/s";return this.getConvertSize(a)+" "+b},getConvertSize:function(b){if(!b){return 0}var a=parseInt(Math.floor(Math.log(b)/Math.log(1024)),10);if(a===0){return(b/Math.pow(1024,a))}return parseFloat((b/Math.pow(1024,a)).toFixed(1))},getUnit:function(b){if(!b){return"KB"}var c=["KB","MB","GB","TB","PB","EB","ZB","YB"];var a=parseInt(Math.floor(Math.log(b)/Math.log(1024)),10);return c[a]}});SYNO.SDS.ResourceMonitor.Widget.NetworkInterface=Ext.extend(Ext.Panel,{constructor:function(b){this.RxSet=new SYNO.SDS.ResourceMonitor.Performance.DataSet({totalTime:SYNO.SDS.ResourceMonitor.WidgetBriefChartMaxTime,color:"#1EB300"});this.TxSet=new SYNO.SDS.ResourceMonitor.Performance.DataSet({totalTime:SYNO.SDS.ResourceMonitor.WidgetBriefChartMaxTime,color:"#0086E6"});this.chart=new Ext.Container({baseCls:"resource-Monitor-widget-base",cls:"flotrchart-wrapper"});this.deviceName=b.deviceName;var a={baseCls:"resource-Monitor-widget-panel",border:false,width:250,items:[{xtype:"panel",baseCls:"resource-Monitor-widget-base",height:92,items:[this.chart]}]};Ext.apply(a,b);SYNO.SDS.ResourceMonitor.Widget.NetworkInterface.superclass.constructor.call(this,a)},pushValue:function(b,d){var a=Math.round(b[0]/1024),c=Math.round(b[1]/1024);this.TxSet.pushData(a,d);this.RxSet.pushData(c,d);this.drawChart()},drawChart:function(){var a=0;a=this.RxSet.getMaxDataValue();if(a<this.TxSet.getMaxDataValue()){a=this.TxSet.getMaxDataValue()}if(a<100){a=100}else{a=a*1.1}var c={lines:{show:true},xaxis:{max:this.RxSet.getLastTime(),min:this.RxSet.getLastTime()-this.RxSet.totalTime,noTicks:0},yaxis:{max:a,min:0,tickDecimals:0,noTicks:5},grid:{color:"#E1EBF5",backgroundColor:"#FFFFFF",tickColor:"#E1EBF5",labelMargin:10,outlineWidth:1},shadowSize:0};var b=[this.RxSet.genSeries(),this.TxSet.genSeries()];if(this.chart.getWidth()>0&&this.chart.getHeight()>0){Flotr.draw(this.chart.getEl().dom,b,c)}},clearValues:function(){this.RxSet.clear();this.TxSet.clear()}});Ext.define("SYNO.SDS.ResourceMonitor.PercentageComponent",{extend:"Ext.BoxComponent",title:"",value:0,type:"horizontal",constructor:function(a){Ext.apply(this,a);SYNO.SDS.ResourceMonitor.PercentageComponent.superclass.constructor.call(this,this.fillConfig())},fillConfig:function(a){var b={width:this.width,height:this.height,layout:"column",cls:"resource-monitor-percentage-cmp "+this.type,autoEl:{tag:"div",cn:[{tag:"div",cls:"percentage-cmp-title",html:this.title},{tag:"div",cls:"percentage-cmp-hbar-background",cn:[{tag:"div",cls:"percentage-cmp-hbar-fill"}]},{tag:"div",cls:"percentage-cmp-value",html:this.value+"%"}]}};return b},setValue:function(a){this.value=a;this.fillPercent(a)},fillPercent:function(d){var b=this.el.child("div.percentage-cmp-value");var c=this.el.child("div.percentage-cmp-hbar-fill");var f=this.el.child("div.percentage-cmp-hbar-background");var e=d*1.5;var a=d*0.74;c.removeClass("high");c.removeClass("very-high");if(d>90){c.addClass("very-high")}else{if(d>80){c.addClass("high")}}b.update(d+"%");if(this.type==="vertical"){c.dom.style.height=a+"px"}else{c.dom.style.width=e+"px"}c.dom.setAttribute("ext:qtip",d+"%");f.dom.setAttribute("ext:qtip",d+"%")}});