/* Copyright (c) 2015 Synology Inc. All rights reserved. */

Ext.namespace("SYNO.SDS.PhotoViewer");SYNO.SDS.PhotoViewer.Util={browser_prefixes:["","-webkit-","-moz-","-o-","-ms-"],utfencode:function(b){var e,d,a="";b=b.replace(/\r\n/g,"\n");for(e=0;e<b.length;e++){d=b.charCodeAt(e);if(d<128){a+=String.fromCharCode(d)}else{if((d>127)&&(d<2048)){a+=String.fromCharCode((d>>6)|192);a+=String.fromCharCode((d&63)|128)}else{a+=String.fromCharCode((d>>12)|224);a+=String.fromCharCode(((d>>6)&63)|128);a+=String.fromCharCode((d&63)|128)}}}return a},bin2hex:function(d){var c,e=0,b=[];d=SYNO.SDS.PhotoViewer.Util.utfencode(d)+"";e=d.length;for(c=0;c<e;c++){b[c]=d.charCodeAt(c).toString(16).replace(/^([\da-f])$/,"0$1")}return b.join("")},removeStyle:function(c){var a,b;if(typeof c!="object"){a={};a[c]="";c=a}for(b in c){if(this.dom.style.removeAttribute){this.dom.style.removeAttribute(b)}else{this.dom.style.removeProperty(b)}}return this},doZoomTransform:function(b,d,c){var a=String.format("scale({0}) translate({1}px, {2}px)",d,c.x,c.y);Ext.each(SYNO.SDS.PhotoViewer.Util.browser_prefixes,function(f){var e={};e[String.format("{0}transform",f)]=a;b.setStyle(e)})},enableZoomTransition:function(d,a,c,b,e){if(a===false){c="0s";b="";e=""}Ext.each(SYNO.SDS.PhotoViewer.Util.browser_prefixes,function(g){var f={};f[String.format("{0}transition-property",g)]=b?String.format("{0}{1}",g,b):"";if(b=="opacity"){f[String.format("{0}transition-property",g)]="opacity"}f[String.format("{0}transition-duration",g)]=c;f[String.format("{0}transition-timing-function")]=e;d.setStyle(f)},this)},clearZoomProperty:function(a){a.removeStyle=SYNO.SDS.PhotoViewer.Util.removeStyle.bind(a);Ext.each(SYNO.SDS.PhotoViewer.Util.browser_prefixes,function(b){a.removeStyle(String.format("{0}transition-property",b));a.removeStyle(String.format("{0}transition-duration",b));a.removeStyle(String.format("{0}transition-timing-function",b));a.removeStyle(String.format("{0}transform",b))},this)},enableTranstionEndListener:function(a,b,c,d){if(a){b.mon(c,"transitionend",d,b);b.mon(c,"mozTransitionEnd",d,b);b.mon(c,"webkitTransitionEnd",d,b);b.mon(c,"OTransitionEnd",d,b);b.mon(c,"msTransitionEnd",d,b)}else{b.mun(c,"transitionend",d,b);b.mun(c,"mozTransitionEnd",d,b);b.mun(c,"webkitTransitionEnd",d,b);b.mun(c,"OTransitionEnd",d,b);b.mun(c,"msTransitionEnd",d,b)}}};Ext.define("SYNO.SDS.PhotoViewer.DropDownBox",{extend:SYNO.ux.ComboBox,onOverClass:"over",onClickClass:"click",afterRender:function(){SYNO.SDS.PhotoViewer.DropDownBox.superclass.afterRender.call(this);this.mon(this.el,"focus",this.el.blur,this.el);this.wrap.hover(this.onWrapHover.createDelegate(this,[true]),this.onWrapHover.createDelegate(this,[false]));this.mon(this.wrap,"mousedown",this.onWrapClick.createDelegate(this))},setValue:function(a){SYNO.SDS.PhotoViewer.DropDownBox.superclass.setValue.call(this,a);this.el.dom.value="";return this},onWrapHover:function(a){if(!this.onOverClass){return}if(this.disabled){return}if(a){Ext.fly(this.wrap).addClass(this.onOverClass)}else{Ext.fly(this.wrap).removeClass(this.onOverClass)}},onWrapClick:function(){if(!this.onClickClass){return}if(this.disabled){return}var c=this.wrap;var a=this.onClickClass;Ext.fly(c).addClass(a);var e=Ext.getDoc(),b=function(){Ext.fly(c).removeClass(a);e.removeListener("mouseup",b)};e.on("mouseup",b)}});Ext.define("SYNO.SDS.PhotoViewer.PlayOption",{extend:SYNO.SDS.PhotoViewer.DropDownBox,playfn:null,showtrigger:true,constructor:function(a){SYNO.SDS.PhotoViewer.PlayOption.superclass.constructor.apply(this,arguments);this.playfn=a.playcallback},render:function(){SYNO.SDS.PhotoViewer.PlayOption.superclass.render.apply(this,arguments);this.playTrigger=this.wrap.createChild({tag:"div",cls:"playTrigger"});this.mon(this.playTrigger,"click",this.onTriggerPlay,this)},onTriggerPlay:function(a){this.collapse();if(!this.playfn){return}this.playfn("default");a.preventDefault();return false},enableTrigger:function(a){this.showtrigger=a},setStatus:function(b){var a="play_select";var c=this.showtrigger?"playTrigger":"pauseTrigger";if(b=="play"){this.container.removeClass(a);this.container.addClass("pause_select");this.playTrigger.removeClass("playTrigger");this.playTrigger.addClass(c)}else{this.container.addClass(a);this.container.removeClass("pause_select");this.playTrigger.removeClass("pauseTrigger");this.playTrigger.addClass(c)}}});Ext.namespace("SYNO.SDS.PhotoViewer");SYNO.SDS.PhotoViewer.InfoWindow=Ext.extend(SYNO.SDS.Window,{currentDir:"",currentName:"",constructor:function(a){SYNO.SDS.PhotoViewer.InfoWindow.superclass.constructor.call(this,Ext.apply({closable:true,width:400,height:400,minWidth:300,layout:"fit",items:[{itemId:"tab",xtype:"syno_tabpanel",plain:true,activeTab:0,defaults:{columns:[{header:_T("status","header_item"),dataIndex:"label"},{header:_T("status","header_value"),dataIndex:"value"}]},items:[{itemId:"exif",xtype:"syno_gridpanel",title:"EXIF",store:new Ext.data.JsonStore({autoDestroy:true,root:"exif",fields:["label","value"]})},{itemId:"iptc",xtype:"syno_gridpanel",title:"IPTC",store:new Ext.data.JsonStore({autoDestroy:true,root:"iptc",fields:["label","value"]})},{itemId:"xmp",xtype:"syno_gridpanel",title:"XMP",store:new Ext.data.JsonStore({autoDestroy:true,root:"xmp",fields:["label","value"]})}]}]},a));this.tab=this.getComponent("tab");this.exif=this.tab.getComponent("exif");this.iptc=this.tab.getComponent("iptc");this.xmp=this.tab.getComponent("xmp");this.reset()},onOpen:function(){SYNO.SDS.PhotoViewer.InfoWindow.superclass.onOpen.apply(this,arguments);return this.onRequest.apply(this,arguments)},onRequest:function(a){SYNO.SDS.PhotoViewer.InfoWindow.superclass.onRequest.apply(this,arguments);if(!a||!a.dir||!a.filename){return}this.loadData(a.dir,a.filename)},reset:function(){this.tab.setActiveTab(this.exif);this.exif.getStore().removeAll();this.tab.hideTabStripItem(this.iptc);this.tab.hideTabStripItem(this.xmp)},loadData:function(b,a){var c=SYNO.SDS.PhotoViewer.Util.bin2hex(b+"/"+a);if(b===this.currentDir&&a===this.currentName){return}this.currentDir=b;this.currentName=a;this.setTitle(a);this.reset();if(this.transId){Ext.Ajax.abort(this.transId)}else{this.setStatusBusy()}this.transId=Ext.Ajax.request({url:this.jsConfig.jsBaseURL+"/photoinfo.cgi",params:{path:c},scope:this,callback:this.onPhotoInfoReady})},onPhotoInfoReady:function(b,a,c){this.clearStatusBusy();delete this.transId;if(!a){return}c=Ext.decode(c.responseText);if(c.exif){this.exif.getStore().loadData(c)}else{this.exif.getStore().loadData({exif:[{label:_T("photo_viewer","no_data"),value:""}]})}if(c.iptc){this.iptc.getStore().loadData(c);this.tab.unhideTabStripItem(this.iptc)}else{this.tab.hideTabStripItem(this.iptc)}if(c.xmp){this.xmp.getStore().loadData(c);this.tab.unhideTabStripItem(this.xmp)}else{this.tab.hideTabStripItem(this.xmp)}}});Ext.namespace("SYNO.SDS.PhotoViewer");SYNO.SDS.PhotoViewer.MagicMotion=Ext.extend(Ext.BoxComponent,{owner:null,el:null,imgContainers:[],boxCount:2,activeIdx:0,photos:[],count:0,currentDir:"",jsConfig:null,onChangeCallback:null,callbackScope:null,fadeTime:["4000ms","1000ms"],motionTime:"5000ms",containerSize:{w:0,h:0},currentImgSize:{w:0,h:0},panRange:{x:[5,45],y:[5,30]},zoomRange:{min:1.3,max:1.5},state:"stopped",constructor:function(a){SYNO.SDS.PhotoViewer.MagicMotion.superclass.constructor.apply(this,arguments);this.owner=a.renderTo;this.el=this.getEl();this.el.hide();this.createSlideBox(this.boxCount);this.onWindowResize();this.swapZOrder()},setOnChangeCallback:function(b,a){this.onChangeCallback=b;this.callbackScope=a},createSlideBox:function(b){for(var a=0;a<b;++a){this.imgContainers[a]=this.el.createChild({tag:"div",cls:"motion-div",style:"position:absolute;"});this.imgContainers[a].img=this.imgContainers[a].createChild({tag:"img",cls:"image-container"});this.imgContainers[a].img.p=this.imgContainers[a];this.imgContainers[a].zIndex=a;this.imgContainers[a].setStyle("z-index",this.imgContainers[a].zIndex);this.mon(this.imgContainers[a].img,"load",this.onImgLoaded.createDelegate(this,[a],false),this)}},getThumbnailUrl:function(a,d,c){var e=this.currentDir+"/"+a,b=Ext.urlAppend(SYNO.API.currentManager.getBaseURL("SYNO.FileStation.Thumb","get",1),Ext.urlEncode({size:d,path:SYNO.API.EscapeStr(e)}));if(c){b=Ext.urlAppend(b,"rotate="+c)}return b},getUnderCotainer:function(){var a=(this.activeIdx+1)%2;return a},setPhotoList:function(a,c,b){this.jsConfig=a;this.currentDir=c;this.photos=b;this.photoIdx=0;this.count=this.photos.length;this.loadImage(this.imgContainers[0].img.dom,this.getThumbnailUrl(this.photos[0],"large",0));this.loadImage(this.imgContainers[1].img.dom,this.getThumbnailUrl(this.photos[1],"large",0))},beginPlay:function(a){this.state="playing";this.el.show();this.photoIdx=a;this.initTransition()},stop:function(){this.state="stopped";this.el.hide();this.photoIdx=0;this.resetImgContainer();for(var a=0;a<this.boxCount;++a){this.munTransitionEnd(this.imgContainers[a],this.fadeOutTransitionEnd,this);this.munTransitionEnd(this.imgContainers[a],this.fadeTransitionEnd,this);SYNO.SDS.PhotoViewer.Util.clearZoomProperty(this.imgContainers[a])}},onImgLoaded:function(a){this.photoIdx++;var b=this.imgContainers[a].img;b.setStyle("width","");b.setStyle("height","");b.addClass("image-container");b.alignTo(b.p,"c-c")},swapZOrder:function(){var a=this.imgContainers[0].zIndex;this.imgContainers[0].zIndex=this.imgContainers[1].zIndex;this.imgContainers[1].zIndex=a;this.imgContainers[0].setStyle("z-index",this.imgContainers[0].zIndex);this.imgContainers[1].setStyle("z-index",this.imgContainers[1].zIndex);this.activeIdx=(this.imgContainers[0].zIndex>this.imgContainers[1].zIndex)?0:1},resetImgContainer:function(){for(var a=0;a<this.boxCount;a++){this.imgContainers[a].stopFx();this.imgContainers[a].img.dom.style.cssText="";this.imgContainers[a].img.addClass("image-container");this.imgContainers[a].img.alignTo(this.imgContainers[a],"c-c")}},configMagicMotion:function(d){if(this.state=="stopped"){return}if(this.onChangeCallback){this.onChangeCallback.apply(this.callbackScope,[d.idx])}d.stopFx();d.dom.style.cssText="";d.addClass("image-container");d.alignTo(d.p,"c-c");var g={w:d.getWidth(),h:d.getHeight(),l:d.getLeft(),t:d.getTop()};var b=d.dom.style.cssText+String.format("position:absolute; width:{0}px; height:{1}px;",g.w,g.h);d.dom.style.cssText=b;d.removeClass("image-container");d.alignTo(d.p,"c-c");this.containerSize.w=d.p.getWidth();this.containerSize.h=d.p.getHeight();this.currentImgSize.w=g.w;this.currentImgSize.h=g.h;var e={x:Math.floor(Math.random()*this.panRange.x[1])+this.panRange.x[0],y:Math.floor(Math.random()*this.panRange.y[1])+this.panRange.y[0]};var c={x:((e.x%2)===0)?1:-1,y:((e.y%2)===0)?1:-1};if(Ext.isIE){if(d.getWidth!=g.w||d.getHeight!=g.h){g.w=d.getWidth();g.h=d.getHeight()}d.setWidth(g.w*this.zoomRange.max);d.setHeight(g.h*this.zoomRange.max);d.alignTo(d.p,"c-c");var a=g.l+e.x*c.x;if(c.x<0){a=g.l/2}d.shift({width:g.w*this.zoomRange.min,height:g.h*this.zoomRange.min,x:a,y:(g.t+e.y*c.y)/2,easing:"easeOut",duration:parseInt(this.motionTime,10)/1000});return}SYNO.SDS.PhotoViewer.Util.enableZoomTransition(d,false,this.motionTime,"transform","ease-out");SYNO.SDS.PhotoViewer.Util.clearZoomProperty(d);SYNO.SDS.PhotoViewer.Util.doZoomTransform(d,this.zoomRange.max,{x:e.x*c.x,y:e.y*c.y});function f(){SYNO.SDS.PhotoViewer.Util.enableZoomTransition(d,true,this.motionTime,"transform","ease-out");SYNO.SDS.PhotoViewer.Util.doZoomTransform(d,this.zoomRange.min,{x:0,y:0})}f.defer(10,this)},fadeOutTransitionEnd:function(){if(this.state=="stopped"){return}this.swapZOrder();var a=this.getUnderCotainer();this.munTransitionEnd(this.imgContainers[a],this.fadeOutTransitionEnd,this);this.imgContainers[a].img.dom.style.cssText="";this.imgContainers[a].img.addClass("image-container");this.imgContainers[a].img.alignTo(this.imgContainers[a].img.p,"c-c");this.imgContainers[a].img.idx=this.photoIdx;this.loadImage(this.imgContainers[a].img.dom,this.getThumbnailUrl(this.photos[(this.photoIdx)%(this.count)],"large",0))},fadeTransitionEnd:function(){SYNO.SDS.PhotoViewer.Util.clearZoomProperty(this.imgContainers[this.activeIdx]);this.munTransitionEnd(this.imgContainers[this.activeIdx],this.fadeTransitionEnd,this);var a=this.getUnderCotainer();SYNO.SDS.PhotoViewer.Util.clearZoomProperty(this.imgContainers[a]);this.imgContainers[a].setOpacity(1);this.configMagicMotion(this.imgContainers[a].img);if(this.state=="stopped"){return}if(Ext.isIE){var b=this.imgContainers[this.activeIdx];b.setStyle("opacity","1.0");b.setOpacity(1);b.fadeOut({remove:false,duration:parseInt(this.fadeTime[1],10)/1000,scope:this,callback:this.fadeOutTransitionEnd,endOpacity:0.01});b=this.imgContainers[a];b.setStyle("opacity","1.0");b.setOpacity(1);b.fadeOut({remove:false,duration:parseInt(this.fadeTime[0],10)/1000,scope:this,callback:this.fadeTransitionEnd,endOpacity:0.99})}else{SYNO.SDS.PhotoViewer.Util.enableZoomTransition(this.imgContainers[this.activeIdx],true,this.fadeTime[1],"opacity","ease-out");this.imgContainers[this.activeIdx].setStyle("opacity","0.0");this.monTransitionEnd(this.imgContainers[this.activeIdx],this.fadeOutTransitionEnd,this);this.imgContainers[a].setStyle("opacity","1.0");SYNO.SDS.PhotoViewer.Util.enableZoomTransition(this.imgContainers[a],true,this.fadeTime[0],"opacity","ease-out");this.imgContainers[a].setStyle("opacity","0.99");this.monTransitionEnd(this.imgContainers[a],this.fadeTransitionEnd,this)}},initTransition:function(){var a=this.photoIdx;for(var b=0;b<this.boxCount;++b){this.imgContainers[b].img.idx=a+b;this.loadImage(this.imgContainers[b].img.dom,this.getThumbnailUrl(this.photos[(a+b)%(this.count)],"large",0))}this.imgContainers[this.getUnderCotainer()].setOpacity(0);this.monTransitionEnd(this.imgContainers[this.activeIdx],this.fadeTransitionEnd,this);if(Ext.isIE){var c=this.imgContainers[this.activeIdx];c.fadeOut({remove:false,duration:parseInt(this.fadeTime[0],10)/1000,scope:this,callback:this.fadeTransitionEnd,endOpacity:0.99});this.configMagicMotion(this.imgContainers[this.activeIdx].img)}else{this.imgContainers[this.activeIdx].setStyle("opacity","1.0");SYNO.SDS.PhotoViewer.Util.enableZoomTransition(this.imgContainers[this.activeIdx],true,this.fadeTime[0],"opacity","ease-out");this.imgContainers[this.activeIdx].setStyle("opacity","0.99");this.configMagicMotion(this.imgContainers[this.activeIdx].img)}},monTransitionEnd:function(c,b,a){SYNO.SDS.PhotoViewer.Util.enableTranstionEndListener(true,a,c,b);c.transitionend={func:b,scope:a}},munTransitionEnd:function(c,b,a){SYNO.SDS.PhotoViewer.Util.enableTranstionEndListener(false,a,c,b);c.transitionend=null},onWindowResize:function(){this.el.setWidth(this.owner.getWidth());this.el.setHeight(this.owner.getHeight());this.el.alignTo(this.owner,"c-c");for(var c=0;c<this.boxCount;c++){this.imgContainers[c].setWidth(this.el.getWidth());this.imgContainers[c].setHeight(this.el.getHeight());this.imgContainers[c].setLeft(0);this.imgContainers[c].setTop(0)}if(this.containerSize.w<=0||this.containerSize.h<=0){return}var d=this.el.getWidth()/this.containerSize.w;var e=this.imgContainers[this.activeIdx].img;e.setWidth(e.getWidth()*d);e.setHeight(e.getHeight()*d);var a=(this.el.getWidth()-this.containerSize.w)/2;var b=(this.el.getHeight()-this.containerSize.h)/2;e.setLeft(e.getLeft()+a);e.setTop(e.getTop()+b);this.containerSize.w=this.el.getWidth();this.containerSize.h=this.el.getHeight()},getImageLoader:function(){return this.imageload||(this.imageload=new SYNO.SDS.Utils.ImageLoad())},beforeDestroy:function(){this.getImageLoader().stop();SYNO.SDS.PhotoViewer.MagicMotion.superclass.beforeDestroy.apply(this,arguments)},loadImage:function(b,a){this.getImageLoader().load(a,{load:(function(){if(this.isDestroyed){return}b.src=a}).createDelegate(this),error:(function(){if(this.isDestroyed){return}b.src="/webman/modules/PhotoViewer/images/no_thumbnail.gif"}).createDelegate(this)})}});Ext.namespace("SYNO.SDS.PhotoViewer");SYNO.SDS.PhotoViewer.Application=Ext.extend(SYNO.SDS.AppInstance,{appWindowName:"SYNO.SDS.PhotoViewer.MainWindow",constructor:function(){SYNO.SDS.PhotoViewer.Application.superclass.constructor.apply(this,arguments)}});Ext.define("SYNO.SDS.PhotoViewer.MainWindow",{thumbnailSize:"medium",extend:"SYNO.SDS.AppWindow",assignTask:null,assignDeferTime:500,imgContainer:null,thumbContainer:null,thumbScroller:null,loadingImg:null,photoList:null,photoMtime:null,imgRotation:null,currentIdx:-1,currentShareDir:"",currentDir:"",currentName:"",currentDirRW:false,isSliding:false,slideShowInterval:3000,loadSeq:0,selectedImgWidth:100,selectedDivWidth:104,thumbImgWidth:60,thumbDivWidth:66,thumbContainerHeight:118,divThumbs:null,imgThumbs:null,thumbDeferTime:500,thumbDeferSize:8,bbarWidth:456,photoScale:1,photoTranslate:{x:0,y:0},scaleLevelIndex:14,scaleLevel:[6.6,5.74,4.98,4.33,3.77,3.28,2.85,2.48,2.16,1.87,1.62,1.41,1.23,1.07,1,0.93,0.81,0.71,0.61,0.53,0.47,0.41,0.35,0.31,0.27,0.23,0.2,0.17,0.15,0.13,0.12,0.1],slideshowMode:"MagicMotion",isIndexed:false,thumbScale:[],validWallpaperExt:[".jpg",".jpeg",".jpe",".bmp",".gif",".png"],pixlrExt:{pixlr_editor:{ui_string:String.format(SYNO.SDS.Utils.GetLocalizedString("pixlr:openeditmenu"),"Pixlr Editor"),launch:SYNO.SDS.PixlrImageEditor.FBExt.launchEditFn,check:SYNO.SDS.PixlrImageEditor.FBExt.checkEditFn},pixlr_express:{ui_string:String.format(SYNO.SDS.Utils.GetLocalizedString("pixlr:openeditmenu"),"Pixlr Express"),launch:SYNO.SDS.PixlrImageEditor.FBExt.launchExpressFn,check:SYNO.SDS.PixlrImageEditor.FBExt.checkExpressFn}},simple_viewer:false,constructor:function(b){if(_S("diskless")||_S("standalone")){this.bbarWidth=320}SYNO.SDS.PhotoViewer.MainWindow.superclass.constructor.call(this,Ext.apply({dsmStyle:"v5",showHelp:false,pinable:false,width:656,height:424,minWidth:656,minHeight:424,toggleFullScreen:true,cls:"syno_photo_viewer",layout:"fit",bbarCfg:{cls:"x-window-bbar syno_photo_viewer_bbar"},bbar:[{itemId:"left_space",xtype:"tbspacer",width:10},{tooltip:_T("photo_viewer","tooltip_info"),itemId:"info",iconCls:"info",scope:this,handler:this.onClickInfo},{hidden:_S("diskless")||_S("standalone"),disabled:_S("demo_mode"),tooltip:_S("demo_mode")?_T("photo_viewer","tooltip_wallpaper")+" - "+_JSLIBSTR("uicommon","error_demo"):_T("photo_viewer","tooltip_wallpaper"),itemId:"wallpaper",iconCls:"set_as_wallpaper",scope:this,handler:this.onClickWallpaper},new SYNO.SDS.PhotoViewer.PlayOption({itemId:"play_select",ctCls:"play_select",listClass:"play_options",disabledClass:"edit_options_disable",hideTrigger:true,xtype:"combo",width:48,editable:false,mode:"local",triggerAction:"all",valueField:"value",displayField:"display",store:new Ext.data.ArrayStore({autoDestroy:true,fields:["value","display"],sortInfo:{field:"value",direction:"ASC"}}),playcallback:this.onPlayOption.createDelegate(this),listeners:{scope:this,select:function(e,f){this.onPlayOption(f.get("value"))}}}),{tooltip:_T("photo_viewer","tooltip_prev"),itemId:"prev",ctCls:"prev-ct",iconCls:"prev",scope:this,handler:this.onClickPrev},{tooltip:_T("photo_viewer","tooltip_next"),itemId:"next",ctCls:"next-ct",iconCls:"next",scope:this,handler:this.onClickNext},{hidden:_S("diskless"),tooltip:_T("photo_viewer","tooltip_rotate_left"),itemId:"rotate_left",iconCls:"rotate_left",scope:this,handler:this.onClickRotateLeft},{hidden:_S("diskless"),tooltip:_T("photo_viewer","tooltip_rotate_right"),itemId:"rotate_right",iconCls:"rotate_right",scope:this,handler:this.onClickRotateRight},{disabled:true,tooltip:_S("demo_mode")?_T("common","delete")+" - "+_JSLIBSTR("uicommon","error_demo"):_T("common","delete"),itemId:"delete",iconCls:"delete",scope:this,handler:this.onClickDelete},new SYNO.SDS.PhotoViewer.DropDownBox({itemId:"pixlr_edit_select",ctCls:"pixlr_edit_select",listClass:"pixlr_edit_options",disabledClass:"pixlr_edit_options_disable",hideTrigger:true,xtype:"combo",width:32,editable:false,mode:"local",triggerAction:"all",valueField:"value",displayField:"display",store:new Ext.data.ArrayStore({autoDestroy:true,fields:["value","display"],sortInfo:{field:"value",direction:"ASC"}}),listeners:{scope:this,select:function(e,f){this.onPixlrEdit(f.get("value"))}}})],listeners:{scope:this,resize:function(g,f,e){var h=g.el.child(".x-window-tl");if(Ext.isDefined(f)){h.setWidth(f)}}}},b));this.loadingImg=this.body.createChild({tag:"div",cls:"loading-indicator"});this.imgContainer=this.body.createChild({tag:"img",cls:"image-container"});this.motionController=new SYNO.SDS.PhotoViewer.MagicMotion({id:"magic_motion",style:"background:black;",x:0,y:0,renderTo:this.body});this.motionController.setOnChangeCallback(this.onChangeCallback,this);this.thumbContainer=this.body.createChild({tag:"div",cls:"thumb-container",style:"z-index:5"});this.thumbScroller=this.thumbContainer.createChild({tag:"div",cls:"thumb-scroller clickable"});this.scrollThumbNext=this.thumbContainer.createChild({tag:"div",cls:"thumb-scroll-next"}).enableDisplayMode();this.scrollThumbPrev=this.thumbContainer.createChild({tag:"div",cls:"thumb-scroll-prev"}).enableDisplayMode();var c=this.getBottomToolbar();this.leftPadding=c.getComponent("left_space");this.btnInfo=c.getComponent("info");this.btnWallpaper=c.getComponent("wallpaper");this.btnNext=c.getComponent("next");this.btnPrev=c.getComponent("prev");this.btnRotateLeft=c.getComponent("rotate_left");this.btnRotateRight=c.getComponent("rotate_right");this.btnDelete=c.getComponent("delete");this.pixlrSelect=c.getComponent("pixlr_edit_select");this.playSelect=c.getComponent("play_select");this.actionControls=[this.btnInfo,this.btnWallpaper,this.btnRotateLeft,this.btnRotateRight,this.btnDelete,this.btnNext,this.btnPrev,this.pixlrSelect,this.playSelect];this.loadingImg.hide();this.imgContainer.hide();this.photoList=[];this.divThumbs=[];this.imgThumbs=[];this.imgRotation=[];this.assignTask=new Ext.util.DelayedTask(this.assignImgSrc,this);this.keyHandler=new Ext.KeyNav(document,{scope:this,left:this.onPressLeft,right:this.onPressRight});this.addManagedComponent(this.keyHandler);this.scrollThumbPrev.addClassOnClick("click");this.scrollThumbPrev.addClassOnOver("over");this.scrollThumbNext.addClassOnClick("click");this.scrollThumbNext.addClassOnOver("over");this.imgContainer.removeStyle=function(g){var e,f;if(typeof g!="object"){e={};e[g]="";g=e}for(f in g){if(this.dom.style.removeAttribute){this.dom.style.removeAttribute(f)}else{this.dom.style.removeProperty(f)}}return this}.bind(this.imgContainer);this.mon(this.scrollThumbPrev,"click",this.onScrollPrev,this);this.mon(this.scrollThumbNext,"click",this.onScrollNext,this);this.mon(this,"resize",this.updateSize,this);this.mon(this.imgContainer,"mousedown",this.onPhotoMouseDown,this);this.mon(this.imgContainer,"mouseup",this.onPhotoMouseUp,this);this.mon(this.imgContainer,"mousemove",this.onPhotoMouseMove,this);this.mon(this.body,"mousewheel",this.onPhotoMouseWheel,this);this.mon(this.body,"dblclick",this.onPhotoDblClick,this);this.mon(this.thumbContainer,"mousewheel",this.onThumbMouseWheel,this);this.mon(this.el,"mousemove",this.onMouseMove,this);this.thumbContainer.on("mouseenter",this.onMouseIn,this);this.thumbContainer.on("mouseleave",this.onMouseOut,this);this.mon(this,"beforeenablefullscreen",this.onBeforeFullScreenEnabled,this);this.mon(this,"beforedisablefullscreen",this.onBeforeFullScreenDisabled,this);this.mon(this,"windowfullscreendisabled",this.onFullScreenDisabled,this);var a=[];Ext.iterate(this.pixlrExt,function(e,f){a.push([e,f.ui_string])},this);this.pixlrSelect.getStore().loadData(a);var d=[["default",_T("photo_viewer","slideshow_fade")],["motion",_T("photo_viewer","slideshow_motion")]];this.playSelect.getStore().loadData(d)},setIcon:function(){},onPlayOption:function(a){if(!this.isSliding){this.slideshowMode=(a=="default")?"default":"MagicMotion"}this.onClickPlay();this.setThumbContainerVisible(false,Ext.enableFx)},onClose:function(){if(this.motionController){this.motionController.stop();delete this.motionController}return SYNO.SDS.PhotoViewer.MainWindow.superclass.onClose.apply(this,arguments)},onBeforeFullScreenEnabled:function(){var c=[["default",_T("photo_viewer","slideshow_fade")],["motion",_T("photo_viewer","slideshow_motion")]],b=new SYNO.SDS.PhotoViewer.PlayOption({itemId:"play_select",ctCls:"play_select",listClass:"play_options",disabledClass:"edit_options_disable",hideTrigger:true,xtype:"combo",width:48,editable:false,mode:"local",triggerAction:"all",valueField:"value",displayField:"display",store:new Ext.data.ArrayStore({autoDestroy:true,fields:["value","display"],sortInfo:{field:"value",direction:"ASC"}}),playcallback:this.onPlayOption.createDelegate(this),listeners:{scope:this,select:function(d,e){this.onPlayOption(e.get("value"))}}}),a=new SYNO.ux.Toolbar({layout:"vbox",items:b,renderTo:SYNO.SDS.Desktop.id});b.getStore().loadData(c);this.tmpPlaySelect=b;this.tmpPlaySelect.setStatus(this.isSliding?"play":"pause");this.tmpToolbar=a;this.initFSToolbar(a.el,"l",["syno_photo_viewer_bbar","x-window-bbar"],false,[20,56]);this.getBottomToolbar().hide()},onBeforeFullScreenDisabled:function(){if(this.tmpPlaySelect){this.tmpPlaySelect.collapse()}},onFullScreenDisabled:function(){this.getBottomToolbar().show();if(!this.maximized){this.setHeight(this.getHeight()+this.getBottomToolbar().getHeight())}Ext.destroy(this.tmpToolbar);Ext.destroy(this.tmpPlaySelect);this.tmpToolbar=null;this.tmpPlaySelect=null;this.destroyFSToolbar(true)},makeCurrentFileRecord:function(){var b=Ext.data.Record.create([{name:"file_id"},{name:"type"}]);var a=new b({file_id:String.format("{0}/{1}",this.currentShareDir,this.photoList[this.currentIdx]),type:this.getCurrentExt()});return[a]},getCurrentExt:function(){if(this.currentIdx<0){return""}var a=this.photoList[this.currentIdx];var b=a.substr(a.lastIndexOf(".")+1);return b},updatePixlrOption:function(){this.pixlrSelect.reset();if(true===this.simple_viewer){return}var a=[];Ext.iterate(this.pixlrExt,function(b,c){if(!c.check(this.getCurrentExt(),this.makeCurrentFileRecord())){return}a.push([b,c.ui_string])},this);if(a.length===0){this.pixlrSelect.disable()}else{this.pixlrSelect.enable()}this.pixlrSelect.getStore().loadData(a)},onPixlrEdit:function(a){this.pixlrExt[a].launch.call(this,this.makeCurrentFileRecord())},onActivate:function(){SYNO.SDS.PhotoViewer.MainWindow.superclass.onActivate.apply(this,arguments);this.keyHandler.enable()},onDeactivate:function(){this.keyHandler.disable();SYNO.SDS.PhotoViewer.MainWindow.superclass.onDeactivate.apply(this,arguments)},onOpen:function(){SYNO.SDS.PhotoViewer.MainWindow.superclass.onOpen.apply(this,arguments);this.updateSize();this.setThumbContainerVisible(false,false);return this.onRequest.apply(this,arguments)},onRequest:function(d){var a,f,e,b,c,g=SYNO.SDS.Utils.GetLocalizedString(this.jsConfig.title);SYNO.SDS.PhotoViewer.MainWindow.superclass.onRequest.apply(this,arguments);if(this.maskCnt>0||!d){return}if(this.isSliding){this.onClickPlay()}if(this.imgContainer){SYNO.SDS.PhotoViewer.Util.clearZoomProperty(this.imgContainer)}if(true===d.simple_viewer&&Ext.isString(d.url)&&Ext.isString(d.filename)){this.simple_viewer=true;this.scrollThumbPrev.hide();this.scrollThumbNext.hide();this.thumbScroller.hide();this.getBottomToolbar().hide();this.assignImgSrc(d.url);this.setTitle(d.filename);this.clearImageContainerSiblings()}else{this.simple_viewer=false;this.scrollThumbPrev.show();this.scrollThumbNext.show();this.thumbScroller.show();this.getBottomToolbar().show()}if(Ext.isEmpty(d.fb_recs)){return}e=d.fb_recs[0].get("file_id");e=e.substr(0,e.lastIndexOf("/"));a=d.fb_recs[0].get("filename");f=d.fb_recs[0].get("path");b=f.substr(0,f.lastIndexOf("/"));c=b.substr(b.lastIndexOf("/")+1);if(b!==this.currentDir){this.setTitle(Ext.util.Format.htmlEncode(g+" - "+c));this.assignCurrentIdx(-1);this.currentShareDir=e;this.currentDir=b;this.photoList=[]}this.viewByFilename(a)},onClickWallpaper:function(){var a=Ext.apply({},SYNO.SDS.UserSettings.getProperty("Desktop","wallpaper")||{},{customize_color:false,customize_wallpaper:false});a.customize_wallpaper=true;a.wallpaper_path=this.currentDir+"/"+this.currentName;a.wallpaper_ext="."+this.getCurrentExt();a.wallpaper_type="fromDS";a.wallpaper_position="fill";a.newImage=true;a.wallpaper=1+(a.wallpaper||0);SYNO.SDS.Desktop.updateBackground(a);SYNO.SDS.UserSettings.setProperty("Desktop","wallpaper",a)},onClickPrev:function(){if(this.isSliding){return}this.viewByIdx(this.currentIdx-1);this.onAnimateKeymove()},onClickNext:function(){if(this.isSliding){return}this.viewByIdx(this.currentIdx+1);this.onAnimateKeymove()},onClickPlay:function(){if(this.currentIdx<0){return}this.isSliding=!this.isSliding;this.updateControllers();this.slideShow()},setSize:function(a,b){b+=this.header.getHeight();if(typeof a=="object"){a.height+=this.header.getHeight()}this.callParent(arguments)},onClickInfo:function(){if(!this.infoWin||this.infoWin.isDestroyed){this.infoWin=new SYNO.SDS.PhotoViewer.InfoWindow({owner:this})}this.infoWin.open({dir:this.currentDir,filename:this.currentName})},onClickDelete:function(){if(this.isSliding||-1==this.currentIdx){return}this.getMsgBox().confirmDelete(_T("common","delete"),_T("photo_viewer","confirm_delete"),function(a){if("yes"===a){this.deleteCurrent()}},this)},deleteCurrent:function(){var b=this.currentIdx,a=this.photoList.length-1;this.setStatusBusy({text:_T("common","msg_waiting")});var c=this.currentShareDir+"/"+this.currentName;this.addWebAPITask({api:"SYNO.FileStation.Delete",method:"delete",version:1,params:{path:SYNO.API.EscapeStr(c),recursive:false},callback:function(g,d,e){this.clearStatusBusy();if(!g){this.getMsgBox().alert(_T("common","delete"),SYNO.webfm.utils.getWebAPIErr(g,d,e));return}this.imgContainer.hide();this.imgThumbs[b].remove();this.divThumbs[b].remove();this.photoList.splice(b,1);this.divThumbs.splice(b,1);this.imgThumbs.splice(b,1);this.imgRotation.splice(b,1);this.currentIdx=-1;this.currentName=null;if(b>=a){b=a-1}this.viewByIdx(b);this.updateActionBtns();var f=SYNO.SDS.AppMgr.getByAppName("SYNO.SDS.App.FileStation3.Instance");Ext.each(f,function(i){var h=i.window.getPanelInstance();SYNO.FileStation.WindowPanel.superclass.refreshTreeNode.apply(h,[[this.currentShareDir],true])},this)},scope:this}).start()},updateActionBtns:function(){var a=(this.photoList&&this.photoList.length>0);Ext.each(this.actionControls,function(b){b.setDisabled(!a)},this);if(!a){this.setTitle("")}},onClickRotateLeft:function(){if(this.isSliding){return}this.rotateCurrent(-1)},onClickRotateRight:function(){if(this.isSliding){return}this.rotateCurrent(1)},rotateCurrent:function(e){var b=this.currentIdx,d=this.photoList[b],f=this.imgRotation[b]||0,a=(f+e+4)%4;this.resetZoomParams();this.imgContainer.dom.style.cssText="";this.imgContainer.addClass("image-container");this.imgContainer.alignTo(this.body,"c-c");this.imgRotation[b]=a;var c=this.imgThumbs[b];c.src=this.getThumbnailUrl(d,this.thumbnailSize,a);this.getImageLoader().loadImg(c,{load:this.onThumbLoaded.createDelegate(this,[b,this.loadSeq]),error:this.onThumbLoadError.createDelegate(this,[b,this.loadSeq])});this.assignTask.delay(this.assignDeferTime,undefined,undefined,[this.getThumbnailUrl(d,"large",a)])},onPressLeft:function(){if(this.maskCnt>0){return}this.onClickPrev()},onPressRight:function(){if(this.maskCnt>0){return}this.onClickNext()},updateSize:function(){var a=this.getInnerWidth();this.leftPadding.setWidth((a-this.bbarWidth)/2);this.loadingImg.alignTo(this.body,"c-c");if(!Ext.isDefined(this.imgContainer.enterScalingMode)){this.imgContainer.alignTo(this.body,"c-c")}this.thumbContainer.setWidth(a);this.alignThumbScroller();if(this.motionController){this.motionController.onWindowResize()}this.visibleBuffer=Math.ceil(this.getWidth()/this.thumbDivWidth)},updateInfoWindow:function(){if(!this.infoWin||this.infoWin.isDestroyed){return}this.infoWin.loadData(this.currentDir,this.currentName)},updateControllers:function(){var a=this.isSliding;this.scrollThumbPrev.setVisible(!a);this.scrollThumbNext.setVisible(!a);this.playSelect.setStatus(a?"play":"pause");this.btnPrev.setDisabled(a);this.btnNext.setDisabled(a);this.btnRotateLeft.setDisabled(a);this.btnRotateRight.setDisabled(a);if(this.tmpPlaySelect){this.tmpPlaySelect.setStatus(a?"play":"pause")}if(!_S("demo_mode")){this.btnDelete.setDisabled(a||!this.currentDirRW)}this.updateWallpaperBtn();this.updatePixlrOption();if(a){this.alignThumbScroller();this.thumbScroller.removeClass("clickable")}else{this.thumbScroller.addClass("clickable")}},alignThumbScroller:function(b){if(this.currentIdx<0){return}var a=(b)?this.selectedDivWidth:this.thumbDivWidth;var c=(-this.thumbDivWidth*(this.currentIdx))-(a/2);this.thumbScroller.alignTo(this.thumbContainer,"l-c",[c,0],Ext.enableFx);this.autoLoadThumb()},scrollThumbScroller:function(d,b){var e=this.thumbScroller.getAlignToXY(this.thumbContainer,"l-c"),c=this.thumbScroller.getX()-e[0],a=c+this.thumbScroller.getWidth();c+=this.thumbDivWidth/2;a-=this.thumbDivWidth/2;if(d>0){d=Math.min(Math.abs(c),d)}else{d=-Math.min(a,Math.abs(d))}this.thumbScroller.move("r",d,b);this.autoLoadThumb()},getThumbnailUrl:function(b,f,e){var a="";if(!Ext.isEmpty(this.photoMtime)){a=this.photoMtime[b]}else{var h=new Date();a=h.getTime()}var g=this.currentDir+"/"+b,c=Ext.urlAppend(SYNO.API.currentManager.getBaseURL("SYNO.FileStation.Thumb","get",1),Ext.urlEncode({size:f,path:SYNO.API.EscapeStr(g)}));if(e){c=Ext.urlAppend(c,"rotate="+e)}c=Ext.urlAppend(c,"mtime="+a);c=Ext.urlAppend(c,"indexed="+this.isIndexed);return c},assignImgSrc:function(b){this.loadingImg.show();var a=this.imgContainer.dom;var c=a.cloneNode(true);c.id=Ext.id();this.cloneImg=this.imgContainer.insertSibling(c,"after");if(!this.cloneImg.getAttribute("src")){this.cloneImg.set({src:Ext.BLANK_IMAGE_URL})}this.imgContainer.addClass("before-fade-in");a.src=b;this.getImageLoader().loadImg(a,{load:this.onPhotoLoaded.createDelegate(this),error:(function(){a.src="/webman/modules/PhotoViewer/images/no_thumbnail.gif";this.onPhotoLoaded();this.onPhotoError()}).createDelegate(this)})},assignCurrentIdx:function(a){if(0<=this.currentIdx&&this.currentIdx<this.divThumbs.length){this.divThumbs[this.currentIdx].removeClass("current");this.setThumbSize(this.currentIdx,false)}this.currentIdx=a;this.setTitle(this.photoList[a]);this.updateWallpaperBtn();if(0<=this.currentIdx&&this.currentIdx<this.divThumbs.length){this.divThumbs[this.currentIdx].addClass("current");this.setThumbSize(this.currentIdx,true)}},viewByIdx:function(a){if(a<0||a>=this.photoList.length){return}this.assignCurrentIdx(a);this.alignThumbScroller();this.loadPhoto(this.photoList[a],this.imgRotation[a])},updateWallpaperBtn:function(){var b=this.photoList[this.currentIdx];var a=(b)?b.lastIndexOf("."):-1;var d=false;if(a===-1||this.isSliding){d=true}else{var c=b.substr(a).toLowerCase();if(this.validWallpaperExt.indexOf(c)===-1){d=true}}this.btnWallpaper.setDisabled(d)},viewByFilename:function(b){var a=this.photoList.indexOf(b);if(a>=0){this.viewByIdx(a);return}this.loadPhotoList(b)},viewNext:function(){this.viewByIdx((this.currentIdx+1)%this.photoList.length)},loadPhoto:function(a,b){if(a===this.currentName){return}this.currentName=a;this.resetZoomParams();this.imgContainer.dom.style.cssText="";if(this.cloneImg){this.cloneImg.remove()}this.imgContainer.alignTo(this.body,"c-c");this.imgContainer.removeClass("fade-in");this.imgContainer.removeClass("before-fade-in");this.imgContainer.addClass("image-container");this.updateInfoWindow();this.assignTask.delay(this.assignDeferTime,undefined,undefined,[this.getThumbnailUrl(a,"large",b)])},resetZoomParams:function(){delete this.imgContainer.enterScalingMode;this.imgContainer.beginDrag=false;this.photoScale=1;this.scaleLevelIndex=14;this.photoTranslate={x:0,y:0};this.imgContainer.tempTranslate={x:0,y:0}},enableTranstionEndListener:function(a){SYNO.SDS.PhotoViewer.Util.enableTranstionEndListener(a,this,this.imgContainer,this.onZoomTransitionEnd)},onPhotoMouseDown:function(a){if(!Ext.isDefined(this.imgContainer.enterScalingMode)){return}SYNO.SDS.PhotoViewer.Util.enableZoomTransition(this.imgContainer,false,"","","");this.imgContainer.beginDrag=true;this.imgContainer.beginXY=a.xy;this.imgContainer.setStyle({cursor:"pointer"});a.preventDefault();return false},onPhotoMouseMove:function(a){if(!this.imgContainer.beginDrag){return}var b=this.imgContainer.beginXY;this.imgContainer.dragOffset=[a.xy[0]-b[0],a.xy[1]-b[1]];this.imgContainer.dragOffset[0]=this.imgContainer.dragOffset[0]/this.photoScale;this.imgContainer.dragOffset[1]=this.imgContainer.dragOffset[1]/this.photoScale;this.imgContainer.tempTranslate={};this.imgContainer.tempTranslate.x=this.photoTranslate.x+this.imgContainer.dragOffset[0];this.imgContainer.tempTranslate.y=this.photoTranslate.y+this.imgContainer.dragOffset[1];SYNO.SDS.PhotoViewer.Util.doZoomTransform(this.imgContainer,this.photoScale,this.imgContainer.tempTranslate)},onPhotoMouseUp:function(a){if(!this.imgContainer.beginDrag||!this.imgContainer.tempTranslate){return}this.imgContainer.removeStyle("cursor");SYNO.SDS.PhotoViewer.Util.enableZoomTransition(this.imgContainer,true,"0.6s","transform","ease-out");this.photoTranslate.x=this.imgContainer.tempTranslate.x;this.photoTranslate.y=this.imgContainer.tempTranslate.y;this.imgContainer.beginDrag=false},initZoomMode:function(){this.imgContainer.enterScalingMode=true;this.enableTranstionEndListener(false);var c=this.imgContainer.getWidth();var a=this.imgContainer.getHeight();var b=this.imgContainer.dom.style.cssText+String.format("position:absolute; width:{0}px; height:{1}px;",c,a);this.imgContainer.removeClass("image-container");this.imgContainer.dom.style.cssText=b;this.imgContainer.alignTo(this.body,"c-c");SYNO.SDS.PhotoViewer.Util.doZoomTransform(this.imgContainer,this.photoScale,this.photoTranslate);SYNO.SDS.PhotoViewer.Util.enableZoomTransition(this.imgContainer,true,"0.6s","transform","ease-out")},onPhotoMouseWheel:function(a){if(this.isSliding){return}if(!Ext.isDefined(this.imgContainer.enterScalingMode)){this.initZoomMode()}var b=a.getWheelDelta();if(b>0&&this.scaleLevelIndex>0){this.scaleLevelIndex--}else{if(b<0&&this.scaleLevelIndex<this.scaleLevel.length){this.scaleLevelIndex++}}this.photoScale=this.scaleLevel[this.scaleLevelIndex];if(!a.isSliding){SYNO.SDS.PhotoViewer.Util.doZoomTransform(this.imgContainer,this.photoScale,this.photoTranslate)}a.preventDefault();return false},onZoomTransitionEnd:function(){if(Ext.isDefined(this.imgContainer.enterScalingMode)&&this.imgContainer.enterScalingMode){return}this.imgContainer.dom.style.cssText="";this.imgContainer.addClass("image-container");this.imgContainer.alignTo(this.body,"c-c");this.resetZoomParams();this.enableTranstionEndListener(false)},onPhotoDblClick:function(b){if(!Ext.isDefined(this.imgContainer.enterScalingMode)){this.initZoomMode();this.scaleLevelIndex=6;this.photoScale=this.scaleLevel[this.scaleLevelIndex];var a={x:this.imgContainer.getLeft()+this.imgContainer.getWidth()/2,y:this.imgContainer.getTop()+this.imgContainer.getHeight()/2};var c={x:(b.getXY()[0]-a.x)/(this.photoScale-1)*-1,y:(b.getXY()[1]-a.y)/(this.photoScale-1)*-1};this.photoTranslate.x=c.x;this.photoTranslate.y=c.y;SYNO.SDS.PhotoViewer.Util.doZoomTransform(this.imgContainer,this.photoScale,this.photoTranslate)}else{this.resetZoomParams();SYNO.SDS.PhotoViewer.Util.doZoomTransform(this.imgContainer,1,{x:0,y:0});this.enableTranstionEndListener(true)}},onPhotoLoaded:function(){SYNO.SDS.PhotoViewer.Util.clearZoomProperty(this.imgContainer);this.imgContainer.alignTo(this.body,"c-c");this.loadingImg.hide();this.imgContainer.show();this.updatePixlrOption();this.preloadImageByRange(1);if(this.cloneImg&&this.cloneImg.dom){this.cloneImg.addClass("fade-out");SYNO.SDS.PhotoViewer.Util.enableTranstionEndListener(true,this,this.cloneImg,this.onCloneImageFadeOut)}this.imgContainer.addClass("fade-in")},onPhotoError:function(){Ext.Ajax.request({url:this.jsConfig.jsBaseURL+"/photoinfo.cgi"})},onCloneImageFadeOut:function(){this.cloneImg.remove();SYNO.SDS.PhotoViewer.Util.enableTranstionEndListener(false,this,this.cloneImg,this.onCloneImageFadeOut)},loadPhotoList:function(a){this.assignCurrentIdx(-1);this.imgRotation=[];this.divThumbs=[];this.imgThumbs=[];this.photoList=[];this.thumbScroller.update("");this.loadSeq++;Ext.Ajax.request({seq:this.loadSeq,url:this.jsConfig.jsBaseURL+"/photolist.cgi",params:{share:SYNO.SDS.PhotoViewer.Util.bin2hex(this.currentShareDir)},scope:this,success:function(c,b){this.updatePhotoList(c,b);this.loadPhoto(a);this.assignCurrentIdx(this.photoList.indexOf(this.currentName));this.alignThumbScroller(true)}})},updatePhotoList:function(h,c){var f,b,a,d;try{f=Ext.decode(h.responseText)}catch(g){}if(!Ext.isObject(f)||!Ext.isArray(f.list)||c.seq!==this.loadSeq){return}this.currentDirRW=!!f.rw;this.isIndexed=f.indexed;this.photoList=f.list.sort(function(i,k){var j,e;j=i.toLowerCase();e=k.toLowerCase();if(i===k){return 0}else{if(j===e){return(i>k)?1:-1}else{return(j>e)?1:-1}}});this.photoMtime=f.mtime;d=this.photoList.length;this.thumbScroller.setWidth(this.thumbDivWidth*d+150);this.motionController.setPhotoList(this.jsConfig,this.currentDir,this.photoList);Ext.each(this.photoList,function(k,i){var l,j,e=Ext.util.Format.htmlEncode(Ext.util.Format.htmlEncode(k));l=this.thumbScroller.createChild({tag:"div",cls:"thumb-image loading","ext:qtip":e});l.dom.onclick=this.onThumbClick.createDelegate(this,[k]);this.divThumbs.push(l);j=l.createChild({tag:"img","ext:qtip":e});this.imgThumbs.push(j)},this);this.imgSize=[];this.thumbLoaded=[];for(b=0;b<d;++b){this.thumbScale[b]=1;this.thumbLoaded[b]=false;a=0}this.updateActionBtns();this.updateControllers()},autoLoadThumb:function(){this.runTask("getThumb",this.updateThumb,this.thumbDeferTime)},updateThumb:function(){var c;var e=this.thumbScroller.getStyle("left");var d=parseInt(e,10)*(-1);var a=Math.ceil(d/this.thumbDivWidth)-2;a=Math.max(0,a);var b=a+this.visibleBuffer+2;b=Math.min(b,this.divThumbs.length);for(c=a;c<b;c++){if(!this.thumbLoaded[c]){this.loadThumb(c)}}},loadThumb:function(a){this.thumbLoaded[a]=true;this.onThumbDeferred(a,this.loadSeq)},onThumbDeferred:function(a,c){if(this.isDestroyed||c!==this.loadSeq){return}var b=this.imgThumbs[a].dom;b.src=this.getThumbnailUrl(this.photoList[a],this.thumbnailSize);this.getImageLoader().loadImg(b,{load:this.onThumbLoaded.defer.createDelegate(this.onThumbLoaded,[50,this,[a,this.loadSeq]]),error:this.onThumbLoadError.defer.createDelegate(this.onThumbLoadError,[50,this,[a,this.loadSeq]])})},onThumbLoaded:function(a,d){if(this.isDestroyed||d!==this.loadSeq){return}var c=this.imgThumbs[a],b=this.divThumbs[a],e=(a===this.currentIdx);this.setThumbSize(a,e);c.center(b);b.removeClass("loading")},setThumbSize:function(a,b){var c;if(this.thumbScale[a]){c=this.thumbScale[a]}else{if(b){c=this.selectedImgWidth/this.thumbImgWidth}else{c=1}}this.scaleThumb(a,c)},onThumbLoadError:function(a,d){if(this.isDestroyed||d!==this.loadSeq){return}var c=this.imgThumbs[a],b=this.divThumbs[a];c.dom.src=this.getThumbnailUrl(this.photoList[a],"large");this.getImageLoader().loadImg(c.dom,{load:function(){b.removeClass("loading");c.center(b)}})},onThumbClick:function(a){if(this.isSliding){return}this.viewByFilename(a)},onThumbMouseWheel:function(a){var b=a.getWheelDelta();if(this.isSliding){return}this.scrollThumbScroller(b<0?-this.thumbDivWidth:this.thumbDivWidth);a.preventDefault();a.stopPropagation();return false},onScrollPrev:function(){if(this.isSliding){return}var a=this.getInnerWidth();this.scrollThumbScroller(a/4,true)},onScrollNext:function(){if(this.isSliding){return}var a=this.getInnerWidth();this.scrollThumbScroller(-a/4,true)},setThumbContainerVisible:function(d,b){var c=this.thumbContainer,a=c.animOpt&&c.animOpt.anim;if((!a&&d===c.isVisible())||(a&&d!==c.animateHide)){return false}if(a){c.animOpt.anim.stop()}if(b){c.animOpt={duration:0.35,easing:"easeIn",callback:function(){delete c.animOpt;c.dom.style[c.VISIBILITY]=c.HIDDEN;c.setOpacity(1)}};c.animateHide=!d}c.setVisible(d,c.animOpt);return true},setFisheyeScale:function(a,b){this.thumbImgWidth=a;this.selectedImgWidth=b;this.thumbContainerHeight=b+4+14;this.thumbDivWidth=a+6;this.selectedDivWidth=b+4;this.thumbContainer.setHeight(this.thumbContainerHeight);Ext.util.CSS.updateRule(".syno_photo_viewer .thumb-container","height",this.thumbContainerHeight);Ext.util.CSS.updateRule(".syno_photo_viewer .thumb-scroller","height",this.thumbContainerHeight);Ext.util.CSS.updateRule(".syno_photo_viewer .thumb-image","height",a);Ext.util.CSS.updateRule(".syno_photo_viewer .thumb-image","width",a);Ext.util.CSS.updateRule(".syno_photo_viewer .thumb-image.current","height",b);Ext.util.CSS.updateRule(".syno_photo_viewer .thumb-image.current","width",b)},getIndexById:function(b){for(var a=0;a<this.divThumbs.length;a++){if(this.divThumbs[a].id===b){return a}}return -1},getHoverScale:function(b,f){var a=(this.thumbScale[b])?this.thumbScale[b]:1;var h=this.divThumbs[b];if(!h){return this.getInitThumbScale()}var g=h.getX();var d=f.xy[0];var c=((d-g)/(this.thumbImgWidth*a))-0.5;if(c>0.5){c=0.5}else{if(c<-0.5){c=-0.5}}return this.getFisheyeScale(b,c)},getKeymoveScale:function(a){return this.getFisheyeScale(a,0)},getFisheyeScale:function(h,d){var g=this.divThumbs;var f=2;var j=[];var a=this.selectedImgWidth/this.thumbImgWidth;var b=1;var c;for(var e=0;e<g.length;e++){if(e<h-f||e>h+f){j[e]=b}else{c=Math.cos(((e-h-d)/(f+0.5))*(Math.PI/2));j[e]=b+(a-b)*c}}return j},getInitThumbScale:function(){var b=[],a;for(a=0;a<this.divThumbs.length;a++){b[a]=1}return b},fishEyeEffect:function(a,d,c){var b;var f;if(a===-1){f=this.getInitThumbScale()}else{if(c){f=this.getKeymoveScale(c)}else{f=this.getHoverScale(a,d)}}for(b=0;b<this.divThumbs.length;b++){if(f[b]!==this.thumbScale[b]){this.scaleThumb(b,f[b])}}this.thumbScale=f},scaleThumb:function(l,d){var i=this.divThumbs[l];if(!i.isVisible()){return}var m=this.thumbImgWidth*d;var b=this.thumbContainerHeight-m-6;b-=(l===this.currentIdx)?4:0;var c=String.format("width:{0}px; height:{0}px; margin-top:{1}px;",m,b);i.dom.setStyle(c);var g=this.imgThumbs[l];if(!this.imgSize[l]||(this.imgSize[l].width===0&&this.imgSize[l].height===0)){this.imgSize[l]=g.getSize()}var k=this.imgSize[l];var j;var e,h,a,f;if(k.width>k.height){f=k.width*(m/k.height);e=(m-f)/2;j=String.format("width:auto; height:{0}px; left:{1}px; top:0px;",m,e)}else{a=k.height*(m/k.width);h=(m-a)/2;j=String.format("width:{0}px; height:auto; left:0px; top:{1}px",m,h)}g.dom.setStyle(j)},onAnimateKeymove:function(){this.fishEyeEffect(null,null,this.currentIdx);this.needResetScale=true},onAnimateThumbHover:function(b){var d=this.thumbContainer.child(".thumb-image:hover");var c=this.thumbContainer.child(":hover");if(this.thumbContainer.isVisible()&&d){var a=this.getIndexById(d.id);this.fishEyeEffect(a,b);this.needResetScale=true}else{if(!c&&this.needResetScale){this.fishEyeEffect(-1,b);this.needResetScale=false}}},onMouseMove:function(b){if(this.maskCnt>0){return}this.onAnimateThumbHover(b);if(!this.thumbContainer.isVisible()){var c=this.thumbContainer.getRegion();var d=b.getXY();var a=new Ext.lib.Region(d[1],d[0],d[1],d[0]);if(a.intersect(c)){this.setThumbContainerVisible(true,Ext.enableFx)}}},onMouseIn:function(a){this.onAnimateThumbHover(a);this.setThumbContainerVisible(true,Ext.enableFx)},onMouseOut:function(a){this.setThumbContainerVisible(false,Ext.enableFx)},slideShow:function(){if(this.slideshowMode=="MagicMotion"){if(this.isSliding){this.motionController.beginPlay(this.currentIdx);return}this.viewByIdx(this.currentIdx);this.motionController.stop()}else{if(this.isSliding){this.preloadImage();return}if(this.slideTimer){clearTimeout(this.slideTimer);delete this.slideTimer}this.clearPreloadImage()}},preloadImageByRange:function(b){for(var a=1;a<=b;a++){this.preloadImageWithoutSliding(this.currentIdx-a);this.preloadImageWithoutSliding(this.currentIdx+a)}},preloadImageWithoutSliding:function(a){if(this.isDestroyed||a>this.photoList.length-1||a<0){return}if(!this.preloadNextImgContainer){this.preloadNextImgContainer=this.body.createChild({tag:"img",cls:"image-container"},this.imgContainer.dom)}this.preloadNextImgContainer.hide();var b=this.getThumbnailUrl(this.photoList[a],"large");this.getImageLoader().load(b,{load:(function(){if(this.isDestroyed){return}this.preloadNextImgContainer.dom.src=b}).createDelegate(this),error:(function(){if(this.isDestroyed){return}this.preloadNextImgContainer.dom.src="/webman/modules/PhotoViewer/images/no_thumbnail.gif"}).createDelegate(this)})},preloadImage:function(){var a=(this.currentIdx+1)%this.photoList.length;if(this.isDestroyed||!this.isSliding){return}this.preloadImgContainer=this.body.createChild({tag:"img",cls:"image-container"},this.imgContainer.dom);this.preloadImgContainer.hide();var b=this.getThumbnailUrl(this.photoList[a],"large");this.mon(this.preloadImgContainer,"load",this.onPreloadLoaded,this);this.preloadTime=(new Date()).getTime();this.getImageLoader().load(b,{load:(function(){if(this.isDestroyed){return}this.preloadImgContainer.dom.src=b}).createDelegate(this),error:(function(){if(this.isDestroyed){return}this.preloadImgContainer.dom.src="/webman/modules/PhotoViewer/images/no_thumbnail.gif"}).createDelegate(this)})},clearPreloadImage:function(){if(!this.preloadImgContainer){return}this.mun(this.preloadImgContainer,"load",this.onPreloadLoaded,this);Ext.destroy(this.preloadImgContainer);delete this.preloadImgContainer},onPreloadLoaded:function(){var a=(new Date()).getTime(),b=this.slideShowInterval-(a-this.preloadTime);this.slideTimer=this.switchPreloadImage.defer(Math.max(b,0),this)},switchPreloadImage:function(){if(this.isDestroyed){return}if(!this.isSliding){this.clearPreloadImage();return}this.imgContainer.fadeOut({remove:true,scope:this,callback:this.preloadImage});this.mun(this.preloadImgContainer,"load",this.onPreloadLoaded,this);this.preloadImgContainer.alignTo(this.body,"c-c");this.preloadImgContainer.fadeIn();this.imgContainer=this.preloadImgContainer;delete this.preloadImgContainer;this.assignCurrentIdx((this.currentIdx+1)%this.photoList.length);this.currentName=this.photoList[this.currentIdx];this.updateInfoWindow();this.alignThumbScroller()},onChangeCallback:function(a){this.assignCurrentIdx((a)%this.photoList.length);this.updateInfoWindow();this.alignThumbScroller()},getImageLoader:function(){return this.imageload||(this.imageload=new SYNO.SDS.Utils.ImageLoad())},onBeforeDestroy:function(){this.getImageLoader().stop();SYNO.SDS.PhotoViewer.MainWindow.superclass.onBeforeDestroy.apply(this,arguments)},clearImageContainerSiblings:function(){var a;if(!this.imgContainer){return}a=this.imgContainer.dom.previousSiblings();a.each(function(b){if(b.hasClassName("image-container")){b.remove()}});a=this.imgContainer.dom.nextSiblings();a.each(function(b){if(b.hasClassName("image-container")){b.remove()}})}});