#!/bin/sh
# Copyright (c) 2000-2014 Synology Inc. All rights reserved.

# usage, example

action=$1
if=$2
ip=$3
netmask=$4
port=5000
C_PING=/bin/ping
C_TR=/usr/bin/traceroute
C_CAT=/bin/cat
C_RM=/bin/rm
C_WGET=/usr/bin/wget
C_DD=/bin/dd
C_ECHO=/bin/echo
C_MV=/bin/mv
C_IFCON=/sbin/ifconfig
C_SLEEP=/bin/sleep
C_TOUCH=/bin/touch
C_LOGGER=/usr/bin/logger
ResTimeLimit=1 # ms
speedLimit='50' #50M

TEMPPATH=/tmp
TESTFILE_PATH=/webman/modules/HAManager
TESTFILE_PREFIX=/usr/syno/synoman
TESTFILE=10M

TMPFILE=$TEMPPATH/.HA.CheckHeartbeatLink.tmp
CHECKING_FILE=$TEMPPATH/.HA.CHECK_HEARTBEAT_ENV
RESULT_FILE=$TEMPPATH/ha/HA.Heartbeat.check.result
is_active=
auto_reset=0
cmdline=

log_debug()
{
	$C_LOGGER -p err -t synoha "[HeartbeatCheck] ${1:-}"
}

record_header()
{
	$C_ECHO "=======================" >> $RESULT_FILE 2>&1
	$C_ECHO "=="$(date +"%Y/%m/%d %H:%M:%S")"==" >> $RESULT_FILE 2>&1
	$C_ECHO "=======================" >> $RESULT_FILE 2>&1
}

record_content()
{
	local content=$1
	$C_CAT $content >> $RESULT_FILE 2>&1
	$C_ECHO "" >> $RESULT_FILE 2>&1
}

command_exec_to_tmpfile()
{
	local command=$1
	local echovalue=$2

	record_header

	$C_ECHO "$command" > $TMPFILE 2>&1
	if [ $echovalue ] ; then
		$command >> $TMPFILE 2>&1 || (log_debug "$command"; $C_ECHO $echovalue)
	else
		$command >> $TMPFILE 2>&1
	fi

	record_content $TMPFILE
}

# see also HAHeartbeatCheck at synoha/src/lib/ha.cc.
reset_env()
{
	if [ -z $if ] ; then
		$C_ECHO 9
		exit
	fi
	if [ -e $CHECKING_FILE ] ; then
		$C_RM $CHECKING_FILE 2> /tmp/rmfile
		IFEXIST=`/sbin/ip -o -f inet addr show | grep $if:DRBD`
		if [ -n "$IFEXIST" ] ; then
			command_exec_to_tmpfile "$C_IFCON $if:DRBD down" 2
		fi
		if [ -z $is_active ] ; then
			command_exec_to_tmpfile "$C_RM $TESTFILE_PREFIX/$TESTFILE_PATH/$TESTFILE" 3
		fi
		if [ $auto_reset -eq 1 ] ; then
			command_exec_to_tmpfile "/usr/syno/synoha/sbin/synoha --restore-drbd-attr $if"
		fi
		$C_ECHO 1
		/usr/bin/killall `basename $0`
	fi
}

# see also HAHeartbeatCheck at synoha/src/lib/ha.cc.
prepare_env()
{
	$C_RM $RESULT_FILE
	if [ -z $netmask ] ; then
		echo 9
		exit
	fi
	$C_TOUCH $CHECKING_FILE
	command_exec_to_tmpfile "$C_IFCON $if:DRBD $ip netmask $netmask" 3
	if [ -z $is_active ] ; then
		command_exec_to_tmpfile "$C_DD if=/dev/zero of=$TEMPPATH/$TESTFILE bs=1M count=10" 4
		command_exec_to_tmpfile "$C_MV $TEMPPATH/$TESTFILE $TESTFILE_PREFIX/$TESTFILE_PATH/$TESTFILE" 5
	fi
	$C_ECHO 1
	auto_reset=1

	# sleep 60 and reset
	{
		$C_SLEEP 60 && reset_env
	}&
}

case "$action" in
	prepare_active)
		is_active=1
		prepare_env
		;;
	reset_active)
		is_active=1
		reset_env
		;;
	prepare_passive)
		prepare_env
		exit
		;;
	reset_passive)
		reset_env
		exit
		;;
	check)
		if [ -z $if ] ; then
			$C_ECHO 9
			exit
		fi
		# Guarantee the ARP table being built-up by sending 3 ping's to pair,
		# and waiting them for up to 60 seconds. If it fails, return failure
		# right now.  Packet size of 9000 is necessary because we need to
		# make sure the environment is ready for the following tests.
		command_exec_to_tmpfile "$C_PING $ip -s 9000 -I $if -c 3 -w 60" 2

		cmdline="$C_PING $ip -s 9000 -I $if -w 5"
		command_exec_to_tmpfile "$cmdline"
		ttl=`$C_CAT $TMPFILE | grep ttl -m 1 | cut -d " " -f 6 | cut -d"=" -f 2`
		resTime=`$C_CAT $TMPFILE | grep "\/avg\/" | cut -d"/" -f 4`
		lossRate=`$C_CAT $TMPFILE | grep packets | cut -d" " -f 7`
		$C_RM $TMPFILE

		if [ "$lossRate" == "100%" ]; then
			log_debug "$cmdline"
			$C_ECHO "2"
			exit;
		fi
		if [ "$lossRate" != "0%" ]; then
			log_debug "$cmdline"
			$C_ECHO "3"
			exit;
		fi
		if [ $ttl -ne 64 ] ; then
			log_debug "$cmdline"
			$C_ECHO "4"
			exit;
		fi
		if [ $resTime -gt $ResTimeLimit ] ; then
			log_debug "$cmdline"
			$C_ECHO "5"
			exit;
		fi

#		echo "TTL: $ttl \nResTime: $resTime \nLossRate: $lossRate" > /tmp/.checkResultXHeartBeat
		for times in `seq 1 10` #1 2 3 4 5 6 7 8 9 10
		do
			#2014-05-12 18:45:41 (108 MB/s) - '10M' saved [10485760/10485760]
			cmdline="$C_WGET --tries=1 --timeout=1 --delete-after http://$ip:${port}${TESTFILE_PATH}/$TESTFILE"
			command_exec_to_tmpfile "$cmdline"
			speed=`$C_CAT $TMPFILE | grep saved | cut -d"(" -f 2 | cut -d" " -f 1`
#			echo "Speed: $speed" >> /tmp/.checkResultXHeartBeat
			if [ -z $speed ] ; then
				log_debug "$cmdline"
				$C_ECHO "6"
				break;
			fi
			if [ $speed -le $speedLimit ] ; then
				log_debug "$cmdline"
				$C_ECHO "7"
				break;
			fi
		done

		$C_ECHO "1";

		;;
	testPing)
		echo "$C_PING $ip -s 9000 -I $if -w 5 > $TMPFILE"
		command_exec_to_tmpfile "$C_PING $ip -s 9000 -I $if -w 5"
		ttl=`$C_CAT $TMPFILE | grep ttl -m 1 | cut -d " " -f 6 | cut -d"=" -f 2`
		resTime=`$C_CAT $TMPFILE | grep "\/max" | cut -d"/" -f 5 | cut -d" " -f 1`
		lossRate=`$C_CAT $TMPFILE | grep packets | cut -d" " -f 7`
		$C_RM $TMPFILE

		echo "Loss rate: $lossRate"
		echo "TTL $ttl"
		echo "max response time $resTime"

		if [ "$lossRate" == "100%" ]; then
			echo "ping failed, MTU 9000 not support or network unreachable."
			exit;
		fi
		if [ "$lossRate" != "0%" ]; then
			echo "Network not stable."
			exit;
		fi
		if [ $ttl -ne 64 ] ; then
			echo "TTL != 64"
			exit;
		fi
		if [ $resTime -gt $ResTimeLimit ] ; then
			echo "Response time > $ResTimeLimit"
			exit;
		fi
		;;
	testSpeed)
#		wget --timeout=1 http://192.168.35.144:5000/10M 2>&1 | grep 100% | awk -F"=" '{print $2}' | cut -d's' -f 1
		echo "$C_WGET --tries=1 --timeout=1 --delete-after http://$ip:$port/$TESTFILE"
		for times in `seq 1 10` #1 2 3 4 5 6 7 8 9 10
		do
			command_exec_to_tmpfile "$C_WGET --tries=1 --timeout=1 --delete-after http://$ip:${port}${TESTFILE_PATH}/$TESTFILE"
			speed=`$C_CAT $TMPFILE | grep saved | cut -d"(" -f 2 | cut -d" " -f 1`
			command_exec_to_tmpfile "$C_WGET --tries=1 --timeout=1 --delete-after http://$ip:${port}${TESTFILE_PATH}/$TESTFILE"
			time=`$C_CAT $TMPFILE | grep "100%" | awk -F"=" '{print $2}' | cut -d 's' -f 1`
			echo "Time speed: $time $speed"
			if [ -z $speed ] ; then
				echo "Wget failed."
				break;
			fi
			if [ $speed -le $speedLimit ] ; then
				echo "Network speed to slow"
				break;
			fi
		done
		;;
esac

