#!/bin/sh
# Copyright (c) 2000-2014 Synology Inc. All rights reserved.
BIN_RELAYD="/usr/syno/sbin/synorelayd"
RunHTTPS=$(/bin/get_key_value /etc/synoinfo.conf runHTTPS)
SupportSPDY=$(/bin/get_key_value /etc.defaults/synoinfo.conf support_spdy)
RunSPDY=$(/bin/get_key_value /etc/synoinfo.conf runsysspdy)
relayd_arg=""

case "$RunHTTPS" in
    "no")
        relayd_arg="$relayd_arg --remove dsm_https --remove dms_https --remove audio_https --remove dsm_portal_https --remove file_sharing_https"
        [ "yes" = "$SupportSPDY" ] && relayd_arg="$relayd_arg --remove dsm_https_spdy_30 --remove dsm_portal_https_spdy_30"
    ;;
    "yes")
        relayd_arg="$relayd_arg --add dsm_https --add dms_https --add audio_https --add dsm_portal_https --add file_sharing_https"
        [ "yes" = "$SupportSPDY" -a "yes" = "$RunSPDY" ] && relayd_arg="$relayd_arg --add dsm_https_spdy_30 --add dsm_portal_https_spdy_30"
    ;;
esac

if [ -z "$relayd_arg" ]; then
    relayd_arg="--hup"
fi

$BIN_RELAYD $relayd_arg > /dev/null 2>&1
# ignore relayd return value.
# when relayd is not running, hup will return false
exit 0
