#!/bin/sh
LOGGER="/usr/bin/logger"

log_msg()
{
	$LOGGER -sp $1 -t CUPS "$2"
}

link_airprint_filter()
{
	if [ -d /usr/local/cups/filter/ ]; then
		# backward compatible to DSM 5.0 AirPrint drivers
		ln -s /usr/local/cups/filter/* /usr/lib/cups/filter/ > /dev/null 2>&1
	fi
}
reload_cups()
{
	link_airprint_filter

	/usr/syno/sbin/synoservicecfg --status cupsd
	if [ 0 -eq $? ] ; then
		/usr/syno/sbin/synoservicecfg --reload cupsd
    else
		/usr/syno/sbin/synoservicecfg --start cupsd
	fi
	exit 0
}

case $1 in
add)
	if [ -z "$2" ]; then
		log_msg err "Need to specify a devicce node name: /dev/usb/deviceNodeName"
		exit 1;
	fi

	/usr/syno/sbin/synoservicecfg --status cupsd
	if [ 0 -ne $? ] ; then
		/usr/syno/sbin/synoservicecfg --start cupsd
	fi

	if [ -z "$3" ]; then
		log_msg err "Need to specify PPD file, printer=$2"
		exit 1;
	fi

	/usr/syno/bin/synoprint --ppd $2 $3
	if [ $? -eq 0 ]; then
	    exit 0;
	else
	    log_msg err "synoprint add cups ppd printer failed, $2"
	    exit 1;
	fi

	;;
reload)
	reload_cups
	;;
*)
	/bin/echo "usage: $0 { reload | add }" >&2
	exit 1
	;;
esac
# the return value should be 0 if operation success without a hitch
