#!/bin/sh

################################################
# SynoShare SDK hook for volume mount
# Usable environment variable:
#	LOCATION, DEVICE, MOUNTPOINT, and RESULT
###############################################

restart_php_fpm()
{
        SynoDefConf="/etc.defaults/synoinfo.conf"
        SynoConf="/etc/synoinfo.conf"
        SZD_MailStation="/var/packages/MailStation"
        SZD_PhotoStation="/var/packages/PhotoStation"
        SupportWeb=$(/bin/get_key_value ${SynoDefConf} supportweb)
        RunWebLocal=$(/bin/get_key_value ${SynoConf} supportweblocaluser)

        if [  -f "${SZD_MailStation}/enabled" ]; then
                        WebmailEnabled="yes"
        fi
        if [  -f "${SZD_PhotoStation}/enabled" ]; then
                        RunPhoto="yes"
        fi

        synoservicecfg --status webstation > /dev/null
        if [ $? -eq 0 -o $? -eq 4 -o \( "$SupportWeb" = "yes" -a \( "$RunPhoto" = "yes" -o "$RunWebLocal" = "yes" -o "$WebmailEnabled" = "yes" \) \) ]; then
                /usr/syno/sbin/synoservicectl --restart php-fpm
        fi
}

case $1 in
        --sdk-mod-ver)
                echo "1.0"
        ;;
        --name)
                echo "synocheckshare volume hook"
        ;;
        --pkg-ver)
                echo "1.0"
        ;;
        --vendor)
                echo "Synology Inc."
        ;;
        --pre)

        ;;
        --post)
                if [ 0 -eq "$RESULT" ]; then
                        local TMP_DIR=/var/services/tmp
                        if [ $(/usr/bin/readlink "$TMP_DIR" | /bin/grep "^$MOUNTPOINT/") ]; then
                                rm -rf $TMP_DIR
                                local LINK_DIR
                                LINK_DIR=$(/usr/syno/bin/servicetool --get-alive-sharebin)
                                if [ $? != 1 ]; then
                                        mkdir $TMP_DIR
                                        chmod 1777 $TMP_DIR
                                else
                                        local TARGET_DIR=$LINK_DIR/@tmp
                                        [ -d "$TARGET_DIR" ] || mkdir "$TARGET_DIR"
                                        chmod 1777 "$TARGET_DIR"
                                        ln -sf "$TARGET_DIR" "$TMP_DIR"
                                        restart_php_fpm
                                fi
                        fi
                fi
		;;
        *)
                echo "Usage: $0 --sdk-mod-ver|--name|--pkg-ver|--vendor|--pre|--post"
        ;;
esac
