#!/bin/sh

###############################################################
#   This script should be hooked when invoking SYNOShareDelete()
#   Usable environment variable:
#       SHARE_NAME, ENC_ACTION={encrypt|decrypt}, RESULT
###############################################################

#Include common scripts
FILE_SYSLOGNG_INC_SCRP=/usr/libexec/SyslogShareCommon.sh
. ${FILE_SYSLOGNG_INC_SCRP}

#At begining, acquire package settings
PackageInfoGet;

case $1 in
    --sdk-mod-ver)
        #Print SDK support version
        echo ${SYSLOGNG_PKG_MODVER};
    ;;
    --name)
        #Print package name
        echo ${SYSLOGNG_PKG_NAME};
    ;;
    --pkg-ver)
        #Print package version
        echo ${SYSLOGNG_PKG_VERSION};
    ;;
    --vendor)
        #Print package vendor
        echo ${SYSLOGNG_PKG_VENDOR};
    ;;
    --pre)
        #Actions before share encrypt action
        
        ################################################
        # PS: Service is paused by service framework
        ################################################
    ;;
    --post)
        #Actions after share encrypt action
        
        #Check if service share
        ServiceInfoGet;
        CHK_SHARE=${SHARE_NAME};
        SvrShareCheck;
        if [ "1" != "${IS_SVR_SHARE}" ]; then
            return;
        fi

        #Send notification when encrypt/decrypt action is completed
        if [ "encrypt" = "${ENC_ACTION}" ]; then
            if [ "0" = "${RESULT}" ]; then
                SyslogMailShareEncUnmount;
            fi
        elif [ "decrypt" = "${ENC_ACTION}" ]; then
            if [ "0" = "${RESULT}" ]; then
                SyslogMailShareEncMount;
            fi
        fi

        ################################################
        # PS: Service is resumed/disabled by service framework
        ################################################
    ;;
    *)
        echo "Usage: $0 --sdk-mod-ver|--name|--pkg-ver|--vendor|--pre|--post"
    ;;
esac
