#!/bin/sh
#delete routing rule when no link of static IP

ETHTOOL="/usr/syno/bin/ethtool"

del_route()
{
	local IFCFG_FILE="/etc/sysconfig/network-scripts/ifcfg-${IFNAME}"
	local BOOTPROTO=`get_key_value ${IFCFG_FILE} BOOTPROTO`
	if [ "${BOOTPROTO}" != "static" ]; then
		return
	else
		local LINK_DETECT=`${ETHTOOL} ${IFNAME} | grep "Link detected" | cut -d " " -f "3"`
		local SUBNET=`/sbin/ip route | grep ${IFNAME} | grep -v "default" | cut -d " " -f "1"`

		if [ "xno" = "x${LINK_DETECT}" -a "x" != "x${SUBNET}" ]; then
			`/sbin/ip route del ${SUBNET} dev ${IFNAME}`
                fi
	fi
}

case $1 in
        --sdk-mod-ver)
        #Print SDK support version
        echo "1.0";
        ;;
        --name)
        #Print package name
        echo "SynorouterClient"
        ;;
        --pkg-ver)
        #Print package version
        echo "1.0";
        ;;
        --vendor)
        #Print package vendor
        echo "Synology";
        ;;
        --post)
	del_route
        ;;
        *)
        echo "Usage: $0 --sdk-mod-ver|--name|--pkg-ver|--vendor|--pre|--post"
        ;;
esac
