#!/bin/sh

# TODO check if upgrade

# upgrade procedure(draft):
# .check if sda3 is mountable and upgrade file exists
# .backup user's configs
# .delete all files on root partition
# .extract new root fs
# .copy user's configs back to its position
#
# Any needed configuration format updating or new configs
# will be geenerated automatically by config generator.
UpgradeFile="SynoUpgrade.tar.gz"
UpgradeFileDot=".SynoUpgrade.tar.gz"
TarUpgradeFile="SynoUpgrade.tar"
TarUpgradeFileDot=".SynoUpgrade.tar"
SupportDualhead=`/bin/get_key_value /etc.defaults/synoinfo.conf support_dual_head`
SupportRAID=`/bin/get_key_value /etc/synoinfo.conf supportraid`
PLATFORM=`get_key_value /etc/synoinfo.conf unique | cut -d"_" -f2`
# executables
Umount="/bin/umount -f"
Mount="/bin/mount"
Cp="/bin/cp"
Rm="/bin/rm"
Mv="/bin/mv"
Tar="/bin/tar"
Mkdir="/bin/mkdir"
Fsck="/sbin/e2fsck -nq"
# backup configs
BackupDirList="/etc /usr/syno/etc /var /usr/syno/synoman/webman/3rdparty /usr/local /root/.ssh /etc/nginx/sites-enabled"
RemoveUPSFiles="/usr/syno/etc/ups.conf /usr/syno/etc/upsd.conf /usr/syno/etc/upsd.users /usr/syno/etc/upsmon.conf /usr/syno/etc/upssched.conf"
RemovePPPOEFiles="/etc/ppp/ip-up /etc/ppp/ip-down /etc/ppp/ip-function /etc/ppp/ipv6-up /etc/ppp/ipv6-down /etc/ppp/options"
RemoveCUPSFilters="/usr/local/cups/filter/bannertops /usr/local/cups/filter/commandtops /usr/local/cups/filter/gziptoany /usr/local/cups/filter/imagetops /usr/local/cups/filter/imagetoraster /usr/local/cups/filter/pdftops /usr/local/cups/filter/pstops /usr/local/cups/filter/rastertoepson /usr/local/cups/filter/rastertohp /usr/local/cups/filter/rastertolabel /usr/local/cups/filter/rastertopwg /usr/local/cups/filter/texttops /usr/local/cups/filter/hpgltops"
RemoveCUPSFiles="/usr/local/cups/mime.types /usr/local/cups/mime.convs /usr/local/cups/cupsd.conf /usr/local/cups/testprint ${RemoveCUPSFilters}"
RemoveHostapdFiles="/etc/hostapd/stainfo.sh /etc/hostapd/mac_filter/mfscript.sh /usr/syno/etc/rfkill.sh"
RemoveSSLFiles="/usr/syno/etc/ssl/mkcert.sh /usr/syno/etc/ssl/mkcgikey.sh"
RemoveUSBModemFiles="/usr/syno/etc/usbmodem/wcdma_list.json /usr/syno/etc/usbmodem/usb_modeswitch.d/*"
RemovePHPFiles="/etc/php/php.ini /etc/php/php-fpm.conf /etc/php/conf.d/opcache.ini"
RemoveSynoServiceConf="/usr/syno/etc/synoservice.d/global.setting /usr/syno/etc/synoservice.d/system.cfg"
RemoveFileList="/etc/ftpusers /etc/rc /etc/rc.network /usr/syno/etc/rc.atalk /usr/syno/etc/.htpasswd /usr/syno/etc/lpd/lpd.conf /usr/syno/etc/printcap ${RemoveUPSFiles} /etc/lvm/lvm.conf /usr/local/etc/rc.d/SynoEnablePersonalServices.sh /etc/rc.network_routing /usr/syno/etc/rc.tun /usr/syno/etc/afpd.conf /etc/pam.d/samba ${RemovePPPOEFiles} ${RemoveCUPSFiles} ${RemoveHostapdFiles} /usr/syno/etc/iptables_guest_net.sh /etc/ld.so.preload /etc/tc/default.cmd $RemoveSSLFiles /etc/logrotate.conf $RemoveUSBModemFiles $RemovePHPFiles $RemoveSynoServiceConf /usr/syno/etc/ssdp/dsm_desc.xml /usr/syno/etc/iptables_time_ctrl.sh /etc/profile /etc/inputrc /etc/dhclient/dhclient-script /etc/dhclient/ipv4/dhclient.conf /etc/dhclient/ipv6/dhclient.conf"
RemoveCUPSDir="/usr/local/cups/backend /usr/local/cups/mime"
RemoveDirList="/etc/pam.d /usr/syno/etc/vfs /var/run /var/state/ups /usr/syno/etc/ups /var/spool/postfix ${RemoveCUPSDir} /etc/fw_security/sysconf /etc/init /etc/logrotate.d /etc/syslog-ng /var/lib/dpkg /etc/httpd/conf /etc/postgresql /etc/nginx /etc/wide-dhcpv6 /etc/apparmor.d /usr/syno/etc/synoservice.d /var/dynlib /etc/iproute2/script /etc/ssl/certs /usr/syno/etc/dbus-1 /etc/avahi /usr/syno/etc/synovpnclient/scripts /var/lib/apparmor"
# backup folder for migration
UpdateBackupDirList="/usr/syno/etc/synoservice.d /var/run/ha /var/run/ha_log_message.sqlite /var/run/first_time_synced /etc/apparmor.d"

if [ "$SupportRAID" = "yes" -o "$SupportDualhead" = "yes" ]; then
	DISKNODE="/dev/md"
	DEF_PARTNO="0"
	RootPartition="${DISKNODE}0"
	SwapPartition="${DISKNODE}1"
else
	DISKNODE="/dev/sda"
	DEF_PARTNO="3"
	RootPartition="${DISKNODE}1"
	SwapPartition="${DISKNODE}2"
fi

RootMnt="/tmpRoot"
UPGRADE_VOL_FILE="${RootMnt}/.upgrade_vol"
NOTIFY_ASSISTANT_INSTALL_VOL_CREATE="${RootMnt}/.assistant_install_create_vol"
IS_INSTALL_CREATE_VOL=0
PLATFORM=`get_key_value /etc.defaults/synoinfo.conf unique | cut -d"_" -f2`

if [ -f ${NOTIFY_ASSISTANT_INSTALL_VOL_CREATE} ]; then
	IS_INSTALL_CREATE_VOL=1
fi

if [ -f ${UPGRADE_VOL_FILE} ]; then
	DataPartition="${DISKNODE}`cat ${UPGRADE_VOL_FILE}`"
	$Rm -f ${UPGRADE_VOL_FILE}
	echo "found ${UPGRADE_VOL_FILE} and get ${DataPartition}"
else
	DataPartition="${DISKNODE}${DEF_PARTNO}"
	echo "use default ${DataPartition}"
fi

if [ ${RootPartition} = ${DataPartition} ]; then
	DataMnt="${RootMnt}"
else
	DataMnt="/tmpData"
fi

IsCleanlyUmounted() {
	if [ -z "$1" ]; then
		return 0
	fi
	if [ "${RootPartition}" != "$1" ]; then
		CleanlyUmounted=`${Fsck} $1 | grep "is cleanly umounted"`
		if [ -z "$CleanlyUmounted" ]; then
			return 0
		fi
	elif [ -f "${RootMnt}/.needquotacheck" ]; then
		rm -f ${RootMnt}/.needquotacheck
		echo "Found ${RootPartition}:/.needquotacheck, removed."
	fi
	return 1
}

#
#
# ##########################################################
echo "Begin upgrade procedure"

IsCleanlyUmounted ${DataPartition}
IsClean=$?

if [ ${RootMnt} != ${DataMnt} ]; then
	${Mkdir} -p $DataMnt
	# mount data
	echo "Mount data partition"
	echo "$Mount $DataPartition $DataMnt"
	$Mount $DataPartition $DataMnt
	RetMount=$?
	if [ $RetMount -ne 0 ]; then
		# mount data failed
		echo "Mount data partition failed"
		exit 1
	fi
fi

# check flag and upgrade file
if [ -f $DataMnt/$TarUpgradeFile ]; then
	UpgradeFile=$TarUpgradeFile
	UpgradeFileDot=$TarUpgradeFileDot
fi

if [ -f $DataMnt/$UpgradeFile ]; then
	# file exists. start upgrade
	echo "Found an upgrade file on data volume. Begin upgrade"

	# rename upgrade patch first
	$Mv $DataMnt/$UpgradeFile $DataMnt/$UpgradeFileDot
	UPGRADE_FILE="$DataMnt/$UpgradeFileDot"

	## clean immutable bit to avoid upgrade failed
	chattr -R -i ${RootMnt}/ > /dev/null 2>&1

	# backup file which will be override after untar hda1
	UPDATE_BKPDIR="${RootMnt}/.syno/update_bkp"
	$Rm -rf ${UPDATE_BKPDIR}
	for TargetDir in ${UpdateBackupDirList}; do
		[ ! -e $RootMnt/$TargetDir ] && continue
		echo "$RootMnt/$TargetDir ==>    ${UPDATE_BKPDIR}/$TargetDir/"
		TargetPrefix=`dirname ${TargetDir}`
		mkdir -p ${UPDATE_BKPDIR}/${TargetPrefix}
		$Cp -a $RootMnt/$TargetDir ${UPDATE_BKPDIR}/${TargetDir}
	done

    BKPDIR="${DataMnt}/.upd@te"
	# backup user configs before upgrading
	for ConfigDir in ${BackupDirList}; do
		echo "$RootMnt/$ConfigDir ->	${BKPDIR}${ConfigDir}/"
		ConfigPrefix=`dirname ${ConfigDir}`
		mkdir -p ${BKPDIR}/${ConfigPrefix}
		$Mv $RootMnt/$ConfigDir ${BKPDIR}/${ConfigDir}
	done

	# B#69262 make sure /root is 700
	chmod 700 ${BKPDIR}/root

	# copy upgrade builtin packages
	if [ -d ${DataMnt}/SynoUpgradePackages ]; then
		$Mv ${DataMnt}/SynoUpgradePackages ${RootMnt}/.SynoUpgradePackages
	fi

	# copy upgrade indexdb
	if [ -f ${DataMnt}/SynoUpgradeIndexdb.tgz ]; then
		$Mv ${DataMnt}/SynoUpgradeIndexdb.tgz ${RootMnt}/.SynoUpgradeIndexdb.tgz
	fi

	# copy upgrade synohdpack_img
	if [ -f ${DataMnt}/SynoUpgradeSynohdpackImg.tgz ]; then
		$Mv ${DataMnt}/SynoUpgradeSynohdpackImg.tgz ${RootMnt}/.SynoUpgradeSynohdpackImg.tgz
	fi

	# remove need-to-upgrade files
	for RemovalFile in ${RemoveFileList}; do
		echo "Removing ${BKPDIR}/${RemovalFile}..."
		$Rm -f ${BKPDIR}/${RemovalFile}
	done

	# remove need-to-upgrade dir
	for RemovalDir in ${RemoveDirList}; do
		echo "Removing ${BKPDIR}/${RemovalDir}..."
		$Rm -rf ${BKPDIR}/${RemovalDir}
	done

	OLD_PATCH_DIR=$RootMnt/.old_patch_info
	$Rm -rf ${OLD_PATCH_DIR}
	${Mkdir} ${OLD_PATCH_DIR}
	$Cp $RootMnt/etc.defaults/VERSION ${OLD_PATCH_DIR}/VERSION
	$Cp $RootMnt/etc.defaults/synoinfo.conf ${OLD_PATCH_DIR}/synoinfo.conf
	$Cp -rf $RootMnt/.system_info ${OLD_PATCH_DIR}/

	# rm all files on root fs
	$Rm -rf $RootMnt/*
	# extract
	mkswap ${SwapPartition}
	swapon ${SwapPartition}
	echo "Untaring ${UPGRADE_FILE}..."
	$Tar xf $UPGRADE_FILE -C $RootMnt
	isFailToUntarSynoUpgrade=$?

	if [ $isFailToUntarSynoUpgrade -ne 0 -a "synology_monaco_ds216play" == `/bin/get_key_value /etc.defaults/synoinfo.conf unique` ]; then
		# Workaround for DS216play to avoid for failing to untar SynoUpgrade.tar
		# see bug HW_DS216play_STM # 48
		maxUntarRetryCount=10
		untarRetryCount=0
		while [ $untarRetryCount -ne 5 ]; do
			echo "fail to untar. sleep 10 seconds and try again"
			sleep 10
			untarRetryCount=$(( $untarRetryCount +1 ))
			echo "Untaring ${UPGRADE_FILE}... retry=${untarRetryCount}/${maxUntarRetryCount}"
			$Tar xf $UPGRADE_FILE -C $RootMnt
			isFailToUntarSynoUpgrade=$?
			if [ $isFailToUntarSynoUpgrade -eq 0 ]; then
				break;
			fi
		done
	fi

	if [ $isFailToUntarSynoUpgrade -ne 0 ]; then
		# remove bad files
		$Rm -rf $RootMnt/*

		# remove upgrade tarball file
		$Rm -rf $UPGRADE_FILE

		# restore backed-up config files
		if [ ${RootPartition} = ${DataPartition} ]; then
			$Cp -alf ${BKPDIR}/* ${RootMnt}/
		else
			$Cp -a ${BKPDIR}/* ${RootMnt}/
		fi
		# remove backup config files
		$Rm -rf ${BKPDIR}

		# restore VERSION & synoinfo.conf
		${Mkdir} -p ${RootMnt}/etc.defaults
		$Cp -a ${OLD_PATCH_DIR}/VERSION ${RootMnt}/etc.defaults/VERSION
		$Cp -a ${OLD_PATCH_DIR}/synoinfo.conf ${RootMnt}/etc.defaults/synoinfo.conf

		swapoff ${SwapPartition}
		exit 2;
	fi

	# Copy configs to default folders
	$Cp -a $RootMnt/etc				$RootMnt/etc.defaults
	$Cp -a $RootMnt/var				$RootMnt/var.defaults
	$Cp -a $RootMnt/usr/syno/etc	$RootMnt/usr/syno/etc.defaults
	swapoff ${SwapPartition}

	# remove upgrade tarball file
	$Rm -rf $UPGRADE_FILE

	# copy backed-up config files
	if [ ${RootPartition} = ${DataPartition} ]; then
		$Cp -alf ${BKPDIR}/* ${RootMnt}/
	else
		$Cp -a ${BKPDIR}/* ${RootMnt}/
	fi
	# remove backup config files
	$Rm -rf ${BKPDIR}

	# modify unique in disk synoinfo.conf for rp and non-rp models
	if [ -x /usr/syno/bin/synohdcfgen ]; then
		insmod /lib/modules/synobios.*
		/bin/mknod /dev/synobios c 201 0
		echo "Starting /usr/syno/bin/synohdcfgen..."
		/usr/syno/bin/synohdcfgen $RootMnt
		RetCfg=$?
		echo "/usr/syno/bin/synohdcfgen returns $RetCfg"
		rmmod `/sbin/lsmod | /bin/grep synobios  | /usr/bin/cut -f 1 -d ' '`
	fi
	# untar indexdb
	if [ -f ${RootMnt}/.SynoUpgradeIndexdb.tgz ]; then
		echo "Untaring .SynoUpgradeIndexdb.tgz";
		$Tar -xf ${RootMnt}/.SynoUpgradeIndexdb.tgz -C ${RootMnt}/usr/syno/synoman/indexdb
		# remove indexdb file
		$Rm -f ${RootMnt}/.SynoUpgradeIndexdb.tgz
	fi
	# untar synohdpack
	if [ -f ${RootMnt}/.SynoUpgradeSynohdpackImg.tgz ]; then
		echo "Untaring .SynoUpgradeSynohdpackImg.tgz";
		$Tar -xf ${RootMnt}/.SynoUpgradeSynohdpackImg.tgz -C ${RootMnt}/usr/syno/synoman/synohdpack
		# remove synohdpack file
		$Rm -f ${RootMnt}/.SynoUpgradeSynohdpackImg.tgz
	fi

	touch ${RootMnt}/var/.UpgradeBootup
	echo "Touching ${RootPartition}:/var/.UpgradeBootup"
	
	if [ $IS_INSTALL_CREATE_VOL -eq 1 ]; then
	    touch ${NOTIFY_ASSISTANT_INSTALL_VOL_CREATE}
	    echo "Touching ${NOTIFY_ASSISTANT_INSTALL_VOL_CREATE}"
	fi


	# Workaround for BLDK issue in all models that support EUP
	# this file (/var/.updater_enable_rcpower) is read by S79RCPower.sh in the
	# last rebooting to keep RCPower enable during upgrading.
	# And it should be removed now

	if [ -e "$RootMnt/var/.updater_enable_rcpower" ]; then
		rm -f $RootMnt/var/.updater_enable_rcpower
	fi

	sync ; sync ; sync
else
	echo "No upgrade file exists"
fi

if [ $IsClean -ne 1 ]; then
	touch ${DataMnt}/.needquotacheck_upgrade
	echo "Touching ${DataPartition}:/.needquotacheck_upgrade"
fi

# cleanup
sync ; sync ; sync
if [ ${RootMnt} != ${DataMnt} ]; then
	$Umount $DataMnt
fi

echo "End upgrade procedure"
##################################

