#!/bin/sh

# This script is used to initialize a new disk containing 
# only the first (root) partition from etc/rc. This script
# thus assume root partition is already mounted.
#
# The intended disk layout after executing this script 
# will be:
#	Partition 1: root fs
#	Partition 2: swap
#	Partition 3: user data mounted at /volume1
# 
# It (clear existing if any and re)create partition 2,3,4 
# on /dev/sda.
#
#
. /etc/rc.subr

RaidTool="/sbin/raidtool"
PROCPARTITION="/proc/partitions"
SupportRAID=`/bin/get_key_value /etc/synoinfo.conf supportraid`
SupportDualhead=`/bin/get_key_value /etc.defaults/synoinfo.conf support_dual_head`
DefaultFS=`/bin/get_key_value /etc/synoinfo.conf defaultfs`
SystemFS=`/bin/get_key_value /etc/synoinfo.conf systemfs`
SupportBuildinStorage=`/bin/get_key_value /etc.defaults/synoinfo.conf support_buildin_storage`
UniqueRD=`/bin/get_key_value /etc.defaults/synoinfo.conf unique | cut -d"_" -f2`
EmmcBoot=`/bin/get_key_value /etc.defaults/synoinfo.conf support_emmc_boot`
if [ "$SupportRAID" = "yes" ]; then
   DISKNODE="/dev/md"
   PARTNO_ROOT="0"
   PARTNO_SWAP="1"
   PARTNO_DATA="2"
else
   DISKNODE="/dev/sda"
   PARTNO_ROOT="1"
   PARTNO_SWAP="2"
   PARTNO_DATA="3"
fi
WRITEABLE_SIZE=4980480
SWAP_SIZE=4194304
ROOT_SKIP=2048
SWAP_SKIP=0
LINUX_FS_TYPE=83
LINUX_SWAP_TYPE=82
Sfdisk="/sbin/sfdisk"
Mount="/bin/mount"
Umount="/bin/umount"
FlagFile="/SynoRepart"
FS_Opt=""
ErrorFile="/tmp/installer.error"
HaveDisk=0

HAS_SYSTEM_PARTITION=0
DO_CLEAN_PARTITION="1"

if [ "yes" = "${EmmcBoot}" ]; then
	PARTNO_PATCH="4"
	WRITEABLE_SIZE=2097152
	DATA_SIZE=5105569
	PATCH_SIZE=524288
	DATA_SKIP=0
	PATCH_SKIP=0
fi

###########################################################

# stop all burn-in test (memtester or DMA test) before install
/usr/sbin/burnin_test -f &> /dev/null

/bin/echo "Check new disk..."
for i
do
	case "${i}"
	in
		-n)
			DO_CLEAN_PARTITION="0"
			shift
		;;
		-s)
			HAS_SYSTEM_PARTITION=1
			shift
		;;		
	esac
done

/bin/rm ${ErrorFile}

if [ "$SupportRAID" = "yes" ]; then
	if [ "$SupportDualhead" = "yes" ]; then
		diskIdxList=`/usr/syno/bin/synodiskport -eunit`
	else
		diskIdxList=`/usr/syno/bin/synodiskport -internal`
	fi
	disk_count=0
	for DiskIdx in ${diskIdxList} ; do
		/bin/dd if=/dev/${DiskIdx} of=/dev/null count=1 > /dev/null 2>&1
		if [ $? = "0" ]; then
			HaveDisk=1
			disk_count=$(($disk_count+1))
		fi
	done

	if [ "0" = "${HaveDisk}" ]; then
		IfErrorThenExit "NODISK" 1 ${ErrorFile}
	fi
	if [ "$SupportDualhead" = "yes" ]; then
		if [ 3 -gt $disk_count ]; then
			IfErrorThenExit "DUALHEAD_MORE_DISKS" 1 ${ErrorFile}
		fi
	fi
else
	/bin/dd if=/dev/sda of=/dev/null count=1 > /dev/null 2>&1
	if [ $? != "0" ]; then
		IfErrorThenExit "NODISK" 1 ${ErrorFile}
	fi
fi

/bin/umount /volume1
if [ "yes" != "${EmmcBoot}" ]; then
	/sbin/swapoff ${DISKNODE}${PARTNO_SWAP}
fi

if [ "$SupportRAID" = "yes" ]; then
	
	if [ $HAS_SYSTEM_PARTITION -eq 0 ]; then
	    # SupportRAID always do not clean data partition
	    for RaidVol in 1 0; do
		    /bin/echo "${RaidTool} destroy ${RaidVol}"
		    ${RaidTool} destroy ${RaidVol}
	    done
	    #${RaidTool} initsys-dd
	    ${RaidTool} initsys
	    IfErrorThenExit "CREATE" $? ${ErrorFile}	
	fi
elif [ "${DO_CLEAN_PARTITION}" = "1" ]; then
	# clean partitions
	for RaidVol in 0 1 2 3 4 5 6 7 8 9 10 11 12 13; do
		/bin/grep md${RaidVol} ${PROCPARTITION}
		if [ $? -eq 0 ]; then
			/bin/echo "${RaidTool} destroy ${RaidVol}"
			${RaidTool} destroy ${RaidVol}
		fi
	done

	if [ $HAS_SYSTEM_PARTITION -eq 1 ]; then
	    #Has system partition, just clean data partition
	    for Partition in 3 4; do
		    /bin/echo "Clean partition ${Partition}"
		    CleanPartition ${Partition} ${DISKNODE}
		    IfErrorThenExit "CLEAN" $? ${ErrorFile}
	    done	
	else
	    #Doesn't has system/data partition, clean all partition
	    ${Sfdisk} -M1 ${DISKNODE}
	    ResFdisk=$?
	    IfErrorThenExit "FDISK" $ResFdisk ${ErrorFile}
	    for Partition in 1 2 3 4; do
		    /bin/echo "Clean partition ${Partition}"
		    CleanPartition ${Partition} ${DISKNODE}
		    IfErrorThenExit "CLEAN" $? ${ErrorFile}
	    done
    
	    CreatePartition ${PARTNO_ROOT} ${WRITEABLE_SIZE} ${LINUX_FS_TYPE} ${ROOT_SKIP} ${DISKNODE}
	    IfErrorThenExit "CREATE" $? ${ErrorFile}
	    if [ "yes" != "${EmmcBoot}" ]; then
		    CreatePartition ${PARTNO_SWAP} ${SWAP_SIZE} ${LINUX_SWAP_TYPE} ${SWAP_SKIP} ${DISKNODE}
		    IfErrorThenExit "CREATE" $? ${ErrorFile}
	    fi
	    if [ "yes" = "${EmmcBoot}" ]; then
		    CreatePartition ${PARTNO_DATA} ${DATA_SIZE} ${LINUX_FS_TYPE} ${DATA_SKIP} ${DISKNODE}
		    IfErrorThenExit "CREATE" $? ${ErrorFile}

	        CreatePartition ${PARTNO_PATCH} ${PATCH_SIZE} ${LINUX_FS_TYPE} ${PATCH_SKIP} ${DISKNODE}
	        IfErrorThenExit "CREATE" $? ${ErrorFile}
	    fi
		sleep 1
	    if [ "yes" != "${EmmcBoot}" ]; then
	        synodd ${DISKNODE}${PARTNO_ROOT} ${DISKNODE}${PARTNO_SWAP}
	        IfErrorThenExit "SYNODD" $? ${ErrorFile}
	    else
	        echo "1/1" > /tmp/synodd.sda
	    fi
	fi
fi

if [ $HAS_SYSTEM_PARTITION -eq 0 ]; then
	if [ "yes" != "${EmmcBoot}" ]; then
		/bin/echo "mkswap ${DISKNODE}${PARTNO_SWAP}"
		/sbin/mkswap ${DISKNODE}${PARTNO_SWAP}
		IfErrorThenExit "MKSWAP" $? ${ErrorFile}
	fi

    FS_Opt=$( get_mkfs_option ${SystemFS} )
    /sbin/mkfs.${SystemFS} ${FS_Opt} ${DISKNODE}${PARTNO_ROOT}
    Res=$?
    IfErrorThenExit "MKFS" $Res ${ErrorFile}

	if [ "yes" = "${EmmcBoot}" ]; then
		/sbin/mkfs.${DefaultFS} ${DISKNODE}${PARTNO_DATA}
		Res=$?
		IfErrorThenExit "MKFS" $Res ${ErrorFile}

		/sbin/mkfs.${SystemFS} ${DISKNODE}${PARTNO_PATCH}
		Res=$?
		IfErrorThenExit "MKFS" $Res ${ErrorFile}
	fi
else     
    Res=0
    # Notify Assistant to skip format system partition
    /bin/touch "/.skip_format_sys"
    /bin/echo "touching /.skip_format_sys"
fi

if [ $Res -eq 0 -a "$SupportDualhead" = "yes" ]; then
	/usr/sbin/chroot /dual_glibc /usr/syno/synoaha/bin/synoaha --prepare-for-install
	Res=$?
fi

if [ $Res -eq 0 ]; then
	/bin/mount ${DISKNODE}${PARTNO_ROOT} /mnt
	/bin/touch /mnt/.noroot
	/bin/umount /mnt
fi

if [ -x /usr/syno/bin/mantool ]; then
	/usr/syno/bin/mantool -auto_poweron_disable
fi

exit 0

