/*var synoQuotaUsageData = {
    'volume1' : {
		maxQuota : '12345678',
		data : [],
		raw : [
				[[ 0, 0, 55 ],  [0, 0, 60]],
				[[ 0, 1, 30 ],  [0, 1, 100]],
				[[ 0, 2, 70 ],  [0, 2, 80]],
				[[0, 3, 30],  [0, 3, 50]],
				[[0, 4, 90] , [0, 4, 95]],
				[[0, 5, 30],  [0, 5, 50]],
				[[0, 6, 5] , [0, 6, 10]]
		],
		labels : ['admin' + ' (99%)', 
			'guest', 
			'root', 
			'nobody', 
			'user', 
			'test1', 
			'test2' 
		]
	},
    'volume2' : {
		raw : [
				[[ 0, 0, 55 ],  [0, 0, 60]],
				[[ 0, 1, 30 ],  [0, 1, 35]],
				[[ 0, 2, 70 ],  [0, 2, 80]],
				[[0, 3, 30],  [0, 3, 50]],
				[[0, 4, 90] , [0, 4, 95]],
				[[0, 5, 30],  [0, 5, 50]]
		],
		maxQuota : '2345678',
		labels : [ 'admin' + ' (99%)', 'guest', 'root', 'nobody', 'user' ],
		data : []
	}
};*/

var gQuotaUsageContainerId = 'quota_usage_container';
var gQuotaUsageContainerIdShare = 'share_quota_usage_container';

function QuotaUsageRedraw(tabpanel, tab)
{
	var volume = tab.id;
	QuotaUsageDrawX(volume, tabpanel.quotaType);
	QuotaUsageDrawBar(volume, tabpanel.quotaType);
	QuotaUsageTable(volume, tabpanel.quotaType);
	if(tabpanel.quotaType === 'volume') {
		(new GridPanelPlugin()).updateScrollbar(document.getElementById(gQuotaUsageContainerId));
	} else {
		(new GridPanelPlugin()).updateScrollbar(document.getElementById(gQuotaUsageContainerIdShare));
	}
}

function QuotaUsageRenderPercent(val, metaData, record, rowIndex, colIndex, store)
{
	var img = '';
	if(val < 0) {
		return '-';
	} else if(val > 0  && val <= 10) {
		img = 'icon_10.png';
	} else if(val > 10 && val <= 20) {
		img = 'icon_20.png';
	} else if(val > 20 && val <= 30) {
		img = 'icon_30.png';
	} else if(val > 30 && val <= 40) {
		img = 'icon_40.png';
	} else if(val > 40 && val <= 50) {
		img = 'icon_50.png';
	} else if(val > 50 && val <= 60) {
		img = 'icon_60.png';
	} else if(val > 60 && val <= 70) {
		img = 'icon_70.png';
	} else if(val > 70 && val <= 80) {
		img = 'icon_80.png';
	} else if(val > 80 && val <= 90) {
		img = 'icon_90.png';
	} else {
		img = 'icon_100.png';
	}
	metaData.attr='style="background-image: url(../../template/pic/' + img + '); background-position: 10% 50%; background-repeat: no-repeat;"';
	return val + '%';
}

var quotaUsageGrid;
var quotaUsageGridShare;
function QuotaUsageTable(volume, quotaType)
{
	Ext.QuickTips.init();
	var quotaData;
	var currentGrid;

	if(quotaType === 'volume') {
		currentGrid = quotaUsageGrid;
		if(typeof synoQuotaUsageTable === 'undefined' || synoQuotaUsageTable.length === 0) {
			NoDataSet('quota_usage_nodata');
			return;
		}
		quotaData = synoQuotaUsageTable;
	} else {
		currentGrid = quotaUsageGridShare;
		if(typeof synoQuotaUsageByShareTable === 'undefined' || synoQuotaUsageByShareTable.length === 0) {
			NoDataSet('share_quota_usage_nodata');
			return;
		}
		quotaData = synoQuotaUsageByShareTable;
	}

	var store = new Ext.data.ArrayStore({
        fields: [
           {name: 'User'},
           {name: 'Quota'},
           {name: 'Used'},
           {name: 'Percentage'}
        ]
    });

	store.setDefaultSort('Used', 'DESC');

	// manually load local data
    store.loadData(quotaData[volume]);

    var gridColumnModel = new Ext.grid.ColumnModel({
			columns: [
            {
                header   : _T('common', 'username'),
                width    : 200,
                sortable : true,
                dataIndex: 'User',
				align: 'left',
                tooltip  : _T('common', 'username')
            },
            {
				header   : _T('user', 'user_quota_capacity'),
                width    : 200,
                sortable : true,
                dataIndex: 'Quota',
                tooltip:  _T('user', 'user_quota_capacity'),
                renderer: QuotaUsageRenderQuota
            },
            {
				header   : _T('report', 'reportUI_title_used'),
                width    : 200,
                sortable : true,
                tooltip  : _T('report', 'reportUI_title_used'),
                dataIndex: 'Used',
                renderer: SizeUnit
            },
            {
				header   : _T('report', 'reportUI_title_percent'),
                sortable : true,
                dataIndex: 'Percentage',
                tooltip  : _T('report', 'reportUI_title_percent'),
                renderer: QuotaUsageRenderPercent
            }
		]});

	// create the Grid
	var gridConfig = {
		border: false,
		store: store,
		stripeRows: true,
		width: 930,
		enableColumnResize: false,
		enableHdMenu: false,
		enableColumnHide: false,
		enableColumnMove: false,
		view: new Ext.ux.grid.BufferView(BufferViewConfig),
		plugins: [new SYNO.Report.BufferViewFlexcrollPlugin(), new SYNO.Report.GridPanelFlexcrollPlugin()],
		colModel: gridColumnModel
	};

	if(typeof currentGrid === 'undefined') {
		// render the grid to the specified div in the page
		if(quotaType === 'volume') {
			quotaUsageGrid = currentGrid = new Ext.grid.GridPanel( gridConfig);
			quotaUsageGrid.render('quota_usage_table');
		} else {
			quotaUsageGridShare = currentGrid = new Ext.grid.GridPanel( gridConfig);
			quotaUsageGridShare.render('share_quota_usage_table');
		}
	} else {
		//quotaUsageGrid.reconfigure(synoQuotaUsageTable[volume], gridColumnModel);
		currentGrid.reconfigure(store, gridColumnModel);
	}
}

function QuotaUsageDrawX(volume, quotaType)
{
	var d1        = [[0, 0, 50]];
	var
	rootObj,
	data = [],
	markers   = [],
	i, graph, point;
	var quotaData;

	if(quotaType === 'volume') {
		quotaData = synoQuotaUsageData;
	} else {
		quotaData = synoQuotaUsageByShareData;
	}

	var maxQuota	= quotaData[volume].maxQuota;
	var maxUserUsed	= quotaData[volume].maxUserUsed;

	var container;
	if(quotaType === 'volume') {
		container = document.getElementById('quota_usage_x');
	} else {
		container = document.getElementById('share_quota_usage_x');
	}

	container.style.width="930px";
	container.style.height="22px";

	// Draw Graph
	graph = Flotr.draw(container, data, {
		xaxis: {
			min: 0,
			max: 110,
			ticks: [ 0, 10, 20, 30, 40, 50, 60, 70, 80, 90, 100 ],
			tickFormatter: function (x) {
			var xx = parseInt(x, 10), months = [];

			for(i=0; i<=10; i++) {
				months.push(SizeUnit(parseInt(maxUserUsed* i/10*1024, 10)));
			}
			//prevent out of div boundary
			if( xx === 0) {
				return "";
			}
			return months[((xx)%101)/10];
		}
    },
    yaxis: {
		showLabels : false
    },
    grid: {
		outlineWidth: 3,
		outline : 's',
		horizontalLines : false
    }
  });
}

function QuotaUsageDrawBar(volume, quotaType)
{
	var rootObj, markers = [], i, graph, point;
	var timeline  = { show : true, barWidth : 0.85, synoColorList : ['#1886ca'] };

	var container;
	var containerId;
	var quotaData;
	if(quotaType === 'volume') {
		container = document.getElementById('quota_usage');
		containerId = gQuotaUsageContainerId;
		quotaData   = synoQuotaUsageData;
	} else {
		container = document.getElementById('share_quota_usage');
		containerId = gQuotaUsageContainerIdShare;
		quotaData   = synoQuotaUsageByShareData;
	}

	rootObj = quotaData[volume];
	rootObj.data = [];

	//fix size hieght 500px
	var drawHeight = (rootObj.raw.length * 35) < 300 ? 300 + 'px' : (rootObj.raw.length * 35) + 'px';
	container.style.width="930px";
	container.style.height=drawHeight;

	//Timeline
	Flotr._.each(rootObj.raw, function (d) {
		rootObj.data.push({
			data : d,
			timeline : Flotr._.clone(timeline)
		});
	});

	// Markers
	Flotr._.each(rootObj.raw, function (d) {
		point = d[0];
		markers.push([point[0], point[1]]);
	});

	//data.push({
	rootObj.data.push({
		data: markers,
		markers: {
			show: true,
			position: 'rm',
			fontSize: 13,
			labelFormatter : function (o) { return rootObj.labels[o.index]; },
			color: Ext.isIE8?'#000000':'#FFFFFF',
			synoTextOption: {
				font: '14px Verdana',
				shadowColor: '#0f1928',
				shadowBlur: 5
			}
		}
	});

	// Draw Graph
	graph = Flotr.draw(container, rootObj.data, {
		xaxis: {
			showLabels : false,
			min: 0,
			max: 110,
			ticks: [ 0, 10, 20, 30, 40, 50, 60, 70, 80, 90, 100 ],
			tickFormatter: function (x) {
				var
				xx = parseInt(x, 10),
				months = [];

				for(i=0; i<=10; i++) {
					months.push(parseInt(rootObj.maxUserUsed* i/10, 10));
				}
				if( xx === 0) {
					return "";
				} else if(xx == 100) {
					return "";
				}
				return months[((xx)%101)/10];
			}
		}, 
		yaxis: {
			showLabels : false
		},
		mouse: {
			synoCustomizeToolTip: true,
			synoFlexContainerId: containerId,
			track: true,
			trackAll: true,
			position: 'ne',
			trackFormatter: function(x,y,z) {
				return _T('report', 'reportUI_title_used') + ' ' + SizeUnit(x.series.data[0][2] * rootObj.maxUserUsed* 1024/100);
			}
		},
		grid: {
			outlineWidth: 3,
			outline : 'w',
			horizontalLines : false
		}
  });
}

/*!
 * Ext JS Library 3.3.1
 * Copyright(c) 2006-2010 Sencha Inc.
 * licensing@sencha.com
 * http://www.sencha.com/license
 */

function QuotaUsage(quotaType)
{
	var data;
	var panel_id;
	Ext.QuickTips.init();

	if(typeof quotaType === 'undefined') {
		//compatible old version html data
		quotaType = 'volume';
	}

	if(quotaType === 'volume') {
		if(typeof synoQuotaUsageData ==='undefined' || typeof synoQuotaUsageTable === 'undefined') {
			NoDataSet('quota_usage_nodata');
			return;
		}
		data = synoQuotaUsageData;
		panel_id = 'myTPanel';
	} else {
		if(typeof synoQuotaUsageByShareData ==='undefined' || typeof synoQuotaUsageByShareTable === 'undefined') {
			if(typeof share_title_quota_usage === 'undefined') {
				//old version
				return;
			}
			NoDataSet('share_quota_usage_nodata');
			return;
		}
		data = synoQuotaUsageByShareData;
		panel_id = 'myTPanelShare';
	}

	// Create our instance of tabScrollerMenu
	var scrollerMenu = new Ext.ux.TabScrollerMenu({
		maxText  : 15,
		pageSize : 5
	});

	//new Ext.Window({
	var mainPanel = new Ext.Panel({
		height : 50,
		width  : 930,
		border: false,
		viewConfig: { forceFit: true },
		items  : {
			xtype           : 'tabpanel',
			quotaType		: quotaType,
			activeTab       : 0,
			id              : panel_id,
			viewConfig: { forceFit: true },
			enableTabScroll : true,
			minTabWidth     : 150,
			tabWidth        : 150,
			border          : false,
			//plugins         : [ scrollerMenu ],
			items           : [],
			listeners: {
				tabchange: {
					fn: QuotaUsageRedraw,
					scope: this
				}
			}
		}
	});

	//show panel
	if(quotaType === 'volume') {
		mainPanel.render('quota_usage_menu');
	} else {
		if(synoQuotaUsageByShareData) {
			mainPanel.render('share_quota_usage_menu');
		}
	}

	
	// Add a bunch of tabs dynamically
	var j=0;
	(function (num) {
		for (var i in data) {
			Ext.getCmp(panel_id).add({
				id		 : i,
				title    : quotaType === 'volume' ? VolumeId2Name(i) : i,
				tabTip   : quotaType === 'volume' ? VolumeId2Name(i) : i,
				closable : false
			});
			if(j == 0) {
				Ext.getCmp(panel_id).activate(0);
				j++;
			}
		}
	})();
}

