/*var synoLeastModifyData = [
	[ 'public', '/volume1/public/aa', 1024, 1353491284 ],
	[ 'music',  '/volume1/music/bb',  2048, 1353491284 ],
	[ 'video',  '/volume1/video/vv',  4096, 1353491284 ]
];*/

function LeastModify()
{
    Ext.QuickTips.init();

    if(typeof synoLeastModifyData === 'undefined' || synoLeastModifyData.length === 0) {
        NoDataSet('least_modify_nodata');
        return ;
    }


    // NOTE: This is an example showing simple state management. During development,
    // it is generally best to disable state management as dynamically-generated ids
    // can change across page loads, leading to unpredictable results.  The developer
    // should ensure that stable state ids are set for stateful components in real apps.    
    Ext.state.Manager.setProvider(new Ext.state.CookieProvider());

    var store = new Ext.data.ArrayStore({
        fields: [
           {name: 'Share'},
           {name: 'File'},
           {name: 'Size', type: 'int'},
           {name: 'Time', type: 'date', dateFormat:'U'}
        ]
    });

    // manually load local data
    store.loadData(synoLeastModifyData);

    // create the Grid
    var grid = new Ext.grid.GridPanel({
		border: false,
        store: store,
		stripeRows: true,
        width: 930,
		enableColumnResize: false,
		enableHdMenu: false,
		enableColumnHide: false,
		enableColumnMove: false,
		view: new Ext.ux.grid.BufferView(BufferViewConfig),
        columns: [
            {
				header   : _T('report','reportUI_title_share'),
                width    : 200,
                sortable : true,
                dataIndex: 'Share',
				tooltip  : _T('report','reportUI_title_share'),
				css: 'font-weight: bold;'
            },
            {
				header   : _T('common', 'file'),
                width    : 400,
                sortable : true,
                dataIndex: 'File',
				tooltip  : _T('common', 'file'),
                renderer: htmlEncodeRenderer
            },
            {
                header   : _T('common', 'size'),
                width    : 130,
                sortable : true,
                renderer : SizeUnit,
				tooltip  : _T('common', 'size'),
                dataIndex: 'Size'
            },
            {
                header   : _T('report','reportUI_title_modify_time'),
                width    : 200,
                sortable : true,
                dataIndex: 'Time',
				tooltip  : _T('report','reportUI_title_modify_time'),
				renderer: Ext.util.Format.dateRenderer('Y-m-d H:i:s')
            }
        ],
        plugins: [new SYNO.Report.BufferViewFlexcrollPlugin(), new SYNO.Report.GridPanelFlexcrollPlugin()]
    });

    // render the grid to the specified div in the page
    grid.render('least_modify');
}
