/*var synoDuplicateFileData = [
	[ '1', 'public', '/volume1/public/aa', 1024, 1353491284 ],
	[ '2', 'music',  '/volume1/music/bb',  2048, 1353491284 ],
	[ '3', 'video',  '/volume1/video/vv',  4096, 1353491284 ]
];*/

function DuplicateFile()
{
    Ext.QuickTips.init();

	if(typeof synoDuplicateFileData === 'undefined' || synoDuplicateFileData.length === 0) {
		NoDataSet('duplicate_file_nodata');
		return ;
	}
    // NOTE: This is an example showing simple state management. During development,
    // it is generally best to disable state management as dynamically-generated ids
    // can change across page loads, leading to unpredictable results.  The developer
    // should ensure that stable state ids are set for stateful components in real apps.    
    Ext.state.Manager.setProvider(new Ext.state.CookieProvider());

    var store = new Ext.data.ArrayStore({
        fields: [
           {name: 'Group'},
           {name: 'Share'},
           {name: 'File'},
           {name: 'Size', type: 'int'},
           {name: 'Time', type: 'date', dateFormat:'U'}
        ]
    });

    // manually load local data
    store.loadData(synoDuplicateFileData);

    // create the Grid
    var grid = new Ext.grid.GridPanel({
		border: false,
        store: store,
		stripeRows: true,
        width: 930,
		enableColumnResize: false,
		enableHdMenu: false,
		enableColumnHide: false,
		enableColumnMove: false,
		view: new Ext.ux.grid.BufferView(BufferViewConfig),
        columns: [
            {
				header   : _T('report','reportUI_title_group'),
                width    : 80,
                sortable : true,
				tooltip  : _T('report','reportUI_title_group'),
                dataIndex: 'Group'
            },
            {
                header   : _T('report','reportUI_title_share'),
                width    : 150,
                sortable : true,
                dataIndex: 'Share',
				tooltip  : _T('report','reportUI_title_share'),
				css: 'font-weight: bold;'
            },
            {
				header   : _T('common','file'),
                width    : 350,
                sortable : true,
                dataIndex: 'File',
				tooltip  : _T('common','file'),
                renderer: htmlEncodeRenderer
            },
            {
                header   : _T('common','size'),
                width    : 150,
                sortable : true,
				tooltip  : _T('common','size'),
                renderer : SizeUnit,
                dataIndex: 'Size'
            },
            {
				header   : _T('report', 'reportUI_title_modify_time'),
                width    : 200,
                sortable : true,
				tooltip  : _T('report', 'reportUI_title_modify_time'),
				renderer: Ext.util.Format.dateRenderer('Y-m-d H:i:s'),
                dataIndex: 'Time'
            }
        ],
        plugins: [ new GridPanelPlugin(14) ]
    });

    // render the grid to the specified div in the page
    grid.render('duplicate_file');
}

function DuplicateFile2()
{
    Ext.QuickTips.init();
	var store, column5;

	if(typeof synoDuplicateFileData === 'undefined' || synoDuplicateFileData.length === 0) {
		NoDataSet('duplicate_file_nodata');
		return ;
	}
    // NOTE: This is an example showing simple state management. During development,
    // it is generally best to disable state management as dynamically-generated ids
    // can change across page loads, leading to unpredictable results.  The developer
    // should ensure that stable state ids are set for stateful components in real apps.    
    Ext.state.Manager.setProvider(new Ext.state.CookieProvider());

	store = new Ext.data.ArrayStore({
		fields: [
		   {name: 'Group'},
		   {name: 'Share'},
		   {name: 'File'},
		   {name: 'Size', type: 'int'},
           {name: 'Time', type: 'date', dateFormat:'U'},
		   {name: 'Status'}
		]
		/*],
		listeners:  {
			load: {
				fn: StatFileList
			}
		}*/
	});
	column5 = {
		header   : _T('report', 'reportUI_title_action'),
		xtype    : 'actioncolumn',
		width    : 200,
		renderer:  function (val, cellmeta, rec, rowIndex, colIndex, store) {
			if (val === 'delete_ok' || val === 'file_not_exist') {
				cellmeta.attr='style="color:#aaaaaa;"';
				return _T('report', 'reportUI_file_status_removed');
			} else if(val === 'delete_failed') {
				cellmeta.attr='style="color:red;"';
				return _T('error', 'error_error');
			} else if(val === 'file_status_unknow' || val === 'file_ajax') {
				var img = '../../template/pic/loading.gif';
				return String.format('<img width="18" height="18" src="{0}">', img);
			}
			return '';
		},
		dataIndex: 'Status',
		items: [{
				icon: '../../template/pic/bt_del.png',
				scope: this,
				getClass:  function (val, cellmeta, rec) {
					if(rec.data['Status'] === 'delete_ok' || rec.data['Status']=== 'file_not_exist') {
						return 'image_hidden';
					} else if(rec.data['Status'] === 'file_status_unknow' || rec.data['Status'] === 'file_ajax') {
						return 'image_hidden';
					} else if(rec.data['Status'] === 'delete_failed') {
						return 'image_hidden';
					} else if(rec.data['Status'] === '') {
						//cannot stat file
						return 'image_hidden';
					}
					return 'image_normal';
				},
				handler: onDeleteFile
			}]
		};
	store.loadData(synoDuplicateFileData);

	//preload need image(session time will load img failed
	Ext.Msg.confirm(_T('report','reportUI_msgbox_title_info'), _T('common','loading')).hide();

	// create the Grid
	var grid = new Ext.grid.GridPanel({
			border: false,
			store: store,
			stripeRows: true,
			width: 930,
			enableColumnResize: false,
			enableHdMenu: false,
			enableColumnHide: false,
			enableColumnMove: false,
			cls: 'without-dirty-red-grid',
			view: new Ext.ux.grid.BufferView(BufferViewConfig),
			columns: [
				{
					header   : _T('report','reportUI_title_group'),
					width    : 80,
					sortable : true,
					tooltip  : _T('report','reportUI_title_group'),
					dataIndex: 'Group'
				},
				{
					header   : _T('report','reportUI_title_share'),
					width    : 150,
					sortable : true,
					dataIndex: 'Share',
					tooltip  : _T('report','reportUI_title_share'),
					css: 'font-weight: bold;'
				},
				{
					header   : _T('common','file'),
					width    : 350,
					sortable : true,
					dataIndex: 'File',
					tooltip  : _T('common','file'),
					renderer: htmlEncodeRenderer
				},
				{
					header   : _T('common','size'),
					width    : 150,
					sortable : true,
					tooltip  : _T('common','size'),
					renderer : SizeUnit,
					dataIndex: 'Size'
				},
				{
					header   : _T('report', 'reportUI_title_modify_time'),
					width    : 200,
					sortable : true,
					tooltip  : _T('report', 'reportUI_title_modify_time'),
					renderer: Ext.util.Format.dateRenderer('Y-m-d H:i:s'),
					dataIndex: 'Time'
				},
				column5
			],
			plugins: [new SYNO.Report.BufferViewFlexcrollPlugin(), new SYNO.Report.GridPanelFlexcrollPlugin()]
		});

    // render the grid to the specified div in the page
    grid.render('duplicate_file');
	StatFileList.call(store);
}

function StatFileList()
{
	var i, rec, list = '', share_path, share_name_index, url;

	for(i=0; i<this.getCount(); i++) {
		rec = this.getAt(i);
		share_name_index = GetShareNameIndex(rec);
		share_path = VolumePath2SharePath(rec.data.File, rec.json[share_name_index], true);
		if(i != 0) {
			list += ',';
		}
		list += share_path.replace(/[\\]/g, '\\\\').replace(/[,]/g, '\\,');
	}


	url = '/webapi/FileStation/file_share.cgi';

	Ext.Ajax.request({
			url: url,
			method: 'POST',
			scope: this,
			params: { api: 'SYNO.FileStation.List', version: 1, method: 'getinfo', path: list },
			callback: function (options, success, response) {
				var obj;
				try {
					if(response && response.responseText) {
						obj = Ext.decode(response.responseText);
					}
				} catch(e) {
				}
				
				var i, j;
				if(obj && obj.success === true) {
					var share_name_index = GetShareNameIndex(this.getAt(0));
					for(i=0; i<this.data.items.length; i++) {
						rec = this.getAt(i);
						share_path = VolumePath2SharePath(rec.data.File, rec.json[share_name_index], true);
						if(obj.data.files[i].path === share_path) {
							if(typeof obj.data.files[i].code === 'undefined') {
								rec.set('Status',rec.data.File);
								this.doUpdate(rec);
							} else {
								rec.set('Status', 'file_not_exist');
								this.doUpdate(rec);
							}
						}
					}
				} else {
					for(i=0; i<this.data.items.length; i++) {
						rec = this.getAt(i);
						rec.set('Status', '');
						this.doUpdate(rec);
					}
				}
				return;
			}
		});
}

function onDeleteFile(grid, rowIndex, colIndex)
{
	var url = '/webapi/FileStation/file_delete.cgi';
	var rec = grid.store.getAt(rowIndex);
	var share_path = VolumePath2SharePath(rec.data['File'], rec.data['Share'], true);

	if ('undefined' !== typeof synoDemoMode && !!synoDemoMode) {
		Ext.Msg.alert("", _T('common', "error_demo"));
		return;
	}

	share_path = share_path.replace(/[\\]/g, '\\\\').replace(/[,]/g, '\\,');

	rec.set('Status', 'file_ajax');
	grid.store.doUpdate(rec);

	Ext.Ajax.request({
		url: url,
		method: 'POST',
		scope: this,
		params: { api: 'SYNO.FileStation.Delete', version: 1, method: 'delete', path: share_path, recursive: false },
		callback: function (options, success, response) {
			try {
				var obj = Ext.decode(response.responseText);
				if(obj.success === false) {
					if(obj.error.code === 105) {
						rec.set('Status', 'delete_failed_login');
						grid.store.doUpdate(rec);
						Ext.Msg.confirm(_T('report','reportUI_msgbox_title_info'), _T('report','reportUI_msgbox_ask_login'), function(btn) {
							if(btn === 'yes') {
								location.reload(true);
							}
						});
					} else {
						rec.set('Status', 'delete_failed');
						grid.store.doUpdate(rec);
					}
					return;
				}
				rec.set('Status', 'delete_ok');
				grid.store.doUpdate(rec);
			} catch(e) {
				//reset status
				rec.set('Status', rec.data.File);
				grid.store.doUpdate(rec);
			}
			return;
		}
	});
}
