/* Copyright (c) 2015 Synology Inc. All rights reserved. */

Ext.namespace("SYNO.SDS.ACEEditor");Ext.define("SYNO.SDS.ACEEditor.PreferenceDialog",{extend:"SYNO.SDS.ModalWindow",constructor:function(a){this.parent=a.parent;this.owner=a.owner;var b=this.fillConfig(a);this.callParent([b])},fillConfig:function(a){this.tabPanel=new SYNO.SDS.ACEEditor.PreferenceDialog.TabPanel({editorSettings:this.parent.editorSettings});var b={width:500,height:570,resizable:false,layout:"fit",title:_T("texteditor","Preferences"),items:this.tabPanel,buttons:[{text:_T("common","save"),btnStyle:"blue",scope:this,handler:this.onOkClick},{text:_T("common","cancel"),scope:this,handler:this.onCancelClick}]};Ext.apply(b,a);return b},onOkClick:function(){if(this._S("demo_mode")){this.owner.getMsgBox().alert("",_T("common","error_demo"));return}var b=this.tabPanel.viewFormPanel.getForm();var c=this.tabPanel.editFormPanel.getForm();if(!b.findField("textWrappingColumnNumber").isValid()){this.tabPanel.setActiveTab("viewForm");this.getMsgBox().alert("",_T("common","forminvalid"));return}else{if(!c.findField("tabWidth").isValid()||!c.findField("fontSize").isValid()){this.tabPanel.setActiveTab("editForm");this.getMsgBox().alert("",_T("common","forminvalid"));return}}var a={showLineNumber:b.findField("showLineNumber").getValue(),showInvisibles:b.findField("showInvisibles").getValue(),showIndentGuides:b.findField("showIndentGuides").getValue(),highlightCurrentLine:b.findField("highlightCurrentLine").getValue(),highlightSelectedWord:b.findField("highlightSelectedWord").getValue(),enableCodeFolding:b.findField("enableCodeFolding").getValue(),autoHideFoldingWidget:b.findField("autoHideFoldingWidget").getValue(),codeFoldingMode:b.findField("codeFoldingMode").getValue(),textWrappingMode:b.findField("textWrappingMode").getGroupValue(),textWrappingColumnNumber:b.findField("textWrappingColumnNumber").getValue(),enableBehaviours:c.findField("enableBehaviours").getValue(),insertSpacesInsteadOfTabs:c.findField("insertSpacesInsteadOfTabs").getValue(),tabWidth:c.findField("tabWidth").getValue(),fontSize:c.findField("fontSize").getValue(),theme:c.findField("theme").getValue(),defaultCodepage:c.findField("defaultCodepage").getValue()};this.sendWebAPI({api:"SYNO.ACEEditor.Preference",method:"set",version:1,scope:this,params:{newSettings:a},callback:function(e,d){if(!e){this.getMsgBox().alert("",_T("texteditor","SavePreferenceFail"));return}}});Ext.apply(this.parent.editorSettings,a);this.parent.applyEditorSettings();if(this.owner.mainPanel.tabPanel.getActiveTab()){this.owner.mainPanel.tabPanel.getActiveTab().editor.focus()}this.close()},onCancelClick:function(){if(this.owner.mainPanel.tabPanel.getActiveTab()){this.owner.mainPanel.tabPanel.getActiveTab().editor.focus()}this.close()}});Ext.define("SYNO.SDS.ACEEditor.PreferenceDialog.ViewFormPanel",{extend:"SYNO.SDS.Utils.FormPanel",constructor:function(a){var b=this.fillConfig(a);this.callParent([b]);this.on("afterlayout",function(d,e){var c=new SYNO.ux.Utils.EnableCheckGroup(d.getForm(),"enableCodeFolding",["autoHideFoldingWidget","codeFoldingMode"]);var f=new SYNO.ux.Utils.EnableRadioGroup(d.getForm(),"textWrappingMode",{off:[],free:[],custom:["textWrappingColumnNumber"]})},this,{single:true})},fillConfig:function(a){var b={itemId:"viewForm",title:_T("texteditor","View"),items:[{xtype:"syno_checkbox",name:"showInvisibles",checked:a.editorSettings.showInvisibles,boxLabel:_T("texteditor","ShowInvisibles")},{xtype:"syno_checkbox",name:"showIndentGuides",checked:a.editorSettings.showIndentGuides,boxLabel:_T("texteditor","ShowIndentGuides")},{xtype:"syno_checkbox",name:"highlightCurrentLine",checked:a.editorSettings.highlightCurrentLine,boxLabel:_T("texteditor","HighlightCurrentLine")},{xtype:"syno_checkbox",name:"highlightSelectedWord",checked:a.editorSettings.highlightSelectedWord,boxLabel:_T("texteditor","HighlightSelectedWord")},{xtype:"syno_fieldset",title:_T("texteditor","ShowLineNumber"),collapsible:true,items:[{xtype:"syno_checkbox",name:"showLineNumber",checked:a.editorSettings.showLineNumber,boxLabel:_T("texteditor","ShowLineNumber"),handler:function(c,e){var d=c.ownerCt.getComponent("enableCodeFolding");if(!e){d.setValue(false).disable()}else{d.enable()}}},{xtype:"syno_checkbox",name:"enableCodeFolding",itemId:"enableCodeFolding",disabled:!a.editorSettings.showLineNumber,checked:a.editorSettings.enableCodeFolding,boxLabel:_T("texteditor","EnableCodeFolding")},{xtype:"syno_checkbox",name:"autoHideFoldingWidget",checked:a.editorSettings.autoHideFoldingWidget,boxLabel:_T("texteditor","AutoHideFoldingWidget"),indent:1},{xtype:"syno_combobox",name:"codeFoldingMode",value:a.editorSettings.codeFoldingMode,fieldLabel:_T("texteditor","CodeFoldingMode"),store:new Ext.data.ArrayStore({fields:["modeName","modeValue"],data:[[_T("texteditor","MarkBegin"),"markbegin"],[_T("texteditor","MarkBeginAndEnd"),"markbeginend"]]}),valueField:"modeValue",displayField:"modeName",indent:1}]},{xtype:"syno_fieldset",title:_T("texteditor","TextWrapping"),collapsible:true,items:[{xtype:"syno_radio",name:"textWrappingMode",checked:(a.editorSettings.textWrappingMode=="off"),inputValue:"off",boxLabel:_T("texteditor","Off")},{xtype:"syno_radio",name:"textWrappingMode",checked:(a.editorSettings.textWrappingMode=="free"),inputValue:"free",boxLabel:_T("texteditor","Free")},{xtype:"syno_compositefield",hideLabel:true,items:[{xtype:"syno_radio",name:"textWrappingMode",checked:(a.editorSettings.textWrappingMode=="custom"),inputValue:"custom",boxLabel:_T("texteditor","CustomColumnNumber")},{xtype:"syno_numberfield",name:"textWrappingColumnNumber",value:a.editorSettings.textWrappingColumnNumber,minValue:2,maxValue:512}]}]}]};Ext.apply(b,a);return b}});Ext.define("SYNO.SDS.ACEEditor.PreferenceDialog.EditFormPanel",{extend:"SYNO.SDS.Utils.FormPanel",constructor:function(a){var b=this.fillConfig(a);this.callParent([b])},fillConfig:function(a){var b={itemId:"editForm",title:_T("texteditor","Edit"),items:[{xtype:"syno_checkbox",name:"enableBehaviours",checked:a.editorSettings.enableBehaviours,boxLabel:_T("texteditor","EnableBehaviours")},{xtype:"syno_checkbox",name:"insertSpacesInsteadOfTabs",checked:a.editorSettings.insertSpacesInsteadOfTabs,boxLabel:_T("texteditor","InsertSpacesInsteadOfTabs")},{xtype:"syno_combobox",name:"defaultCodepage",value:a.editorSettings.defaultCodepage,fieldLabel:_T("texteditor","DefaultCodepage"),store:new Ext.data.ArrayStore({fields:["value","name"],data:SYNO.SDS.ACEEditor.Utils.getComboBoxCodepageList(true)}),valueField:"value",displayField:"name"},{xtype:"syno_fieldset",title:_T("texteditor","FontAndColor"),collapsible:true,items:[{xtype:"syno_numberfield",name:"tabWidth",value:a.editorSettings.tabWidth,fieldLabel:_T("texteditor","TabWidth"),minValue:1,maxValue:10},{xtype:"syno_numberfield",name:"fontSize",value:a.editorSettings.fontSize,fieldLabel:_T("texteditor","FontSize"),minValue:6,maxValue:72},{xtype:"syno_combobox",name:"theme",value:a.editorSettings.theme,fieldLabel:_T("texteditor","Theme"),store:new Ext.data.ArrayStore({fields:["themeValue","themeName"],data:[["ambiance","Ambiance"],["chaos","Chaos"],["chrome","Chrome"],["clouds","Clouds"],["clouds_midnight","Clouds Midnight"],["cobalt","Cobalt"],["crimson_editor","Crimson Editor"],["dawn","Dawn"],["dreamweaver","Dreamweaver"],["eclipse","Eclipse"],["github","Github"],["idle_fingers","Idle Fingers"],["kr_theme","krTheme"],["merbivore","Merbivore"],["merbivore_soft","Merbivore Soft"],["mono_industrial","Mono Industrial"],["monokai","Monokai"],["pastel_on_dark","Pastel on Dark"],["solarized_dark","Solarized Dark"],["solarized_light","Solatized Light"],["terminal","Terminal"],["textmate","TextMate"],["tomorrow","Tomorrow"],["tomorrow_night_blue","Tomorrow Night Blue"],["tomorrow_night_bright","Tomorrow Night Bright"],["tomorrow_night_eighties","Tomorrow Night 80s"],["tomorrow_night","Tomorrow Night"],["twilight","Twilight"],["vibrant_ink","Vibrant Ink"],["xcode","XCode"]]}),valueField:"themeValue",displayField:"themeName"}]}]};Ext.apply(b,a);return b}});Ext.define("SYNO.SDS.ACEEditor.PreferenceDialog.TabPanel",{extend:"SYNO.ux.TabPanel",viewFormPanel:null,editFormPanel:null,constructor:function(a){var b=this.fillConfig(a);this.callParent([b])},fillConfig:function(a){this.viewFormPanel=new SYNO.SDS.ACEEditor.PreferenceDialog.ViewFormPanel({editorSettings:a.editorSettings});this.editFormPanel=new SYNO.SDS.ACEEditor.PreferenceDialog.EditFormPanel({editorSettings:a.editorSettings});var b={activeTab:0,deferredRender:false,items:[this.viewFormPanel,this.editFormPanel]};Ext.apply(b,a);return b}});Ext.namespace("SYNO.SDS.ACEEditor");Ext.define("SYNO.SDS.ACEEditor.FindDialog",{extend:"SYNO.SDS.ModalWindow",constructor:function(a){this.parent=a.parent;this.owner=a.owner;var b=this.fillConfig(a);this.callParent([b])},fillConfig:function(a){var b={width:380,height:184,padding:"0px 20px",cls:"syno-sds-aceeditor-misc-dialog",title:_T("texteditor","Find"),layout:"column",resizable:false,buttons:false,useStatusBar:false,items:[{xtype:"syno_fieldset",layout:"vbox",width:218,items:[{xtype:"syno_textfield",id:this.findNeedleId=Ext.id(),value:a.previousNeedle,emptyText:_T("texteditor","SearchFor"),hideLabel:true,width:218,listeners:{afterrender:function(c){c.focus(true,300)}}},{xtype:"syno_checkbox",id:this.caseSensitiveId=Ext.id(),boxLabel:_T("texteditor","CaseSensitive"),name:"caseSensitive",margins:"5 0 0 0"},{xtype:"syno_checkbox",id:this.wholeWordSearchId=Ext.id(),boxLabel:_T("texteditor","WholeWordSearch"),name:"wholeWordSearch"},{xtype:"syno_checkbox",id:this.regExpId=Ext.id(),boxLabel:_T("texteditor","RegularExpression"),name:"regExp"}]},{xtype:"syno_fieldset",layout:"vbox",items:[{xtype:"syno_button",width:110,text:_T("texteditor","FindNext"),margins:"0 0 0 12",scope:this,handler:this.onFindNextClick},{xtype:"syno_button",width:110,text:_T("texteditor","FindPrevious"),margins:"10 0 0 12",scope:this,handler:this.onFindPreviousClick},{xtype:"syno_button",width:110,text:_T("common","close"),margins:"10 0 0 12",scope:this,handler:this.onCloseClick}]}]};if(Ext.isIE9){b.width++}Ext.apply(b,a);return b},onFindNextClick:function(){this.parent.find(Ext.getCmp(this.findNeedleId).value,{caseSensitive:Ext.getCmp(this.caseSensitiveId).checked,wholeWord:Ext.getCmp(this.wholeWordSearchId).checked,regExp:Ext.getCmp(this.regExpId).checked})},onFindPreviousClick:function(){this.parent.find(Ext.getCmp(this.findNeedleId).value,{caseSensitive:Ext.getCmp(this.caseSensitiveId).checked,wholeWord:Ext.getCmp(this.wholeWordSearchId).checked,regExp:Ext.getCmp(this.regExpId).checked,backwards:true})},onCloseClick:function(){this.owner.mainPanel.tabPanel.getActiveTab().editor.focus();this.close()}});Ext.define("SYNO.SDS.ACEEditor.ReplaceDialog",{extend:"SYNO.SDS.ModalWindow",constructor:function(a){this.parent=a.parent;this.owner=a.owner;var b=this.fillConfig(a);this.callParent([b])},fillConfig:function(a){var b={width:380,height:223,padding:"0px 20px",title:_T("texteditor","Replace"),cls:"syno-sds-aceeditor-misc-dialog",layout:"column",buttons:false,useStatusBar:false,resizable:false,items:[{xtype:"syno_fieldset",layout:"vbox",width:218,items:[{xtype:"syno_textfield",id:this.replaceNeedleId=Ext.id(),value:a.previousNeedle,emptyText:_T("texteditor","SearchFor"),hideLabel:true,width:218,listeners:{afterrender:function(c){c.focus(true,300)}}},{xtype:"syno_textfield",id:this.replaceWithId=Ext.id(),emptyText:_T("texteditor","ReplaceWith"),hideLabel:true,width:218,margins:"10 0 0 0"},{xtype:"syno_checkbox",id:this.caseSensitiveId=Ext.id(),boxLabel:_T("texteditor","CaseSensitive"),name:"caseSensitive",margins:"5 0 0 0"},{xtype:"syno_checkbox",id:this.wholeWordSearchId=Ext.id(),boxLabel:_T("texteditor","WholeWordSearch"),name:"wholeWordSearch"},{xtype:"syno_checkbox",id:this.regExpId=Ext.id(),boxLabel:_T("texteditor","RegularExpression"),name:"regExp"}]},{xtype:"syno_fieldset",layout:"vbox",items:[{xtype:"syno_button",width:110,text:_T("texteditor","Replace"),margins:"0 0 0 12",scope:this,handler:this.onReplaceClick},{xtype:"syno_button",width:110,text:_T("texteditor","ReplaceAll"),margins:"10 0 0 12",scope:this,handler:this.onReplaceAllClick},{xtype:"syno_button",width:110,text:_T("common","close"),margins:"10 0 0 12",scope:this,handler:this.onCloseClick}]}]};if(Ext.isIE9){b.width++}Ext.apply(b,a);return b},onReplaceClick:function(){this.parent.replace(Ext.getCmp(this.replaceNeedleId).value,Ext.getCmp(this.replaceWithId).value,{caseSensitive:Ext.getCmp(this.caseSensitiveId).checked,wholeWord:Ext.getCmp(this.wholeWordSearchId).checked,regExp:Ext.getCmp(this.regExpId).checked},false)},onReplaceAllClick:function(){this.parent.replace(Ext.getCmp(this.replaceNeedleId).value,Ext.getCmp(this.replaceWithId).value,{caseSensitive:Ext.getCmp(this.caseSensitiveId).checked,wholeWord:Ext.getCmp(this.wholeWordSearchId).checked,regExp:Ext.getCmp(this.regExpId).checked},true)},onCloseClick:function(){this.owner.mainPanel.tabPanel.getActiveTab().editor.focus();this.close()}});Ext.define("SYNO.SDS.ACEEditor.GoToLineDialog",{extend:"SYNO.SDS.ModalWindow",constructor:function(a){this.parent=a.parent;this.owner=a.owner;var b=this.fillConfig(a);this.callParent([b])},fillConfig:function(a){var b={width:235,height:125,padding:"0px 20px",title:_T("texteditor","GoToLine"),cls:"syno-sds-aceeditor-misc-dialog",resizable:false,items:[{xtype:"syno_formpanel",items:[{xtype:"syno_numberfield",name:"targetLineNumber",emptyText:_T("texteditor","LineNumber"),width:195,hideLabel:true,value:1,minValue:1,listeners:{afterrender:function(c){c.focus(false,300)}}}]}],buttons:[{xtype:"syno_button",text:_T("common","ok"),scope:this,handler:this.onOkClick},{xtype:"syno_button",text:_T("common","cancel"),scope:this,handler:this.onCancelClick}]};Ext.apply(b,a);return b},onOkClick:function(){var c=this.items.items[0].getForm().findField("targetLineNumber");if(!c.isValid()){return}var b=c.value;var a=this.parent.tabPanel.getActiveTab();a.goToLine(b);a.focusEditor();this.close()},onCancelClick:function(){this.owner.mainPanel.tabPanel.getActiveTab().editor.focus();this.close()}});Ext.namespace("SYNO.SDS.ACEEditor");Ext.define("SYNO.SDS.ACEEditor.Editor",{extend:"Ext.Panel",listeners:{resize:function(){this.resizeEditor()},activate:function(){this.focusEditor()}},constructor:function(a){this.owner=a.owner;var b=this.fillConfig(a);this.callParent([b])},fillConfig:function(a){this.addEvents({editorCreated:true,changeCursor:true});var b={layout:"fit",title:a.fileName,items:{html:"<pre>"+Ext.util.Format.htmlEncode(a.initValue)+"</pre>",border:false}};Ext.apply(b,a);return b},onRender:function(a){this.on("afterlayout",function(){var b=this;this.editorId=document.getElementById(this.items.keys[0]).children[0].children[0].id;this.editor=ace.edit(this.editorId);this.um=this.editor.getSession().$undoManager;this.editor.moveCursorTo(0,0);this.editor.setShowPrintMargin(false);this.setMode(this.fileMode);this.applyEditorSettings(this.editorSettings);this.fireEvent("editorCreated");this.editor.selection.on("changeCursor",function(c){b.fireEvent("changeCursor")});this.editor.on("input",function(){if(b.um.isClean()){b.setTitle(b.fileName)}else{b.setTitle("*"+b.fileName)}b.owner.updateWindowTitle(b)});this.mon(this.el,{click:function(c){c.stopPropagation()}})},this,{single:true});this.callParent(arguments)},applyEditorSettings:function(a){this.setShowLineNumber(a.showLineNumber);this.setShowInvisibles(a.showInvisibles);this.setShowIndentGuides(a.showIndentGuides);this.setHighlightCurrentLine(a.highlightCurrentLine);this.setHighlightSelectedWord(a.highlightSelectedWord);if(a.enableCodeFolding){this.setCodeFoldingMode(a.codeFoldingMode);this.setAutoHideFoldingWidget(a.autoHideFoldingWidget)}else{this.setCodeFoldingMode("manual")}switch(a.textWrappingMode){case"off":this.setTextWrapMode(false);break;case"free":this.setTextWrapMode(true);this.setWrapLimitRange(null,null);break;case"custom":this.setTextWrapMode(true);this.setWrapLimitRange(a.textWrappingColumnNumber,a.textWrappingColumnNumber);break}this.setEnableBehaviours(a.enableBehaviours);this.setInsertSpacesInsteadOfTabs(a.insertSpacesInsteadOfTabs);this.setTabWidth(a.tabWidth);this.setFontSize(a.fontSize);this.setTheme(a.theme)},getEditor:function(){return this.editor},getValue:function(){return this.editor.getSession().getValue()},setValue:function(a){this.editor.getSession().setValue(a)},setMode:function(a){this.editor.getSession().setMode("ace/mode/"+a)},setShowLineNumber:function(a){this.editor.renderer.setShowGutter(a)},setShowInvisibles:function(a){this.editor.setShowInvisibles(a)},setShowIndentGuides:function(a){this.editor.setDisplayIndentGuides(a)},setHighlightCurrentLine:function(a){this.editor.setHighlightActiveLine(a)},setHighlightSelectedWord:function(a){this.editor.setHighlightSelectedWord(a)},setCodeFoldingMode:function(a){this.editor.getSession().setFoldStyle(a)},setAutoHideFoldingWidget:function(a){this.editor.setFadeFoldWidgets(a)},setTextWrapMode:function(a){this.editor.getSession().setUseWrapMode(a)},setWrapLimitRange:function(b,a){this.editor.getSession().setWrapLimitRange(b,a)},setEnableBehaviours:function(a){this.editor.setBehavioursEnabled(a)},setInsertSpacesInsteadOfTabs:function(a){this.editor.getSession().setUseSoftTabs(a)},setTabWidth:function(a){this.editor.getSession().setTabSize(a)},setFontSize:function(a){this.editor.setFontSize(a)},setTheme:function(a){this.editor.setTheme("ace/theme/"+a)},undo:function(){this.editor.undo()},redo:function(){this.editor.redo()},selectAll:function(){this.editor.selectAll()},highlight:function(a){this.editor.getSession().highlight(a||this.editor.$search.$options.re);this.editor.renderer.updateBackMarkers()},find:function(d,b){var c={skipCurrent:true,backwards:false,wrap:true};Ext.apply(c,b);var a=this.editor.find(d,c);if(!a){this.owner.owner.getMsgBox().alert("",_T("texteditor","NoMatchedItem"))}else{this.highlight()}},replace:function(e,d,b,a){var c={backwards:false,wrap:true};Ext.apply(c,b);if(a){this.editor.findAll(e,c);this.editor.replaceAll(d)}else{this.editor.find(e,c);this.editor.replace(d)}},goToLine:function(a){if(!isNaN(parseInt(a,10))){this.editor.gotoLine(parseInt(a,10))}},resizeEditor:function(){if(this.editor){this.editor.resize(true)}},focusEditor:function(){if(this.editor){this.editor.resize();this.editor.focus()}this.fireEvent("focusEditor")}});Ext.namespace("SYNO.SDS.ACEEditor.Utils");Ext.apply(SYNO.SDS.ACEEditor.Utils,{className:"SYNO.SDS.ACEEditor.Application",guessMode:function(c){var a=c.split(".");var b=a.length>1?a.pop().toLowerCase():null;if(null!=b){if(SYNO.SDS.ACEEditor.Utils.TextFileExtensions.hasOwnProperty(b)){return SYNO.SDS.ACEEditor.Utils.TextFileExtensions[b]}else{return"plain_text"}}return"plain_text"},launchFn:function(a){var b=a[0].get("path");var c={path:b};SYNO.SDS.AppLaunch("SYNO.SDS.ACEEditor.Application",{fb_recs:c})},checkFn:function(b,a){if(Ext.isIE6||Ext.isIE7||Ext.isIE8){return false}if(a[0].data.isdir){return false}var c=a[0].get("filename").split(".");if(c.length==1){return true}return SYNO.SDS.ACEEditor.Utils.TextFileExtensions.hasOwnProperty(c.pop().toLowerCase())},getCodepageName:function(c){var a=SYNO.SDS.ACEEditor.Utils.getComboBoxCodepageList(true);for(var b=0;b<a.length;b++){if(a[b][0]===c){return a[b][1]}}return"Unknown"},getKeyMapConfig:function(a){return[{key:"123456789",ctrl:false,alt:true,shift:false,scope:a,fn:function(b,d){d.preventDefault();var c=(b-Ext.EventObject.ONE)%9;if(c>=this.tabPanel.items.items.length){return}this.tabPanel.setActiveTab(c)}},{key:[Ext.EventObject.NUM_ONE,Ext.EventObject.NUM_TWO,Ext.EventObject.NUM_THREE,Ext.EventObject.NUM_FOUR,Ext.EventObject.NUM_FIVE,Ext.EventObject.NUM_SIX,Ext.EventObject.NUM_SEVEN,Ext.EventObject.NUM_EIGHT,Ext.EventObject.NUM_NINE],ctrl:false,alt:true,shift:false,scope:a,fn:function(b,d){d.preventDefault();var c=(b-Ext.EventObject.NUM_ONE)%9;if(c>=this.tabPanel.items.items.length){return}this.tabPanel.setActiveTab(c)}},{key:"s",ctrl:true,alt:false,shift:true,scope:a,fn:function(b,c){c.preventDefault();if(Ext.getCmp(this.saveAsBtnId).disabled){return}this.saveFileAs(this.tabPanel.getActiveTab())}},{key:"s",ctrl:true,alt:false,shift:false,scope:a,fn:function(b,c){c.preventDefault();if(Ext.getCmp(this.saveBtnId).disabled){return}this.saveFile(this.tabPanel.getActiveTab())}},{key:"f",ctrl:true,alt:true,shift:false,scope:a,fn:function(b,c){c.preventDefault();if(Ext.getCmp(this.findBtnId).disabled){return}this.openFindDialog()}},{key:"h",ctrl:true,alt:true,shift:false,scope:a,fn:function(b,c){c.preventDefault();if(Ext.getCmp(this.replaceBtnId).disabled){return}this.openReplaceDialog()}},{key:"o",ctrl:true,alt:true,shift:false,scope:a,fn:function(b,c){c.preventDefault();this.openFile()}},{key:"n",ctrl:true,alt:true,shift:false,scope:a,fn:function(b,c){c.preventDefault();this.newFile()}},{key:"q",ctrl:true,alt:false,shift:false,scope:a,fn:function(b,c){c.preventDefault();if(Ext.getCmp(this.closeBtnId).disabled){return}this.closeFile()}}]},getComboBoxCodepageList:function(b){var a=[["BIG5",_T("texteditor","chinese_traditional")+" (BIG5)"],["BIG5-HKSCS",_T("texteditor","chinese_traditional")+" (BIG5-HKSCS)"],["GBK",_T("texteditor","chinese_simplified")+" (GBK)"],["GB18030",_T("texteditor","chinese_simplified")+" (GB18030)"],["EUC-JP",_T("texteditor","japanese")+" (EUC-JP)"],["SHIFT_JIS",_T("texteditor","japanese")+" (SHIFT_JIS)"],["ISO-2022-JP",_T("texteditor","japanese")+" (ISO-2022-JP)"],["EUC-KR",_T("texteditor","korean")+" (EUC-KR)"],["CP949",_T("texteditor","korean")+" (CP949)"],["CP1258",_T("texteditor","vietnamese")+" (CP1258)"],["VISCII",_T("texteditor","vietnamese")+" (VISCII)"],["TIS-620",_T("texteditor","thai")+" (TIS-620)"],["ISO-8859-11",_T("texteditor","thai")+" (ISO-8859-11)"],["ISO-8859-2",_T("texteditor","central_european")+" (ISO-8859-2)"],["CP1250",_T("texteditor","central_european")+" (CP1250)"],["ISO-8859-10",_T("texteditor","nordic")+" (ISO-8859-10)"],["ISO-8859-1",_T("texteditor","western")+" (ISO-8859-1)"],["ISO-8859-15",_T("texteditor","western")+" (ISO-8859-15)"],["CP1252",_T("texteditor","western")+" (CP1252)"],["Macintosh",_T("texteditor","western")+" (Macintosh)"],["CP1254",_T("texteditor","turkish")+" (CP1254)"],["CP1255",_T("texteditor","hebrew")+" (CP1255)"],["ISO-8859-8",_T("texteditor","hebrew")+" (ISO-8859-8)"],["ISO-8859-7",_T("texteditor","greek")+" (ISO-8859-7)"],["CP1253",_T("texteditor","greek")+" (CP1253)"],["CP1256",_T("texteditor","arabic")+" (CP1256)"],["ISO-8859-6",_T("texteditor","arabic")+" (ISO-8859-6)"],["ISO-8859-4",_T("texteditor","baltic")+" (ISO-8859-4)"],["ISO-8859-13",_T("texteditor","baltic")+" (ISO-8859-13)"],["CP1257",_T("texteditor","baltic")+" (CP1257)"],["ISO-8859-3",_T("texteditor","south_european")+" (ISO-8859-3)"],["ISO-8859-5",_T("texteditor","cyrillic")+" (ISO-8859-5)"],["CP1251",_T("texteditor","cyrillic")+" (CP1251)"],["KOI8-R",_T("texteditor","cyrillic")+" (KOI8-R)"],["KOI8-U",_T("texteditor","cyrillic")+" (KOI8-U)"],["ISO-8859-14",_T("texteditor","celtic")+" (ISO-8859-14)"],["ISO-8859-16",_T("texteditor","romanian")+" (ISO-8859-16)"],["ARMSCII-8",_T("texteditor","armenian")+" (ARMSCII-8)"],["Georgian-Academy",_T("texteditor","georgian")+" (Georgian-Academy)"],["KOI8-T",_T("texteditor","tajik")+" (KOI8-T)"],["CP1133",_T("texteditor","laotian")+" (CP1133)"],["PT154",_T("texteditor","kazakh")+" (PT154)"]];a.sort(function(d,c){return d[1].localeCompare(c[1])});a.unshift(["UTF-16",_T("texteditor","unicode")+" (UTF-16)"]);a.unshift(["UTF-8_withBOM",_T("texteditor","unicode")+" (UTF-8 with BOM)"]);a.unshift(["UTF-8",_T("texteditor","unicode")+" (UTF-8)"]);if(b){a.unshift(["auto",_T("texteditor","AutoDetect")])}return a},TextFileExtensions:{abap:"abap",as:"actionsctipt",ada:"ada",s:"assembly_x86",ahk:"autohotkey",bat:"batchfile",c:"c_cpp",cpp:"c_cpp",clj:"clojure",edn:"clojure",cbl:"cobol",coffee:"coffee",cfm:"coldfusion",cs:"csharp",css:"css",d:"d",dart:"dart",diff:"diff",dot:"dot",ejs:"ejs",erl:"erlang",f:"forth",fth:"forth",forth:"forth",ftl:"ftl",glsl:"glsl",go:"golang",groovy:"groovy",haml:"haml",handlebars:"handlebars",hs:"haskell",hx:"haxe",ht3:"html",htm:"html",html:"html",htmls:"html",ini:"ini",jack:"jack",jade:"jade",java:"java",js:"javascript",json:"json",jsp:"jsp",jsx:"jsx",jl:"julia",latex:"latex",less:"less",liquid:"liquid",lisp:"lisp",ls:"livescript",lsl:"lsl",lua:"lua",mk:"makefile",markdown:"markdown",m:"matlab",mysql:"mysql",nix:"nix",ocaml:"ocaml",pascal:"pascal",perl:"perl",php:"php",txt:"plain_text",pl:"prolog",py:"python",r:"r",rhtml:"rhtml",rb:"ruby",rbw:"ruby",rs:"rust",sass:"sass",scad:"scad",scala:"scala",scm:"scheme",ss:"scheme",scss:"scss",sh:"sh",sjs:"sjs",sql:"sql",styl:"stylus",svg:"svg",tcl:"tcl",tex:"tex",textile:"textile",vb:"vbscript",v:"verilog",vhdl:"vhdl",xml:"xml",xq:"xquery",xqy:"xquery",xquery:"xquery",yml:"yaml",yaml:"yaml","!!!":"plain_text","$00":"plain_text","$01":"plain_text","$02":"plain_text","$04":"plain_text","$05":"plain_text","$o1":"plain_text","$ol":"plain_text","001":"plain_text","12da":"plain_text","1st":"plain_text","7":"plain_text","82t":"plain_text","92t":"plain_text",abl:"plain_text",ac:"plain_text",adiumhtmllog:"plain_text",adiumlog:"plain_text",adl:"plain_text",adt:"plain_text",adw:"plain_text",aiml:"plain_text",alx:"plain_text",aml:"plain_text",android:"plain_text",annot:"plain_text",ans:"plain_text",ansi:"plain_text",application:"plain_text",aprj:"plain_text",apx:"plain_text",aqt:"plain_text",arff:"plain_text",ARTask:"plain_text",asc:"plain_text",ascii:"plain_text",asl:"plain_text",asp:"plain_text",ass:"plain_text",assoc:"plain_text",atc:"plain_text",att:"plain_text",awa:"plain_text",awb:"plain_text",awd:"plain_text",awh:"plain_text",awp:"plain_text",axt:"plain_text",ba1:"plain_text",bad:"plain_text",bas:"plain_text",bbs:"plain_text",bbxt:"plain_text",bcr:"plain_text",bdp:"plain_text",bdr:"plain_text",bea:"plain_text",bel:"plain_text",bep:"plain_text",big:"plain_text",big5:"plain_text",bk:"plain_text",blm:"plain_text",bln:"plain_text",blw:"plain_text",bmtp:"plain_text",bna:"plain_text",bnx:"plain_text",bog:"plain_text",box:"plain_text",bpdx:"plain_text",brf:"plain_text",bsdl:"plain_text",bss:"plain_text",bt:"plain_text",bzw:"plain_text",cag:"plain_text",cas:"plain_text",cascii:"plain_text",cc:"plain_text",cd2:"plain_text",charset:"plain_text",cho:"plain_text",chord:"plain_text",cif:"plain_text",cil:"plain_text",ckn:"plain_text",clg:"plain_text",cli:"plain_text",clix:"plain_text",cmd:"plain_text",cmtx:"plain_text",cof:"plain_text",conf:"plain_text",coo:"plain_text",crash:"plain_text",crd:"plain_text",csassembly:"plain_text",csmanifest:"plain_text",csv:"plain_text",ctd:"plain_text",ctf:"plain_text",ctl:"plain_text",ctx:"plain_text",dat:"plain_text",dcd:"plain_text",dce:"plain_text",ddd:"plain_text",ddt:"plain_text",de:"plain_text",dectest:"plain_text",des:"plain_text",desc:"plain_text",dfe:"plain_text",dfm:"plain_text",dii:"plain_text",diskdefines:"plain_text",diz:"plain_text",dk:"plain_text",dkz:"plain_text",dmr:"plain_text",dne:"plain_text",dok:"plain_text",dp:"plain_text",dpv:"plain_text",dqy:"plain_text",drp:"plain_text",dsc:"plain_text",dsml:"plain_text",dtd:"plain_text",dwl:"plain_text",ecsv:"plain_text",edml:"plain_text",edt:"plain_text",efm:"plain_text",eia:"plain_text",emulecollection:"plain_text",en:"plain_text",enc:"plain_text",enf:"plain_text",eng:"plain_text",err:"plain_text",es:"plain_text",esw:"plain_text",etf:"plain_text",etx:"plain_text",euc:"plain_text",ext:"plain_text",extra:"plain_text",faq:"plain_text",fff:"plain_text",ffp:"plain_text",fin:"plain_text",first:"plain_text",flr:"plain_text",fmr:"plain_text",fnx:"plain_text",fon:"plain_text",fr:"plain_text",fra:"plain_text",frm:"plain_text",fsa:"plain_text",full:"plain_text",gbf:"plain_text",gdt:"plain_text",gen:"plain_text",ger:"plain_text",gnu:"plain_text",gpl:"plain_text",gs:"plain_text",gthr:"plain_text",gtx:"plain_text",guide:"plain_text",hdr:"plain_text",hhc:"plain_text",hhs:"plain_text",hlm:"plain_text",hlx:"plain_text",hp8:"plain_text",hsk:"plain_text",htx:"plain_text",hvc:"plain_text",hwl:"plain_text",hz:"plain_text",id31:"plain_text",id32:"plain_text",idc:"plain_text",idt:"plain_text",idx:"plain_text",iem:"plain_text",igv:"plain_text",igy:"plain_text",iif:"plain_text",ill:"plain_text",inc:"plain_text",inuse:"plain_text",ion:"plain_text",ipr:"plain_text",iqy:"plain_text",isr:"plain_text",it:"plain_text",ivp:"plain_text",ja:"plain_text",jad:"plain_text",jam:"plain_text",jeb:"plain_text",jis:"plain_text",jp1:"plain_text",jss:"plain_text",jtx:"plain_text",kahl:"plain_text",kar:"plain_text",kch:"plain_text",kix:"plain_text",klg:"plain_text",kor:"plain_text",la:"plain_text",label:"plain_text",las:"plain_text",lay:"plain_text",lin:"plain_text",linux:"plain_text",linx:"plain_text",lnc:"plain_text",log:"plain_text",lo_:"plain_text",lrc:"plain_text",lst:"plain_text",ltr:"plain_text",ltt:"plain_text",ltx:"plain_text",lue:"plain_text",luf:"plain_text",lwd:"plain_text",lxfml:"plain_text",lyr:"plain_text",lyt:"plain_text",man:"plain_text",manifest:"plain_text",map:"plain_text",mar:"plain_text",mathml:"plain_text",maxFR:"plain_text",mcw:"plain_text",md:"plain_text",mdl:"plain_text",mdle:"plain_text",mdown:"plain_text",mdtext:"plain_text",mdtxt:"plain_text",mdwn:"plain_text",me:"plain_text",mez:"plain_text",mf:"plain_text",mib:"plain_text",mit:"plain_text",mkd:"plain_text",mkdn:"plain_text",mno:"plain_text",mnu:"plain_text",modd:"plain_text",mpsub:"plain_text",mss:"plain_text",mtx:"plain_text",mtxt:"plain_text",mvg:"plain_text",mw:"plain_text",nbr:"plain_text",nclk:"plain_text",ncm:"plain_text","new":"plain_text",nfo:"plain_text",nlc:"plain_text",nmbd:"plain_text",nokogiri:"plain_text",not:"plain_text",notes:"plain_text",now:"plain_text",npdt:"plain_text",nt:"plain_text",nwctxt:"plain_text",ocr:"plain_text",odc:"plain_text",oh:"plain_text",ojp:"plain_text",omn:"plain_text",oogl:"plain_text",oot:"plain_text",opc:"plain_text",openbsd:"plain_text",opml:"plain_text",ort:"plain_text",osi:"plain_text",p3x:"plain_text",panic:"plain_text",pbd:"plain_text",pc5:"plain_text",pcl:"plain_text",pd:"plain_text",pdu:"plain_text",pfs:"plain_text",pgw:"plain_text",pjs:"plain_text",pla:"plain_text",plf:"plain_text",plg:"plain_text",plist:"plain_text",plk:"plain_text",pln:"plain_text",pml:"plain_text",pmo:"plain_text",pod:"plain_text",prc:"plain_text",prn:"plain_text",pro:"plain_text",prr:"plain_text",ps:"plain_text",psb:"plain_text",psi2:"plain_text",pt3:"plain_text",pts:"plain_text",pvj:"plain_text",pvw:"plain_text","q&a":"plain_text",qdt:"plain_text",qud:"plain_text",rbdf:"plain_text",rdf:"plain_text",rea:"plain_text",readme:"plain_text",reg:"plain_text",rel:"plain_text",rep:"plain_text",resp:"plain_text",rest:"plain_text",rff:"plain_text",ris:"plain_text",rml:"plain_text",rqy:"plain_text",rst:"plain_text",rt:"plain_text",rtf:"plain_text",rtl:"plain_text",rtx:"plain_text",ru:"plain_text",rus:"plain_text",rzk:"plain_text",rzn:"plain_text",s19:"plain_text",s2k:"plain_text",sami:"plain_text",sbv:"plain_text",sct:"plain_text",sdnf:"plain_text",sen:"plain_text",seq:"plain_text",set:"plain_text",sfb:"plain_text",sgp:"plain_text",sha1:"plain_text",sha512:"plain_text",skcard:"plain_text",skv:"plain_text",sls:"plain_text",smali:"plain_text",smf:"plain_text",smi:"plain_text",sms:"plain_text",snw:"plain_text",soap:"plain_text",soundscript:"plain_text",spa:"plain_text",spec:"plain_text",spg:"plain_text",spn:"plain_text",spx:"plain_text",srt:"plain_text",srx:"plain_text",ssa:"plain_text",ssf:"plain_text",st1:"plain_text",stf:"plain_text",stq:"plain_text",strings:"plain_text",sub:"plain_text",syn:"plain_text",t:"plain_text",t2t:"plain_text",tab:"plain_text",tbd:"plain_text",tbl:"plain_text",tbx:"plain_text",tce:"plain_text",tcm:"plain_text",tdf:"plain_text",ted:"plain_text",text:"plain_text",textclipping:"plain_text",tfw:"plain_text",tgf:"plain_text",thml:"plain_text",thp:"plain_text",tlb:"plain_text",tle:"plain_text",tlx:"plain_text",tm:"plain_text",tml:"plain_text",tmprtf:"plain_text",tmx:"plain_text",tnef:"plain_text",tph:"plain_text",tpl:"plain_text",trn:"plain_text",trt:"plain_text",tsv:"plain_text",tt:"plain_text",ttbl:"plain_text",tte:"plain_text",ttf:"plain_text",ttpl:"plain_text",ttxt:"plain_text",tx8:"plain_text","tx?":"plain_text",txa:"plain_text",txd:"plain_text",txe:"plain_text",txh:"plain_text",u3i:"plain_text",uax:"plain_text",uhtml:"plain_text",uk:"plain_text",unauth:"plain_text",uni:"plain_text",unx:"plain_text",us:"plain_text",usa:"plain_text",user:"plain_text",usf:"plain_text",usg:"plain_text",utf8:"plain_text",utx:"plain_text",utxt:"plain_text",ver:"plain_text",vet:"plain_text",vfk:"plain_text",vhd:"plain_text",vis:"plain_text",vkp:"plain_text",vmg:"plain_text",vmsg:"plain_text",vna:"plain_text",vsmproj:"plain_text",vw:"plain_text",vw3:"plain_text",vxml:"plain_text",wer:"plain_text",wir:"plain_text",wkf:"plain_text",wn:"plain_text",wrd:"plain_text",wrl:"plain_text",wsc:"plain_text",wst:"plain_text",wtf:"plain_text",wtl:"plain_text",wtx:"plain_text",x20:"plain_text",x60:"plain_text",x70:"plain_text",x80:"plain_text",x90:"plain_text",xb0:"plain_text",xc0:"plain_text",xct:"plain_text",xd0:"plain_text",xdl:"plain_text",xdp:"plain_text",xfd:"plain_text",xff:"plain_text",xhtm:"plain_text",xlf:"plain_text",xsd:"plain_text",xsl:"plain_text",xslt:"plain_text",xsr:"plain_text",xwp:"plain_text",xy:"plain_text",xy3:"plain_text",xyp:"plain_text",xyw:"plain_text",xyz:"plain_text",zanebug:"plain_text",zed:"plain_text",zhp:"plain_text",zib:"plain_text",zw:"plain_text",zxe:"plain_text",_me:"plain_text"}});Ext.namespace("SYNO.SDS.ACEEditor");Ext.define("SYNO.SDS.ACEEditor.Application",{extend:"SYNO.SDS.AppInstance",appWindowName:"SYNO.SDS.ACEEditor.MainWindow"});Ext.define("SYNO.SDS.ACEEditor.MainWindow",{extend:"SYNO.SDS.AppWindow",dsmStyle:"v5",constructor:function(a){this.appInstance=a.appInstance;var b=this.fillConfig(a);this.callParent([b]);this.mon(SYNO.SDS.StatusNotifier,"beforeunload",function(){if(Ext.isDefined(this.mainPanel)){return !this.mainPanel.isAnyFileDirty()}return true},this)},fillConfig:function(a){this.mainPanel=new SYNO.SDS.ACEEditor.MainPanel({owner:this});var b={layout:"fit",width:800,minWidth:350,height:400,minHeight:200,cls:"syno-sds-aceeditor-window",forceClose:false,isClosing:false,isChaining:false,items:[this.mainPanel],keys:SYNO.SDS.ACEEditor.Utils.getKeyMapConfig(this.mainPanel),listeners:{scope:this,beforeclose:this.onBeforeClose}};Ext.apply(b,a);return b},onRender:function(){SYNO.SDS.ACEEditor.MainWindow.superclass.onRender.apply(this,arguments);this.mon(this.el,{click:function(){this.focus()},scope:this})},onOpen:function(a){SYNO.SDS.ACEEditor.MainWindow.superclass.onOpen.apply(this,arguments);this.sendWebAPI({api:"SYNO.ACEEditor.Preference",method:"get",version:1,scope:this,callback:function(c,b){if(!c){this.getMsgBox().alert("",_T("texteditor","LoadPreferenceFail"),function(){this.close()},this);return}if("Unknown"===SYNO.SDS.ACEEditor.Utils.getCodepageName(b.defaultCodepage)){b.defaultCodepage="auto"}this.mainPanel.editorSettings=b;Ext.getCmp(this.mainPanel.preferencesBtnId).enable();this.onRequest.call(this,a)}})},onRequest:function(e){var c,h,g,d,f,a;SYNO.SDS.ACEEditor.MainWindow.superclass.onRequest.apply(this,arguments);if(!Ext.isObject(e)){return}if(true===e.simple_viewer&&Ext.isString(e.text)&&Ext.isString(e.filename)){this.mainPanel.addEditorTab(null,e.filename,"plain_text","UTF-8",e.text);a=this.mainPanel.tabPanel.activeTab;a.getEditor().setReadOnly(true);a.addListener("activate",function(){this.mainPanel.setDisableEditorButtons(true)},this);a.addListener("deactivate",function(){this.mainPanel.setDisableEditorButtons(false)},this);this.mainPanel.setDisableEditorButtons(true);return}if(Ext.isEmpty(e.fb_recs)){return}c=e.fb_recs.path;h=this.mainPanel.editorSettings.defaultCodepage;g=Ext.util.Format.htmlEncode(c.split("/").pop());d=SYNO.SDS.ACEEditor.Utils.guessMode(g);f=this.mainPanel.tabPanel;for(var b=0;b<f.items.length;b++){if(c==f.items.items[b].filePath){f.setActiveTab(b);return}}this.getEl().mask(_T("common","msg_waiting"),"x-mask-loading");this.sendWebAPI({api:"SYNO.Core.File",version:1,method:"load",params:{file_path:c,codepage:h},scope:this,callback:function(i,j,k){if(!i){this.getEl().unmask();if(5606===j.code){this.getMsgBox().alert("",String.format(_T("texteditor","CodepageConvertFail"),g))}else{this.getMsgBox().alert("",SYNO.API.Erros.core[j.code]||_T("common","commfail"))}return}this.mainPanel.addEditorTab(c,g,d,k.codepage==="auto"?j.detect_codepage:k.codepage,SYNO.Util.Base64.decode(j.file_content));this.getEl().unmask()}})},onDestroy:function(){var a=this.mainPanel.dropZone;a.removeFromGroup(a.ddGroup)},onBeforeClose:function(){if(this.forceClose){return true}else{this.mainPanel.stepCloseChain(true);return false}}});Ext.define("SYNO.SDS.ACEEditor.MainPanel",{extend:"Ext.Panel",constructor:function(a){this.owner=a.owner;var b=this.fillConfig(a);this.callParent([b])},initEvents:function(){this.on("afterrender",function(){this.dropZone=new Ext.dd.DropZone(this.body,{ddGroup:"SDSShortCut",onContainerDrop:this.onContainerDrop.createDelegate(this,[],true),onContainerOver:function(c,b,a){c.getProxy().getGhost().update(_T("texteditor","OpenWithTextEditor"));return"x-dd-drop-ok-add"}})},this,{single:true});this.callParent(arguments)},fillConfig:function(a){this.codepageMenu=new SYNO.ux.Menu({items:this.getCodepageMenuItems()});this.topToolBar=new Ext.Toolbar({items:[{xtype:"syno_button",text:_T("texteditor","File"),menu:{items:[{text:_T("texteditor","New"),scope:this,handler:this.newFile},{text:_T("texteditor","Open"),scope:this,handler:this.openFile},{text:_T("texteditor","OpenCodepage"),id:this.codepageMenuId=Ext.id(),hideOnClick:false,disabled:true,menu:this.codepageMenu},{xtype:"menuseparator"},{text:_T("texteditor","Save"),scope:this,id:this.saveBtnId=Ext.id(),handler:function(){this.saveFile(this.tabPanel.getActiveTab())},disabled:true},{text:_T("texteditor","SaveAs"),scope:this,id:this.saveAsBtnId=Ext.id(),handler:function(){this.saveFileAs(this.tabPanel.getActiveTab())},disabled:true},{text:_T("texteditor","SaveAll"),scope:this,id:this.saveAllBtnId=Ext.id(),handler:this.saveAll,disabled:true},{xtype:"menuseparator"},{text:_T("common","close"),scope:this,id:this.closeBtnId=Ext.id(),handler:this.closeFile,disabled:true}]}},{xtype:"syno_button",text:_T("texteditor","Edit"),menu:{items:[{text:_T("texteditor","Undo"),scope:this,id:this.undoBtnId=Ext.id(),handler:this.undo,disabled:true},{text:_T("texteditor","Redo"),scope:this,id:this.redoBtnId=Ext.id(),handler:this.redo,disabled:true},{xtype:"menuseparator"},{text:_T("texteditor","SelectAll"),scope:this,id:this.selectAllBtnId=Ext.id(),handler:this.selectAll,disabled:true},{xtype:"menuseparator"},{text:_T("texteditor","lang_tool"),id:this.langToolBtnId=Ext.id(),hideOnClick:false,disabled:true,menu:{xtype:"syno_menu",items:[{text:_T("texteditor","cht_chs"),handler:this.translateText.createDelegate(this,["cht","chs"])},{text:_T("texteditor","chs_cht"),handler:this.translateText.createDelegate(this,["chs","cht"])}]}}]}},{xtype:"syno_button",text:_T("texteditor","Search"),menu:{items:[{text:_T("texteditor","Find"),scope:this,id:this.findBtnId=Ext.id(),handler:this.openFindDialog,disabled:true},{text:_T("texteditor","Replace"),scope:this,id:this.replaceBtnId=Ext.id(),handler:this.openReplaceDialog,disabled:true},{xtype:"menuseparator"},{text:_T("texteditor","GoToLine"),scope:this,id:this.goToLineBtnId=Ext.id(),handler:this.goToLine,disabled:true}]}},{xtype:"syno_button",scope:this,text:_T("texteditor","Preferences"),id:this.preferencesBtnId=Ext.id(),handler:this.preferences,disabled:true}]});this.codepageStatus=new Ext.Toolbar.TextItem({cls:"syno-sds-aceeditor-codepage-status",text:""});this.cursorStatus=new Ext.Toolbar.TextItem({cls:"syno-sds-aceeditor-cursor-status",text:_T("texteditor","NoDocument")});this.selectHighlightMode=new SYNO.ux.ComboBox({width:120,disabled:true,store:new Ext.data.ArrayStore({fields:["name","value"],data:[["ABAP","abap"],["ADA","ada"],["ActionScript","actionscript"],["AsciiDoc","asciidoc"],["Assembly_x86","assembly_x86"],["AutoHotKey","autohotkey"],["BatchFile","batchfile"],["C9Search","c9search"],["C/C++","c_cpp"],["Clojure","clojure"],["Cobol","cobol"],["CoffeeScript","coffee"],["ColdFusion","coldfusion"],["C#","csharp"],["CSS","css"],["Curly","curly"],["D","d"],["Dart","dart"],["Diff","diff"],["Dot","dot"],["Erlang","erlang"],["EJS","ejs"],["Forth","forth"],["FreeMarker","ftl"],["Glsl","glsl"],["Go","golang"],["Groovy","groovy"],["HAML","haml"],["Haskell","haskell"],["haXe","haxe"],["HTML","html"],["HTML (Ruby)","html_ruby"],["Ini","ini"],["Jade","jade"],["Java","java"],["JavaScript","javascript"],["JSON","json"],["JSONiq","jsoniq"],["JSP","jsp"],["JSX","jsx"],["Julia","julia"],["LaTeX","latex"],["LESS","less"],["Liquid","liquid"],["Lisp","lisp"],["LiveScript","livescript"],["LogiQL","logiql"],["LSL","lsl"],["Lua","lua"],["LuaPage","luapage"],["Lucene","lucene"],["Makefile","makefile"],["MATLAB","matlab"],["Markdown","markdown"],["MySQL","mysql"],["MUSHCode","mushcode"],["Objective-C","objectivec"],["OCaml","ocaml"],["Pascal","pascal"],["Perl","perl"],["pgSQL","pgsql"],["PHP","php"],["Powershell","powershell"],["Prolog","prolog"],["Properties","properties"],["Python","python"],["R","r"],["RDoc","rdoc"],["RHTML","rhtml"],["Ruby","ruby"],["Rust","rust"],["SASS","sass"],["SCAD","scad"],["Scala","scala"],["Scheme","scheme"],["SCSS","scss"],["SH","sh"],["snippets","snippets"],["SQL","sql"],["Stylus","stylus"],["SVG","svg"],["Tcl","tcl"],["Tex","tex"],["Text","plain_text"],["Textile","textile"],["Toml","toml"],["Twig","twig"],["Typescript","typescript"],["VBScript","vbscript"],["Velocity","velocity"],["XML","xml"],["XQuery","xquery"],["YAML","yaml"]]}),valueField:"value",displayField:"name",listeners:{scope:this,select:this.onSelectHighlightMode}});this.bottomToolBar=new Ext.Toolbar({items:["->",this.codepageStatus.hide(),this.cursorStatus,this.selectHighlightMode]});this.tabPanel=new SYNO.ux.TabPanel({enableTabScroll:true,listeners:{afterrender:function(){this.header.setVisibilityMode(Ext.Element.DISPLAY).hide()}}});var b={layout:"fit",lastPreventTimeout:0,cls:"syno-sds-aceeditor-main-panel",tbar:this.topToolBar,bbar:this.bottomToolBar,items:[this.tabPanel]};Ext.apply(b,a);return b},getCodepageMenuItems:function(){var b=[],a=SYNO.SDS.ACEEditor.Utils.getComboBoxCodepageList();for(var c=0;c<a.length;c++){b.push({value:a[c][0],text:a[c][1],checked:false,group:"codepage",listeners:{scope:this,checkchange:this.onCodepageMenuCheck}})}return b},translateText:function(d,c){var a=this.tabPanel.getActiveTab().editor;if(Ext.isEmpty(a.getSelectedText())){this.selectAll()}var b=a.getSelectedText();this.owner.getEl().mask(_T("common","msg_waiting"),"x-mask-loading");this.sendWebAPI({api:"SYNO.ACEEditor",method:"translate",version:1,params:{from:d,to:c,source:SYNO.Util.Base64.encode(b),},scope:this,callback:function(e,f){this.owner.getEl().unmask();if(!e){this.owner.getMsgBox().alert("",_T("error","error_error_system"))}else{var g=this.tabPanel.getActiveTab().editor;g.insert(SYNO.Util.Base64.decode(f.result));g.focus()}}})},onCodepageMenuCheck:function(c,b){if(!b){return}var a=this.tabPanel.getActiveTab();if(null==a.filePath){a.codepage=c.value;this.updateLangTool(a.codepage);this.updateStatusBar(a)}else{if(!a.um.isClean()){this.owner.getMsgBox().confirm("",_T("texteditor","AskReloadModifiedFile"),function(d){if("yes"!==d){this.codepageMenu.find("value",a.codepage)[0].setChecked(true,true);return}this.codepageMenu.find("value",c.value)[0].setChecked(true,true);a.codepage=c.value;this.reloadValue(a,c.value)},this)}else{this.codepageMenu.find("value",c.value)[0].setChecked(true,true);a.codepage=c.value;this.reloadValue(a,c.value)}}},reloadValue:function(a,c){var b=a.fileName;this.owner.getEl().mask(_T("common","msg_waiting"),"x-mask-loading");this.sendWebAPI({api:"SYNO.Core.File",version:1,method:"load",params:{file_path:a.filePath,codepage:c},scope:this,callback:function(d,e,g){if(!d){this.owner.getEl().unmask();if(5606===e.code){this.owner.getMsgBox().alert("",String.format(_T("texteditor","CodepageConvertFail"),b))}else{this.owner.getMsgBox().alert("",SYNO.API.Erros.core[e.code]||_T("common","commfail"))}return}var f=this.tabPanel.getActiveTab();f.setValue(SYNO.Util.Base64.decode(e.file_content));this.updateStatusBar(f);this.updateLangTool(f.codepage);this.owner.getEl().unmask()}})},addEditorTab:function(a,e,c,d,b){this.preventTimeout();this.tabPanel.add(new SYNO.SDS.ACEEditor.Editor({owner:this,closable:true,filePath:a,fileName:e,fileMode:c,codepage:d,initValue:b,editorSettings:this.editorSettings,listeners:{scope:this,focusEditor:this.onFocusEditor,changeCursor:this.onChangeCursor,editorCreated:this.onEditorCreated,beforeclose:this.beforeTabClose,close:this.onTabDestroyed}})).show()},newFile:function(){this.addEditorTab(null,_T("texteditor","NewDocument")+".txt","plain_text","UTF-8","",false)},openFile:function(){var a=new SYNO.SDS.Utils.FileChooser.Chooser({owner:this.owner,usage:{type:"open",},title:_T("texteditor","Open"),height:500,enumGluster:true,enumSnapshot:true,folderToolbar:false,comboOption:[{label:_T("texteditor","FileType"),value:"allText",data:[["allText",_T("texteditor","AllTextFile")],["all",_T("texteditor","AllFile")]]},{label:_T("texteditor","Codepage"),value:this.editorSettings.defaultCodepage,data:SYNO.SDS.ACEEditor.Utils.getComboBoxCodepageList(true)}],getFilterPattern:function(b){if("allText"===b[0].value){var c=[];for(var d in SYNO.SDS.ACEEditor.Utils.TextFileExtensions){c.push(d)}return c.join()}return""},listeners:{scope:this,choose:function(g,b,f){var d=b.path;var j=f[1];for(var c=0;c<this.tabPanel.items.length;c++){if(d==this.tabPanel.items.items[c].filePath){g.close();this.tabPanel.setActiveTab(c);this.tabPanel.getActiveTab().editor.focus();return}}var h=Ext.util.Format.htmlEncode(d.split("/").pop());var e=SYNO.SDS.ACEEditor.Utils.guessMode(h);this.owner.focus();g.close();this.owner.getEl().mask(_T("common","msg_waiting"),"x-mask-loading");this.sendWebAPI({api:"SYNO.Core.File",version:1,method:"load",params:{file_path:b.path,codepage:j},scope:this,callback:function(i,k,l){if(!i){this.owner.getEl().unmask();if(5606===k.code){this.owner.getMsgBox().alert("",String.format(_T("texteditor","CodepageConvertFail"),h))}else{this.owner.getMsgBox().alert("",SYNO.API.Erros.core[k.code]||_T("common","commfail"))}return}this.addEditorTab(d,h,e,l.codepage==="auto"?k.detect_codepage:l.codepage,SYNO.Util.Base64.decode(k.file_content));this.owner.getEl().unmask()}})},close:function(){this.owner.focus()}}}).show()},sendSaveRequest:function(a,c,b){this.owner.getEl().mask(_T("common","msg_waiting"),"x-mask-loading");this.sendWebAPI({api:"SYNO.Core.File",version:1,method:"save",params:c,isSaveAs:b,editor:a,callback:function(d,g,f,i){var k=i.editor;k.owner.owner.getEl().unmask();if(d){k.codepage=f.codepage;if(i.isSaveAs){var e=f.file_path;var h=Ext.util.Format.htmlEncode(e.split("/").pop());var l=SYNO.SDS.ACEEditor.Utils.guessMode(h);k.filePath=e;k.fileName=h;k.setMode(l);k.setTitle(h);k.um.markClean();k.owner.selectHighlightMode.setValue(l);k.owner.updateWindowTitle(k);k.owner.updateLangTool(k.codepage);k.owner.codepageMenu.find("value",f.codepage)[0].setChecked(true,true);k.owner.updateStatusBar(k)}else{k.setTitle(k.fileName);k.um.markClean();k.owner.updateWindowTitle(k)}if(k.owner.owner.isClosing){if(k.owner.owner.isChaining){k.owner.stepCloseChain()}else{k.owner.closeFile(k);k.owner.owner.isClosing=false}}SYNO.SDS.StatusNotifier.fireEvent("filechanged",[k.filePath.substr(0,k.filePath.lastIndexOf("/"))],true)}else{switch(g.code){case 5607:function j(m,s,n,p,o,r,q){if("yes"!==m){return}this.sendSaveRequest(o,Ext.apply(r,{force_save:true}),q)}k.owner.owner.getMsgBox().confirm("",SYNO.API.Erros.core[g.code]||_T("common","commfail"),j.createDelegate(k.owner,[k,f,i.isSaveAs],true));break;default:k.owner.owner.getMsgBox().alert("",SYNO.API.Erros.core[g.code]||_T("common","commfail"));break}}}})},saveFile:function(a){if(this._S("demo_mode")){this.owner.getMsgBox().alert("",_T("common","error_demo"));return}if(null==a.filePath){this.saveFileAs(a);return}this.sendSaveRequest(a,{file_path:a.filePath,file_content:SYNO.Util.Base64.encode(a.editor.getValue()),codepage:a.codepage,},false)},saveFileAs:function(b){var d=b.codepage;var c=b.filePath?b.filePath.substring(0,b.filePath.lastIndexOf("/")):"";var a=new SYNO.SDS.Utils.FileChooser.Chooser({owner:this.owner,usage:{type:"save",oldFilename:Ext.util.Format.htmlDecode(b.fileName)},title:_T("texteditor","SaveAs"),height:550,enumGluster:true,enumSnapshot:true,folderToolbar:true,gotoPath:c,editor:b,comboOption:[{label:_T("texteditor","FileType"),value:"allText",data:[["allText",_T("texteditor","AllTextFile")],["all",_T("texteditor","AllFile")]]},{label:_T("texteditor","Codepage"),value:d,data:SYNO.SDS.ACEEditor.Utils.getComboBoxCodepageList(false)}],getFilterPattern:function(e){if("allText"===e[0].value){var f=[];for(var g in SYNO.SDS.ACEEditor.Utils.TextFileExtensions){f.push(g)}return f.join()}return""},listeners:{scope:this,choose:function(h,e,g){if(this._S("demo_mode")){this.owner.getMsgBox().alert("",_T("common","error_demo"));return}var f=h.editor;var i=g[1];this.owner.mainPanel.tabPanel.getActiveTab().editor.focus();h.close();this.sendSaveRequest(f,{file_path:e.path,file_content:SYNO.Util.Base64.encode(f.editor.getValue()),codepage:i},true)},cancel:function(){this.owner.mainPanel.tabPanel.getActiveTab().editor.focus()}}}).show()},saveAll:function(){for(var a=0;a<this.tabPanel.items.length;a++){this.tabPanel.setActiveTab(a);this.saveFile(this.tabPanel.items.items[a])}},closeFile:function(){var a=this.tabPanel.getActiveTab();if(a.fireEvent("beforeclose",a)!==false){a.fireEvent("close",a);this.tabPanel.remove(a)}},undo:function(){if(this.tabPanel.getActiveTab()){this.tabPanel.getActiveTab().undo()}},redo:function(){if(this.tabPanel.getActiveTab()){this.tabPanel.getActiveTab().redo()}},selectAll:function(){if(this.tabPanel.getActiveTab()){this.tabPanel.getActiveTab().selectAll()}},insertDateAndTime:function(){if(this.tabPanel.getActiveTab()){this.tabPanel.getActiveTab().insertDateAndTime()}},preferences:function(){var a=new SYNO.SDS.ACEEditor.PreferenceDialog({parent:this,owner:this.owner}).show()},openFindDialog:function(){var a=new SYNO.SDS.ACEEditor.FindDialog({parent:this,owner:this.owner,previousNeedle:this.findNeedle}).show()},find:function(b,a){this.findNeedle=b;this.findOption=a;this.tabPanel.getActiveTab().find(b,a)},findNext:function(){if(this.findNeedle){this.tabPanel.getActiveTab().find(this.findNeedle,this.findOption)}else{this.openFindDialog()}},findPrevious:function(){if(this.findNeedle){this.tabPanel.getActiveTab().find(this.findNeedle,Ext.apply({backwards:true},this.findOption))}else{this.openFindDialog()}},openReplaceDialog:function(){var a=new SYNO.SDS.ACEEditor.ReplaceDialog({parent:this,owner:this.owner,previousNeedle:this.findNeedle}).show()},replace:function(d,b,c,a){this.findNeedle=d;this.tabPanel.getActiveTab().replace(d,b,c,a)},goToLine:function(){var a=new SYNO.SDS.ACEEditor.GoToLineDialog({parent:this,owner:this.owner}).show()},applyEditorSettings:function(){for(var a=0;a<this.tabPanel.items.length;a++){this.tabPanel.items.items[a].applyEditorSettings(this.editorSettings)}},setDisableEditorButtons:function(a){Ext.getCmp(this.codepageMenuId).setDisabled(a);Ext.getCmp(this.saveBtnId).setDisabled(a);Ext.getCmp(this.saveAsBtnId).setDisabled(a);Ext.getCmp(this.saveAllBtnId).setDisabled(a);Ext.getCmp(this.closeBtnId).setDisabled(a);Ext.getCmp(this.undoBtnId).setDisabled(a);Ext.getCmp(this.redoBtnId).setDisabled(a);Ext.getCmp(this.selectAllBtnId).setDisabled(a);Ext.getCmp(this.langToolBtnId).setDisabled(a);Ext.getCmp(this.findBtnId).setDisabled(a);Ext.getCmp(this.replaceBtnId).setDisabled(a);Ext.getCmp(this.goToLineBtnId).setDisabled(a);this.selectHighlightMode.setValue("").setDisabled(a)},beforeTabClose:function(a){if(false==a.editor.renderer.session.$undoManager.isClean()){this.owner.isClosing=true;this.owner.getMsgBox().confirm("",String.format(_T("texteditor","AskSaveDirtyFile"),a.fileName),function(b){if("yes"===b){this.owner.saveFile(this)}else{if("no"===b){if(this.owner.owner.isChaining){this.owner.stepCloseChain()}else{this.owner.onTabDestroyed.call(this.owner);this.destroy()}}else{this.owner.owner.isClosing=false;this.owner.owner.isChaining=false}}},a,{yes:{xtype:"syno_button",text:_T("common","save")},no:{xtype:"syno_button",text:_T("texteditor","dont_save")},cancel:true});return false}return true},setTabPanelHeader:function(a){if(a){this.tabPanel.header.show()}else{this.tabPanel.header.hide()}this.tabPanel.syncSize();this.tabPanel.ownerCt.doLayout()},onContainerDrop:function(e,c,m){var b=m.SDSShortCut;var o=this.editorSettings.defaultCodepage;var p=[],a=[];for(var h=0;h<b.length;h++){if(b[h].config.param.isdir){continue}var d=b[h].config.param.openfile;var l=this.tabPanel,k=false;for(var g=0;g<l.items.length;g++){if(d==l.items.items[g].filePath){k=true;break}}if(k){continue}var f=Ext.util.Format.htmlEncode(d.split("/").pop());var n=SYNO.SDS.ACEEditor.Utils.guessMode(f);a.push({filePath:d,fileName:f,fileMode:n});p.push({api:"SYNO.Core.File",version:1,method:"load",params:{file_path:d,codepage:o}})}if(0===p.length){return}this.owner.getEl().mask(_T("common","msg_waiting"),"x-mask-loading");this.sendWebAPI({params:{},compound:{params:p},fileConfig:a,scope:this,callback:function(q,s,r,t){this.owner.getEl().unmask();if(!q){this.owner.getMsgBox().alert("",_T("error","error_error_system"));return}var w=s.result;var j=t.fileConfig;var x=[];for(var u=0;u<w.length;u++){if(!w[u].success){if(5606===w[u].error.code){x.push(String.format(_T("texteditor","CodepageConvertFail"),j[u].fileName))}else{x.push(String.format(j[u].fileName+": "+(SYNO.API.Erros.core[w[u].error.code]||_T("common","commfail"))))}continue}this.addEditorTab(j[u].filePath,j[u].fileName,j[u].fileMode,this.editorSettings.defaultCodepage==="auto"?w[u].data.detect_codepage:this.editorSettings.defaultCodepage,SYNO.Util.Base64.decode(w[u].data.file_content))}if(0<x.length){this.owner.getMsgBox().alert("",x.join("<br>"))}this.owner.toFront();var v=this.tabPanel.getActiveTab();if(v){v.focusEditor.defer(500,v)}}})},onTabDestroyed:function(){if(this.tabPanel.items.length==1){this.setDisableEditorButtons(true);this.codepageStatus.hide().setText("");this.cursorStatus.setText(_T("texteditor","NoDocument"));this.findAppWindow().setTitle(_T("texteditor","ApplicationTitle"));this.owner.focus()}else{if(this.tabPanel.items.length==2){this.setTabPanelHeader(false)}}},onEditorCreated:function(){this.setDisableEditorButtons(false);if(1<this.tabPanel.items.length){this.setTabPanelHeader(true)}},onFocusEditor:function(){var a=this.tabPanel.getActiveTab();var b=a.editor.session.$modeId;var c=a.codepage;this.updateWindowTitle(a);this.updateStatusBar(a);this.updateLangTool(c);this.selectHighlightMode.setValue(b.substring(b.lastIndexOf("/")+1));this.codepageMenu.find("value",c)[0].setChecked(true,true)},onChangeCursor:function(){var a=this.tabPanel.getActiveTab();this.updateStatusBar(a);this.preventTimeout()},onSelectHighlightMode:function(a,b){var c=b.data.value;this.tabPanel.getActiveTab().setMode(c)},updateLangTool:function(b){var a=["BIG5","BIG5-HKSCS","GBK","GB18030","UTF-16","UTF-8","UTF-8_withBOM"];Ext.getCmp(this.langToolBtnId).setDisabled(a.indexOf(b)===-1)},updateStatusBar:function(a){var d=a.editor.selection.getCursor();var b=a.codepage;this.codepageStatus.show().setText(_T("texteditor","Codepage")+": "+SYNO.SDS.ACEEditor.Utils.getCodepageName(b));this.cursorStatus.setText(_T("texteditor","Line")+": "+(d.row+1)+", "+_T("texteditor","Column")+": "+d.column)},updateWindowTitle:function(a){this.findAppWindow().setTitle(a.title+" - "+_T("texteditor","ApplicationTitle"),undefined,false)},isAnyFileDirty:function(){var a;for(a=0;a<this.tabPanel.items.length;a++){if(!this.tabPanel.items.items[a].um.isClean()){return true}}return false},preventTimeout:function(){var a=(new Date()).getTime();if(a-this.lastPreventTimeout>50*1000){this.sendWebAPI({api:"SYNO.Core.Desktop.Timeout",method:"reset",version:1});this.lastPreventTimeout=a}},stepCloseChain:function(b){if(b){this.owner.isChaining=true;this.owner.closeChain={currentIndex:-1,chainLength:this.tabPanel.items.length}}for(var a=this.owner.closeChain.currentIndex+1;a<this.owner.closeChain.chainLength;a++){if(!this.tabPanel.items.items[a].um.isClean()){this.tabPanel.setActiveTab(this.owner.closeChain.currentIndex=a);this.closeFile();return}}this.owner.isClosing=false;this.owner.isChaining=false;this.owner.forceClose=true;this.owner.close()}});