#!/bin/sh
# Copyright (c) 2003-2013 Synology Inc. All rights reserved.

PGSQL="/usr/bin/psql -U postgres"
DATABASE="mediaserver"
UPGRADE_DIR="/usr/syno/synoindex/sql/upgrade"

echo "test video_profile column in $DATABASE db"
SQL="SELECT video_profile FROM video LIMIT 1"
$PGSQL $DATABASE -c "$SQL" > /dev/null 2>&1
Ret=$?
if [ $Ret = 1 ]; then
	echo "Create more columns in $DATABASE db"
	Script="$UPGRADE_DIR/005_video_convert.pgsql"
	$PGSQL $DATABASE < $Script
	if [ $? != 0 ]; then
		echo "Failed to create video_profile column in $DATABASE db video table"
		exit 2 # error
	fi

	exit 1 # need reindex
fi

exit 0 # no modification

