#!/bin/sh
# Copyright (c) 2000-2014 Synology Inc. All rights reserved.
# define
. /etc/iproute2/script/gateway-mgt-function
SYNONETD_TOOL="/usr/syno/sbin/synonetdtool"

# input args
IF_NAME=$1
NET_STATUS=$2 #CONNECTED or DISCONNECTED

# function start
local ifcfg_file="/etc/sysconfig/network-scripts/ifcfg-${IF_NAME}"
if [ ! -f $IF_IFCFG ]; then
	return
fi

local bootproto=`/bin/get_key_value ${ifcfg_file} BOOTPROTO`
if [ "xDISCONNECTED" = "x${NET_STATUS}" ]; then
	if [ "xdhcp" = "x${bootproto}" ]; then
		stop dhcp-client IFACE=${IF_NAME}
	fi
	return
fi

# re-connect status
if [ "xdhcp" = "x${bootproto}" ]; then
	start dhcp-client IFACE=${IF_NAME}
fi

local GATEWAY="NULL"
local DNS="NULL"
local GATEWAY_DATABASE="/etc/iproute2/config/gateway_database"

GATEWAY=`/usr/syno/bin/get_section_key_value ${GATEWAY_DATABASE} ${IF_NAME} gateway`
if test -z "$GATEWAY" ; then
	GATEWAY="NULL"
fi
DNS=`/usr/syno/bin/get_section_key_value ${GATEWAY_DATABASE} ${IF_NAME} dns`
if test -z "$DNS" ; then
	DNS="NULL"
fi

# FIXME: wlan still using ethernet class
${SYNONETD_TOOL} --add-gateway-info -4 -2 ${IF_NAME} ${GATEWAY} ${DNS} ethernet

set_default_gateway_interface

${SYNONETD_TOOL} --refresh-gateway -4
if [ "${GATEWAY}" != "NULL" ]; then
	local enable_multi_gateway=`/bin/get_key_value /etc/synoinfo.conf multi_gateway`
	if [ "xyes" = "x${enable_multi_gateway}" ]; then
		local IPADDR=`get_key_value ${IFCFG_FILE} IPADDR`
		${SYNONETD_TOOL} --add-policy-route-rule -4 multi-gateway ${IF_NAME} NULL NULL ${GATEWAY}
		${SYNONETD_TOOL} --refresh-route-table -4 ${IF_NAME} ${IPADDR}
	fi
fi
