#!/bin/sh
# Copyright (c) 2000-2013 Synology Inc. All rights reserved.

Httpd="/usr/bin/httpd"
HttpdConf="/etc/httpd/conf/httpd.conf-webdav"
HttpdSSLConf="/etc/httpd/conf/extra/httpd-ssl.conf-webdav"
HttpdSSLConfCipher="/etc/httpd/conf/extra/httpd-ssl.conf-cipher"
PROCNAME="httpd"
PIDFILE="/var/run/httpd/httpd-webdav.pid"
RunWEBDAV="no"
RunWEBDAVHTTPS="no"

RunCALDAV="$(/bin/get_key_value /etc/synoinfo.conf runCalDav)"
SSLKEYGEN="/usr/syno/etc.defaults/rc.ssl_keygen"
CGIKEYGEN="/usr/syno/etc.defaults/rc.cgi_keygen"
INTERCRT="/usr/syno/etc/ssl/ssl.intercrt/server-ca.crt"

. /etc.defaults/rc.subr

GenerateConf()
{
	WEBDAV_PORT="$(/bin/get_key_value /etc/synoinfo.conf WebDavPort)"
	if [ -z "$WEBDAV_PORT" ]; then
		WEBDAV_PORT="$(/bin/get_key_value /etc.defaults/synoinfo.conf WebDavPort)"
		if [ -z "$WEBDAV_PORT" ]; then
			WEBDAV_PORT="5005"
		fi
	fi
	WEBDAV_SSL_PORT="$(/bin/get_key_value /etc/synoinfo.conf secure_WebDavPort)"
	if [ -z "$WEBDAV_SSL_PORT" ]; then
		WEBDAV_SSL_PORT="$(/bin/get_key_value /etc.defaults/synoinfo.conf secure_WebDavPort)"
		if [ -z "$WEBDAV_SSL_PORT" ]; then
			WEBDAV_SSL_PORT="5006"
		fi
	fi

	if [ -z "$RunWEBDAV" ]; then
		RunWEBDAV="no"
	fi
	if [ -z "$RunWEBDAVHTTPS" ]; then
		RunWEBDAVHTTPS="no"
	fi
	if [ -z "$RunCALDAV" ]; then
		RunCALDAV="no"
	fi

	DAV_LINE="Listen"
	if [ "no" = "$RunWEBDAV" -a "yes" = "$RunWEBDAVHTTPS" ]; then
		DAV_AWK="/^L/,\"#L\""
	else
		DAV_AWK="/^#L/,\"L\""
	fi

	cp -f ${HttpdConf} ${HttpdConf}.$$
	if [ $? -ne 0 ]; then
		logger -p user.err -t $(basename $0) "backup ${HttpdConf} failed."
		rm -f ${HttpdConf}.$$
		return 1
	fi
	if [ "no" = "$RunWEBDAV" -a "yes" = "$RunWEBDAVHTTPS" ]; then
		sed -e "/^Listen/c\\Listen ${WEBDAV_SSL_PORT}" -e "/^ServerName/c\\ServerName *:${WEBDAV_SSL_PORT}" ${HttpdConf} > ${HttpdConf}.$$
	else
		sed -e "/^Listen/c\\Listen ${WEBDAV_PORT}" -e "/^ServerName/c\\ServerName *:${WEBDAV_PORT}" ${HttpdConf} > ${HttpdConf}.$$
	fi
	if [ -s "${HttpdConf}.$$" ]; then
		mv ${HttpdConf}.$$ ${HttpdConf}
	fi

	cp -f ${HttpdConf} ${HttpdConf}.$$
	if [ $? -ne 0 ]; then
		logger -p user.err -t $(basename $0) "backup ${HttpdConf} failed."
		rm -f ${HttpdConf}.$$
		return 1
	fi
	if [ "yes" = "$RunCALDAV" ]; then
		sed -e "/^#LoadModule dav_acl_module/c\\LoadModule dav_acl_module modules\/mod_dav_acl.so" -e "/^#LoadModule caldav_module/c\\LoadModule caldav_module modules/mod_caldav.so" ${HttpdConf} > ${HttpdConf}.$$
	else
		sed -e "/^LoadModule dav_acl_module/c\\#LoadModule dav_acl_module modules\/mod_dav_acl.so" -e "/^LoadModule caldav_module/c\\#LoadModule caldav_module modules/mod_caldav.so" ${HttpdConf} > ${HttpdConf}.$$
	fi
	if ! grep "LoadModule synobandwidth_module modules/mod_synobandwidth.so" ${HttpdConf}; then
		echo "LoadModule synobandwidth_module modules/mod_synobandwidth.so" >> ${HttpdConf}.$$
	fi
	if [ -s "${HttpdConf}.$$" ]; then
		mv ${HttpdConf}.$$ ${HttpdConf}
	fi

	cp -f ${HttpdSSLConf} ${HttpdSSLConf}.$$
	if [ $? -ne 0 ]; then
		logger -p user.err -t $(basename $0) "backup ${HttpdSSLConf} failed."
		rm -f ${HttpdSSLConf}.$$
		return 1
	fi

	sed -e "/^Listen/c\\Listen ${WEBDAV_SSL_PORT}" \
		-e "/^<VirtualHost/c\\<VirtualHost *:${WEBDAV_SSL_PORT}>" \
		${HttpdSSLConf} | awk "{if(/${DAV_LINE}/)sub(${DAV_AWK});print}" > ${HttpdSSLConf}.$$

	if [ -s "${HttpdSSLConf}.$$" ]; then
		mv ${HttpdSSLConf}.$$ ${HttpdSSLConf}
	fi

	rm -f ${HttpdConf}.$$ ${HttpdSSLConf}.$$ 2>/dev/null

	if [ -s ${HttpdSSLConfCipher} ]; then
		if [ -f "$INTERCRT" ]; then
			sed -e "/^#SSLCertificateChainFile/c\\SSLCertificateChainFile /usr/syno/etc/ssl/ssl.intercrt/server-ca.crt" \
			${HttpdSSLConfCipher} > ${HttpdSSLConfCipher}.$$
		else
			sed -e "/^SSLCertificateChainFile/c\\#SSLCertificateChainFile /usr/syno/etc/ssl/ssl.intercrt/server-ca.crt" \
			${HttpdSSLConfCipher} > ${HttpdSSLConfCipher}.$$
		fi

		if [ -s "${HttpdSSLConfCipher}.$$" ]; then
			mv ${HttpdSSLConfCipher}.$$ ${HttpdSSLConfCipher}
		fi

		rm -f ${HttpdSSLConfCipher}.$$ 2>/dev/null
	fi
}

TmpSleep()
{
	lsb_status $PROCNAME $PIDFILE
	BUSYWAIT=$?
	TIMEOUT=0
	EXITVALUE=0
	while [ ! $BUSYWAIT -eq $1 ]
	do
		lsb_status $PROCNAME $PIDFILE
		BUSYWAIT=$?
		sleep 1
		TIMEOUT=$(($TIMEOUT+1))
		if [ $TIMEOUT = 30 ] ; then
			echo "Time out: wait more than 30 seconds!"
			EXITVALUE=1
			break
		fi
	done
	return $EXITVALUE
}


RUNPURE=$(echo $2 | awk -F ":" '{print $2}')
RUNSSL=$(echo $3 | awk -F ":" '{print $2}')
if [ "$RUNPURE" = "yes" ]; then
	RunWEBDAV="yes"
fi
if [ "$RUNSSL" = "yes" ]; then
	RunWEBDAVHTTPS="yes"
fi


# check for pidfile
if [ -f $PIDFILE ] ; then
	PID=$(cat $PIDFILE)
	if [ "x$PID" != "x" ] && kill -0 $PID 2>/dev/null ; then
		STATUS="httpd (pid $PID) running"
		RUNNING=1
	else
		STATUS="httpd (pid $PID?) not running"
		RUNNING=0
	fi
else
	STATUS="httpd (no pid file) not running"
	RUNNING=0
fi

case $1 in
[Ss][Tt][Oo][Pp])
	if [ ! -n "$RUNPURE" -a ! -n "$RUNSSL" ]; then
		exit 0
	fi
	if [ $RUNNING -eq 0 ]; then
		echo $STATUS
	else
		if kill $PID ; then
			echo "$0: webdav httpd stopped"
		else
			echo "$0: webdav httpd could not be stopped"
			exit 1;
		fi
	fi

	TmpSleep $LSB_STAT_NOT_RUNNING
	;;
[Ss][Tt][Aa][Rr][Tt])
	if [ ! -n "$RUNPURE" -a ! -n "$RUNSSL" ]; then
		exit 0
	fi

	$SSLKEYGEN > /dev/null 2>&1
	$CGIKEYGEN > /dev/null 2>&1 &
	if [ ! -x "$Httpd" ]; then
		echo "$Httpd is not executable."
		exit 1;
	fi

	if [ $RUNNING -eq 1 ]; then
		echo "$0 $ARG: httpd (pid $PID) already running"
	else
		GenerateConf

		mkdir -p /var/log/httpd /run/httpd

		if [ "yes" = "$RunWEBDAVHTTPS" -o "yes" = "$RunWEBDAV" ]; then
			startArg=""
			if [ "yes" = "$RunWEBDAVHTTPS" ]; then
				startArg="$startArg -DSSL"
			fi

			startArg="$startArg -f ${HttpdConf}"

			echo "Start WebDav Apache Server ..... $startArg"
			if $Httpd $startArg; then
				echo "$0: webdav httpd started"
				TmpSleep $LSB_STAT_RUNNING
				if [ $? -ne 0 ]; then
					exit 1
				fi
			else
				echo "$0: webdav httpd could not be started"
				exit 1;
			fi
		fi
	fi
	;;
[Rr][Ee][Ll][Oo][Aa][Dd])
	GenerateConf
	kill -HUP $(cat $PIDFILE)
	exit 0
	;;
[Rr][Ee][Ss][Tt][Aa][Rr][Tt])
	if [ $RUNNING -eq 0 ]; then
		$0 start
	else
		$0 stop
		sleep 3
		$0 start
	fi
	;;
[Ss][Tt][Aa][Tt][Uu][Ss])
	lsb_status $PROCNAME $PIDFILE
	exit $?
	;;
*)
	echo "Usage: $0 [start|stop|restart|status]"
	;;
esac
exit 0;
