#!/bin/sh
# Copyright (c) 2000-2013 Synology Inc. All rights reserved.

SYNOINFO_DEF="/etc.defaults/synoinfo.conf"
SUPPORT_USB_VOLUME=`get_key_value $SYNOINFO_DEF support_usb_volume`
SYNOPKG=/usr/syno/bin/synopkg
HAMANAGER="HAManager"
PGUPGRADE_FLAG="/tmp/.UpgradePGSQLDatabase"
SZF_MANUTIL_PACKAGE_FLAG="/.manutil_install_package"

syslog() {
	local ret=$?
	logger -p user.err -t $(basename $0) "$@"
	return $ret
}
syno_disable_HD204UI()
{
	for hdd in /sys/block/sd*/device/model /sys/block/usb*/device/model /sys/block/sas*/device/model; do
		if [ -f "$hdd" -a -f "${hdd//model/syno_disk_serial}" ]; then
			if cat $hdd | egrep -q "HD204UI *$"; then
				if cat ${hdd//model/syno_disk_serial} | cut -c8-9 | egrep -q "Z[0-9AB]"; then
					tmp=${hdd#/sys/block/}
					dev=${tmp%/device/model}
					/usr/syno/bin/hdparm -W 0 /dev/$dev
				fi
			fi
		fi
	done
}

is_key_value_yes()
{
	if [ "x`/bin/get_key_value /etc/synoinfo.conf $1`" == "xyes" ]; then
		true
	else
		false
	fi
}

is_package_installed()
{
	local packageFile="$1"
	local packageName=`echo $packageFile | sed -n 's,^.*/\([a-zA-Z]\+\).*$,\1,p'`

	if [ -d "/var/packages/$packageName" ]; then
		true
	else
		false
	fi
}

# Is packge $2 built-in package for dsm $1?
#
# Example1, Is MailServer in dsm 4.1 will return 0
# Example2, Is Perl in dsm 4.1 will return 1
#
# PROTO TYPE:
#         is_in_dsm version package_name
is_in_dsm()
{
	local packageName=`echo $2 | sed -n 's,^.*/\([a-zA-Z]\+\).*$,\1,p'`
	local package_list=

	case "$1" in
		"4.1")
			package_list="MailServer"
			;;
		"4.2")
			package_list="MailServer Perl"
			;;
		"4.3")
			package_list="MailServer Perl"
			;;
		"5.0")
			package_list="MariaDB"
			;;
		*)
			return 1
			;;
	esac

	for i in ${package_list}
	do
		if [ "x$packageName" = "x${i}" ]; then
			return 0
		fi
	done
	return 1
}

install_package() {
	local packageName=`echo $1 | sed -n 's,^.*/\([a-zA-Z]\+\).*$,\1,p'`
	local ret=

	case "$packageName" in
		"MariaDB")
			# for DSM 4.3, we will install MariaDB if and only if runmysql = true
			# for DSM 5.0, we only consider MariaDB install or not
			if [ `get_key_value /etc/synoinfo.conf runmysql` != "yes" ] && ! is_package_installed $1; then
				return
			fi
			;;
		"*")
			;;
	esac

	syslog "install package: $1"
	$SYNOPKG install "$1"
	ret=$?

	# we need touch to make package center think that we have enabled this package before.
	# note: HAManager startable attribute is no, so we need to skip it.
	if [ "$packageName" != "$HAMANAGER" ]; then
		touch /var/packages/$packageName/enabled
	fi
	return $ret
}

BackupPython() {
	local PythonBackup="/usr/local/packages/@appstore/.Python2_SitePackages.bak"

	rm -rf $PythonBackup
	mkdir -p $PythonBackup

	cp -af /usr/local/lib/python2.7/site-packages/* $PythonBackup
}

RemovePython() {
	local preuninst="/var/packages/Python/scripts/preuninst"
	sed -ie 's,.*libpython.*,:,g' -e 's,.*/usr/bin/python.*,:,g' $preuninst
	synopkg uninstall Python
}

install_builtin_packages() {
	local package_dir=$1
	local old_major=`/bin/get_key_value /.old_patch_info/VERSION majorversion`
	local old_minor=`/bin/get_key_value /.old_patch_info/VERSION minorversion`
	local HAMANAGERSPK=`find $package_dir | grep $HAMANAGER`
	local PythonModuleSPK=`find $package_dir | grep "PythonModule"`
	local PYTHON_DIR="/var/packages/Python"

	[ -d "$package_dir" ] || return 1

	# if no "/.old_patch_info" (new installation), skip installation of builtin package
	[ -f "/.old_patch_info/VERSION" ] || return 1

	if [ -n "$PythonModuleSPK" ] && [ -d "$PYTHON_DIR" ]; then
		if ! BackupPython; then
			syslog "Backup python package failed!"
		else
			if ! RemovePython; then
				syslog "Remove python package failed!"
			else
				synopkg install $PythonModuleSPK
			fi
		fi
	fi
	rm $PythonModuleSPK

	# If HA is running, HA should have been upgraded (at /etc/rc),
	# and the .spk should be deleted after upgrading finished (should not appear here!).
	if [ -n "$HAMANAGERSPK" ]; then
		# If user has installed HA but not enable HA, upgrade it
		# If HA has not installed , do not upgrade it
		if is_package_installed "$HAMANAGERSPK"; then
			install_package "$HAMANAGERSPK"
		fi
		rm $HAMANAGERSPK
	fi

	if [ ! -z "$(ls -A $package_dir)" ]; then
		for i in $package_dir/*; do
			# if user remove this package in old dsm, we should not install again.
			if $(is_in_dsm "${old_major}.${old_minor}" "$i"); then
				if is_package_installed "$i"; then
					install_package "$i"
				fi
			else
				install_package "$i"
			fi
		done
	fi

	# [WORKAROUND]: fix service port config is not loaded while starting firewall
	# restart firewall here to fix it temporarily
	/usr/syno/etc/rc.d/S01iptables.sh restart
}

dump_sas_disk_map()
{
	supportSAS=`/bin/get_key_value /etc.defaults/synoinfo.conf supportsas`
	if [ "xyes" == "x${supportSAS}" -o "xYES" == "x${supportSAS}" ]; then
		sleep 15
		/usr/syno/bin/synoenc --dump_enc_disk /tmp/sasdiskmaps
		cat /tmp/sasdiskmaps >> /var/log/messages
	fi
}

# Since the glusterfs provide the gluster share for other package,
#	it should be started before other packages start.
process_glusterfs_package() #$1: start/stop
{
	local synogluster_sbin="/var/packages/GlusterfsMgmt/target/sbin"
	local gluster_upgrade_lock="/usr/syno/etc/packages/GlusterfsMgmt/USUSPEND"
	local gluster_upgrade_status="upgrade_success"
	local gluster_upgrade_success="`/usr/syno/bin/synogetkeyvalue "${gluster_upgrade_lock}" "${gluster_upgrade_status}"`"
	local synocluster="${synogluster_sbin}/synocluster"
	local synoglusterservice="${synogluster_sbin}/synoglusterservice"
	local glusterresumed="${synogluster_sbin}/glusterresumed"

	if [ -e "${gluster_upgrade_lock}" -a -n "${gluster_upgrade_success}" -a -x "${synocluster}" -a "$1" = "start" ]; then
		# since we'll need WebAPIs from CMS & gluster, start the packages first
		$SYNOPKG start "CMS"
		$SYNOPKG start "GlusterfsMgmt"

		if [ "${gluster_upgrade_success}" = "yes" ]; then
			${synocluster} --upgrade
		fi

		# resuming, launch resume daemon
		${glusterresumed}
	elif [ -x "${synoglusterservice}" ] && [ "`${synoglusterservice} --status`" = "enable" ]; then
		if [ "$1" = "start" ]; then
			${synoglusterservice} --start
		elif [ "$1" = "stop" ]; then
			${synoglusterservice} --stop
		fi
	fi
}
# disable write cache of HD204UI
if [ x`/bin/get_key_value /etc/synoinfo.conf allow_HD204UI` != "xyes" ]; then
	syno_disable_HD204UI
fi

# the file was touched in /etc/rc
if [ -f /tmp/.ImproperShutdown ]; then
	/usr/syno/bin/synologset1 sys warn 0x11100001
	/usr/syno/bin/synonotify ImproperShutdown
	rm -f /tmp/.ImproperShutdown
fi

if [ "$1" = "start" ]; then
	if [ -f $SZF_MANUTIL_PACKAGE_FLAG ]; then
		volume_size=`/bin/get_key_value /.manutil_volume_size size`
		touch /tmp/volume.$volume_size
		rm -f /.manutil_volume_size size
	fi
	# when no volume exist, pgsql and related service can not start.
	# On this case, we pause pgsql by reason "no-volume", to avoid
	# boot up sequence be blocked by wait pgsql and related service ready
	/usr/syno/bin/servicetool --get-service-path pgsql >/dev/null 2>&1
	if [ $? -eq 0 ]; then
		/usr/syno/sbin/synoservicecfg --pause-by-reason pgsql no-volume
	fi

	# Increase bootup timeout from 180 to 600 when pgsql is update database
	time=0
	while true; do
		if msg=`/usr/syno/sbin/synoservicecfg --is-all-up`; then
			echo $msg
			logger -p user.err -t $(basename $0) "$msg"
			break;
		else
			echo $msg
		fi

		if [ -f "$PGUPGRADE_FLAG" -a "$time" -ge '600' ] || [ ! -f "$PGUPGRADE_FLAG" -a "$time" -ge '180' ]; then
			logger -p user.err -t $(basename $0) "Error! synoservices start timeout! ($msg)"
			break;
		fi
		sleep 3
		time=$(($time+3))
	done
	/usr/syno/sbin/synoservicecfg --log-fail-service

	# Time out but pgsql still in upgrade operation, alert user
	if [ -f "$PGUPGRADE_FLAG" ]; then
		echo timeout > $PGUPGRADE_FLAG
		logger -p user.err -t `basename $0` "pgsql upgrade timeout."
		synodsmnotify @administrators dsmnotify:system_event widget:pgsql_upgrade_timeout
	fi

	/bin/kill -USR1 `cat /var/run/findhostd.pid`

	if [ -x /usr/syno/bin/synofstool ]; then
		/usr/syno/bin/synofstool --dump-fscache &
	fi

	#Create volume for network install
	if [ -f "/.assistant_install_create_vol" ]; then
		/usr/syno/bin/volumetool --create-for-install
		rm -f /.assistant_install_create_vol
	fi

	if [ -f $SZF_MANUTIL_PACKAGE_FLAG ] && [ -d /.SynoUpgradePackages ]; then
		/usr/syno/bin/synosetkeyvalue /etc/synoinfo.conf pkg_source_trust_level 2
		local mountedvolume=`servicetool --get-alive-volume`
		while [ ! "/volume1" = "$mountedvolume" ]
		do
			echo volume is unavailable now... retry
			sleep 5
			mountedvolume=`servicetool --get-alive-volume`
		done

		ManutilPackDir=/.SynoUpgradePackages/manutilPackage
		ManutilPackList=`cat $ManutilPackDir/install_list`
		for mPackage in $ManutilPackList
		do
			echo install $mPackage
			install_package $ManutilPackDir/$mPackage
			local installRet=$?
			local pName=`echo $mPackage | sed -n 's,^.*/\([a-zA-Z]\+\).*$,\1,p'`
			if [ 0 -eq $installRet ]; then
				$SYNOPKG start $pName
			fi
		done
		rm -rf $ManutilPackDir
		rm -f $SZF_MANUTIL_PACKAGE_FLAG
	fi

	if [ -d /.SynoUpgradePackages ]; then
		install_builtin_packages /.SynoUpgradePackages
		rm -rf /.SynoUpgradePackages
	fi

	# set pakcage channel to beta channel if DSM is beta
	if [ -f "/var/.UpgradeBootup" ]; then
		buildphase=`/bin/get_key_value /etc.defaults/VERSION buildphase`
		if [ "xbeta" == "x${buildphase}" ]; then
			/usr/syno/bin/synosetkeyvalue /etc/synoinfo.conf package_update_channel beta
		fi
	fi

	#Remove updater and version files for first-bootup of upgrade
	rm -f /.updater
	rm -f /var/.UpgradeBootup

	# clean up migrate backup file
	rm -rf /.syno/update_bkp/
fi


dump_sas_disk_map &

if [ "$1" = "start" -a "yes" = "${SUPPORT_USB_VOLUME}" ]; then
	/usr/syno/bin/synocheckshare --chkusbvol
fi

if [ "$1" = "stop" ]; then
	# Due to HA may run S99 many times(switch over), clean bootup fail dir after each time we check
	/bin/rm /run/synoservice/bootup-fail-job/*
fi

process_glusterfs_package $1

#Change permission of /dev/fuse
if [ -e "/dev/fuse" ]; then
    /bin/chown root:users /dev/fuse
    /bin/chmod 0666 /dev/fuse
fi


