#!/bin/sh

###############################################################
#   This script should be hooked when invoking SYNOShareDelete()
#   Usable environment variable:
#       NITEMS, SHARE_NAME_X, SHARE_PATH_X, SHARE_OP_RESULT_X
###############################################################

#Include common scripts
FILE_SYSLOGNG_INC_SCRP=/usr/libexec/SyslogShareCommon.sh
. ${FILE_SYSLOGNG_INC_SCRP}

#At begining, acquire package settings
PackageInfoGet;

case $1 in
    --sdk-mod-ver)
        #Print SDK support version
        echo ${SYSLOGNG_PKG_MODVER};
    ;;
    --name)
        #Print package name
        echo ${SYSLOGNG_PKG_NAME};
    ;;
    --pkg-ver)
        #Print package version
        echo ${SYSLOGNG_PKG_VERSION};
    ;;
    --vendor)
        #Print package vendor
        echo ${SYSLOGNG_PKG_VENDOR};
    ;;
    --pre)
        #Actions before share set

        ################################################
        # PS: Service is paused by service framework
        ################################################
    ;;
    --post)
        #Actions after share set
        ServiceInfoGet;
        SHARE_IDX=0;
        CNT=1;
        NITEMS=$((NITEMS + 1));

        #Check if service share
        while [ "${CNT}" != "${NITEMS}" ]
        do
            eval "CHK_SHARE=\$SHARE_NAME_$CNT"
            SvrShareCheck;    
            if [ "1" = "${IS_SVR_SHARE}" ]; then
                SHARE_IDX=${CNT};
            fi

            CNT=$((CNT + 1));
        done
        if [ "0" == "${SHARE_IDX}" ]; then
            return;
        fi

        #Send notification when removal is success
        eval "RESULT=\$SHARE_OP_RESULT_$SHARE_IDX"
        if [ "0x0000" = "${RESULT}" ]; then
            SyslogMailShareRemove;
        fi

        ################################################
        # PS: Service is resumed/disabled by service framework
        ################################################
    ;;
    *)
        echo "Usage: $0 --sdk-mod-ver|--name|--pkg-ver|--vendor|--pre|--post"
    ;;
esac
