#!/usr/bin/perl
use strict;

#ARGV[0]:input file ARGV[1]:rn ARGV[2]:output file
my $i=0;
my $filename=$ARGV[2];
my $rn=$ARGV[1];
my $rule_count;
my @attr=();

open FILE_LIST, "<$ARGV[0]" or die "can't open $ARGV[0]\n";

#parse /tmp/routertemp into array
while(my $fileBuf = <FILE_LIST>) {
	chomp($fileBuf);
	my %map;

	%map = split(/[&=]/, $fileBuf);
	push @attr, \%map;
}
close FILE_LIST;

open RULE_FILE, ">$filename";
$rule_count = scalar @attr;

#should follow this order
print RULE_FILE "rn=$rn&form_action=add&uniquecount=$rule_count&app_path=&origin_name=synology&app_name=synology&clone_enable=on&add_rangesel=TCP&add_triggersel=6&";
printfunc("hid_inbound_end_showrow");
printfunc("hid_inbound_showrow");
printfunc("hid_outbound_end_showrow");
printfunc("hid_outbound_showrow");
printfunc("hid_rangesel_showrow");
printfunc("hid_triggerport_showrow");
printfunc("hid_triggersel_showrow");
close RULE_FILE;

print $filename;

sub printfunc {
	my ($f) = @_;

	for my $i (0 .. $rule_count) {
		if (!exists $attr[$i]{"$f"}) {
			last;
		} else {
			my $t = $i+1;
			print RULE_FILE "$f$t=".$attr[$i]{"$f"}."&";
		}
	}
}
