#!/bin/sh

# current design, we use pwm1 & pwm2 only
ADTPWMS="pwm1 pwm2"
ADTPWMCONTROL=_syno_control
ADTPWMHIGHFREQ=_high_freq
PECI_ERROR=peci_error
SYNOINFO_DEF=/etc.defaults/synoinfo.conf

findADTPath()
{
	ret=0
	unset ADTDIRS
	file=/sys/class/i2c-dev/i2c-*/device/0-002[c-e]
	for f in $file
	do
		if [ ! -f "$f/name" ]; then
			continue
		fi
		name=`cat $f/name`
		if [ "$name" == "adt7490" ];then
			ADTDIRS="${ADTDIRS} $f"
			ret=1
		fi
	done
	return ${ret}
}

supportadt7490=`get_key_value $SYNOINFO_DEF supportadt7490`

if [ "$supportadt7490" = "yes" ]; then
	findADTPath
	if [ 1 -ne $? ]; then
		return
	fi
	for ADTDIR in ${ADTDIRS}
	do
		echo ADT Set FAN SPEED ${ADTDIR}
		#Clean the peci error
		cat $ADTDIR/$PECI_ERROR >/dev/null 2>&1
		for ADTPWM in ${ADTPWMS}
		do
			#Set high frquency
			echo 1 > $ADTDIR/$ADTPWM$ADTPWMHIGHFREQ
			#Set pwm control to manual
			echo 2 > $ADTDIR/$ADTPWM$ADTPWMCONTROL
			#Set pwm
			SupportDualhead=`get_key_value $SYNOINFO_DEF support_dual_head`

			if [ "$SupportDualhead" = "yes" ]; then
				echo 20 > $ADTDIR/$ADTPWM
			else
				echo 125 > $ADTDIR/$ADTPWM
			fi
		done
	done
fi
