#!/bin/sh
# Copyright (c) 2000-2014 Synology Inc. All rights reserved.

. /etc.defaults/rc.subr

SASRemoveSDNode()
{
	# remove useless sd* in sas model for fail safe
	# because in SAS model, all device nodes are generated dynamically,
	# so remove these useless device nodes to prevent mis-use
	SDLIST=`ls /dev/* | grep sd[a-z]`
	SDLIST="${SDLIST} `ls /dev/* | grep hd[a-z]`"
	SDLIST="${SDLIST} `ls /dev/* | grep sas[1-9]`"
	SDLIST="${SDLIST} `ls /dev/* | grep usb[1-9]`"
	SDLIST="${SDLIST} `ls /dev/* | grep iscsi[1-9]`"
	SDLIST="${SDLIST} `ls /dev/erase*`"
	if [ -n "${SDLIST}" ]; then
		rm ${SDLIST}
	fi
	SYNOGenAllDeviceNodes
}

SASEnablePhy()
{
	# see if any phy of sas controller and expander is manually disabled
	PHYPREFIX="/sys/class/sas_phy/phy-*"
	for prefix in $PHYPREFIX; do
		if [ `cat "$prefix/negotiated_linkrate" | grep -c "Phy disabled"` -ne 0 ]; then
			echo 1 > "$prefix/enable"
		fi
	done
}

SASAssignEncID()
{
	/usr/syno/sbin/enclosureidassign
}

SubTunDiskPerformance()
{
	DISKLIST=`/usr/syno/bin/synodiskport -$1`
	for disk in ${DISKLIST};
	do
		/usr/syno/bin/sasdisktune ${disk}
	done
}

SASTunDiskPerformance()
{
	echo "tunning SAS disk performance"
	SubTunDiskPerformance internal
	SubTunDiskPerformance eunit
	# We don't tune SSD cache scheduler to CFQ here
	# unless there are SSDs which work in SAS protocol and their performance suffer by using Anticipatory as scheduler
}

# interrupt SAS disk self test, for #47006
SubInterruptDiskSelfTest()
{
	DISKLIST=`/usr/syno/bin/synodiskport -$1`
	for disk in ${DISKLIST};
	do
		/usr/syno/bin/sasdiskselftestinterrupt ${disk}
	done
}

SASInterruptDiskSelfTest()
{
	echo "interrupt SAS disk self test"
	SubInterruptDiskSelfTest internal
	SubInterruptDiskSelfTest eunit
}

SASWaitEncHDDReady()
{
	# Get all sas address of host sas controllers
	host_sas_addr_list=""
	for addr in `cat /sys/class/scsi_host/host*/host_sas_address`; do
		# Remove prefix 0x
		addr="${addr#0x}"
		host_sas_addr_list="$host_sas_addr_list ${addr}"
	done

	# Maximum delay time: 200s
	delay_limit=200
	total_delay=0
	last_expander_count=0

	while [ $total_delay -lt $delay_limit ]
	do
		# two conditions that need wait
		# 1. new expander attach in 5 sec, there may be more expanders on the way
		# 2. not enough hdd is detected

		# check new expander
		expander_list=`echo /sys/class/sas_device/expander-*`
		expander_count=`echo "$expander_list" | wc -w`

		if [ $expander_count -ne $last_expander_count ]; then
			echo "======== Wait Enclosure Ready (last: $last_expander_count, new: $expander_count) ========"
			last_expander_count=$expander_count
			sleep 5
			total_delay=$(($total_delay+5))
			continue
		fi

		# check new disk
		# Count numbers of attached PHYs
		phy_count_total=0
		for i in $expander_list
		do
			sas_addr=`cat $i/sas_address`
			# we only want expander-*:*
			expander_id=`/usr/bin/basename $i`
			phy_enum=`/usr/syno/bin/synoses --phy_enum $expander_id $sas_addr`
			phy_count=`echo "$phy_enum" | cut -d " " -f3 | grep -c 1`

			# Don't count the upper link PHYs which are connected to the host
			for addr in $host_sas_addr_list; do
				phys_attached_host=`echo "$phy_enum" | grep -c $addr`
				phy_count=$(($phy_count-$phys_attached_host))
			done

			phy_count_total=$(($phy_count_total+$phy_count))
		done

		# Count numbers of block device sasX
		hdd_count=`echo /sys/block/sas* | wc -w`
		hdd_dev_count=`echo /dev/sas* | wc -w`
		hdd_partition_count=`echo /dev/sas*p* | wc -w`
		hdd_dev_count=$(($hdd_dev_count-$hdd_partition_count))
		hdd_enc_soft_link_count=`echo /sys/block/sas*/device/enclosure_device:* | wc -w`

		if [ $hdd_count -lt $phy_count_total -o $hdd_dev_count -lt $phy_count_total -o $hdd_enc_soft_link_count -lt $phy_count_total ]; then
			echo "======== Wait HDD Ready (block: $hdd_count, dev node: $hdd_dev_count, soft_link: $hdd_enc_soft_link_count, total: $phy_count_total) ========"
			sleep 1
			total_delay=$(($total_delay+1))
			continue
		fi

		echo "======== All HDD Ready ($hdd_count, $hdd_dev_count, $hdd_enc_soft_link_count, $phy_count_total) ========="
		break
	done
}

